/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A channel is a named input source that training algorithms can consume. For more information, see .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLChannel implements SdkPojo, Serializable, ToCopyableBuilder<AutoMLChannel.Builder, AutoMLChannel> {
    private static final SdkField<AutoMLDataSource> DATA_SOURCE_FIELD = SdkField
            .<AutoMLDataSource> builder(MarshallingType.SDK_POJO).memberName("DataSource")
            .getter(getter(AutoMLChannel::dataSource)).setter(setter(Builder::dataSource)).constructor(AutoMLDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompressionType").getter(getter(AutoMLChannel::compressionTypeAsString))
            .setter(setter(Builder::compressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()).build();

    private static final SdkField<String> TARGET_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAttributeName").getter(getter(AutoMLChannel::targetAttributeName))
            .setter(setter(Builder::targetAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAttributeName").build())
            .build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(AutoMLChannel::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            COMPRESSION_TYPE_FIELD, TARGET_ATTRIBUTE_NAME_FIELD, CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLDataSource dataSource;

    private final String compressionType;

    private final String targetAttributeName;

    private final String contentType;

    private AutoMLChannel(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.compressionType = builder.compressionType;
        this.targetAttributeName = builder.targetAttributeName;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The data source for an AutoML channel.
     * </p>
     * 
     * @return The data source for an AutoML channel.
     */
    public final AutoMLDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
     * @see CompressionType
     */
    public final CompressionType compressionType() {
        return CompressionType.fromValue(compressionType);
    }

    /**
     * <p>
     * You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
     * @see CompressionType
     */
    public final String compressionTypeAsString() {
        return compressionType;
    }

    /**
     * <p>
     * The name of the target variable in supervised learning, usually represented by 'y'.
     * </p>
     * 
     * @return The name of the target variable in supervised learning, usually represented by 'y'.
     */
    public final String targetAttributeName() {
        return targetAttributeName;
    }

    /**
     * <p>
     * The content type of the data from the input source. You can use <code>text/csv;header=present</code> or
     * <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.
     * </p>
     * 
     * @return The content type of the data from the input source. You can use <code>text/csv;header=present</code> or
     *         <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLChannel)) {
            return false;
        }
        AutoMLChannel other = (AutoMLChannel) obj;
        return Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(compressionTypeAsString(), other.compressionTypeAsString())
                && Objects.equals(targetAttributeName(), other.targetAttributeName())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLChannel").add("DataSource", dataSource())
                .add("CompressionType", compressionTypeAsString()).add("TargetAttributeName", targetAttributeName())
                .add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "CompressionType":
            return Optional.ofNullable(clazz.cast(compressionTypeAsString()));
        case "TargetAttributeName":
            return Optional.ofNullable(clazz.cast(targetAttributeName()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLChannel, T> g) {
        return obj -> g.apply((AutoMLChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLChannel> {
        /**
         * <p>
         * The data source for an AutoML channel.
         * </p>
         * 
         * @param dataSource
         *        The data source for an AutoML channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(AutoMLDataSource dataSource);

        /**
         * <p>
         * The data source for an AutoML channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLDataSource.Builder} avoiding the
         * need to create one manually via {@link AutoMLDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSource(AutoMLDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link AutoMLDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(AutoMLDataSource)
         */
        default Builder dataSource(Consumer<AutoMLDataSource.Builder> dataSource) {
            return dataSource(AutoMLDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
         * </p>
         * 
         * @param compressionType
         *        You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(String compressionType);

        /**
         * <p>
         * You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
         * </p>
         * 
         * @param compressionType
         *        You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(CompressionType compressionType);

        /**
         * <p>
         * The name of the target variable in supervised learning, usually represented by 'y'.
         * </p>
         * 
         * @param targetAttributeName
         *        The name of the target variable in supervised learning, usually represented by 'y'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAttributeName(String targetAttributeName);

        /**
         * <p>
         * The content type of the data from the input source. You can use <code>text/csv;header=present</code> or
         * <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.
         * </p>
         * 
         * @param contentType
         *        The content type of the data from the input source. You can use <code>text/csv;header=present</code>
         *        or <code>x-application/vnd.amazon+parquet</code>. The default value is
         *        <code>text/csv;header=present</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private AutoMLDataSource dataSource;

        private String compressionType;

        private String targetAttributeName;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLChannel model) {
            dataSource(model.dataSource);
            compressionType(model.compressionType);
            targetAttributeName(model.targetAttributeName);
            contentType(model.contentType);
        }

        public final AutoMLDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(AutoMLDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(AutoMLDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getCompressionType() {
            return compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final String getTargetAttributeName() {
            return targetAttributeName;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public AutoMLChannel build() {
            return new AutoMLChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
