/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the location of the output produced by the labeling job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobOutput.Builder, LabelingJobOutput> {
    private static final SdkField<String> OUTPUT_DATASET_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputDatasetS3Uri").getter(getter(LabelingJobOutput::outputDatasetS3Uri))
            .setter(setter(Builder::outputDatasetS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDatasetS3Uri").build())
            .build();

    private static final SdkField<String> FINAL_ACTIVE_LEARNING_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FinalActiveLearningModelArn")
            .getter(getter(LabelingJobOutput::finalActiveLearningModelArn))
            .setter(setter(Builder::finalActiveLearningModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalActiveLearningModelArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_DATASET_S3_URI_FIELD,
            FINAL_ACTIVE_LEARNING_MODEL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputDatasetS3Uri;

    private final String finalActiveLearningModelArn;

    private LabelingJobOutput(BuilderImpl builder) {
        this.outputDatasetS3Uri = builder.outputDatasetS3Uri;
        this.finalActiveLearningModelArn = builder.finalActiveLearningModelArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket location of the manifest file for labeled data.
     * </p>
     * 
     * @return The Amazon S3 bucket location of the manifest file for labeled data.
     */
    public final String outputDatasetS3Uri() {
        return outputDatasetS3Uri;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model trained as part of automated data
     * labeling.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model trained as part of automated
     *         data labeling.
     */
    public final String finalActiveLearningModelArn() {
        return finalActiveLearningModelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputDatasetS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(finalActiveLearningModelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobOutput)) {
            return false;
        }
        LabelingJobOutput other = (LabelingJobOutput) obj;
        return Objects.equals(outputDatasetS3Uri(), other.outputDatasetS3Uri())
                && Objects.equals(finalActiveLearningModelArn(), other.finalActiveLearningModelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelingJobOutput").add("OutputDatasetS3Uri", outputDatasetS3Uri())
                .add("FinalActiveLearningModelArn", finalActiveLearningModelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputDatasetS3Uri":
            return Optional.ofNullable(clazz.cast(outputDatasetS3Uri()));
        case "FinalActiveLearningModelArn":
            return Optional.ofNullable(clazz.cast(finalActiveLearningModelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobOutput, T> g) {
        return obj -> g.apply((LabelingJobOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobOutput> {
        /**
         * <p>
         * The Amazon S3 bucket location of the manifest file for labeled data.
         * </p>
         * 
         * @param outputDatasetS3Uri
         *        The Amazon S3 bucket location of the manifest file for labeled data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDatasetS3Uri(String outputDatasetS3Uri);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model trained as part of automated data
         * labeling.
         * </p>
         * 
         * @param finalActiveLearningModelArn
         *        The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model trained as part of automated
         *        data labeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalActiveLearningModelArn(String finalActiveLearningModelArn);
    }

    static final class BuilderImpl implements Builder {
        private String outputDatasetS3Uri;

        private String finalActiveLearningModelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobOutput model) {
            outputDatasetS3Uri(model.outputDatasetS3Uri);
            finalActiveLearningModelArn(model.finalActiveLearningModelArn);
        }

        public final String getOutputDatasetS3Uri() {
            return outputDatasetS3Uri;
        }

        public final void setOutputDatasetS3Uri(String outputDatasetS3Uri) {
            this.outputDatasetS3Uri = outputDatasetS3Uri;
        }

        @Override
        public final Builder outputDatasetS3Uri(String outputDatasetS3Uri) {
            this.outputDatasetS3Uri = outputDatasetS3Uri;
            return this;
        }

        public final String getFinalActiveLearningModelArn() {
            return finalActiveLearningModelArn;
        }

        public final void setFinalActiveLearningModelArn(String finalActiveLearningModelArn) {
            this.finalActiveLearningModelArn = finalActiveLearningModelArn;
        }

        @Override
        public final Builder finalActiveLearningModelArn(String finalActiveLearningModelArn) {
            this.finalActiveLearningModelArn = finalActiveLearningModelArn;
            return this;
        }

        @Override
        public LabelingJobOutput build() {
            return new LabelingJobOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
