/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the behavior of the client used by Amazon SageMaker to interact with the model container during
 * asynchronous inference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncInferenceClientConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncInferenceClientConfig.Builder, AsyncInferenceClientConfig> {
    private static final SdkField<Integer> MAX_CONCURRENT_INVOCATIONS_PER_INSTANCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentInvocationsPerInstance")
            .getter(getter(AsyncInferenceClientConfig::maxConcurrentInvocationsPerInstance))
            .setter(setter(Builder::maxConcurrentInvocationsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MaxConcurrentInvocationsPerInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MAX_CONCURRENT_INVOCATIONS_PER_INSTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxConcurrentInvocationsPerInstance;

    private AsyncInferenceClientConfig(BuilderImpl builder) {
        this.maxConcurrentInvocationsPerInstance = builder.maxConcurrentInvocationsPerInstance;
    }

    /**
     * <p>
     * The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is
     * provided, Amazon SageMaker will choose an optimal value for you.
     * </p>
     * 
     * @return The maximum number of concurrent requests sent by the SageMaker client to the model container. If no
     *         value is provided, Amazon SageMaker will choose an optimal value for you.
     */
    public final Integer maxConcurrentInvocationsPerInstance() {
        return maxConcurrentInvocationsPerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentInvocationsPerInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceClientConfig)) {
            return false;
        }
        AsyncInferenceClientConfig other = (AsyncInferenceClientConfig) obj;
        return Objects.equals(maxConcurrentInvocationsPerInstance(), other.maxConcurrentInvocationsPerInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncInferenceClientConfig")
                .add("MaxConcurrentInvocationsPerInstance", maxConcurrentInvocationsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxConcurrentInvocationsPerInstance":
            return Optional.ofNullable(clazz.cast(maxConcurrentInvocationsPerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceClientConfig, T> g) {
        return obj -> g.apply((AsyncInferenceClientConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncInferenceClientConfig> {
        /**
         * <p>
         * The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is
         * provided, Amazon SageMaker will choose an optimal value for you.
         * </p>
         * 
         * @param maxConcurrentInvocationsPerInstance
         *        The maximum number of concurrent requests sent by the SageMaker client to the model container. If no
         *        value is provided, Amazon SageMaker will choose an optimal value for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentInvocationsPerInstance(Integer maxConcurrentInvocationsPerInstance);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxConcurrentInvocationsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceClientConfig model) {
            maxConcurrentInvocationsPerInstance(model.maxConcurrentInvocationsPerInstance);
        }

        public final Integer getMaxConcurrentInvocationsPerInstance() {
            return maxConcurrentInvocationsPerInstance;
        }

        public final void setMaxConcurrentInvocationsPerInstance(Integer maxConcurrentInvocationsPerInstance) {
            this.maxConcurrentInvocationsPerInstance = maxConcurrentInvocationsPerInstance;
        }

        @Override
        public final Builder maxConcurrentInvocationsPerInstance(Integer maxConcurrentInvocationsPerInstance) {
            this.maxConcurrentInvocationsPerInstance = maxConcurrentInvocationsPerInstance;
            return this;
        }

        @Override
        public AsyncInferenceClientConfig build() {
            return new AsyncInferenceClientConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
