/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A versioned model that can be deployed for SageMaker inference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackage implements SdkPojo, Serializable, ToCopyableBuilder<ModelPackage.Builder, ModelPackage> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageName").getter(getter(ModelPackage::modelPackageName))
            .setter(setter(Builder::modelPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupName").getter(getter(ModelPackage::modelPackageGroupName))
            .setter(setter(Builder::modelPackageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build())
            .build();

    private static final SdkField<Integer> MODEL_PACKAGE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelPackageVersion").getter(getter(ModelPackage::modelPackageVersion))
            .setter(setter(Builder::modelPackageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersion").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageArn").getter(getter(ModelPackage::modelPackageArn)).setter(setter(Builder::modelPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageDescription").getter(getter(ModelPackage::modelPackageDescription))
            .setter(setter(Builder::modelPackageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelPackage::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField
            .<InferenceSpecification> builder(MarshallingType.SDK_POJO).memberName("InferenceSpecification")
            .getter(getter(ModelPackage::inferenceSpecification)).setter(setter(Builder::inferenceSpecification))
            .constructor(InferenceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build())
            .build();

    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<SourceAlgorithmSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("SourceAlgorithmSpecification")
            .getter(getter(ModelPackage::sourceAlgorithmSpecification))
            .setter(setter(Builder::sourceAlgorithmSpecification))
            .constructor(SourceAlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification")
                    .build()).build();

    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField
            .<ModelPackageValidationSpecification> builder(MarshallingType.SDK_POJO).memberName("ValidationSpecification")
            .getter(getter(ModelPackage::validationSpecification)).setter(setter(Builder::validationSpecification))
            .constructor(ModelPackageValidationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageStatus").getter(getter(ModelPackage::modelPackageStatusAsString))
            .setter(setter(Builder::modelPackageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build())
            .build();

    private static final SdkField<ModelPackageStatusDetails> MODEL_PACKAGE_STATUS_DETAILS_FIELD = SdkField
            .<ModelPackageStatusDetails> builder(MarshallingType.SDK_POJO).memberName("ModelPackageStatusDetails")
            .getter(getter(ModelPackage::modelPackageStatusDetails)).setter(setter(Builder::modelPackageStatusDetails))
            .constructor(ModelPackageStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatusDetails").build())
            .build();

    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CertifyForMarketplace").getter(getter(ModelPackage::certifyForMarketplace))
            .setter(setter(Builder::certifyForMarketplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build())
            .build();

    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelApprovalStatus").getter(getter(ModelPackage::modelApprovalStatusAsString))
            .setter(setter(Builder::modelApprovalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build())
            .build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(ModelPackage::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(ModelPackage::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<ModelMetrics> MODEL_METRICS_FIELD = SdkField.<ModelMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("ModelMetrics").getter(getter(ModelPackage::modelMetrics)).setter(setter(Builder::modelMetrics))
            .constructor(ModelMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ModelPackage::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(ModelPackage::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalDescription").getter(getter(ModelPackage::approvalDescription))
            .setter(setter(Builder::approvalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(ModelPackage::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Task")
            .getter(getter(ModelPackage::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()).build();

    private static final SdkField<String> SAMPLE_PAYLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SamplePayloadUrl").getter(getter(ModelPackage::samplePayloadUrl))
            .setter(setter(Builder::samplePayloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePayloadUrl").build()).build();

    private static final SdkField<List<AdditionalInferenceSpecificationDefinition>> ADDITIONAL_INFERENCE_SPECIFICATIONS_FIELD = SdkField
            .<List<AdditionalInferenceSpecificationDefinition>> builder(MarshallingType.LIST)
            .memberName("AdditionalInferenceSpecifications")
            .getter(getter(ModelPackage::additionalInferenceSpecifications))
            .setter(setter(Builder::additionalInferenceSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInferenceSpecifications")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalInferenceSpecificationDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalInferenceSpecificationDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ModelPackage::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CUSTOMER_METADATA_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomerMetadataProperties")
            .getter(getter(ModelPackage::customerMetadataProperties))
            .setter(setter(Builder::customerMetadataProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DriftCheckBaselines> DRIFT_CHECK_BASELINES_FIELD = SdkField
            .<DriftCheckBaselines> builder(MarshallingType.SDK_POJO).memberName("DriftCheckBaselines")
            .getter(getter(ModelPackage::driftCheckBaselines)).setter(setter(Builder::driftCheckBaselines))
            .constructor(DriftCheckBaselines::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftCheckBaselines").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD,
            MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_VERSION_FIELD, MODEL_PACKAGE_ARN_FIELD,
            MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, INFERENCE_SPECIFICATION_FIELD,
            SOURCE_ALGORITHM_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, MODEL_PACKAGE_STATUS_FIELD,
            MODEL_PACKAGE_STATUS_DETAILS_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD, MODEL_APPROVAL_STATUS_FIELD, CREATED_BY_FIELD,
            METADATA_PROPERTIES_FIELD, MODEL_METRICS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD,
            APPROVAL_DESCRIPTION_FIELD, DOMAIN_FIELD, TASK_FIELD, SAMPLE_PAYLOAD_URL_FIELD,
            ADDITIONAL_INFERENCE_SPECIFICATIONS_FIELD, TAGS_FIELD, CUSTOMER_METADATA_PROPERTIES_FIELD,
            DRIFT_CHECK_BASELINES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelPackageName;

    private final String modelPackageGroupName;

    private final Integer modelPackageVersion;

    private final String modelPackageArn;

    private final String modelPackageDescription;

    private final Instant creationTime;

    private final InferenceSpecification inferenceSpecification;

    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;

    private final ModelPackageValidationSpecification validationSpecification;

    private final String modelPackageStatus;

    private final ModelPackageStatusDetails modelPackageStatusDetails;

    private final Boolean certifyForMarketplace;

    private final String modelApprovalStatus;

    private final UserContext createdBy;

    private final MetadataProperties metadataProperties;

    private final ModelMetrics modelMetrics;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final String approvalDescription;

    private final String domain;

    private final String task;

    private final String samplePayloadUrl;

    private final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications;

    private final List<Tag> tags;

    private final Map<String, String> customerMetadataProperties;

    private final DriftCheckBaselines driftCheckBaselines;

    private ModelPackage(BuilderImpl builder) {
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageVersion = builder.modelPackageVersion;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.modelPackageStatus = builder.modelPackageStatus;
        this.modelPackageStatusDetails = builder.modelPackageStatusDetails;
        this.certifyForMarketplace = builder.certifyForMarketplace;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.createdBy = builder.createdBy;
        this.metadataProperties = builder.metadataProperties;
        this.modelMetrics = builder.modelMetrics;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.approvalDescription = builder.approvalDescription;
        this.domain = builder.domain;
        this.task = builder.task;
        this.samplePayloadUrl = builder.samplePayloadUrl;
        this.additionalInferenceSpecifications = builder.additionalInferenceSpecifications;
        this.tags = builder.tags;
        this.customerMetadataProperties = builder.customerMetadataProperties;
        this.driftCheckBaselines = builder.driftCheckBaselines;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelPackageName() {
        return modelPackageName;
    }

    /**
     * <p>
     * The model group to which the model belongs.
     * </p>
     * 
     * @return The model group to which the model belongs.
     */
    public final String modelPackageGroupName() {
        return modelPackageGroupName;
    }

    /**
     * <p>
     * The version number of a versioned model.
     * </p>
     * 
     * @return The version number of a versioned model.
     */
    public final Integer modelPackageVersion() {
        return modelPackageVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model package.
     */
    public final String modelPackageArn() {
        return modelPackageArn;
    }

    /**
     * <p>
     * The description of the model package.
     * </p>
     * 
     * @return The description of the model package.
     */
    public final String modelPackageDescription() {
        return modelPackageDescription;
    }

    /**
     * <p>
     * The time that the model package was created.
     * </p>
     * 
     * @return The time that the model package was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the InferenceSpecification property for this object.
     * 
     * @return The value of the InferenceSpecification property for this object.
     */
    public final InferenceSpecification inferenceSpecification() {
        return inferenceSpecification;
    }

    /**
     * Returns the value of the SourceAlgorithmSpecification property for this object.
     * 
     * @return The value of the SourceAlgorithmSpecification property for this object.
     */
    public final SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return sourceAlgorithmSpecification;
    }

    /**
     * Returns the value of the ValidationSpecification property for this object.
     * 
     * @return The value of the ValidationSpecification property for this object.
     */
    public final ModelPackageValidationSpecification validationSpecification() {
        return validationSpecification;
    }

    /**
     * <p>
     * The status of the model package. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The model package is pending being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The model package is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The model package was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The model package failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The model package is in the process of being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The status of the model package. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The model package is pending being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The model package is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The model package was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The model package failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The model package is in the process of being deleted.
     *         </p>
     *         </li>
     * @see ModelPackageStatus
     */
    public final ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(modelPackageStatus);
    }

    /**
     * <p>
     * The status of the model package. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The model package is pending being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The model package is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The model package was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The model package failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The model package is in the process of being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The status of the model package. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The model package is pending being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The model package is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The model package was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The model package failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The model package is in the process of being deleted.
     *         </p>
     *         </li>
     * @see ModelPackageStatus
     */
    public final String modelPackageStatusAsString() {
        return modelPackageStatus;
    }

    /**
     * Returns the value of the ModelPackageStatusDetails property for this object.
     * 
     * @return The value of the ModelPackageStatusDetails property for this object.
     */
    public final ModelPackageStatusDetails modelPackageStatusDetails() {
        return modelPackageStatusDetails;
    }

    /**
     * <p>
     * Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For information
     * about listing model packages on Amazon Web Services Marketplace, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model
     * Package on Amazon Web Services Marketplace</a>.
     * </p>
     * 
     * @return Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
     *         information about listing model packages on Amazon Web Services Marketplace, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or
     *         Model Package on Amazon Web Services Marketplace</a>.
     */
    public final Boolean certifyForMarketplace() {
        return certifyForMarketplace;
    }

    /**
     * <p>
     * The approval status of the model. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVED</code> - The model is approved
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The model is rejected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVED</code> - The model is approved
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The model is rejected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
     *         </p>
     *         </li>
     * @see ModelApprovalStatus
     */
    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(modelApprovalStatus);
    }

    /**
     * <p>
     * The approval status of the model. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVED</code> - The model is approved
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The model is rejected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVED</code> - The model is approved
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The model is rejected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
     *         </p>
     *         </li>
     * @see ModelApprovalStatus
     */
    public final String modelApprovalStatusAsString() {
        return modelApprovalStatus;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * <p>
     * Metrics for the model.
     * </p>
     * 
     * @return Metrics for the model.
     */
    public final ModelMetrics modelMetrics() {
        return modelMetrics;
    }

    /**
     * <p>
     * The last time the model package was modified.
     * </p>
     * 
     * @return The last time the model package was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * A description provided when the model approval is set.
     * </p>
     * 
     * @return A description provided when the model approval is set.
     */
    public final String approvalDescription() {
        return approvalDescription;
    }

    /**
     * <p>
     * The machine learning domain of your model package and its components. Common machine learning domains include
     * computer vision and natural language processing.
     * </p>
     * 
     * @return The machine learning domain of your model package and its components. Common machine learning domains
     *         include computer vision and natural language processing.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The machine learning task your model package accomplishes. Common machine learning tasks include object detection
     * and image classification.
     * </p>
     * 
     * @return The machine learning task your model package accomplishes. Common machine learning tasks include object
     *         detection and image classification.
     */
    public final String task() {
        return task;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip
     * compressed tar archive (.tar.gz suffix).
     * </p>
     * 
     * @return The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a
     *         single gzip compressed tar archive (.tar.gz suffix).
     */
    public final String samplePayloadUrl() {
        return samplePayloadUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalInferenceSpecifications
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalInferenceSpecifications() {
        return additionalInferenceSpecifications != null && !(additionalInferenceSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of additional Inference Specification objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalInferenceSpecifications}
     * method.
     * </p>
     * 
     * @return An array of additional Inference Specification objects.
     */
    public final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications() {
        return additionalInferenceSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tags associated with the model package. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of the tags associated with the model package. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerMetadataProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomerMetadataProperties() {
        return customerMetadataProperties != null && !(customerMetadataProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata properties for the model package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerMetadataProperties} method.
     * </p>
     * 
     * @return The metadata properties for the model package.
     */
    public final Map<String, String> customerMetadataProperties() {
        return customerMetadataProperties;
    }

    /**
     * <p>
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     * </p>
     * 
     * @return Represents the drift check baselines that can be used when the model monitor is set using the model
     *         package.
     */
    public final DriftCheckBaselines driftCheckBaselines() {
        return driftCheckBaselines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(certifyForMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(approvalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(samplePayloadUrl());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalInferenceSpecifications() ? additionalInferenceSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerMetadataProperties() ? customerMetadataProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(driftCheckBaselines());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackage)) {
            return false;
        }
        ModelPackage other = (ModelPackage) obj;
        return Objects.equals(modelPackageName(), other.modelPackageName())
                && Objects.equals(modelPackageGroupName(), other.modelPackageGroupName())
                && Objects.equals(modelPackageVersion(), other.modelPackageVersion())
                && Objects.equals(modelPackageArn(), other.modelPackageArn())
                && Objects.equals(modelPackageDescription(), other.modelPackageDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(inferenceSpecification(), other.inferenceSpecification())
                && Objects.equals(sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification())
                && Objects.equals(validationSpecification(), other.validationSpecification())
                && Objects.equals(modelPackageStatusAsString(), other.modelPackageStatusAsString())
                && Objects.equals(modelPackageStatusDetails(), other.modelPackageStatusDetails())
                && Objects.equals(certifyForMarketplace(), other.certifyForMarketplace())
                && Objects.equals(modelApprovalStatusAsString(), other.modelApprovalStatusAsString())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(metadataProperties(), other.metadataProperties())
                && Objects.equals(modelMetrics(), other.modelMetrics())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(approvalDescription(), other.approvalDescription()) && Objects.equals(domain(), other.domain())
                && Objects.equals(task(), other.task()) && Objects.equals(samplePayloadUrl(), other.samplePayloadUrl())
                && hasAdditionalInferenceSpecifications() == other.hasAdditionalInferenceSpecifications()
                && Objects.equals(additionalInferenceSpecifications(), other.additionalInferenceSpecifications())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasCustomerMetadataProperties() == other.hasCustomerMetadataProperties()
                && Objects.equals(customerMetadataProperties(), other.customerMetadataProperties())
                && Objects.equals(driftCheckBaselines(), other.driftCheckBaselines());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ModelPackage")
                .add("ModelPackageName", modelPackageName())
                .add("ModelPackageGroupName", modelPackageGroupName())
                .add("ModelPackageVersion", modelPackageVersion())
                .add("ModelPackageArn", modelPackageArn())
                .add("ModelPackageDescription", modelPackageDescription())
                .add("CreationTime", creationTime())
                .add("InferenceSpecification", inferenceSpecification())
                .add("SourceAlgorithmSpecification", sourceAlgorithmSpecification())
                .add("ValidationSpecification", validationSpecification())
                .add("ModelPackageStatus", modelPackageStatusAsString())
                .add("ModelPackageStatusDetails", modelPackageStatusDetails())
                .add("CertifyForMarketplace", certifyForMarketplace())
                .add("ModelApprovalStatus", modelApprovalStatusAsString())
                .add("CreatedBy", createdBy())
                .add("MetadataProperties", metadataProperties())
                .add("ModelMetrics", modelMetrics())
                .add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy())
                .add("ApprovalDescription", approvalDescription())
                .add("Domain", domain())
                .add("Task", task())
                .add("SamplePayloadUrl", samplePayloadUrl())
                .add("AdditionalInferenceSpecifications",
                        hasAdditionalInferenceSpecifications() ? additionalInferenceSpecifications() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("CustomerMetadataProperties", hasCustomerMetadataProperties() ? customerMetadataProperties() : null)
                .add("DriftCheckBaselines", driftCheckBaselines()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageName":
            return Optional.ofNullable(clazz.cast(modelPackageName()));
        case "ModelPackageGroupName":
            return Optional.ofNullable(clazz.cast(modelPackageGroupName()));
        case "ModelPackageVersion":
            return Optional.ofNullable(clazz.cast(modelPackageVersion()));
        case "ModelPackageArn":
            return Optional.ofNullable(clazz.cast(modelPackageArn()));
        case "ModelPackageDescription":
            return Optional.ofNullable(clazz.cast(modelPackageDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "InferenceSpecification":
            return Optional.ofNullable(clazz.cast(inferenceSpecification()));
        case "SourceAlgorithmSpecification":
            return Optional.ofNullable(clazz.cast(sourceAlgorithmSpecification()));
        case "ValidationSpecification":
            return Optional.ofNullable(clazz.cast(validationSpecification()));
        case "ModelPackageStatus":
            return Optional.ofNullable(clazz.cast(modelPackageStatusAsString()));
        case "ModelPackageStatusDetails":
            return Optional.ofNullable(clazz.cast(modelPackageStatusDetails()));
        case "CertifyForMarketplace":
            return Optional.ofNullable(clazz.cast(certifyForMarketplace()));
        case "ModelApprovalStatus":
            return Optional.ofNullable(clazz.cast(modelApprovalStatusAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "ModelMetrics":
            return Optional.ofNullable(clazz.cast(modelMetrics()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "ApprovalDescription":
            return Optional.ofNullable(clazz.cast(approvalDescription()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Task":
            return Optional.ofNullable(clazz.cast(task()));
        case "SamplePayloadUrl":
            return Optional.ofNullable(clazz.cast(samplePayloadUrl()));
        case "AdditionalInferenceSpecifications":
            return Optional.ofNullable(clazz.cast(additionalInferenceSpecifications()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CustomerMetadataProperties":
            return Optional.ofNullable(clazz.cast(customerMetadataProperties()));
        case "DriftCheckBaselines":
            return Optional.ofNullable(clazz.cast(driftCheckBaselines()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackage, T> g) {
        return obj -> g.apply((ModelPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackage> {
        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelPackageName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageName(String modelPackageName);

        /**
         * <p>
         * The model group to which the model belongs.
         * </p>
         * 
         * @param modelPackageGroupName
         *        The model group to which the model belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupName(String modelPackageGroupName);

        /**
         * <p>
         * The version number of a versioned model.
         * </p>
         * 
         * @param modelPackageVersion
         *        The version number of a versioned model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageVersion(Integer modelPackageVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model package.
         * </p>
         * 
         * @param modelPackageArn
         *        The Amazon Resource Name (ARN) of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageArn(String modelPackageArn);

        /**
         * <p>
         * The description of the model package.
         * </p>
         * 
         * @param modelPackageDescription
         *        The description of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageDescription(String modelPackageDescription);

        /**
         * <p>
         * The time that the model package was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the model package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the InferenceSpecification property for this object.
         *
         * @param inferenceSpecification
         *        The new value for the InferenceSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecification(InferenceSpecification inferenceSpecification);

        /**
         * Sets the value of the InferenceSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InferenceSpecification.Builder} avoiding
         * the need to create one manually via {@link InferenceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceSpecification(InferenceSpecification)}.
         * 
         * @param inferenceSpecification
         *        a consumer that will call methods on {@link InferenceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSpecification(InferenceSpecification)
         */
        default Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return inferenceSpecification(InferenceSpecification.builder().applyMutation(inferenceSpecification).build());
        }

        /**
         * Sets the value of the SourceAlgorithmSpecification property for this object.
         *
         * @param sourceAlgorithmSpecification
         *        The new value for the SourceAlgorithmSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification);

        /**
         * Sets the value of the SourceAlgorithmSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SourceAlgorithmSpecification.Builder}
         * avoiding the need to create one manually via {@link SourceAlgorithmSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceAlgorithmSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAlgorithmSpecification(SourceAlgorithmSpecification)}.
         * 
         * @param sourceAlgorithmSpecification
         *        a consumer that will call methods on {@link SourceAlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAlgorithmSpecification(SourceAlgorithmSpecification)
         */
        default Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return sourceAlgorithmSpecification(SourceAlgorithmSpecification.builder()
                    .applyMutation(sourceAlgorithmSpecification).build());
        }

        /**
         * Sets the value of the ValidationSpecification property for this object.
         *
         * @param validationSpecification
         *        The new value for the ValidationSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSpecification(ModelPackageValidationSpecification validationSpecification);

        /**
         * Sets the value of the ValidationSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ModelPackageValidationSpecification.Builder} avoiding the need to create one manually via
         * {@link ModelPackageValidationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageValidationSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #validationSpecification(ModelPackageValidationSpecification)}
         * .
         * 
         * @param validationSpecification
         *        a consumer that will call methods on {@link ModelPackageValidationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationSpecification(ModelPackageValidationSpecification)
         */
        default Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return validationSpecification(ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)
                    .build());
        }

        /**
         * <p>
         * The status of the model package. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The model package is pending being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The model package is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The model package was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The model package failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The model package is in the process of being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelPackageStatus
         *        The status of the model package. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The model package is pending being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The model package is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The model package was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The model package failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The model package is in the process of being deleted.
         *        </p>
         *        </li>
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(String modelPackageStatus);

        /**
         * <p>
         * The status of the model package. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The model package is pending being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The model package is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The model package was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The model package failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The model package is in the process of being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelPackageStatus
         *        The status of the model package. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The model package is pending being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The model package is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The model package was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The model package failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The model package is in the process of being deleted.
         *        </p>
         *        </li>
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(ModelPackageStatus modelPackageStatus);

        /**
         * Sets the value of the ModelPackageStatusDetails property for this object.
         *
         * @param modelPackageStatusDetails
         *        The new value for the ModelPackageStatusDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails);

        /**
         * Sets the value of the ModelPackageStatusDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ModelPackageStatusDetails.Builder}
         * avoiding the need to create one manually via {@link ModelPackageStatusDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageStatusDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #modelPackageStatusDetails(ModelPackageStatusDetails)}.
         * 
         * @param modelPackageStatusDetails
         *        a consumer that will call methods on {@link ModelPackageStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackageStatusDetails(ModelPackageStatusDetails)
         */
        default Builder modelPackageStatusDetails(Consumer<ModelPackageStatusDetails.Builder> modelPackageStatusDetails) {
            return modelPackageStatusDetails(ModelPackageStatusDetails.builder().applyMutation(modelPackageStatusDetails).build());
        }

        /**
         * <p>
         * Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For information
         * about listing model packages on Amazon Web Services Marketplace, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model
         * Package on Amazon Web Services Marketplace</a>.
         * </p>
         * 
         * @param certifyForMarketplace
         *        Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
         *        information about listing model packages on Amazon Web Services Marketplace, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or
         *        Model Package on Amazon Web Services Marketplace</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certifyForMarketplace(Boolean certifyForMarketplace);

        /**
         * <p>
         * The approval status of the model. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVED</code> - The model is approved
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The model is rejected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVED</code> - The model is approved
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The model is rejected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
         *        </p>
         *        </li>
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(String modelApprovalStatus);

        /**
         * <p>
         * The approval status of the model. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVED</code> - The model is approved
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The model is rejected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVED</code> - The model is approved
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The model is rejected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.
         *        </p>
         *        </li>
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetadataProperties.Builder} avoiding the
         * need to create one manually via {@link MetadataProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * Metrics for the model.
         * </p>
         * 
         * @param modelMetrics
         *        Metrics for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelMetrics(ModelMetrics modelMetrics);

        /**
         * <p>
         * Metrics for the model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelMetrics.Builder} avoiding the need
         * to create one manually via {@link ModelMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #modelMetrics(ModelMetrics)}.
         * 
         * @param modelMetrics
         *        a consumer that will call methods on {@link ModelMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelMetrics(ModelMetrics)
         */
        default Builder modelMetrics(Consumer<ModelMetrics.Builder> modelMetrics) {
            return modelMetrics(ModelMetrics.builder().applyMutation(modelMetrics).build());
        }

        /**
         * <p>
         * The last time the model package was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the model package was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * A description provided when the model approval is set.
         * </p>
         * 
         * @param approvalDescription
         *        A description provided when the model approval is set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalDescription(String approvalDescription);

        /**
         * <p>
         * The machine learning domain of your model package and its components. Common machine learning domains include
         * computer vision and natural language processing.
         * </p>
         * 
         * @param domain
         *        The machine learning domain of your model package and its components. Common machine learning domains
         *        include computer vision and natural language processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The machine learning task your model package accomplishes. Common machine learning tasks include object
         * detection and image classification.
         * </p>
         * 
         * @param task
         *        The machine learning task your model package accomplishes. Common machine learning tasks include
         *        object detection and image classification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        /**
         * <p>
         * The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single
         * gzip compressed tar archive (.tar.gz suffix).
         * </p>
         * 
         * @param samplePayloadUrl
         *        The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a
         *        single gzip compressed tar archive (.tar.gz suffix).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplePayloadUrl(String samplePayloadUrl);

        /**
         * <p>
         * An array of additional Inference Specification objects.
         * </p>
         * 
         * @param additionalInferenceSpecifications
         *        An array of additional Inference Specification objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInferenceSpecifications(
                Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications);

        /**
         * <p>
         * An array of additional Inference Specification objects.
         * </p>
         * 
         * @param additionalInferenceSpecifications
         *        An array of additional Inference Specification objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInferenceSpecifications(AdditionalInferenceSpecificationDefinition... additionalInferenceSpecifications);

        /**
         * <p>
         * An array of additional Inference Specification objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <AdditionalInferenceSpecificationDefinition>.Builder} avoiding the need to create one manually via
         * {@link List<AdditionalInferenceSpecificationDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdditionalInferenceSpecificationDefinition>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalInferenceSpecifications(List<AdditionalInferenceSpecificationDefinition>)}.
         * 
         * @param additionalInferenceSpecifications
         *        a consumer that will call methods on {@link List<AdditionalInferenceSpecificationDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalInferenceSpecifications(List<AdditionalInferenceSpecificationDefinition>)
         */
        Builder additionalInferenceSpecifications(
                Consumer<AdditionalInferenceSpecificationDefinition.Builder>... additionalInferenceSpecifications);

        /**
         * <p>
         * A list of the tags associated with the model package. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of the tags associated with the model package. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of the tags associated with the model package. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of the tags associated with the model package. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of the tags associated with the model package. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The metadata properties for the model package.
         * </p>
         * 
         * @param customerMetadataProperties
         *        The metadata properties for the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerMetadataProperties(Map<String, String> customerMetadataProperties);

        /**
         * <p>
         * Represents the drift check baselines that can be used when the model monitor is set using the model package.
         * </p>
         * 
         * @param driftCheckBaselines
         *        Represents the drift check baselines that can be used when the model monitor is set using the model
         *        package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftCheckBaselines(DriftCheckBaselines driftCheckBaselines);

        /**
         * <p>
         * Represents the drift check baselines that can be used when the model monitor is set using the model package.
         * </p>
         * This is a convenience method that creates an instance of the {@link DriftCheckBaselines.Builder} avoiding the
         * need to create one manually via {@link DriftCheckBaselines#builder()}.
         *
         * When the {@link Consumer} completes, {@link DriftCheckBaselines.Builder#build()} is called immediately and
         * its result is passed to {@link #driftCheckBaselines(DriftCheckBaselines)}.
         * 
         * @param driftCheckBaselines
         *        a consumer that will call methods on {@link DriftCheckBaselines.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftCheckBaselines(DriftCheckBaselines)
         */
        default Builder driftCheckBaselines(Consumer<DriftCheckBaselines.Builder> driftCheckBaselines) {
            return driftCheckBaselines(DriftCheckBaselines.builder().applyMutation(driftCheckBaselines).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String modelPackageName;

        private String modelPackageGroupName;

        private Integer modelPackageVersion;

        private String modelPackageArn;

        private String modelPackageDescription;

        private Instant creationTime;

        private InferenceSpecification inferenceSpecification;

        private SourceAlgorithmSpecification sourceAlgorithmSpecification;

        private ModelPackageValidationSpecification validationSpecification;

        private String modelPackageStatus;

        private ModelPackageStatusDetails modelPackageStatusDetails;

        private Boolean certifyForMarketplace;

        private String modelApprovalStatus;

        private UserContext createdBy;

        private MetadataProperties metadataProperties;

        private ModelMetrics modelMetrics;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private String approvalDescription;

        private String domain;

        private String task;

        private String samplePayloadUrl;

        private List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications = DefaultSdkAutoConstructList
                .getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> customerMetadataProperties = DefaultSdkAutoConstructMap.getInstance();

        private DriftCheckBaselines driftCheckBaselines;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackage model) {
            modelPackageName(model.modelPackageName);
            modelPackageGroupName(model.modelPackageGroupName);
            modelPackageVersion(model.modelPackageVersion);
            modelPackageArn(model.modelPackageArn);
            modelPackageDescription(model.modelPackageDescription);
            creationTime(model.creationTime);
            inferenceSpecification(model.inferenceSpecification);
            sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            validationSpecification(model.validationSpecification);
            modelPackageStatus(model.modelPackageStatus);
            modelPackageStatusDetails(model.modelPackageStatusDetails);
            certifyForMarketplace(model.certifyForMarketplace);
            modelApprovalStatus(model.modelApprovalStatus);
            createdBy(model.createdBy);
            metadataProperties(model.metadataProperties);
            modelMetrics(model.modelMetrics);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            approvalDescription(model.approvalDescription);
            domain(model.domain);
            task(model.task);
            samplePayloadUrl(model.samplePayloadUrl);
            additionalInferenceSpecifications(model.additionalInferenceSpecifications);
            tags(model.tags);
            customerMetadataProperties(model.customerMetadataProperties);
            driftCheckBaselines(model.driftCheckBaselines);
        }

        public final String getModelPackageName() {
            return modelPackageName;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final String getModelPackageGroupName() {
            return modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final Integer getModelPackageVersion() {
            return modelPackageVersion;
        }

        public final void setModelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
        }

        @Override
        public final Builder modelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
            return this;
        }

        public final String getModelPackageArn() {
            return modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelPackageDescription() {
            return modelPackageDescription;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return inferenceSpecification != null ? inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.toBuilder() : null;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build()
                    : null;
        }

        @Override
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return validationSpecification != null ? validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final String getModelPackageStatus() {
            return modelPackageStatus;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final ModelPackageStatusDetails.Builder getModelPackageStatusDetails() {
            return modelPackageStatusDetails != null ? modelPackageStatusDetails.toBuilder() : null;
        }

        public final void setModelPackageStatusDetails(ModelPackageStatusDetails.BuilderImpl modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails != null ? modelPackageStatusDetails.build() : null;
        }

        @Override
        public final Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final String getModelApprovalStatus() {
            return modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final ModelMetrics.Builder getModelMetrics() {
            return modelMetrics != null ? modelMetrics.toBuilder() : null;
        }

        public final void setModelMetrics(ModelMetrics.BuilderImpl modelMetrics) {
            this.modelMetrics = modelMetrics != null ? modelMetrics.build() : null;
        }

        @Override
        public final Builder modelMetrics(ModelMetrics modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getApprovalDescription() {
            return approvalDescription;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getTask() {
            return task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getSamplePayloadUrl() {
            return samplePayloadUrl;
        }

        public final void setSamplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
        }

        @Override
        public final Builder samplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
            return this;
        }

        public final List<AdditionalInferenceSpecificationDefinition.Builder> getAdditionalInferenceSpecifications() {
            List<AdditionalInferenceSpecificationDefinition.Builder> result = AdditionalInferenceSpecificationsCopier
                    .copyToBuilder(this.additionalInferenceSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalInferenceSpecifications(
                Collection<AdditionalInferenceSpecificationDefinition.BuilderImpl> additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = AdditionalInferenceSpecificationsCopier
                    .copyFromBuilder(additionalInferenceSpecifications);
        }

        @Override
        public final Builder additionalInferenceSpecifications(
                Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = AdditionalInferenceSpecificationsCopier
                    .copy(additionalInferenceSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecifications(
                AdditionalInferenceSpecificationDefinition... additionalInferenceSpecifications) {
            additionalInferenceSpecifications(Arrays.asList(additionalInferenceSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecifications(
                Consumer<AdditionalInferenceSpecificationDefinition.Builder>... additionalInferenceSpecifications) {
            additionalInferenceSpecifications(Stream.of(additionalInferenceSpecifications)
                    .map(c -> AdditionalInferenceSpecificationDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getCustomerMetadataProperties() {
            if (customerMetadataProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customerMetadataProperties;
        }

        public final void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
        }

        @Override
        public final Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
            return this;
        }

        public final DriftCheckBaselines.Builder getDriftCheckBaselines() {
            return driftCheckBaselines != null ? driftCheckBaselines.toBuilder() : null;
        }

        public final void setDriftCheckBaselines(DriftCheckBaselines.BuilderImpl driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines != null ? driftCheckBaselines.build() : null;
        }

        @Override
        public final Builder driftCheckBaselines(DriftCheckBaselines driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines;
            return this;
        }

        @Override
        public ModelPackage build() {
            return new ModelPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
