/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the results of a transform job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformOutput implements SdkPojo, Serializable, ToCopyableBuilder<TransformOutput.Builder, TransformOutput> {
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputPath").getter(getter(TransformOutput::s3OutputPath)).setter(setter(Builder::s3OutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Accept")
            .getter(getter(TransformOutput::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accept").build()).build();

    private static final SdkField<String> ASSEMBLE_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssembleWith").getter(getter(TransformOutput::assembleWithAsString))
            .setter(setter(Builder::assembleWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssembleWith").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(TransformOutput::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_PATH_FIELD,
            ACCEPT_FIELD, ASSEMBLE_WITH_FIELD, KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3OutputPath;

    private final String accept;

    private final String assembleWith;

    private final String kmsKeyId;

    private TransformOutput(BuilderImpl builder) {
        this.s3OutputPath = builder.s3OutputPath;
        this.accept = builder.accept;
        this.assembleWith = builder.assembleWith;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For example,
     * <code>s3://bucket-name/key-name-prefix</code>.
     * </p>
     * <p>
     * For every S3 object used as input for the transform job, batch transform stores the transformed data with an .
     * <code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For example, for the
     * input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform stores
     * the transformed data at <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>. Batch
     * transform doesn't upload partially processed objects. For an input S3 object that contains multiple records, it
     * creates an .<code>out</code> file only if the transform job succeeds on the entire file. When the input contains
     * multiple S3 objects, the batch transform job processes the listed S3 objects and uploads only the output for
     * successfully processed objects. If any object fails in the transform job batch transform marks the job as failed
     * to prompt investigation.
     * </p>
     * 
     * @return The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For
     *         example, <code>s3://bucket-name/key-name-prefix</code>.</p>
     *         <p>
     *         For every S3 object used as input for the transform job, batch transform stores the transformed data with
     *         an .<code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For
     *         example, for the input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>,
     *         batch transform stores the transformed data at
     *         <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>. Batch transform doesn't
     *         upload partially processed objects. For an input S3 object that contains multiple records, it creates an
     *         .<code>out</code> file only if the transform job succeeds on the entire file. When the input contains
     *         multiple S3 objects, the batch transform job processes the listed S3 objects and uploads only the output
     *         for successfully processed objects. If any object fails in the transform job batch transform marks the
     *         job as failed to prompt investigation.
     */
    public final String s3OutputPath() {
        return s3OutputPath;
    }

    /**
     * <p>
     * The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to
     * transfer data from the transform job.
     * </p>
     * 
     * @return The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to
     *         transfer data from the transform job.
     */
    public final String accept() {
        return accept;
    }

    /**
     * <p>
     * Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most
     * convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline
     * character at the end of every transformed record, specify <code>Line</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assembleWith} will
     * return {@link AssemblyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assembleWithAsString}.
     * </p>
     * 
     * @return Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is
     *         most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a
     *         newline character at the end of every transformed record, specify <code>Line</code>.
     * @see AssemblyType
     */
    public final AssemblyType assembleWith() {
        return AssemblyType.fromValue(assembleWith);
    }

    /**
     * <p>
     * Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most
     * convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline
     * character at the end of every transformed record, specify <code>Line</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assembleWith} will
     * return {@link AssemblyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assembleWithAsString}.
     * </p>
     * 
     * @return Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is
     *         most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a
     *         newline character at the end of every transformed record, specify <code>Line</code>.
     * @see AssemblyType
     */
    public final String assembleWithAsString() {
        return assembleWith;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any
     * of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name: <code>alias/ExampleAlias</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's
     * account. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in
     * the <i>Amazon Simple Storage Service Developer Guide.</i>
     * </p>
     * <p>
     * The KMS key policy must grant permission to the IAM role that you specify in your <a>CreateModel</a> request. For
     * more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key
     * Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code>
     *         can be any of the following formats: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name: <code>alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your
     *         role's account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption
     *         Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i>
     *         </p>
     *         <p>
     *         The KMS key policy must grant permission to the IAM role that you specify in your <a>CreateModel</a>
     *         request. For more information, see <a
     *         href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in
     *         Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(assembleWithAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOutput)) {
            return false;
        }
        TransformOutput other = (TransformOutput) obj;
        return Objects.equals(s3OutputPath(), other.s3OutputPath()) && Objects.equals(accept(), other.accept())
                && Objects.equals(assembleWithAsString(), other.assembleWithAsString())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformOutput").add("S3OutputPath", s3OutputPath()).add("Accept", accept())
                .add("AssembleWith", assembleWithAsString()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputPath":
            return Optional.ofNullable(clazz.cast(s3OutputPath()));
        case "Accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "AssembleWith":
            return Optional.ofNullable(clazz.cast(assembleWithAsString()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformOutput, T> g) {
        return obj -> g.apply((TransformOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformOutput> {
        /**
         * <p>
         * The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For example,
         * <code>s3://bucket-name/key-name-prefix</code>.
         * </p>
         * <p>
         * For every S3 object used as input for the transform job, batch transform stores the transformed data with an
         * .<code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For example, for
         * the input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform
         * stores the transformed data at
         * <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>. Batch transform doesn't
         * upload partially processed objects. For an input S3 object that contains multiple records, it creates an .
         * <code>out</code> file only if the transform job succeeds on the entire file. When the input contains multiple
         * S3 objects, the batch transform job processes the listed S3 objects and uploads only the output for
         * successfully processed objects. If any object fails in the transform job batch transform marks the job as
         * failed to prompt investigation.
         * </p>
         * 
         * @param s3OutputPath
         *        The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For
         *        example, <code>s3://bucket-name/key-name-prefix</code>.</p>
         *        <p>
         *        For every S3 object used as input for the transform job, batch transform stores the transformed data
         *        with an .<code>out</code> suffix in a corresponding subfolder in the location in the output prefix.
         *        For example, for the input data stored at
         *        <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform stores the
         *        transformed data at <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>.
         *        Batch transform doesn't upload partially processed objects. For an input S3 object that contains
         *        multiple records, it creates an .<code>out</code> file only if the transform job succeeds on the
         *        entire file. When the input contains multiple S3 objects, the batch transform job processes the listed
         *        S3 objects and uploads only the output for successfully processed objects. If any object fails in the
         *        transform job batch transform marks the job as failed to prompt investigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputPath(String s3OutputPath);

        /**
         * <p>
         * The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to
         * transfer data from the transform job.
         * </p>
         * 
         * @param accept
         *        The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call
         *        to transfer data from the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most
         * convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline
         * character at the end of every transformed record, specify <code>Line</code>.
         * </p>
         * 
         * @param assembleWith
         *        Defines how to assemble the results of the transform job as a single S3 object. Choose a format that
         *        is most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To
         *        add a newline character at the end of every transformed record, specify <code>Line</code>.
         * @see AssemblyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssemblyType
         */
        Builder assembleWith(String assembleWith);

        /**
         * <p>
         * Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most
         * convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline
         * character at the end of every transformed record, specify <code>Line</code>.
         * </p>
         * 
         * @param assembleWith
         *        Defines how to assemble the results of the transform job as a single S3 object. Choose a format that
         *        is most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To
         *        add a newline character at the end of every transformed record, specify <code>Line</code>.
         * @see AssemblyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssemblyType
         */
        Builder assembleWith(AssemblyType assembleWith);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
         * encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be
         * any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name: <code>alias/ExampleAlias</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's
         * account. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption
         * Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i>
         * </p>
         * <p>
         * The KMS key policy must grant permission to the IAM role that you specify in your <a>CreateModel</a> request.
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon
         * Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker
         *        uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The
         *        <code>KmsKeyId</code> can be any of the following formats: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name: <code>alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your
         *        role's account. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption
         *        Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i>
         *        </p>
         *        <p>
         *        The KMS key policy must grant permission to the IAM role that you specify in your <a>CreateModel</a>
         *        request. For more information, see <a
         *        href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in
         *        Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String s3OutputPath;

        private String accept;

        private String assembleWith;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOutput model) {
            s3OutputPath(model.s3OutputPath);
            accept(model.accept);
            assembleWith(model.assembleWith);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getS3OutputPath() {
            return s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getAssembleWith() {
            return assembleWith;
        }

        public final void setAssembleWith(String assembleWith) {
            this.assembleWith = assembleWith;
        }

        @Override
        public final Builder assembleWith(String assembleWith) {
            this.assembleWith = assembleWith;
            return this;
        }

        @Override
        public final Builder assembleWith(AssemblyType assembleWith) {
            this.assembleWith(assembleWith == null ? null : assembleWith.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public TransformOutput build() {
            return new TransformOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
