/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of <code>Domain</code> configuration settings to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSettingsForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainSettingsForUpdate.Builder, DomainSettingsForUpdate> {
    private static final SdkField<RStudioServerProDomainSettingsForUpdate> R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField
            .<RStudioServerProDomainSettingsForUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("RStudioServerProDomainSettingsForUpdate")
            .getter(getter(DomainSettingsForUpdate::rStudioServerProDomainSettingsForUpdate))
            .setter(setter(Builder::rStudioServerProDomainSettingsForUpdate))
            .constructor(RStudioServerProDomainSettingsForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RStudioServerProDomainSettingsForUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;

    private DomainSettingsForUpdate(BuilderImpl builder) {
        this.rStudioServerProDomainSettingsForUpdate = builder.rStudioServerProDomainSettingsForUpdate;
    }

    /**
     * <p>
     * A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
     * </p>
     * 
     * @return A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
     */
    public final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate() {
        return rStudioServerProDomainSettingsForUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rStudioServerProDomainSettingsForUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSettingsForUpdate)) {
            return false;
        }
        DomainSettingsForUpdate other = (DomainSettingsForUpdate) obj;
        return Objects.equals(rStudioServerProDomainSettingsForUpdate(), other.rStudioServerProDomainSettingsForUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainSettingsForUpdate")
                .add("RStudioServerProDomainSettingsForUpdate", rStudioServerProDomainSettingsForUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RStudioServerProDomainSettingsForUpdate":
            return Optional.ofNullable(clazz.cast(rStudioServerProDomainSettingsForUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSettingsForUpdate, T> g) {
        return obj -> g.apply((DomainSettingsForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSettingsForUpdate> {
        /**
         * <p>
         * A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
         * </p>
         * 
         * @param rStudioServerProDomainSettingsForUpdate
         *        A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate);

        /**
         * <p>
         * A collection of <code>RStudioServerPro</code> Domain-level app settings to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RStudioServerProDomainSettingsForUpdate.Builder} avoiding the need to create one manually via
         * {@link RStudioServerProDomainSettingsForUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link RStudioServerProDomainSettingsForUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate)}.
         * 
         * @param rStudioServerProDomainSettingsForUpdate
         *        a consumer that will call methods on {@link RStudioServerProDomainSettingsForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate)
         */
        default Builder rStudioServerProDomainSettingsForUpdate(
                Consumer<RStudioServerProDomainSettingsForUpdate.Builder> rStudioServerProDomainSettingsForUpdate) {
            return rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate.builder()
                    .applyMutation(rStudioServerProDomainSettingsForUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSettingsForUpdate model) {
            rStudioServerProDomainSettingsForUpdate(model.rStudioServerProDomainSettingsForUpdate);
        }

        public final RStudioServerProDomainSettingsForUpdate.Builder getRStudioServerProDomainSettingsForUpdate() {
            return rStudioServerProDomainSettingsForUpdate != null ? rStudioServerProDomainSettingsForUpdate.toBuilder() : null;
        }

        public final void setRStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate.BuilderImpl rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate != null ? rStudioServerProDomainSettingsForUpdate
                    .build() : null;
        }

        @Override
        public final Builder rStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate;
            return this;
        }

        @Override
        public DomainSettingsForUpdate build() {
            return new DomainSettingsForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
