/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings that update the current configuration for the <code>RStudioServerPro</code> Domain-level
 * app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RStudioServerProDomainSettingsForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RStudioServerProDomainSettingsForUpdate.Builder, RStudioServerProDomainSettingsForUpdate> {
    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainExecutionRoleArn").getter(getter(RStudioServerProDomainSettingsForUpdate::domainExecutionRoleArn))
            .setter(setter(Builder::domainExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainExecutionRoleArn").build())
            .build();

    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField
            .<ResourceSpec> builder(MarshallingType.SDK_POJO).memberName("DefaultResourceSpec")
            .getter(getter(RStudioServerProDomainSettingsForUpdate::defaultResourceSpec))
            .setter(setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_EXECUTION_ROLE_ARN_FIELD, DEFAULT_RESOURCE_SPEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainExecutionRoleArn;

    private final ResourceSpec defaultResourceSpec;

    private RStudioServerProDomainSettingsForUpdate(BuilderImpl builder) {
        this.domainExecutionRoleArn = builder.domainExecutionRoleArn;
        this.defaultResourceSpec = builder.defaultResourceSpec;
    }

    /**
     * <p>
     * The execution role for the <code>RStudioServerPro</code> Domain-level app.
     * </p>
     * 
     * @return The execution role for the <code>RStudioServerPro</code> Domain-level app.
     */
    public final String domainExecutionRoleArn() {
        return domainExecutionRoleArn;
    }

    /**
     * Returns the value of the DefaultResourceSpec property for this object.
     * 
     * @return The value of the DefaultResourceSpec property for this object.
     */
    public final ResourceSpec defaultResourceSpec() {
        return defaultResourceSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultResourceSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RStudioServerProDomainSettingsForUpdate)) {
            return false;
        }
        RStudioServerProDomainSettingsForUpdate other = (RStudioServerProDomainSettingsForUpdate) obj;
        return Objects.equals(domainExecutionRoleArn(), other.domainExecutionRoleArn())
                && Objects.equals(defaultResourceSpec(), other.defaultResourceSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RStudioServerProDomainSettingsForUpdate")
                .add("DomainExecutionRoleArn", domainExecutionRoleArn()).add("DefaultResourceSpec", defaultResourceSpec())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(domainExecutionRoleArn()));
        case "DefaultResourceSpec":
            return Optional.ofNullable(clazz.cast(defaultResourceSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RStudioServerProDomainSettingsForUpdate, T> g) {
        return obj -> g.apply((RStudioServerProDomainSettingsForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RStudioServerProDomainSettingsForUpdate> {
        /**
         * <p>
         * The execution role for the <code>RStudioServerPro</code> Domain-level app.
         * </p>
         * 
         * @param domainExecutionRoleArn
         *        The execution role for the <code>RStudioServerPro</code> Domain-level app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainExecutionRoleArn(String domainExecutionRoleArn);

        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * @param defaultResourceSpec
         *        The new value for the DefaultResourceSpec property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResourceSpec(ResourceSpec defaultResourceSpec);

        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultResourceSpec(ResourceSpec)}.
         * 
         * @param defaultResourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResourceSpec(ResourceSpec)
         */
        default Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return defaultResourceSpec(ResourceSpec.builder().applyMutation(defaultResourceSpec).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainExecutionRoleArn;

        private ResourceSpec defaultResourceSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(RStudioServerProDomainSettingsForUpdate model) {
            domainExecutionRoleArn(model.domainExecutionRoleArn);
            defaultResourceSpec(model.defaultResourceSpec);
        }

        public final String getDomainExecutionRoleArn() {
            return domainExecutionRoleArn;
        }

        public final void setDomainExecutionRoleArn(String domainExecutionRoleArn) {
            this.domainExecutionRoleArn = domainExecutionRoleArn;
        }

        @Override
        public final Builder domainExecutionRoleArn(String domainExecutionRoleArn) {
            this.domainExecutionRoleArn = domainExecutionRoleArn;
            return this;
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return defaultResourceSpec != null ? defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        @Override
        public RStudioServerProDomainSettingsForUpdate build() {
            return new RStudioServerProDomainSettingsForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
