/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies weight and capacity values for a production variant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DesiredWeightAndCapacity implements SdkPojo, Serializable,
        ToCopyableBuilder<DesiredWeightAndCapacity.Builder, DesiredWeightAndCapacity> {
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantName").getter(getter(DesiredWeightAndCapacity::variantName)).setter(setter(Builder::variantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()).build();

    private static final SdkField<Float> DESIRED_WEIGHT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("DesiredWeight").getter(getter(DesiredWeightAndCapacity::desiredWeight))
            .setter(setter(Builder::desiredWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredWeight").build()).build();

    private static final SdkField<Integer> DESIRED_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredInstanceCount").getter(getter(DesiredWeightAndCapacity::desiredInstanceCount))
            .setter(setter(Builder::desiredInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstanceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_NAME_FIELD,
            DESIRED_WEIGHT_FIELD, DESIRED_INSTANCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String variantName;

    private final Float desiredWeight;

    private final Integer desiredInstanceCount;

    private DesiredWeightAndCapacity(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.desiredWeight = builder.desiredWeight;
        this.desiredInstanceCount = builder.desiredInstanceCount;
    }

    /**
     * <p>
     * The name of the variant to update.
     * </p>
     * 
     * @return The name of the variant to update.
     */
    public final String variantName() {
        return variantName;
    }

    /**
     * <p>
     * The variant's weight.
     * </p>
     * 
     * @return The variant's weight.
     */
    public final Float desiredWeight() {
        return desiredWeight;
    }

    /**
     * <p>
     * The variant's capacity.
     * </p>
     * 
     * @return The variant's capacity.
     */
    public final Integer desiredInstanceCount() {
        return desiredInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(variantName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredWeight());
        hashCode = 31 * hashCode + Objects.hashCode(desiredInstanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredWeightAndCapacity)) {
            return false;
        }
        DesiredWeightAndCapacity other = (DesiredWeightAndCapacity) obj;
        return Objects.equals(variantName(), other.variantName()) && Objects.equals(desiredWeight(), other.desiredWeight())
                && Objects.equals(desiredInstanceCount(), other.desiredInstanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DesiredWeightAndCapacity").add("VariantName", variantName())
                .add("DesiredWeight", desiredWeight()).add("DesiredInstanceCount", desiredInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VariantName":
            return Optional.ofNullable(clazz.cast(variantName()));
        case "DesiredWeight":
            return Optional.ofNullable(clazz.cast(desiredWeight()));
        case "DesiredInstanceCount":
            return Optional.ofNullable(clazz.cast(desiredInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DesiredWeightAndCapacity, T> g) {
        return obj -> g.apply((DesiredWeightAndCapacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DesiredWeightAndCapacity> {
        /**
         * <p>
         * The name of the variant to update.
         * </p>
         * 
         * @param variantName
         *        The name of the variant to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantName(String variantName);

        /**
         * <p>
         * The variant's weight.
         * </p>
         * 
         * @param desiredWeight
         *        The variant's weight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredWeight(Float desiredWeight);

        /**
         * <p>
         * The variant's capacity.
         * </p>
         * 
         * @param desiredInstanceCount
         *        The variant's capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInstanceCount(Integer desiredInstanceCount);
    }

    static final class BuilderImpl implements Builder {
        private String variantName;

        private Float desiredWeight;

        private Integer desiredInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredWeightAndCapacity model) {
            variantName(model.variantName);
            desiredWeight(model.desiredWeight);
            desiredInstanceCount(model.desiredInstanceCount);
        }

        public final String getVariantName() {
            return variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final Float getDesiredWeight() {
            return desiredWeight;
        }

        public final void setDesiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
        }

        @Override
        public final Builder desiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
            return this;
        }

        public final Integer getDesiredInstanceCount() {
            return desiredInstanceCount;
        }

        public final void setDesiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
        }

        @Override
        public final Builder desiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
            return this;
        }

        @Override
        public DesiredWeightAndCapacity build() {
            return new DesiredWeightAndCapacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
