/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Currently, the <code>BlueGreenUpdatePolicy</code> API is not supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlueGreenUpdatePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<BlueGreenUpdatePolicy.Builder, BlueGreenUpdatePolicy> {
    private static final SdkField<TrafficRoutingConfig> TRAFFIC_ROUTING_CONFIGURATION_FIELD = SdkField
            .<TrafficRoutingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficRoutingConfiguration")
            .getter(getter(BlueGreenUpdatePolicy::trafficRoutingConfiguration))
            .setter(setter(Builder::trafficRoutingConfiguration))
            .constructor(TrafficRoutingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficRoutingConfiguration")
                    .build()).build();

    private static final SdkField<Integer> TERMINATION_WAIT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("TerminationWaitInSeconds")
            .getter(getter(BlueGreenUpdatePolicy::terminationWaitInSeconds)).setter(setter(Builder::terminationWaitInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationWaitInSeconds").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumExecutionTimeoutInSeconds")
            .getter(getter(BlueGreenUpdatePolicy::maximumExecutionTimeoutInSeconds))
            .setter(setter(Builder::maximumExecutionTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionTimeoutInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_ROUTING_CONFIGURATION_FIELD, TERMINATION_WAIT_IN_SECONDS_FIELD, MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TrafficRoutingConfig trafficRoutingConfiguration;

    private final Integer terminationWaitInSeconds;

    private final Integer maximumExecutionTimeoutInSeconds;

    private BlueGreenUpdatePolicy(BuilderImpl builder) {
        this.trafficRoutingConfiguration = builder.trafficRoutingConfiguration;
        this.terminationWaitInSeconds = builder.terminationWaitInSeconds;
        this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final TrafficRoutingConfig trafficRoutingConfiguration() {
        return trafficRoutingConfiguration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer terminationWaitInSeconds() {
        return terminationWaitInSeconds;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer maximumExecutionTimeoutInSeconds() {
        return maximumExecutionTimeoutInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficRoutingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(terminationWaitInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maximumExecutionTimeoutInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueGreenUpdatePolicy)) {
            return false;
        }
        BlueGreenUpdatePolicy other = (BlueGreenUpdatePolicy) obj;
        return Objects.equals(trafficRoutingConfiguration(), other.trafficRoutingConfiguration())
                && Objects.equals(terminationWaitInSeconds(), other.terminationWaitInSeconds())
                && Objects.equals(maximumExecutionTimeoutInSeconds(), other.maximumExecutionTimeoutInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlueGreenUpdatePolicy").add("TrafficRoutingConfiguration", trafficRoutingConfiguration())
                .add("TerminationWaitInSeconds", terminationWaitInSeconds())
                .add("MaximumExecutionTimeoutInSeconds", maximumExecutionTimeoutInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficRoutingConfiguration":
            return Optional.ofNullable(clazz.cast(trafficRoutingConfiguration()));
        case "TerminationWaitInSeconds":
            return Optional.ofNullable(clazz.cast(terminationWaitInSeconds()));
        case "MaximumExecutionTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(maximumExecutionTimeoutInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlueGreenUpdatePolicy, T> g) {
        return obj -> g.apply((BlueGreenUpdatePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlueGreenUpdatePolicy> {
        /**
         * <p/>
         * 
         * @param trafficRoutingConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficRoutingConfiguration(TrafficRoutingConfig trafficRoutingConfiguration);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link TrafficRoutingConfig.Builder} avoiding the need
         * to create one manually via {@link TrafficRoutingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficRoutingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficRoutingConfiguration(TrafficRoutingConfig)}.
         * 
         * @param trafficRoutingConfiguration
         *        a consumer that will call methods on {@link TrafficRoutingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficRoutingConfiguration(TrafficRoutingConfig)
         */
        default Builder trafficRoutingConfiguration(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfiguration) {
            return trafficRoutingConfiguration(TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfiguration).build());
        }

        /**
         * <p/>
         * 
         * @param terminationWaitInSeconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationWaitInSeconds(Integer terminationWaitInSeconds);

        /**
         * <p/>
         * 
         * @param maximumExecutionTimeoutInSeconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private TrafficRoutingConfig trafficRoutingConfiguration;

        private Integer terminationWaitInSeconds;

        private Integer maximumExecutionTimeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueGreenUpdatePolicy model) {
            trafficRoutingConfiguration(model.trafficRoutingConfiguration);
            terminationWaitInSeconds(model.terminationWaitInSeconds);
            maximumExecutionTimeoutInSeconds(model.maximumExecutionTimeoutInSeconds);
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfiguration() {
            return trafficRoutingConfiguration != null ? trafficRoutingConfiguration.toBuilder() : null;
        }

        public final void setTrafficRoutingConfiguration(TrafficRoutingConfig.BuilderImpl trafficRoutingConfiguration) {
            this.trafficRoutingConfiguration = trafficRoutingConfiguration != null ? trafficRoutingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder trafficRoutingConfiguration(TrafficRoutingConfig trafficRoutingConfiguration) {
            this.trafficRoutingConfiguration = trafficRoutingConfiguration;
            return this;
        }

        public final Integer getTerminationWaitInSeconds() {
            return terminationWaitInSeconds;
        }

        public final void setTerminationWaitInSeconds(Integer terminationWaitInSeconds) {
            this.terminationWaitInSeconds = terminationWaitInSeconds;
        }

        @Override
        @Transient
        public final Builder terminationWaitInSeconds(Integer terminationWaitInSeconds) {
            this.terminationWaitInSeconds = terminationWaitInSeconds;
            return this;
        }

        public final Integer getMaximumExecutionTimeoutInSeconds() {
            return maximumExecutionTimeoutInSeconds;
        }

        public final void setMaximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
        }

        @Override
        @Transient
        public final Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
            return this;
        }

        @Override
        public BlueGreenUpdatePolicy build() {
            return new BlueGreenUpdatePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
