/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAlgorithmsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListAlgorithmsResponse.Builder, ListAlgorithmsResponse> {
    private static final SdkField<List<AlgorithmSummary>> ALGORITHM_SUMMARY_LIST_FIELD = SdkField
            .<List<AlgorithmSummary>> builder(MarshallingType.LIST)
            .memberName("AlgorithmSummaryList")
            .getter(getter(ListAlgorithmsResponse::algorithmSummaryList))
            .setter(setter(Builder::algorithmSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlgorithmSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlgorithmSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAlgorithmsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AlgorithmSummary> algorithmSummaryList;

    private final String nextToken;

    private ListAlgorithmsResponse(BuilderImpl builder) {
        super(builder);
        this.algorithmSummaryList = builder.algorithmSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlgorithmSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlgorithmSummaryList() {
        return algorithmSummaryList != null && !(algorithmSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * &gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlgorithmSummaryList} method.
     * </p>
     * 
     * @return &gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.
     */
    public final List<AlgorithmSummary> algorithmSummaryList() {
        return algorithmSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the
     * subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use
     *         it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlgorithmSummaryList() ? algorithmSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlgorithmsResponse)) {
            return false;
        }
        ListAlgorithmsResponse other = (ListAlgorithmsResponse) obj;
        return hasAlgorithmSummaryList() == other.hasAlgorithmSummaryList()
                && Objects.equals(algorithmSummaryList(), other.algorithmSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAlgorithmsResponse")
                .add("AlgorithmSummaryList", hasAlgorithmSummaryList() ? algorithmSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlgorithmSummaryList":
            return Optional.ofNullable(clazz.cast(algorithmSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAlgorithmsResponse, T> g) {
        return obj -> g.apply((ListAlgorithmsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAlgorithmsResponse> {
        /**
         * <p>
         * &gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.
         * </p>
         * 
         * @param algorithmSummaryList
         *        &gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmSummaryList(Collection<AlgorithmSummary> algorithmSummaryList);

        /**
         * <p>
         * &gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.
         * </p>
         * 
         * @param algorithmSummaryList
         *        &gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmSummaryList(AlgorithmSummary... algorithmSummaryList);

        /**
         * <p>
         * &gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AlgorithmSummary>.Builder} avoiding
         * the need to create one manually via {@link List<AlgorithmSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AlgorithmSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #algorithmSummaryList(List<AlgorithmSummary>)}.
         * 
         * @param algorithmSummaryList
         *        a consumer that will call methods on {@link List<AlgorithmSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmSummaryList(List<AlgorithmSummary>)
         */
        Builder algorithmSummaryList(Consumer<AlgorithmSummary.Builder>... algorithmSummaryList);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in
         * the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms,
         *        use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<AlgorithmSummary> algorithmSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlgorithmsResponse model) {
            super(model);
            algorithmSummaryList(model.algorithmSummaryList);
            nextToken(model.nextToken);
        }

        public final List<AlgorithmSummary.Builder> getAlgorithmSummaryList() {
            List<AlgorithmSummary.Builder> result = AlgorithmSummaryListCopier.copyToBuilder(this.algorithmSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlgorithmSummaryList(Collection<AlgorithmSummary.BuilderImpl> algorithmSummaryList) {
            this.algorithmSummaryList = AlgorithmSummaryListCopier.copyFromBuilder(algorithmSummaryList);
        }

        @Override
        public final Builder algorithmSummaryList(Collection<AlgorithmSummary> algorithmSummaryList) {
            this.algorithmSummaryList = AlgorithmSummaryListCopier.copy(algorithmSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmSummaryList(AlgorithmSummary... algorithmSummaryList) {
            algorithmSummaryList(Arrays.asList(algorithmSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmSummaryList(Consumer<AlgorithmSummary.Builder>... algorithmSummaryList) {
            algorithmSummaryList(Stream.of(algorithmSummaryList).map(c -> AlgorithmSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlgorithmsResponse build() {
            return new ListAlgorithmsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
