/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AppSortKey;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListAppsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppsRequest.getter(ListAppsRequest::nextToken)).setter(ListAppsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAppsRequest.getter(ListAppsRequest::maxResults)).setter(ListAppsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListAppsRequest.getter(ListAppsRequest::sortOrderAsString)).setter(ListAppsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListAppsRequest.getter(ListAppsRequest::sortByAsString)).setter(ListAppsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> DOMAIN_ID_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIdEquals").getter(ListAppsRequest.getter(ListAppsRequest::domainIdEquals)).setter(ListAppsRequest.setter(Builder::domainIdEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIdEquals").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileNameEquals").getter(ListAppsRequest.getter(ListAppsRequest::userProfileNameEquals)).setter(ListAppsRequest.setter(Builder::userProfileNameEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileNameEquals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, DOMAIN_ID_EQUALS_FIELD, USER_PROFILE_NAME_EQUALS_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String sortOrder;
    private final String sortBy;
    private final String domainIdEquals;
    private final String userProfileNameEquals;

    private ListAppsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.domainIdEquals = builder.domainIdEquals;
        this.userProfileNameEquals = builder.userProfileNameEquals;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final AppSortKey sortBy() {
        return AppSortKey.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final String domainIdEquals() {
        return this.domainIdEquals;
    }

    public final String userProfileNameEquals() {
        return this.userProfileNameEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdEquals());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileNameEquals());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsRequest)) {
            return false;
        }
        ListAppsRequest other = (ListAppsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.domainIdEquals(), other.domainIdEquals()) && Objects.equals(this.userProfileNameEquals(), other.userProfileNameEquals());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortOrder", (Object)this.sortOrderAsString()).add("SortBy", (Object)this.sortByAsString()).add("DomainIdEquals", (Object)this.domainIdEquals()).add("UserProfileNameEquals", (Object)this.userProfileNameEquals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "DomainIdEquals": {
                return Optional.ofNullable(clazz.cast(this.domainIdEquals()));
            }
            case "UserProfileNameEquals": {
                return Optional.ofNullable(clazz.cast(this.userProfileNameEquals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsRequest, T> g) {
        return obj -> g.apply((ListAppsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String sortOrder;
        private String sortBy;
        private String domainIdEquals;
        private String userProfileNameEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortOrder(model.sortOrder);
            this.sortBy(model.sortBy);
            this.domainIdEquals(model.domainIdEquals);
            this.userProfileNameEquals(model.userProfileNameEquals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(AppSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getDomainIdEquals() {
            return this.domainIdEquals;
        }

        public final void setDomainIdEquals(String domainIdEquals) {
            this.domainIdEquals = domainIdEquals;
        }

        @Override
        public final Builder domainIdEquals(String domainIdEquals) {
            this.domainIdEquals = domainIdEquals;
            return this;
        }

        public final String getUserProfileNameEquals() {
            return this.userProfileNameEquals;
        }

        public final void setUserProfileNameEquals(String userProfileNameEquals) {
            this.userProfileNameEquals = userProfileNameEquals;
        }

        @Override
        public final Builder userProfileNameEquals(String userProfileNameEquals) {
            this.userProfileNameEquals = userProfileNameEquals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAppsRequest build() {
            return new ListAppsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder sortBy(String var1);

        public Builder sortBy(AppSortKey var1);

        public Builder domainIdEquals(String var1);

        public Builder userProfileNameEquals(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

