/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHyperParameterTuningJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateHyperParameterTuningJobRequest.Builder, CreateHyperParameterTuningJobRequest> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobName")
            .getter(getter(CreateHyperParameterTuningJobRequest::hyperParameterTuningJobName))
            .setter(setter(Builder::hyperParameterTuningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName")
                    .build()).build();

    private static final SdkField<HyperParameterTuningJobConfig> HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD = SdkField
            .<HyperParameterTuningJobConfig> builder(MarshallingType.SDK_POJO)
            .memberName("HyperParameterTuningJobConfig")
            .getter(getter(CreateHyperParameterTuningJobRequest::hyperParameterTuningJobConfig))
            .setter(setter(Builder::hyperParameterTuningJobConfig))
            .constructor(HyperParameterTuningJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobConfig")
                    .build()).build();

    private static final SdkField<HyperParameterTrainingJobDefinition> TRAINING_JOB_DEFINITION_FIELD = SdkField
            .<HyperParameterTrainingJobDefinition> builder(MarshallingType.SDK_POJO).memberName("TrainingJobDefinition")
            .getter(getter(CreateHyperParameterTuningJobRequest::trainingJobDefinition))
            .setter(setter(Builder::trainingJobDefinition)).constructor(HyperParameterTrainingJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinition").build())
            .build();

    private static final SdkField<List<HyperParameterTrainingJobDefinition>> TRAINING_JOB_DEFINITIONS_FIELD = SdkField
            .<List<HyperParameterTrainingJobDefinition>> builder(MarshallingType.LIST)
            .memberName("TrainingJobDefinitions")
            .getter(getter(CreateHyperParameterTuningJobRequest::trainingJobDefinitions))
            .setter(setter(Builder::trainingJobDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HyperParameterTrainingJobDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(HyperParameterTrainingJobDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HyperParameterTuningJobWarmStartConfig> WARM_START_CONFIG_FIELD = SdkField
            .<HyperParameterTuningJobWarmStartConfig> builder(MarshallingType.SDK_POJO).memberName("WarmStartConfig")
            .getter(getter(CreateHyperParameterTuningJobRequest::warmStartConfig)).setter(setter(Builder::warmStartConfig))
            .constructor(HyperParameterTuningJobWarmStartConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmStartConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateHyperParameterTuningJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD, TRAINING_JOB_DEFINITION_FIELD,
            TRAINING_JOB_DEFINITIONS_FIELD, WARM_START_CONFIG_FIELD, TAGS_FIELD));

    private final String hyperParameterTuningJobName;

    private final HyperParameterTuningJobConfig hyperParameterTuningJobConfig;

    private final HyperParameterTrainingJobDefinition trainingJobDefinition;

    private final List<HyperParameterTrainingJobDefinition> trainingJobDefinitions;

    private final HyperParameterTuningJobWarmStartConfig warmStartConfig;

    private final List<Tag> tags;

    private CreateHyperParameterTuningJobRequest(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobConfig = builder.hyperParameterTuningJobConfig;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.trainingJobDefinitions = builder.trainingJobDefinitions;
        this.warmStartConfig = builder.warmStartConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job
     * launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The
     * name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is
     * not case sensitive.
     * </p>
     * 
     * @return The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning
     *         job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services
     *         Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % -
     *         (hyphen). The name is not case sensitive.
     */
    public final String hyperParameterTuningJobName() {
        return hyperParameterTuningJobName;
    }

    /**
     * <p>
     * The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search strategy, the
     * objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the
     * tuning job. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     * Hyperparameter Tuning Works</a>.
     * </p>
     * 
     * @return The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search
     *         strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and
     *         resource limits for the tuning job. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     *         Hyperparameter Tuning Works</a>.
     */
    public final HyperParameterTuningJobConfig hyperParameterTuningJobConfig() {
        return hyperParameterTuningJobConfig;
    }

    /**
     * <p>
     * The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning job
     * launches, including static hyperparameters, input data configuration, output data configuration, resource
     * configuration, and stopping condition.
     * </p>
     * 
     * @return The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning
     *         job launches, including static hyperparameters, input data configuration, output data configuration,
     *         resource configuration, and stopping condition.
     */
    public final HyperParameterTrainingJobDefinition trainingJobDefinition() {
        return trainingJobDefinition;
    }

    /**
     * Returns true if the TrainingJobDefinitions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTrainingJobDefinitions() {
        return trainingJobDefinitions != null && !(trainingJobDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrainingJobDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.
     */
    public final List<HyperParameterTrainingJobDefinition> trainingJobDefinitions() {
        return trainingJobDefinitions;
    }

    /**
     * <p>
     * Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as
     * a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to
     * search over in the new tuning job.
     * </p>
     * <p>
     * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If
     * you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm start
     * configuration, the training job that performs the best in the new tuning job is compared to the best training
     * jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the
     * objective metric is returned as the overall best training job.
     * </p>
     * <note>
     * <p>
     * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count
     * against the limit of training jobs for the tuning job.
     * </p>
     * </note>
     * 
     * @return Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning
     *         jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of
     *         hyperparameters to search over in the new tuning job.</p>
     *         <p>
     *         All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective
     *         metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value
     *         for the warm start configuration, the training job that performs the best in the new tuning job is
     *         compared to the best training jobs from the parent tuning jobs. From these, the training job that
     *         performs the best as measured by the objective metric is returned as the overall best training job.
     *         </p>
     *         <note>
     *         <p>
     *         All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs
     *         count against the limit of training jobs for the tuning job.
     *         </p>
     */
    public final HyperParameterTuningJobWarmStartConfig warmStartConfig() {
        return warmStartConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.</p>
     *         <p>
     *         Tags that you specify for the tuning job are also added to all training jobs that the tuning job
     *         launches.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingJobDefinitions() ? trainingJobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(warmStartConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHyperParameterTuningJobRequest)) {
            return false;
        }
        CreateHyperParameterTuningJobRequest other = (CreateHyperParameterTuningJobRequest) obj;
        return Objects.equals(hyperParameterTuningJobName(), other.hyperParameterTuningJobName())
                && Objects.equals(hyperParameterTuningJobConfig(), other.hyperParameterTuningJobConfig())
                && Objects.equals(trainingJobDefinition(), other.trainingJobDefinition())
                && hasTrainingJobDefinitions() == other.hasTrainingJobDefinitions()
                && Objects.equals(trainingJobDefinitions(), other.trainingJobDefinitions())
                && Objects.equals(warmStartConfig(), other.warmStartConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHyperParameterTuningJobRequest")
                .add("HyperParameterTuningJobName", hyperParameterTuningJobName())
                .add("HyperParameterTuningJobConfig", hyperParameterTuningJobConfig())
                .add("TrainingJobDefinition", trainingJobDefinition())
                .add("TrainingJobDefinitions", hasTrainingJobDefinitions() ? trainingJobDefinitions() : null)
                .add("WarmStartConfig", warmStartConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperParameterTuningJobName":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobName()));
        case "HyperParameterTuningJobConfig":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobConfig()));
        case "TrainingJobDefinition":
            return Optional.ofNullable(clazz.cast(trainingJobDefinition()));
        case "TrainingJobDefinitions":
            return Optional.ofNullable(clazz.cast(trainingJobDefinitions()));
        case "WarmStartConfig":
            return Optional.ofNullable(clazz.cast(warmStartConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHyperParameterTuningJobRequest, T> g) {
        return obj -> g.apply((CreateHyperParameterTuningJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHyperParameterTuningJobRequest> {
        /**
         * <p>
         * The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job
         * launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region.
         * The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The
         * name is not case sensitive.
         * </p>
         * 
         * @param hyperParameterTuningJobName
         *        The name of the tuning job. This name is the prefix for the names of all training jobs that this
         *        tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon
         *        Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and :
         *        + = @ _ % - (hyphen). The name is not case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobName(String hyperParameterTuningJobName);

        /**
         * <p>
         * The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search strategy,
         * the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for
         * the tuning job. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
         * Hyperparameter Tuning Works</a>.
         * </p>
         * 
         * @param hyperParameterTuningJobConfig
         *        The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search
         *        strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and
         *        resource limits for the tuning job. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
         *        Hyperparameter Tuning Works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig);

        /**
         * <p>
         * The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search strategy,
         * the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for
         * the tuning job. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
         * Hyperparameter Tuning Works</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link HyperParameterTuningJobConfig.Builder} avoiding
         * the need to create one manually via {@link HyperParameterTuningJobConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #hyperParameterTuningJobConfig(HyperParameterTuningJobConfig)}
         * .
         * 
         * @param hyperParameterTuningJobConfig
         *        a consumer that will call methods on {@link HyperParameterTuningJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperParameterTuningJobConfig(HyperParameterTuningJobConfig)
         */
        default Builder hyperParameterTuningJobConfig(
                Consumer<HyperParameterTuningJobConfig.Builder> hyperParameterTuningJobConfig) {
            return hyperParameterTuningJobConfig(HyperParameterTuningJobConfig.builder()
                    .applyMutation(hyperParameterTuningJobConfig).build());
        }

        /**
         * <p>
         * The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning job
         * launches, including static hyperparameters, input data configuration, output data configuration, resource
         * configuration, and stopping condition.
         * </p>
         * 
         * @param trainingJobDefinition
         *        The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this
         *        tuning job launches, including static hyperparameters, input data configuration, output data
         *        configuration, resource configuration, and stopping condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition);

        /**
         * <p>
         * The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning job
         * launches, including static hyperparameters, input data configuration, output data configuration, resource
         * configuration, and stopping condition.
         * </p>
         * This is a convenience that creates an instance of the {@link HyperParameterTrainingJobDefinition.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTrainingJobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTrainingJobDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #trainingJobDefinition(HyperParameterTrainingJobDefinition)}.
         * 
         * @param trainingJobDefinition
         *        a consumer that will call methods on {@link HyperParameterTrainingJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobDefinition(HyperParameterTrainingJobDefinition)
         */
        default Builder trainingJobDefinition(Consumer<HyperParameterTrainingJobDefinition.Builder> trainingJobDefinition) {
            return trainingJobDefinition(HyperParameterTrainingJobDefinition.builder().applyMutation(trainingJobDefinition)
                    .build());
        }

        /**
         * <p>
         * A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.
         * </p>
         * 
         * @param trainingJobDefinitions
         *        A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> trainingJobDefinitions);

        /**
         * <p>
         * A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.
         * </p>
         * 
         * @param trainingJobDefinitions
         *        A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition... trainingJobDefinitions);

        /**
         * <p>
         * A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <HyperParameterTrainingJobDefinition>.Builder} avoiding the need to create one manually via {@link List
         * <HyperParameterTrainingJobDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HyperParameterTrainingJobDefinition>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #trainingJobDefinitions(List<HyperParameterTrainingJobDefinition>)}.
         * 
         * @param trainingJobDefinitions
         *        a consumer that will call methods on {@link List<HyperParameterTrainingJobDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobDefinitions(List<HyperParameterTrainingJobDefinition>)
         */
        Builder trainingJobDefinitions(Consumer<HyperParameterTrainingJobDefinition.Builder>... trainingJobDefinitions);

        /**
         * <p>
         * Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs
         * as a starting point. The results of previous tuning jobs are used to inform which combinations of
         * hyperparameters to search over in the new tuning job.
         * </p>
         * <p>
         * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric.
         * If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm
         * start configuration, the training job that performs the best in the new tuning job is compared to the best
         * training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by
         * the objective metric is returned as the overall best training job.
         * </p>
         * <note>
         * <p>
         * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count
         * against the limit of training jobs for the tuning job.
         * </p>
         * </note>
         * 
         * @param warmStartConfig
         *        Specifies the configuration for starting the hyperparameter tuning job using one or more previous
         *        tuning jobs as a starting point. The results of previous tuning jobs are used to inform which
         *        combinations of hyperparameters to search over in the new tuning job.</p>
         *        <p>
         *        All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective
         *        metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code>
         *        value for the warm start configuration, the training job that performs the best in the new tuning job
         *        is compared to the best training jobs from the parent tuning jobs. From these, the training job that
         *        performs the best as measured by the objective metric is returned as the overall best training job.
         *        </p>
         *        <note>
         *        <p>
         *        All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs
         *        count against the limit of training jobs for the tuning job.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig);

        /**
         * <p>
         * Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs
         * as a starting point. The results of previous tuning jobs are used to inform which combinations of
         * hyperparameters to search over in the new tuning job.
         * </p>
         * <p>
         * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric.
         * If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm
         * start configuration, the training job that performs the best in the new tuning job is compared to the best
         * training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by
         * the objective metric is returned as the overall best training job.
         * </p>
         * <note>
         * <p>
         * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count
         * against the limit of training jobs for the tuning job.
         * </p>
         * </note> This is a convenience that creates an instance of the
         * {@link HyperParameterTuningJobWarmStartConfig.Builder} avoiding the need to create one manually via
         * {@link HyperParameterTuningJobWarmStartConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobWarmStartConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #warmStartConfig(HyperParameterTuningJobWarmStartConfig)}.
         * 
         * @param warmStartConfig
         *        a consumer that will call methods on {@link HyperParameterTuningJobWarmStartConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmStartConfig(HyperParameterTuningJobWarmStartConfig)
         */
        default Builder warmStartConfig(Consumer<HyperParameterTuningJobWarmStartConfig.Builder> warmStartConfig) {
            return warmStartConfig(HyperParameterTuningJobWarmStartConfig.builder().applyMutation(warmStartConfig).build());
        }

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * <p>
         * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.</p>
         *        <p>
         *        Tags that you specify for the tuning job are also added to all training jobs that the tuning job
         *        launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * <p>
         * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.</p>
         *        <p>
         *        Tags that you specify for the tuning job are also added to all training jobs that the tuning job
         *        launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * <p>
         * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hyperParameterTuningJobName;

        private HyperParameterTuningJobConfig hyperParameterTuningJobConfig;

        private HyperParameterTrainingJobDefinition trainingJobDefinition;

        private List<HyperParameterTrainingJobDefinition> trainingJobDefinitions = DefaultSdkAutoConstructList.getInstance();

        private HyperParameterTuningJobWarmStartConfig warmStartConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHyperParameterTuningJobRequest model) {
            super(model);
            hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            hyperParameterTuningJobConfig(model.hyperParameterTuningJobConfig);
            trainingJobDefinition(model.trainingJobDefinition);
            trainingJobDefinitions(model.trainingJobDefinitions);
            warmStartConfig(model.warmStartConfig);
            tags(model.tags);
        }

        public final String getHyperParameterTuningJobName() {
            return hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        public final HyperParameterTuningJobConfig.Builder getHyperParameterTuningJobConfig() {
            return hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig;
            return this;
        }

        public final void setHyperParameterTuningJobConfig(HyperParameterTuningJobConfig.BuilderImpl hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.build()
                    : null;
        }

        public final HyperParameterTrainingJobDefinition.Builder getTrainingJobDefinition() {
            return trainingJobDefinition != null ? trainingJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final void setTrainingJobDefinition(HyperParameterTrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        public final List<HyperParameterTrainingJobDefinition.Builder> getTrainingJobDefinitions() {
            List<HyperParameterTrainingJobDefinition.Builder> result = HyperParameterTrainingJobDefinitionsCopier
                    .copyToBuilder(this.trainingJobDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copy(trainingJobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition... trainingJobDefinitions) {
            trainingJobDefinitions(Arrays.asList(trainingJobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(
                Consumer<HyperParameterTrainingJobDefinition.Builder>... trainingJobDefinitions) {
            trainingJobDefinitions(Stream.of(trainingJobDefinitions)
                    .map(c -> HyperParameterTrainingJobDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTrainingJobDefinitions(
                Collection<HyperParameterTrainingJobDefinition.BuilderImpl> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copyFromBuilder(trainingJobDefinitions);
        }

        public final HyperParameterTuningJobWarmStartConfig.Builder getWarmStartConfig() {
            return warmStartConfig != null ? warmStartConfig.toBuilder() : null;
        }

        @Override
        public final Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig) {
            this.warmStartConfig = warmStartConfig;
            return this;
        }

        public final void setWarmStartConfig(HyperParameterTuningJobWarmStartConfig.BuilderImpl warmStartConfig) {
            this.warmStartConfig = warmStartConfig != null ? warmStartConfig.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHyperParameterTuningJobRequest build() {
            return new CreateHyperParameterTuningJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
