/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransformJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateTransformJobRequest.Builder, CreateTransformJobRequest> {
    private static final SdkField<String> TRANSFORM_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformJobName").getter(getter(CreateTransformJobRequest::transformJobName))
            .setter(setter(Builder::transformJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobName").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(CreateTransformJobRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_TRANSFORMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentTransforms").getter(getter(CreateTransformJobRequest::maxConcurrentTransforms))
            .setter(setter(Builder::maxConcurrentTransforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTransforms").build())
            .build();

    private static final SdkField<ModelClientConfig> MODEL_CLIENT_CONFIG_FIELD = SdkField
            .<ModelClientConfig> builder(MarshallingType.SDK_POJO).memberName("ModelClientConfig")
            .getter(getter(CreateTransformJobRequest::modelClientConfig)).setter(setter(Builder::modelClientConfig))
            .constructor(ModelClientConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelClientConfig").build()).build();

    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxPayloadInMB").getter(getter(CreateTransformJobRequest::maxPayloadInMB))
            .setter(setter(Builder::maxPayloadInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadInMB").build()).build();

    private static final SdkField<String> BATCH_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchStrategy").getter(getter(CreateTransformJobRequest::batchStrategyAsString))
            .setter(setter(Builder::batchStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchStrategy").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Environment")
            .getter(getter(CreateTransformJobRequest::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TransformInput> TRANSFORM_INPUT_FIELD = SdkField
            .<TransformInput> builder(MarshallingType.SDK_POJO).memberName("TransformInput")
            .getter(getter(CreateTransformJobRequest::transformInput)).setter(setter(Builder::transformInput))
            .constructor(TransformInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformInput").build()).build();

    private static final SdkField<TransformOutput> TRANSFORM_OUTPUT_FIELD = SdkField
            .<TransformOutput> builder(MarshallingType.SDK_POJO).memberName("TransformOutput")
            .getter(getter(CreateTransformJobRequest::transformOutput)).setter(setter(Builder::transformOutput))
            .constructor(TransformOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOutput").build()).build();

    private static final SdkField<TransformResources> TRANSFORM_RESOURCES_FIELD = SdkField
            .<TransformResources> builder(MarshallingType.SDK_POJO).memberName("TransformResources")
            .getter(getter(CreateTransformJobRequest::transformResources)).setter(setter(Builder::transformResources))
            .constructor(TransformResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformResources").build())
            .build();

    private static final SdkField<DataProcessing> DATA_PROCESSING_FIELD = SdkField
            .<DataProcessing> builder(MarshallingType.SDK_POJO).memberName("DataProcessing")
            .getter(getter(CreateTransformJobRequest::dataProcessing)).setter(setter(Builder::dataProcessing))
            .constructor(DataProcessing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProcessing").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTransformJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField
            .<ExperimentConfig> builder(MarshallingType.SDK_POJO).memberName("ExperimentConfig")
            .getter(getter(CreateTransformJobRequest::experimentConfig)).setter(setter(Builder::experimentConfig))
            .constructor(ExperimentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_NAME_FIELD,
            MODEL_NAME_FIELD, MAX_CONCURRENT_TRANSFORMS_FIELD, MODEL_CLIENT_CONFIG_FIELD, MAX_PAYLOAD_IN_MB_FIELD,
            BATCH_STRATEGY_FIELD, ENVIRONMENT_FIELD, TRANSFORM_INPUT_FIELD, TRANSFORM_OUTPUT_FIELD, TRANSFORM_RESOURCES_FIELD,
            DATA_PROCESSING_FIELD, TAGS_FIELD, EXPERIMENT_CONFIG_FIELD));

    private final String transformJobName;

    private final String modelName;

    private final Integer maxConcurrentTransforms;

    private final ModelClientConfig modelClientConfig;

    private final Integer maxPayloadInMB;

    private final String batchStrategy;

    private final Map<String, String> environment;

    private final TransformInput transformInput;

    private final TransformOutput transformOutput;

    private final TransformResources transformResources;

    private final DataProcessing dataProcessing;

    private final List<Tag> tags;

    private final ExperimentConfig experimentConfig;

    private CreateTransformJobRequest(BuilderImpl builder) {
        super(builder);
        this.transformJobName = builder.transformJobName;
        this.modelName = builder.modelName;
        this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
        this.modelClientConfig = builder.modelClientConfig;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.batchStrategy = builder.batchStrategy;
        this.environment = builder.environment;
        this.transformInput = builder.transformInput;
        this.transformOutput = builder.transformOutput;
        this.transformResources = builder.transformResources;
        this.dataProcessing = builder.dataProcessing;
        this.tags = builder.tags;
        this.experimentConfig = builder.experimentConfig;
    }

    /**
     * <p>
     * The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web
     * Services account.
     * </p>
     * 
     * @return The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon
     *         Web Services account.
     */
    public final String transformJobName() {
        return transformJobName;
    }

    /**
     * <p>
     * The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of an
     * existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.
     * </p>
     * 
     * @return The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name
     *         of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services
     *         account.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The maximum number of parallel requests that can be sent to each instance in a transform job. If
     * <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the optional
     * execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is
     * not enabled, the default value is <code>1</code>. For more information on execution-parameters, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests"
     * >How Containers Serve Requests</a>. For built-in algorithms, you don't need to set a value for
     * <code>MaxConcurrentTransforms</code>.
     * </p>
     * 
     * @return The maximum number of parallel requests that can be sent to each instance in a transform job. If
     *         <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the
     *         optional execution-parameters to determine the settings for your chosen algorithm. If the
     *         execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information
     *         on execution-parameters, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests"
     *         >How Containers Serve Requests</a>. For built-in algorithms, you don't need to set a value for
     *         <code>MaxConcurrentTransforms</code>.
     */
    public final Integer maxConcurrentTransforms() {
        return maxConcurrentTransforms;
    }

    /**
     * <p>
     * Configures the timeout and maximum number of retries for processing a transform job invocation.
     * </p>
     * 
     * @return Configures the timeout and maximum number of retries for processing a transform job invocation.
     */
    public final ModelClientConfig modelClientConfig() {
        return modelClientConfig;
    }

    /**
     * <p>
     * The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without
     * metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single
     * record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To
     * ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The
     * default value is <code>6</code> MB.
     * </p>
     * <p>
     * For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the
     * value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in
     * algorithms do not support HTTP chunked encoding.
     * </p>
     * 
     * @return The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without
     *         metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a
     *         single record. To estimate the size of a record in MB, divide the size of your dataset by the number of
     *         records. To ensure that the records fit within the maximum payload size, we recommend using a slightly
     *         larger value. The default value is <code>6</code> MB. </p>
     *         <p>
     *         For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding,
     *         set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon
     *         SageMaker built-in algorithms do not support HTTP chunked encoding.
     */
    public final Integer maxPayloadInMB() {
        return maxPayloadInMB;
    }

    /**
     * <p>
     * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is
     * a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
     * </p>
     * <p>
     * To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
     * <code>RecordIO</code>, or <code>TFRecord</code>.
     * </p>
     * <p>
     * To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to
     * <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.
     * </p>
     * <p>
     * To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
     * <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batchStrategy}
     * will return {@link BatchStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #batchStrategyAsString}.
     * </p>
     * 
     * @return Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
     *         <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV
     *         file is a record. </p>
     *         <p>
     *         To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
     *         <code>RecordIO</code>, or <code>TFRecord</code>.
     *         </p>
     *         <p>
     *         To use only one record when making an HTTP invocation request to a container, set
     *         <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.
     *         </p>
     *         <p>
     *         To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
     *         <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
     * @see BatchStrategy
     */
    public final BatchStrategy batchStrategy() {
        return BatchStrategy.fromValue(batchStrategy);
    }

    /**
     * <p>
     * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is
     * a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
     * </p>
     * <p>
     * To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
     * <code>RecordIO</code>, or <code>TFRecord</code>.
     * </p>
     * <p>
     * To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to
     * <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.
     * </p>
     * <p>
     * To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
     * <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batchStrategy}
     * will return {@link BatchStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #batchStrategyAsString}.
     * </p>
     * 
     * @return Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
     *         <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV
     *         file is a record. </p>
     *         <p>
     *         To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
     *         <code>RecordIO</code>, or <code>TFRecord</code>.
     *         </p>
     *         <p>
     *         To use only one record when making an HTTP invocation request to a container, set
     *         <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.
     *         </p>
     *         <p>
     *         To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
     *         <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
     * @see BatchStrategy
     */
    public final String batchStrategyAsString() {
        return batchStrategy;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The environment variables to set in the Docker container. We support up to 16 key and values entries in
     *         the map.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * Describes the input source and the way the transform job consumes it.
     * </p>
     * 
     * @return Describes the input source and the way the transform job consumes it.
     */
    public final TransformInput transformInput() {
        return transformInput;
    }

    /**
     * <p>
     * Describes the results of the transform job.
     * </p>
     * 
     * @return Describes the results of the transform job.
     */
    public final TransformOutput transformOutput() {
        return transformOutput;
    }

    /**
     * <p>
     * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
     * </p>
     * 
     * @return Describes the resources, including ML instance types and ML instance count, to use for the transform job.
     */
    public final TransformResources transformResources() {
        return transformResources;
    }

    /**
     * <p>
     * The data structure used to specify the data to be used for inference in a batch transform job and to associate
     * the data that is relevant to the prediction results in the output. The input filter provided allows you to
     * exclude input data that is not needed for inference in a batch transform job. The output filter provided allows
     * you to include input data relevant to interpreting the predictions in the output from the job. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction
     * Results with their Corresponding Input Records</a>.
     * </p>
     * 
     * @return The data structure used to specify the data to be used for inference in a batch transform job and to
     *         associate the data that is relevant to the prediction results in the output. The input filter provided
     *         allows you to exclude input data that is not needed for inference in a batch transform job. The output
     *         filter provided allows you to include input data relevant to interpreting the predictions in the output
     *         from the job. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate
     *         Prediction Results with their Corresponding Input Records</a>.
     */
    public final DataProcessing dataProcessing() {
        return dataProcessing;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
     * Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) An array of key-value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
     *         >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the ExperimentConfig property for this object.
     * 
     * @return The value of the ExperimentConfig property for this object.
     */
    public final ExperimentConfig experimentConfig() {
        return experimentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentTransforms());
        hashCode = 31 * hashCode + Objects.hashCode(modelClientConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(batchStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transformInput());
        hashCode = 31 * hashCode + Objects.hashCode(transformOutput());
        hashCode = 31 * hashCode + Objects.hashCode(transformResources());
        hashCode = 31 * hashCode + Objects.hashCode(dataProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(experimentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformJobRequest)) {
            return false;
        }
        CreateTransformJobRequest other = (CreateTransformJobRequest) obj;
        return Objects.equals(transformJobName(), other.transformJobName()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(maxConcurrentTransforms(), other.maxConcurrentTransforms())
                && Objects.equals(modelClientConfig(), other.modelClientConfig())
                && Objects.equals(maxPayloadInMB(), other.maxPayloadInMB())
                && Objects.equals(batchStrategyAsString(), other.batchStrategyAsString())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment())
                && Objects.equals(transformInput(), other.transformInput())
                && Objects.equals(transformOutput(), other.transformOutput())
                && Objects.equals(transformResources(), other.transformResources())
                && Objects.equals(dataProcessing(), other.dataProcessing()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(experimentConfig(), other.experimentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransformJobRequest").add("TransformJobName", transformJobName())
                .add("ModelName", modelName()).add("MaxConcurrentTransforms", maxConcurrentTransforms())
                .add("ModelClientConfig", modelClientConfig()).add("MaxPayloadInMB", maxPayloadInMB())
                .add("BatchStrategy", batchStrategyAsString()).add("Environment", hasEnvironment() ? environment() : null)
                .add("TransformInput", transformInput()).add("TransformOutput", transformOutput())
                .add("TransformResources", transformResources()).add("DataProcessing", dataProcessing())
                .add("Tags", hasTags() ? tags() : null).add("ExperimentConfig", experimentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformJobName":
            return Optional.ofNullable(clazz.cast(transformJobName()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "MaxConcurrentTransforms":
            return Optional.ofNullable(clazz.cast(maxConcurrentTransforms()));
        case "ModelClientConfig":
            return Optional.ofNullable(clazz.cast(modelClientConfig()));
        case "MaxPayloadInMB":
            return Optional.ofNullable(clazz.cast(maxPayloadInMB()));
        case "BatchStrategy":
            return Optional.ofNullable(clazz.cast(batchStrategyAsString()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "TransformInput":
            return Optional.ofNullable(clazz.cast(transformInput()));
        case "TransformOutput":
            return Optional.ofNullable(clazz.cast(transformOutput()));
        case "TransformResources":
            return Optional.ofNullable(clazz.cast(transformResources()));
        case "DataProcessing":
            return Optional.ofNullable(clazz.cast(dataProcessing()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ExperimentConfig":
            return Optional.ofNullable(clazz.cast(experimentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformJobRequest, T> g) {
        return obj -> g.apply((CreateTransformJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTransformJobRequest> {
        /**
         * <p>
         * The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web
         * Services account.
         * </p>
         * 
         * @param transformJobName
         *        The name of the transform job. The name must be unique within an Amazon Web Services Region in an
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobName(String transformJobName);

        /**
         * <p>
         * The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of
         * an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.
         * </p>
         * 
         * @param modelName
         *        The name of the model that you want to use for the transform job. <code>ModelName</code> must be the
         *        name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web
         *        Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The maximum number of parallel requests that can be sent to each instance in a transform job. If
         * <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the
         * optional execution-parameters to determine the settings for your chosen algorithm. If the
         * execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information on
         * execution-parameters, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests"
         * >How Containers Serve Requests</a>. For built-in algorithms, you don't need to set a value for
         * <code>MaxConcurrentTransforms</code>.
         * </p>
         * 
         * @param maxConcurrentTransforms
         *        The maximum number of parallel requests that can be sent to each instance in a transform job. If
         *        <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks
         *        the optional execution-parameters to determine the settings for your chosen algorithm. If the
         *        execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more
         *        information on execution-parameters, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests"
         *        >How Containers Serve Requests</a>. For built-in algorithms, you don't need to set a value for
         *        <code>MaxConcurrentTransforms</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentTransforms(Integer maxConcurrentTransforms);

        /**
         * <p>
         * Configures the timeout and maximum number of retries for processing a transform job invocation.
         * </p>
         * 
         * @param modelClientConfig
         *        Configures the timeout and maximum number of retries for processing a transform job invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelClientConfig(ModelClientConfig modelClientConfig);

        /**
         * <p>
         * Configures the timeout and maximum number of retries for processing a transform job invocation.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelClientConfig.Builder} avoiding the need to
         * create one manually via {@link ModelClientConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelClientConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #modelClientConfig(ModelClientConfig)}.
         * 
         * @param modelClientConfig
         *        a consumer that will call methods on {@link ModelClientConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelClientConfig(ModelClientConfig)
         */
        default Builder modelClientConfig(Consumer<ModelClientConfig.Builder> modelClientConfig) {
            return modelClientConfig(ModelClientConfig.builder().applyMutation(modelClientConfig).build());
        }

        /**
         * <p>
         * The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without
         * metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single
         * record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To
         * ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The
         * default value is <code>6</code> MB.
         * </p>
         * <p>
         * For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set
         * the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker
         * built-in algorithms do not support HTTP chunked encoding.
         * </p>
         * 
         * @param maxPayloadInMB
         *        The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record
         *        (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the
         *        size of a single record. To estimate the size of a record in MB, divide the size of your dataset by
         *        the number of records. To ensure that the records fit within the maximum payload size, we recommend
         *        using a slightly larger value. The default value is <code>6</code> MB. </p>
         *        <p>
         *        For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding,
         *        set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon
         *        SageMaker built-in algorithms do not support HTTP chunked encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPayloadInMB(Integer maxPayloadInMB);

        /**
         * <p>
         * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
         * <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file
         * is a record.
         * </p>
         * <p>
         * To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
         * <code>RecordIO</code>, or <code>TFRecord</code>.
         * </p>
         * <p>
         * To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code>
         * to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.
         * </p>
         * <p>
         * To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
         * <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
         * </p>
         * 
         * @param batchStrategy
         *        Specifies the number of records to include in a mini-batch for an HTTP inference request. A
         *        <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single
         *        line in a CSV file is a record. </p>
         *        <p>
         *        To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
         *        <code>RecordIO</code>, or <code>TFRecord</code>.
         *        </p>
         *        <p>
         *        To use only one record when making an HTTP invocation request to a container, set
         *        <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to
         *        <code>Line</code>.
         *        </p>
         *        <p>
         *        To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
         *        <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
         * @see BatchStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchStrategy
         */
        Builder batchStrategy(String batchStrategy);

        /**
         * <p>
         * Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i>
         * <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file
         * is a record.
         * </p>
         * <p>
         * To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
         * <code>RecordIO</code>, or <code>TFRecord</code>.
         * </p>
         * <p>
         * To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code>
         * to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.
         * </p>
         * <p>
         * To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
         * <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
         * </p>
         * 
         * @param batchStrategy
         *        Specifies the number of records to include in a mini-batch for an HTTP inference request. A
         *        <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single
         *        line in a CSV file is a record. </p>
         *        <p>
         *        To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>,
         *        <code>RecordIO</code>, or <code>TFRecord</code>.
         *        </p>
         *        <p>
         *        To use only one record when making an HTTP invocation request to a container, set
         *        <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to
         *        <code>Line</code>.
         *        </p>
         *        <p>
         *        To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set
         *        <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.
         * @see BatchStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchStrategy
         */
        Builder batchStrategy(BatchStrategy batchStrategy);

        /**
         * <p>
         * The environment variables to set in the Docker container. We support up to 16 key and values entries in the
         * map.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container. We support up to 16 key and values entries
         *        in the map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * Describes the input source and the way the transform job consumes it.
         * </p>
         * 
         * @param transformInput
         *        Describes the input source and the way the transform job consumes it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformInput(TransformInput transformInput);

        /**
         * <p>
         * Describes the input source and the way the transform job consumes it.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformInput.Builder} avoiding the need to
         * create one manually via {@link TransformInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformInput.Builder#build()} is called immediately and its
         * result is passed to {@link #transformInput(TransformInput)}.
         * 
         * @param transformInput
         *        a consumer that will call methods on {@link TransformInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformInput(TransformInput)
         */
        default Builder transformInput(Consumer<TransformInput.Builder> transformInput) {
            return transformInput(TransformInput.builder().applyMutation(transformInput).build());
        }

        /**
         * <p>
         * Describes the results of the transform job.
         * </p>
         * 
         * @param transformOutput
         *        Describes the results of the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformOutput(TransformOutput transformOutput);

        /**
         * <p>
         * Describes the results of the transform job.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformOutput.Builder} avoiding the need to
         * create one manually via {@link TransformOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #transformOutput(TransformOutput)}.
         * 
         * @param transformOutput
         *        a consumer that will call methods on {@link TransformOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformOutput(TransformOutput)
         */
        default Builder transformOutput(Consumer<TransformOutput.Builder> transformOutput) {
            return transformOutput(TransformOutput.builder().applyMutation(transformOutput).build());
        }

        /**
         * <p>
         * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
         * </p>
         * 
         * @param transformResources
         *        Describes the resources, including ML instance types and ML instance count, to use for the transform
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformResources(TransformResources transformResources);

        /**
         * <p>
         * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformResources.Builder} avoiding the need to
         * create one manually via {@link TransformResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformResources.Builder#build()} is called immediately and its
         * result is passed to {@link #transformResources(TransformResources)}.
         * 
         * @param transformResources
         *        a consumer that will call methods on {@link TransformResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformResources(TransformResources)
         */
        default Builder transformResources(Consumer<TransformResources.Builder> transformResources) {
            return transformResources(TransformResources.builder().applyMutation(transformResources).build());
        }

        /**
         * <p>
         * The data structure used to specify the data to be used for inference in a batch transform job and to
         * associate the data that is relevant to the prediction results in the output. The input filter provided allows
         * you to exclude input data that is not needed for inference in a batch transform job. The output filter
         * provided allows you to include input data relevant to interpreting the predictions in the output from the
         * job. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate
         * Prediction Results with their Corresponding Input Records</a>.
         * </p>
         * 
         * @param dataProcessing
         *        The data structure used to specify the data to be used for inference in a batch transform job and to
         *        associate the data that is relevant to the prediction results in the output. The input filter provided
         *        allows you to exclude input data that is not needed for inference in a batch transform job. The output
         *        filter provided allows you to include input data relevant to interpreting the predictions in the
         *        output from the job. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate
         *        Prediction Results with their Corresponding Input Records</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProcessing(DataProcessing dataProcessing);

        /**
         * <p>
         * The data structure used to specify the data to be used for inference in a batch transform job and to
         * associate the data that is relevant to the prediction results in the output. The input filter provided allows
         * you to exclude input data that is not needed for inference in a batch transform job. The output filter
         * provided allows you to include input data relevant to interpreting the predictions in the output from the
         * job. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate
         * Prediction Results with their Corresponding Input Records</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link DataProcessing.Builder} avoiding the need to
         * create one manually via {@link DataProcessing#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataProcessing.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProcessing(DataProcessing)}.
         * 
         * @param dataProcessing
         *        a consumer that will call methods on {@link DataProcessing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProcessing(DataProcessing)
         */
        default Builder dataProcessing(Consumer<DataProcessing.Builder> dataProcessing) {
            return dataProcessing(DataProcessing.builder().applyMutation(dataProcessing).build());
        }

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * @param experimentConfig
         *        The new value for the ExperimentConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentConfig(ExperimentConfig experimentConfig);

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExperimentConfig.Builder} avoiding the need to
         * create one manually via {@link ExperimentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentConfig(ExperimentConfig)}.
         * 
         * @param experimentConfig
         *        a consumer that will call methods on {@link ExperimentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentConfig(ExperimentConfig)
         */
        default Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return experimentConfig(ExperimentConfig.builder().applyMutation(experimentConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String transformJobName;

        private String modelName;

        private Integer maxConcurrentTransforms;

        private ModelClientConfig modelClientConfig;

        private Integer maxPayloadInMB;

        private String batchStrategy;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private TransformInput transformInput;

        private TransformOutput transformOutput;

        private TransformResources transformResources;

        private DataProcessing dataProcessing;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformJobRequest model) {
            super(model);
            transformJobName(model.transformJobName);
            modelName(model.modelName);
            maxConcurrentTransforms(model.maxConcurrentTransforms);
            modelClientConfig(model.modelClientConfig);
            maxPayloadInMB(model.maxPayloadInMB);
            batchStrategy(model.batchStrategy);
            environment(model.environment);
            transformInput(model.transformInput);
            transformOutput(model.transformOutput);
            transformResources(model.transformResources);
            dataProcessing(model.dataProcessing);
            tags(model.tags);
            experimentConfig(model.experimentConfig);
        }

        public final String getTransformJobName() {
            return transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Integer getMaxConcurrentTransforms() {
            return maxConcurrentTransforms;
        }

        @Override
        public final Builder maxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public final void setMaxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
        }

        public final ModelClientConfig.Builder getModelClientConfig() {
            return modelClientConfig != null ? modelClientConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelClientConfig(ModelClientConfig modelClientConfig) {
            this.modelClientConfig = modelClientConfig;
            return this;
        }

        public final void setModelClientConfig(ModelClientConfig.BuilderImpl modelClientConfig) {
            this.modelClientConfig = modelClientConfig != null ? modelClientConfig.build() : null;
        }

        public final Integer getMaxPayloadInMB() {
            return maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        public final String getBatchStrategy() {
            return batchStrategy;
        }

        @Override
        public final Builder batchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Override
        public final Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy(batchStrategy == null ? null : batchStrategy.toString());
            return this;
        }

        public final void setBatchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
        }

        public final TransformInput.Builder getTransformInput() {
            return transformInput != null ? transformInput.toBuilder() : null;
        }

        @Override
        public final Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public final void setTransformInput(TransformInput.BuilderImpl transformInput) {
            this.transformInput = transformInput != null ? transformInput.build() : null;
        }

        public final TransformOutput.Builder getTransformOutput() {
            return transformOutput != null ? transformOutput.toBuilder() : null;
        }

        @Override
        public final Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public final void setTransformOutput(TransformOutput.BuilderImpl transformOutput) {
            this.transformOutput = transformOutput != null ? transformOutput.build() : null;
        }

        public final TransformResources.Builder getTransformResources() {
            return transformResources != null ? transformResources.toBuilder() : null;
        }

        @Override
        public final Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public final void setTransformResources(TransformResources.BuilderImpl transformResources) {
            this.transformResources = transformResources != null ? transformResources.build() : null;
        }

        public final DataProcessing.Builder getDataProcessing() {
            return dataProcessing != null ? dataProcessing.toBuilder() : null;
        }

        @Override
        public final Builder dataProcessing(DataProcessing dataProcessing) {
            this.dataProcessing = dataProcessing;
            return this;
        }

        public final void setDataProcessing(DataProcessing.BuilderImpl dataProcessing) {
            this.dataProcessing = dataProcessing != null ? dataProcessing.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return experimentConfig != null ? experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransformJobRequest build() {
            return new CreateTransformJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
