/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelineParametersForExecutionResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListPipelineParametersForExecutionResponse.Builder, ListPipelineParametersForExecutionResponse> {
    private static final SdkField<List<Parameter>> PIPELINE_PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("PipelineParameters")
            .getter(getter(ListPipelineParametersForExecutionResponse::pipelineParameters))
            .setter(setter(Builder::pipelineParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipelineParametersForExecutionResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_PARAMETERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Parameter> pipelineParameters;

    private final String nextToken;

    private ListPipelineParametersForExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineParameters = builder.pipelineParameters;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PipelineParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPipelineParameters() {
        return pipelineParameters != null && !(pipelineParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of pipeline parameters. This list can be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a list of pipeline parameters. This list can be empty.
     */
    public final List<Parameter> pipelineParameters() {
        return pipelineParameters;
    }

    /**
     * <p>
     * If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the
     *         response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the
     *         next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineParameters() ? pipelineParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineParametersForExecutionResponse)) {
            return false;
        }
        ListPipelineParametersForExecutionResponse other = (ListPipelineParametersForExecutionResponse) obj;
        return hasPipelineParameters() == other.hasPipelineParameters()
                && Objects.equals(pipelineParameters(), other.pipelineParameters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelineParametersForExecutionResponse")
                .add("PipelineParameters", hasPipelineParameters() ? pipelineParameters() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineParameters":
            return Optional.ofNullable(clazz.cast(pipelineParameters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineParametersForExecutionResponse, T> g) {
        return obj -> g.apply((ListPipelineParametersForExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPipelineParametersForExecutionResponse> {
        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * 
         * @param pipelineParameters
         *        Contains a list of pipeline parameters. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameters(Collection<Parameter> pipelineParameters);

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * 
         * @param pipelineParameters
         *        Contains a list of pipeline parameters. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameters(Parameter... pipelineParameters);

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineParameters(List<Parameter>)}.
         * 
         * @param pipelineParameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineParameters(List<Parameter>)
         */
        Builder pipelineParameters(Consumer<Parameter.Builder>... pipelineParameters);

        /**
         * <p>
         * If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the
         * response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated,
         *        the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token
         *        in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<Parameter> pipelineParameters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineParametersForExecutionResponse model) {
            super(model);
            pipelineParameters(model.pipelineParameters);
            nextToken(model.nextToken);
        }

        public final List<Parameter.Builder> getPipelineParameters() {
            List<Parameter.Builder> result = ParameterListCopier.copyToBuilder(this.pipelineParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pipelineParameters(Collection<Parameter> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copy(pipelineParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Parameter... pipelineParameters) {
            pipelineParameters(Arrays.asList(pipelineParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Consumer<Parameter.Builder>... pipelineParameters) {
            pipelineParameters(Stream.of(pipelineParameters).map(c -> Parameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineParameters(Collection<Parameter.BuilderImpl> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copyFromBuilder(pipelineParameters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPipelineParametersForExecutionResponse build() {
            return new ListPipelineParametersForExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
