/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeEndpointResponse.Builder, DescribeEndpointResponse> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(DescribeEndpointResponse::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(DescribeEndpointResponse::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(DescribeEndpointResponse::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<List<ProductionVariantSummary>> PRODUCTION_VARIANTS_FIELD = SdkField
            .<List<ProductionVariantSummary>> builder(MarshallingType.LIST)
            .memberName("ProductionVariants")
            .getter(getter(DescribeEndpointResponse::productionVariants))
            .setter(setter(Builder::productionVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductionVariantSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductionVariantSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataCaptureConfigSummary> DATA_CAPTURE_CONFIG_FIELD = SdkField
            .<DataCaptureConfigSummary> builder(MarshallingType.SDK_POJO).memberName("DataCaptureConfig")
            .getter(getter(DescribeEndpointResponse::dataCaptureConfig)).setter(setter(Builder::dataCaptureConfig))
            .constructor(DataCaptureConfigSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()).build();

    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointStatus").getter(getter(DescribeEndpointResponse::endpointStatusAsString))
            .setter(setter(Builder::endpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeEndpointResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeEndpointResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeEndpointResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<DeploymentConfig> LAST_DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("LastDeploymentConfig")
            .getter(getter(DescribeEndpointResponse::lastDeploymentConfig)).setter(setter(Builder::lastDeploymentConfig))
            .constructor(DeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeploymentConfig").build())
            .build();

    private static final SdkField<AsyncInferenceConfig> ASYNC_INFERENCE_CONFIG_FIELD = SdkField
            .<AsyncInferenceConfig> builder(MarshallingType.SDK_POJO).memberName("AsyncInferenceConfig")
            .getter(getter(DescribeEndpointResponse::asyncInferenceConfig)).setter(setter(Builder::asyncInferenceConfig))
            .constructor(AsyncInferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsyncInferenceConfig").build())
            .build();

    private static final SdkField<PendingDeploymentSummary> PENDING_DEPLOYMENT_SUMMARY_FIELD = SdkField
            .<PendingDeploymentSummary> builder(MarshallingType.SDK_POJO).memberName("PendingDeploymentSummary")
            .getter(getter(DescribeEndpointResponse::pendingDeploymentSummary)).setter(setter(Builder::pendingDeploymentSummary))
            .constructor(PendingDeploymentSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingDeploymentSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            ENDPOINT_ARN_FIELD, ENDPOINT_CONFIG_NAME_FIELD, PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD,
            ENDPOINT_STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_DEPLOYMENT_CONFIG_FIELD, ASYNC_INFERENCE_CONFIG_FIELD, PENDING_DEPLOYMENT_SUMMARY_FIELD));

    private final String endpointName;

    private final String endpointArn;

    private final String endpointConfigName;

    private final List<ProductionVariantSummary> productionVariants;

    private final DataCaptureConfigSummary dataCaptureConfig;

    private final String endpointStatus;

    private final String failureReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final DeploymentConfig lastDeploymentConfig;

    private final AsyncInferenceConfig asyncInferenceConfig;

    private final PendingDeploymentSummary pendingDeploymentSummary;

    private DescribeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.endpointArn = builder.endpointArn;
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.endpointStatus = builder.endpointStatus;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastDeploymentConfig = builder.lastDeploymentConfig;
        this.asyncInferenceConfig = builder.asyncInferenceConfig;
        this.pendingDeploymentSummary = builder.pendingDeploymentSummary;
    }

    /**
     * <p>
     * Name of the endpoint.
     * </p>
     * 
     * @return Name of the endpoint.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The name of the endpoint configuration associated with this endpoint.
     * </p>
     * 
     * @return The name of the endpoint configuration associated with this endpoint.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductionVariants property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductionVariants() {
        return productionVariants != null && !(productionVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductionVariants} method.
     * </p>
     * 
     * @return An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.
     */
    public final List<ProductionVariantSummary> productionVariants() {
        return productionVariants;
    }

    /**
     * Returns the value of the DataCaptureConfig property for this object.
     * 
     * @return The value of the DataCaptureConfig property for this object.
     */
    public final DataCaptureConfigSummary dataCaptureConfig() {
        return dataCaptureConfig;
    }

    /**
     * <p>
     * The status of the endpoint.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OutOfService</code>: Endpoint is not available to take incoming requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Creating</code>: <a>CreateEndpoint</a> is executing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled
     * until it has completed. This maintenance operation does not change any customer-specified values such as VPC
     * config, KMS encryption, model, instance type, or instance count.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process
     * of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an
     * <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled
     * and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call
     * or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InService</code>: Endpoint is available to process incoming requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
     * <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only
     * operation that can be performed on a failed endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The status of the endpoint.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OutOfService</code>: Endpoint is not available to take incoming requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Creating</code>: <a>CreateEndpoint</a> is executing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or
     *         re-scaled until it has completed. This maintenance operation does not change any customer-specified
     *         values such as VPC config, KMS encryption, model, instance type, or instance count.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the
     *         process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to
     *         an <code>InService</code> status. This transitional status only applies to an endpoint that has
     *         autoscaling enabled and is undergoing variant weight or capacity changes as part of an
     *         <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a>
     *         operation is called explicitly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InService</code>: Endpoint is available to process incoming requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
     *         <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is
     *         the only operation that can be performed on a failed endpoint.
     *         </p>
     *         </li>
     * @see EndpointStatus
     */
    public final EndpointStatus endpointStatus() {
        return EndpointStatus.fromValue(endpointStatus);
    }

    /**
     * <p>
     * The status of the endpoint.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OutOfService</code>: Endpoint is not available to take incoming requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Creating</code>: <a>CreateEndpoint</a> is executing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled
     * until it has completed. This maintenance operation does not change any customer-specified values such as VPC
     * config, KMS encryption, model, instance type, or instance count.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process
     * of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an
     * <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled
     * and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call
     * or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InService</code>: Endpoint is available to process incoming requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
     * <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only
     * operation that can be performed on a failed endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The status of the endpoint.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OutOfService</code>: Endpoint is not available to take incoming requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Creating</code>: <a>CreateEndpoint</a> is executing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or
     *         re-scaled until it has completed. This maintenance operation does not change any customer-specified
     *         values such as VPC config, KMS encryption, model, instance type, or instance count.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the
     *         process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to
     *         an <code>InService</code> status. This transitional status only applies to an endpoint that has
     *         autoscaling enabled and is undergoing variant weight or capacity changes as part of an
     *         <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a>
     *         operation is called explicitly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InService</code>: Endpoint is available to process incoming requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
     *         <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is
     *         the only operation that can be performed on a failed endpoint.
     *         </p>
     *         </li>
     * @see EndpointStatus
     */
    public final String endpointStatusAsString() {
        return endpointStatus;
    }

    /**
     * <p>
     * If the status of the endpoint is <code>Failed</code>, the reason why it failed.
     * </p>
     * 
     * @return If the status of the endpoint is <code>Failed</code>, the reason why it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * A timestamp that shows when the endpoint was created.
     * </p>
     * 
     * @return A timestamp that shows when the endpoint was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that shows when the endpoint was last modified.
     * </p>
     * 
     * @return A timestamp that shows when the endpoint was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The most recent deployment configuration for the endpoint.
     * </p>
     * 
     * @return The most recent deployment configuration for the endpoint.
     */
    public final DeploymentConfig lastDeploymentConfig() {
        return lastDeploymentConfig;
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * <code>CreateEndpointConfig</code> </a> API.
     * </p>
     * 
     * @return Returns the description of an endpoint configuration created using the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     *         <code>CreateEndpointConfig</code> </a> API.
     */
    public final AsyncInferenceConfig asyncInferenceConfig() {
        return asyncInferenceConfig;
    }

    /**
     * <p>
     * Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating or
     * updating with a new endpoint configuration.
     * </p>
     * 
     * @return Returns the summary of an in-progress deployment. This field is only returned when the endpoint is
     *         creating or updating with a new endpoint configuration.
     */
    public final PendingDeploymentSummary pendingDeploymentSummary() {
        return pendingDeploymentSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductionVariants() ? productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(asyncInferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDeploymentSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointResponse)) {
            return false;
        }
        DescribeEndpointResponse other = (DescribeEndpointResponse) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(endpointArn(), other.endpointArn())
                && Objects.equals(endpointConfigName(), other.endpointConfigName())
                && hasProductionVariants() == other.hasProductionVariants()
                && Objects.equals(productionVariants(), other.productionVariants())
                && Objects.equals(dataCaptureConfig(), other.dataCaptureConfig())
                && Objects.equals(endpointStatusAsString(), other.endpointStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastDeploymentConfig(), other.lastDeploymentConfig())
                && Objects.equals(asyncInferenceConfig(), other.asyncInferenceConfig())
                && Objects.equals(pendingDeploymentSummary(), other.pendingDeploymentSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointResponse").add("EndpointName", endpointName()).add("EndpointArn", endpointArn())
                .add("EndpointConfigName", endpointConfigName())
                .add("ProductionVariants", hasProductionVariants() ? productionVariants() : null)
                .add("DataCaptureConfig", dataCaptureConfig()).add("EndpointStatus", endpointStatusAsString())
                .add("FailureReason", failureReason()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LastDeploymentConfig", lastDeploymentConfig())
                .add("AsyncInferenceConfig", asyncInferenceConfig()).add("PendingDeploymentSummary", pendingDeploymentSummary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "ProductionVariants":
            return Optional.ofNullable(clazz.cast(productionVariants()));
        case "DataCaptureConfig":
            return Optional.ofNullable(clazz.cast(dataCaptureConfig()));
        case "EndpointStatus":
            return Optional.ofNullable(clazz.cast(endpointStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastDeploymentConfig":
            return Optional.ofNullable(clazz.cast(lastDeploymentConfig()));
        case "AsyncInferenceConfig":
            return Optional.ofNullable(clazz.cast(asyncInferenceConfig()));
        case "PendingDeploymentSummary":
            return Optional.ofNullable(clazz.cast(pendingDeploymentSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointResponse, T> g) {
        return obj -> g.apply((DescribeEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEndpointResponse> {
        /**
         * <p>
         * Name of the endpoint.
         * </p>
         * 
         * @param endpointName
         *        Name of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The name of the endpoint configuration associated with this endpoint.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of the endpoint configuration associated with this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(Collection<ProductionVariantSummary> productionVariants);

        /**
         * <p>
         * An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(ProductionVariantSummary... productionVariants);

        /**
         * <p>
         * An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProductionVariantSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ProductionVariantSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductionVariantSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #productionVariants(List<ProductionVariantSummary>)}.
         * 
         * @param productionVariants
         *        a consumer that will call methods on {@link List<ProductionVariantSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionVariants(List<ProductionVariantSummary>)
         */
        Builder productionVariants(Consumer<ProductionVariantSummary.Builder>... productionVariants);

        /**
         * Sets the value of the DataCaptureConfig property for this object.
         *
         * @param dataCaptureConfig
         *        The new value for the DataCaptureConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCaptureConfig(DataCaptureConfigSummary dataCaptureConfig);

        /**
         * Sets the value of the DataCaptureConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataCaptureConfigSummary.Builder}
         * avoiding the need to create one manually via {@link DataCaptureConfigSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCaptureConfigSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #dataCaptureConfig(DataCaptureConfigSummary)}.
         * 
         * @param dataCaptureConfig
         *        a consumer that will call methods on {@link DataCaptureConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCaptureConfig(DataCaptureConfigSummary)
         */
        default Builder dataCaptureConfig(Consumer<DataCaptureConfigSummary.Builder> dataCaptureConfig) {
            return dataCaptureConfig(DataCaptureConfigSummary.builder().applyMutation(dataCaptureConfig).build());
        }

        /**
         * <p>
         * The status of the endpoint.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OutOfService</code>: Endpoint is not available to take incoming requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Creating</code>: <a>CreateEndpoint</a> is executing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled
         * until it has completed. This maintenance operation does not change any customer-specified values such as VPC
         * config, KMS encryption, model, instance type, or instance count.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the
         * process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an
         * <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling
         * enabled and is undergoing variant weight or capacity changes as part of an
         * <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a>
         * operation is called explicitly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InService</code>: Endpoint is available to process incoming requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
         * <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the
         * only operation that can be performed on a failed endpoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpointStatus
         *        The status of the endpoint.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OutOfService</code>: Endpoint is not available to take incoming requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Creating</code>: <a>CreateEndpoint</a> is executing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is
         *        executing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or
         *        re-scaled until it has completed. This maintenance operation does not change any customer-specified
         *        values such as VPC config, KMS encryption, model, instance type, or instance count.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in
         *        the process of rolling back to its previous configuration. Once the rollback completes, endpoint
         *        returns to an <code>InService</code> status. This transitional status only applies to an endpoint that
         *        has autoscaling enabled and is undergoing variant weight or capacity changes as part of an
         *        <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a>
         *        operation is called explicitly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InService</code>: Endpoint is available to process incoming requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
         *        <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a>
         *        is the only operation that can be performed on a failed endpoint.
         *        </p>
         *        </li>
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * The status of the endpoint.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OutOfService</code>: Endpoint is not available to take incoming requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Creating</code>: <a>CreateEndpoint</a> is executing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled
         * until it has completed. This maintenance operation does not change any customer-specified values such as VPC
         * config, KMS encryption, model, instance type, or instance count.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the
         * process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an
         * <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling
         * enabled and is undergoing variant weight or capacity changes as part of an
         * <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a>
         * operation is called explicitly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InService</code>: Endpoint is available to process incoming requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
         * <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the
         * only operation that can be performed on a failed endpoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpointStatus
         *        The status of the endpoint.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OutOfService</code>: Endpoint is not available to take incoming requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Creating</code>: <a>CreateEndpoint</a> is executing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is
         *        executing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or
         *        re-scaled until it has completed. This maintenance operation does not change any customer-specified
         *        values such as VPC config, KMS encryption, model, instance type, or instance count.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in
         *        the process of rolling back to its previous configuration. Once the rollback completes, endpoint
         *        returns to an <code>InService</code> status. This transitional status only applies to an endpoint that
         *        has autoscaling enabled and is undergoing variant weight or capacity changes as part of an
         *        <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a>
         *        operation is called explicitly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InService</code>: Endpoint is available to process incoming requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use
         *        <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a>
         *        is the only operation that can be performed on a failed endpoint.
         *        </p>
         *        </li>
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder endpointStatus(EndpointStatus endpointStatus);

        /**
         * <p>
         * If the status of the endpoint is <code>Failed</code>, the reason why it failed.
         * </p>
         * 
         * @param failureReason
         *        If the status of the endpoint is <code>Failed</code>, the reason why it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * A timestamp that shows when the endpoint was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that shows when the endpoint was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that shows when the endpoint was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The most recent deployment configuration for the endpoint.
         * </p>
         * 
         * @param lastDeploymentConfig
         *        The most recent deployment configuration for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentConfig(DeploymentConfig lastDeploymentConfig);

        /**
         * <p>
         * The most recent deployment configuration for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfig.Builder} avoiding the
         * need to create one manually via {@link DeploymentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #lastDeploymentConfig(DeploymentConfig)}.
         * 
         * @param lastDeploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastDeploymentConfig(DeploymentConfig)
         */
        default Builder lastDeploymentConfig(Consumer<DeploymentConfig.Builder> lastDeploymentConfig) {
            return lastDeploymentConfig(DeploymentConfig.builder().applyMutation(lastDeploymentConfig).build());
        }

        /**
         * <p>
         * Returns the description of an endpoint configuration created using the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
         * <code>CreateEndpointConfig</code> </a> API.
         * </p>
         * 
         * @param asyncInferenceConfig
         *        Returns the description of an endpoint configuration created using the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
         *        <code>CreateEndpointConfig</code> </a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig);

        /**
         * <p>
         * Returns the description of an endpoint configuration created using the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
         * <code>CreateEndpointConfig</code> </a> API.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsyncInferenceConfig.Builder} avoiding
         * the need to create one manually via {@link AsyncInferenceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AsyncInferenceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #asyncInferenceConfig(AsyncInferenceConfig)}.
         * 
         * @param asyncInferenceConfig
         *        a consumer that will call methods on {@link AsyncInferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asyncInferenceConfig(AsyncInferenceConfig)
         */
        default Builder asyncInferenceConfig(Consumer<AsyncInferenceConfig.Builder> asyncInferenceConfig) {
            return asyncInferenceConfig(AsyncInferenceConfig.builder().applyMutation(asyncInferenceConfig).build());
        }

        /**
         * <p>
         * Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating
         * or updating with a new endpoint configuration.
         * </p>
         * 
         * @param pendingDeploymentSummary
         *        Returns the summary of an in-progress deployment. This field is only returned when the endpoint is
         *        creating or updating with a new endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingDeploymentSummary(PendingDeploymentSummary pendingDeploymentSummary);

        /**
         * <p>
         * Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating
         * or updating with a new endpoint configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PendingDeploymentSummary.Builder}
         * avoiding the need to create one manually via {@link PendingDeploymentSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link PendingDeploymentSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #pendingDeploymentSummary(PendingDeploymentSummary)}.
         * 
         * @param pendingDeploymentSummary
         *        a consumer that will call methods on {@link PendingDeploymentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingDeploymentSummary(PendingDeploymentSummary)
         */
        default Builder pendingDeploymentSummary(Consumer<PendingDeploymentSummary.Builder> pendingDeploymentSummary) {
            return pendingDeploymentSummary(PendingDeploymentSummary.builder().applyMutation(pendingDeploymentSummary).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String endpointName;

        private String endpointArn;

        private String endpointConfigName;

        private List<ProductionVariantSummary> productionVariants = DefaultSdkAutoConstructList.getInstance();

        private DataCaptureConfigSummary dataCaptureConfig;

        private String endpointStatus;

        private String failureReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private DeploymentConfig lastDeploymentConfig;

        private AsyncInferenceConfig asyncInferenceConfig;

        private PendingDeploymentSummary pendingDeploymentSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointResponse model) {
            super(model);
            endpointName(model.endpointName);
            endpointArn(model.endpointArn);
            endpointConfigName(model.endpointConfigName);
            productionVariants(model.productionVariants);
            dataCaptureConfig(model.dataCaptureConfig);
            endpointStatus(model.endpointStatus);
            failureReason(model.failureReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            lastDeploymentConfig(model.lastDeploymentConfig);
            asyncInferenceConfig(model.asyncInferenceConfig);
            pendingDeploymentSummary(model.pendingDeploymentSummary);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final List<ProductionVariantSummary.Builder> getProductionVariants() {
            List<ProductionVariantSummary.Builder> result = ProductionVariantSummaryListCopier
                    .copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<ProductionVariantSummary.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantSummaryListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariantSummary> productionVariants) {
            this.productionVariants = ProductionVariantSummaryListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariantSummary... productionVariants) {
            productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariantSummary.Builder>... productionVariants) {
            productionVariants(Stream.of(productionVariants)
                    .map(c -> ProductionVariantSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataCaptureConfigSummary.Builder getDataCaptureConfig() {
            return dataCaptureConfig != null ? dataCaptureConfig.toBuilder() : null;
        }

        public final void setDataCaptureConfig(DataCaptureConfigSummary.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        @Override
        public final Builder dataCaptureConfig(DataCaptureConfigSummary dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(EndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final DeploymentConfig.Builder getLastDeploymentConfig() {
            return lastDeploymentConfig != null ? lastDeploymentConfig.toBuilder() : null;
        }

        public final void setLastDeploymentConfig(DeploymentConfig.BuilderImpl lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig != null ? lastDeploymentConfig.build() : null;
        }

        @Override
        public final Builder lastDeploymentConfig(DeploymentConfig lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig;
            return this;
        }

        public final AsyncInferenceConfig.Builder getAsyncInferenceConfig() {
            return asyncInferenceConfig != null ? asyncInferenceConfig.toBuilder() : null;
        }

        public final void setAsyncInferenceConfig(AsyncInferenceConfig.BuilderImpl asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig != null ? asyncInferenceConfig.build() : null;
        }

        @Override
        public final Builder asyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        public final PendingDeploymentSummary.Builder getPendingDeploymentSummary() {
            return pendingDeploymentSummary != null ? pendingDeploymentSummary.toBuilder() : null;
        }

        public final void setPendingDeploymentSummary(PendingDeploymentSummary.BuilderImpl pendingDeploymentSummary) {
            this.pendingDeploymentSummary = pendingDeploymentSummary != null ? pendingDeploymentSummary.build() : null;
        }

        @Override
        public final Builder pendingDeploymentSummary(PendingDeploymentSummary pendingDeploymentSummary) {
            this.pendingDeploymentSummary = pendingDeploymentSummary;
            return this;
        }

        @Override
        public DescribeEndpointResponse build() {
            return new DescribeEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
