/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.LifecycleConfigArnsCopier;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JupyterServerAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JupyterServerAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultResourceSpec").getter(JupyterServerAppSettings.getter(JupyterServerAppSettings::defaultResourceSpec)).setter(JupyterServerAppSettings.setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build()}).build();
    private static final SdkField<List<String>> LIFECYCLE_CONFIG_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifecycleConfigArns").getter(JupyterServerAppSettings.getter(JupyterServerAppSettings::lifecycleConfigArns)).setter(JupyterServerAppSettings.setter(Builder::lifecycleConfigArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD, LIFECYCLE_CONFIG_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceSpec defaultResourceSpec;
    private final List<String> lifecycleConfigArns;

    private JupyterServerAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.lifecycleConfigArns = builder.lifecycleConfigArns;
    }

    public final ResourceSpec defaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public final boolean hasLifecycleConfigArns() {
        return this.lifecycleConfigArns != null && !(this.lifecycleConfigArns instanceof SdkAutoConstructList);
    }

    public final List<String> lifecycleConfigArns() {
        return this.lifecycleConfigArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JupyterServerAppSettings)) {
            return false;
        }
        JupyterServerAppSettings other = (JupyterServerAppSettings)obj;
        return Objects.equals(this.defaultResourceSpec(), other.defaultResourceSpec()) && this.hasLifecycleConfigArns() == other.hasLifecycleConfigArns() && Objects.equals(this.lifecycleConfigArns(), other.lifecycleConfigArns());
    }

    public final String toString() {
        return ToString.builder((String)"JupyterServerAppSettings").add("DefaultResourceSpec", (Object)this.defaultResourceSpec()).add("LifecycleConfigArns", this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceSpec()));
            }
            case "LifecycleConfigArns": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JupyterServerAppSettings, T> g) {
        return obj -> g.apply((JupyterServerAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceSpec defaultResourceSpec;
        private List<String> lifecycleConfigArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JupyterServerAppSettings model) {
            this.defaultResourceSpec(model.defaultResourceSpec);
            this.lifecycleConfigArns(model.lifecycleConfigArns);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return this.defaultResourceSpec != null ? this.defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final Collection<String> getLifecycleConfigArns() {
            if (this.lifecycleConfigArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleConfigArns;
        }

        public final void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
        }

        @Override
        public final Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleConfigArns(String ... lifecycleConfigArns) {
            this.lifecycleConfigArns(Arrays.asList(lifecycleConfigArns));
            return this;
        }

        public JupyterServerAppSettings build() {
            return new JupyterServerAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JupyterServerAppSettings> {
        public Builder defaultResourceSpec(ResourceSpec var1);

        default public Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return this.defaultResourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(defaultResourceSpec)).build());
        }

        public Builder lifecycleConfigArns(Collection<String> var1);

        public Builder lifecycleConfigArns(String ... var1);
    }
}

