/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelConfiguration> {
    private static final SdkField<String> INFERENCE_SPECIFICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSpecificationName").getter(ModelConfiguration.getter(ModelConfiguration::inferenceSpecificationName)).setter(ModelConfiguration.setter(Builder::inferenceSpecificationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecificationName").build()}).build();
    private static final SdkField<List<EnvironmentParameter>> ENVIRONMENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentParameters").getter(ModelConfiguration.getter(ModelConfiguration::environmentParameters)).setter(ModelConfiguration.setter(Builder::environmentParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_SPECIFICATION_NAME_FIELD, ENVIRONMENT_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inferenceSpecificationName;
    private final List<EnvironmentParameter> environmentParameters;

    private ModelConfiguration(BuilderImpl builder) {
        this.inferenceSpecificationName = builder.inferenceSpecificationName;
        this.environmentParameters = builder.environmentParameters;
    }

    public final String inferenceSpecificationName() {
        return this.inferenceSpecificationName;
    }

    public final boolean hasEnvironmentParameters() {
        return this.environmentParameters != null && !(this.environmentParameters instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentParameter> environmentParameters() {
        return this.environmentParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecificationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentParameters() ? this.environmentParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelConfiguration)) {
            return false;
        }
        ModelConfiguration other = (ModelConfiguration)obj;
        return Objects.equals(this.inferenceSpecificationName(), other.inferenceSpecificationName()) && this.hasEnvironmentParameters() == other.hasEnvironmentParameters() && Objects.equals(this.environmentParameters(), other.environmentParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ModelConfiguration").add("InferenceSpecificationName", (Object)this.inferenceSpecificationName()).add("EnvironmentParameters", this.hasEnvironmentParameters() ? this.environmentParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceSpecificationName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecificationName()));
            }
            case "EnvironmentParameters": {
                return Optional.ofNullable(clazz.cast(this.environmentParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelConfiguration, T> g) {
        return obj -> g.apply((ModelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inferenceSpecificationName;
        private List<EnvironmentParameter> environmentParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelConfiguration model) {
            this.inferenceSpecificationName(model.inferenceSpecificationName);
            this.environmentParameters(model.environmentParameters);
        }

        public final String getInferenceSpecificationName() {
            return this.inferenceSpecificationName;
        }

        public final void setInferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
        }

        @Override
        public final Builder inferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getEnvironmentParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersCopier.copyToBuilder(this.environmentParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentParameters(Collection<EnvironmentParameter.BuilderImpl> environmentParameters) {
            this.environmentParameters = EnvironmentParametersCopier.copyFromBuilder(environmentParameters);
        }

        @Override
        public final Builder environmentParameters(Collection<EnvironmentParameter> environmentParameters) {
            this.environmentParameters = EnvironmentParametersCopier.copy(environmentParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(EnvironmentParameter ... environmentParameters) {
            this.environmentParameters(Arrays.asList(environmentParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(Consumer<EnvironmentParameter.Builder> ... environmentParameters) {
            this.environmentParameters(Stream.of(environmentParameters).map(c -> (EnvironmentParameter)((EnvironmentParameter.Builder)EnvironmentParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ModelConfiguration build() {
            return new ModelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelConfiguration> {
        public Builder inferenceSpecificationName(String var1);

        public Builder environmentParameters(Collection<EnvironmentParameter> var1);

        public Builder environmentParameters(EnvironmentParameter ... var1);

        public Builder environmentParameters(Consumer<EnvironmentParameter.Builder> ... var1);
    }
}

