/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for Dataset Definition inputs. The Dataset Definition input must specify exactly one of either
 * <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetDefinition.Builder, DatasetDefinition> {
    private static final SdkField<AthenaDatasetDefinition> ATHENA_DATASET_DEFINITION_FIELD = SdkField
            .<AthenaDatasetDefinition> builder(MarshallingType.SDK_POJO).memberName("AthenaDatasetDefinition")
            .getter(getter(DatasetDefinition::athenaDatasetDefinition)).setter(setter(Builder::athenaDatasetDefinition))
            .constructor(AthenaDatasetDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaDatasetDefinition").build())
            .build();

    private static final SdkField<RedshiftDatasetDefinition> REDSHIFT_DATASET_DEFINITION_FIELD = SdkField
            .<RedshiftDatasetDefinition> builder(MarshallingType.SDK_POJO).memberName("RedshiftDatasetDefinition")
            .getter(getter(DatasetDefinition::redshiftDatasetDefinition)).setter(setter(Builder::redshiftDatasetDefinition))
            .constructor(RedshiftDatasetDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDatasetDefinition").build())
            .build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalPath").getter(getter(DatasetDefinition::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final SdkField<String> DATA_DISTRIBUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataDistributionType").getter(getter(DatasetDefinition::dataDistributionTypeAsString))
            .setter(setter(Builder::dataDistributionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDistributionType").build())
            .build();

    private static final SdkField<String> INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputMode").getter(getter(DatasetDefinition::inputModeAsString)).setter(setter(Builder::inputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ATHENA_DATASET_DEFINITION_FIELD, REDSHIFT_DATASET_DEFINITION_FIELD, LOCAL_PATH_FIELD, DATA_DISTRIBUTION_TYPE_FIELD,
            INPUT_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AthenaDatasetDefinition athenaDatasetDefinition;

    private final RedshiftDatasetDefinition redshiftDatasetDefinition;

    private final String localPath;

    private final String dataDistributionType;

    private final String inputMode;

    private DatasetDefinition(BuilderImpl builder) {
        this.athenaDatasetDefinition = builder.athenaDatasetDefinition;
        this.redshiftDatasetDefinition = builder.redshiftDatasetDefinition;
        this.localPath = builder.localPath;
        this.dataDistributionType = builder.dataDistributionType;
        this.inputMode = builder.inputMode;
    }

    /**
     * Returns the value of the AthenaDatasetDefinition property for this object.
     * 
     * @return The value of the AthenaDatasetDefinition property for this object.
     */
    public final AthenaDatasetDefinition athenaDatasetDefinition() {
        return athenaDatasetDefinition;
    }

    /**
     * Returns the value of the RedshiftDatasetDefinition property for this object.
     * 
     * @return The value of the RedshiftDatasetDefinition property for this object.
     */
    public final RedshiftDatasetDefinition redshiftDatasetDefinition() {
        return redshiftDatasetDefinition;
    }

    /**
     * <p>
     * The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job.
     * <code>LocalPath</code> is an absolute path to the input data. This is a required parameter when
     * <code>AppManaged</code> is <code>False</code> (default).
     * </p>
     * 
     * @return The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a
     *         processing job. <code>LocalPath</code> is an absolute path to the input data. This is a required
     *         parameter when <code>AppManaged</code> is <code>False</code> (default).
     */
    public final String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataDistributionType} will return {@link DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
     * @see DataDistributionType
     */
    public final DataDistributionType dataDistributionType() {
        return DataDistributionType.fromValue(dataDistributionType);
    }

    /**
     * <p>
     * Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataDistributionType} will return {@link DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
     * @see DataDistributionType
     */
    public final String dataDistributionTypeAsString() {
        return dataDistributionType;
    }

    /**
     * <p>
     * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode, Amazon
     * SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes
     * before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode,
     * Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputMode} will
     * return {@link InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputModeAsString}.
     * </p>
     * 
     * @return Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode,
     *         Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon
     *         EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In
     *         <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
     *         without using the EBS volume.
     * @see InputMode
     */
    public final InputMode inputMode() {
        return InputMode.fromValue(inputMode);
    }

    /**
     * <p>
     * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode, Amazon
     * SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes
     * before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode,
     * Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputMode} will
     * return {@link InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputModeAsString}.
     * </p>
     * 
     * @return Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode,
     *         Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon
     *         EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In
     *         <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
     *         without using the EBS volume.
     * @see InputMode
     */
    public final String inputModeAsString() {
        return inputMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(athenaDatasetDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDatasetDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(dataDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDefinition)) {
            return false;
        }
        DatasetDefinition other = (DatasetDefinition) obj;
        return Objects.equals(athenaDatasetDefinition(), other.athenaDatasetDefinition())
                && Objects.equals(redshiftDatasetDefinition(), other.redshiftDatasetDefinition())
                && Objects.equals(localPath(), other.localPath())
                && Objects.equals(dataDistributionTypeAsString(), other.dataDistributionTypeAsString())
                && Objects.equals(inputModeAsString(), other.inputModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetDefinition").add("AthenaDatasetDefinition", athenaDatasetDefinition())
                .add("RedshiftDatasetDefinition", redshiftDatasetDefinition()).add("LocalPath", localPath())
                .add("DataDistributionType", dataDistributionTypeAsString()).add("InputMode", inputModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AthenaDatasetDefinition":
            return Optional.ofNullable(clazz.cast(athenaDatasetDefinition()));
        case "RedshiftDatasetDefinition":
            return Optional.ofNullable(clazz.cast(redshiftDatasetDefinition()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "DataDistributionType":
            return Optional.ofNullable(clazz.cast(dataDistributionTypeAsString()));
        case "InputMode":
            return Optional.ofNullable(clazz.cast(inputModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetDefinition, T> g) {
        return obj -> g.apply((DatasetDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetDefinition> {
        /**
         * Sets the value of the AthenaDatasetDefinition property for this object.
         *
         * @param athenaDatasetDefinition
         *        The new value for the AthenaDatasetDefinition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaDatasetDefinition(AthenaDatasetDefinition athenaDatasetDefinition);

        /**
         * Sets the value of the AthenaDatasetDefinition property for this object.
         *
         * This is a convenience that creates an instance of the {@link AthenaDatasetDefinition.Builder} avoiding the
         * need to create one manually via {@link AthenaDatasetDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link AthenaDatasetDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #athenaDatasetDefinition(AthenaDatasetDefinition)}.
         * 
         * @param athenaDatasetDefinition
         *        a consumer that will call methods on {@link AthenaDatasetDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaDatasetDefinition(AthenaDatasetDefinition)
         */
        default Builder athenaDatasetDefinition(Consumer<AthenaDatasetDefinition.Builder> athenaDatasetDefinition) {
            return athenaDatasetDefinition(AthenaDatasetDefinition.builder().applyMutation(athenaDatasetDefinition).build());
        }

        /**
         * Sets the value of the RedshiftDatasetDefinition property for this object.
         *
         * @param redshiftDatasetDefinition
         *        The new value for the RedshiftDatasetDefinition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDatasetDefinition(RedshiftDatasetDefinition redshiftDatasetDefinition);

        /**
         * Sets the value of the RedshiftDatasetDefinition property for this object.
         *
         * This is a convenience that creates an instance of the {@link RedshiftDatasetDefinition.Builder} avoiding the
         * need to create one manually via {@link RedshiftDatasetDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDatasetDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftDatasetDefinition(RedshiftDatasetDefinition)}.
         * 
         * @param redshiftDatasetDefinition
         *        a consumer that will call methods on {@link RedshiftDatasetDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDatasetDefinition(RedshiftDatasetDefinition)
         */
        default Builder redshiftDatasetDefinition(Consumer<RedshiftDatasetDefinition.Builder> redshiftDatasetDefinition) {
            return redshiftDatasetDefinition(RedshiftDatasetDefinition.builder().applyMutation(redshiftDatasetDefinition).build());
        }

        /**
         * <p>
         * The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing
         * job. <code>LocalPath</code> is an absolute path to the input data. This is a required parameter when
         * <code>AppManaged</code> is <code>False</code> (default).
         * </p>
         * 
         * @param localPath
         *        The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a
         *        processing job. <code>LocalPath</code> is an absolute path to the input data. This is a required
         *        parameter when <code>AppManaged</code> is <code>False</code> (default).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
         * </p>
         * 
         * @param dataDistributionType
         *        Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>
         *        (default).
         * @see DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataDistributionType
         */
        Builder dataDistributionType(String dataDistributionType);

        /**
         * <p>
         * Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
         * </p>
         * 
         * @param dataDistributionType
         *        Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>
         *        (default).
         * @see DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataDistributionType
         */
        Builder dataDistributionType(DataDistributionType dataDistributionType);

        /**
         * <p>
         * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode, Amazon
         * SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS)
         * volumes before starting your training algorithm. This is the most commonly used input mode. In
         * <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
         * without using the EBS volume.
         * </p>
         * 
         * @param inputMode
         *        Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode,
         *        Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store
         *        (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input
         *        mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your
         *        algorithm without using the EBS volume.
         * @see InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputMode
         */
        Builder inputMode(String inputMode);

        /**
         * <p>
         * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode, Amazon
         * SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS)
         * volumes before starting your training algorithm. This is the most commonly used input mode. In
         * <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
         * without using the EBS volume.
         * </p>
         * 
         * @param inputMode
         *        Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode,
         *        Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store
         *        (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input
         *        mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your
         *        algorithm without using the EBS volume.
         * @see InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputMode
         */
        Builder inputMode(InputMode inputMode);
    }

    static final class BuilderImpl implements Builder {
        private AthenaDatasetDefinition athenaDatasetDefinition;

        private RedshiftDatasetDefinition redshiftDatasetDefinition;

        private String localPath;

        private String dataDistributionType;

        private String inputMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDefinition model) {
            athenaDatasetDefinition(model.athenaDatasetDefinition);
            redshiftDatasetDefinition(model.redshiftDatasetDefinition);
            localPath(model.localPath);
            dataDistributionType(model.dataDistributionType);
            inputMode(model.inputMode);
        }

        public final AthenaDatasetDefinition.Builder getAthenaDatasetDefinition() {
            return athenaDatasetDefinition != null ? athenaDatasetDefinition.toBuilder() : null;
        }

        public final void setAthenaDatasetDefinition(AthenaDatasetDefinition.BuilderImpl athenaDatasetDefinition) {
            this.athenaDatasetDefinition = athenaDatasetDefinition != null ? athenaDatasetDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder athenaDatasetDefinition(AthenaDatasetDefinition athenaDatasetDefinition) {
            this.athenaDatasetDefinition = athenaDatasetDefinition;
            return this;
        }

        public final RedshiftDatasetDefinition.Builder getRedshiftDatasetDefinition() {
            return redshiftDatasetDefinition != null ? redshiftDatasetDefinition.toBuilder() : null;
        }

        public final void setRedshiftDatasetDefinition(RedshiftDatasetDefinition.BuilderImpl redshiftDatasetDefinition) {
            this.redshiftDatasetDefinition = redshiftDatasetDefinition != null ? redshiftDatasetDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder redshiftDatasetDefinition(RedshiftDatasetDefinition redshiftDatasetDefinition) {
            this.redshiftDatasetDefinition = redshiftDatasetDefinition;
            return this;
        }

        public final String getLocalPath() {
            return localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        @Transient
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final String getDataDistributionType() {
            return dataDistributionType;
        }

        public final void setDataDistributionType(String dataDistributionType) {
            this.dataDistributionType = dataDistributionType;
        }

        @Override
        @Transient
        public final Builder dataDistributionType(String dataDistributionType) {
            this.dataDistributionType = dataDistributionType;
            return this;
        }

        @Override
        @Transient
        public final Builder dataDistributionType(DataDistributionType dataDistributionType) {
            this.dataDistributionType(dataDistributionType == null ? null : dataDistributionType.toString());
            return this;
        }

        public final String getInputMode() {
            return inputMode;
        }

        public final void setInputMode(String inputMode) {
            this.inputMode = inputMode;
        }

        @Override
        @Transient
        public final Builder inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        @Override
        @Transient
        public final Builder inputMode(InputMode inputMode) {
            this.inputMode(inputMode == null ? null : inputMode.toString());
            return this;
        }

        @Override
        public DatasetDefinition build() {
            return new DatasetDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
