/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon
 * Virtual Private Cloud (VPC).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageConfig implements SdkPojo, Serializable, ToCopyableBuilder<ImageConfig.Builder, ImageConfig> {
    private static final SdkField<String> REPOSITORY_ACCESS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryAccessMode").getter(getter(ImageConfig::repositoryAccessModeAsString))
            .setter(setter(Builder::repositoryAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAccessMode").build())
            .build();

    private static final SdkField<RepositoryAuthConfig> REPOSITORY_AUTH_CONFIG_FIELD = SdkField
            .<RepositoryAuthConfig> builder(MarshallingType.SDK_POJO).memberName("RepositoryAuthConfig")
            .getter(getter(ImageConfig::repositoryAuthConfig)).setter(setter(Builder::repositoryAuthConfig))
            .constructor(RepositoryAuthConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAuthConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ACCESS_MODE_FIELD,
            REPOSITORY_AUTH_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryAccessMode;

    private final RepositoryAuthConfig repositoryAuthConfig;

    private ImageConfig(BuilderImpl builder) {
        this.repositoryAccessMode = builder.repositoryAccessMode;
        this.repositoryAuthConfig = builder.repositoryAuthConfig;
    }

    /**
     * <p>
     * Set this to one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Platform</code> - The model image is hosted in Amazon ECR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryAccessMode} will return {@link RepositoryAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #repositoryAccessModeAsString}.
     * </p>
     * 
     * @return Set this to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Platform</code> - The model image is hosted in Amazon ECR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
     *         </p>
     *         </li>
     * @see RepositoryAccessMode
     */
    public final RepositoryAccessMode repositoryAccessMode() {
        return RepositoryAccessMode.fromValue(repositoryAccessMode);
    }

    /**
     * <p>
     * Set this to one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Platform</code> - The model image is hosted in Amazon ECR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryAccessMode} will return {@link RepositoryAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #repositoryAccessModeAsString}.
     * </p>
     * 
     * @return Set this to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Platform</code> - The model image is hosted in Amazon ECR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
     *         </p>
     *         </li>
     * @see RepositoryAccessMode
     */
    public final String repositoryAccessModeAsString() {
        return repositoryAccessMode;
    }

    /**
     * <p>
     * (Optional) Specifies an authentication configuration for the private docker registry where your model image is
     * hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the
     * <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image is hosted requires
     * authentication.
     * </p>
     * 
     * @return (Optional) Specifies an authentication configuration for the private docker registry where your model
     *         image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value
     *         for the <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image is
     *         hosted requires authentication.
     */
    public final RepositoryAuthConfig repositoryAuthConfig() {
        return repositoryAuthConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryAuthConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfig)) {
            return false;
        }
        ImageConfig other = (ImageConfig) obj;
        return Objects.equals(repositoryAccessModeAsString(), other.repositoryAccessModeAsString())
                && Objects.equals(repositoryAuthConfig(), other.repositoryAuthConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageConfig").add("RepositoryAccessMode", repositoryAccessModeAsString())
                .add("RepositoryAuthConfig", repositoryAuthConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryAccessMode":
            return Optional.ofNullable(clazz.cast(repositoryAccessModeAsString()));
        case "RepositoryAuthConfig":
            return Optional.ofNullable(clazz.cast(repositoryAuthConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageConfig, T> g) {
        return obj -> g.apply((ImageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageConfig> {
        /**
         * <p>
         * Set this to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Platform</code> - The model image is hosted in Amazon ECR.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
         * </p>
         * </li>
         * </ul>
         * 
         * @param repositoryAccessMode
         *        Set this to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Platform</code> - The model image is hosted in Amazon ECR.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
         *        </p>
         *        </li>
         * @see RepositoryAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryAccessMode
         */
        Builder repositoryAccessMode(String repositoryAccessMode);

        /**
         * <p>
         * Set this to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Platform</code> - The model image is hosted in Amazon ECR.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
         * </p>
         * </li>
         * </ul>
         * 
         * @param repositoryAccessMode
         *        Set this to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Platform</code> - The model image is hosted in Amazon ECR.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.
         *        </p>
         *        </li>
         * @see RepositoryAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryAccessMode
         */
        Builder repositoryAccessMode(RepositoryAccessMode repositoryAccessMode);

        /**
         * <p>
         * (Optional) Specifies an authentication configuration for the private docker registry where your model image
         * is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the
         * <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image is hosted
         * requires authentication.
         * </p>
         * 
         * @param repositoryAuthConfig
         *        (Optional) Specifies an authentication configuration for the private docker registry where your model
         *        image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value
         *        for the <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image
         *        is hosted requires authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryAuthConfig(RepositoryAuthConfig repositoryAuthConfig);

        /**
         * <p>
         * (Optional) Specifies an authentication configuration for the private docker registry where your model image
         * is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the
         * <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image is hosted
         * requires authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryAuthConfig.Builder} avoiding
         * the need to create one manually via {@link RepositoryAuthConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryAuthConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #repositoryAuthConfig(RepositoryAuthConfig)}.
         * 
         * @param repositoryAuthConfig
         *        a consumer that will call methods on {@link RepositoryAuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryAuthConfig(RepositoryAuthConfig)
         */
        default Builder repositoryAuthConfig(Consumer<RepositoryAuthConfig.Builder> repositoryAuthConfig) {
            return repositoryAuthConfig(RepositoryAuthConfig.builder().applyMutation(repositoryAuthConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String repositoryAccessMode;

        private RepositoryAuthConfig repositoryAuthConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfig model) {
            repositoryAccessMode(model.repositoryAccessMode);
            repositoryAuthConfig(model.repositoryAuthConfig);
        }

        public final String getRepositoryAccessMode() {
            return repositoryAccessMode;
        }

        public final void setRepositoryAccessMode(String repositoryAccessMode) {
            this.repositoryAccessMode = repositoryAccessMode;
        }

        @Override
        public final Builder repositoryAccessMode(String repositoryAccessMode) {
            this.repositoryAccessMode = repositoryAccessMode;
            return this;
        }

        @Override
        public final Builder repositoryAccessMode(RepositoryAccessMode repositoryAccessMode) {
            this.repositoryAccessMode(repositoryAccessMode == null ? null : repositoryAccessMode.toString());
            return this;
        }

        public final RepositoryAuthConfig.Builder getRepositoryAuthConfig() {
            return repositoryAuthConfig != null ? repositoryAuthConfig.toBuilder() : null;
        }

        public final void setRepositoryAuthConfig(RepositoryAuthConfig.BuilderImpl repositoryAuthConfig) {
            this.repositoryAuthConfig = repositoryAuthConfig != null ? repositoryAuthConfig.build() : null;
        }

        @Override
        public final Builder repositoryAuthConfig(RepositoryAuthConfig repositoryAuthConfig) {
            this.repositoryAuthConfig = repositoryAuthConfig;
            return this;
        }

        @Override
        public ImageConfig build() {
            return new ImageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
