/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of recommendations made by Amazon SageMaker Inference Recommender.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceRecommendation.Builder, InferenceRecommendation> {
    private static final SdkField<RecommendationMetrics> METRICS_FIELD = SdkField
            .<RecommendationMetrics> builder(MarshallingType.SDK_POJO).memberName("Metrics")
            .getter(getter(InferenceRecommendation::metrics)).setter(setter(Builder::metrics))
            .constructor(RecommendationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()).build();

    private static final SdkField<EndpointOutputConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<EndpointOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("EndpointConfiguration")
            .getter(getter(InferenceRecommendation::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(EndpointOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build())
            .build();

    private static final SdkField<ModelConfiguration> MODEL_CONFIGURATION_FIELD = SdkField
            .<ModelConfiguration> builder(MarshallingType.SDK_POJO).memberName("ModelConfiguration")
            .getter(getter(InferenceRecommendation::modelConfiguration)).setter(setter(Builder::modelConfiguration))
            .constructor(ModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD,
            ENDPOINT_CONFIGURATION_FIELD, MODEL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final RecommendationMetrics metrics;

    private final EndpointOutputConfiguration endpointConfiguration;

    private final ModelConfiguration modelConfiguration;

    private InferenceRecommendation(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.modelConfiguration = builder.modelConfiguration;
    }

    /**
     * <p>
     * The metrics used to decide what recommendation to make.
     * </p>
     * 
     * @return The metrics used to decide what recommendation to make.
     */
    public final RecommendationMetrics metrics() {
        return metrics;
    }

    /**
     * <p>
     * Defines the endpoint configuration parameters.
     * </p>
     * 
     * @return Defines the endpoint configuration parameters.
     */
    public final EndpointOutputConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    /**
     * <p>
     * Defines the model configuration.
     * </p>
     * 
     * @return Defines the model configuration.
     */
    public final ModelConfiguration modelConfiguration() {
        return modelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceRecommendation)) {
            return false;
        }
        InferenceRecommendation other = (InferenceRecommendation) obj;
        return Objects.equals(metrics(), other.metrics())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration())
                && Objects.equals(modelConfiguration(), other.modelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceRecommendation").add("Metrics", metrics())
                .add("EndpointConfiguration", endpointConfiguration()).add("ModelConfiguration", modelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "EndpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        case "ModelConfiguration":
            return Optional.ofNullable(clazz.cast(modelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceRecommendation, T> g) {
        return obj -> g.apply((InferenceRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceRecommendation> {
        /**
         * <p>
         * The metrics used to decide what recommendation to make.
         * </p>
         * 
         * @param metrics
         *        The metrics used to decide what recommendation to make.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(RecommendationMetrics metrics);

        /**
         * <p>
         * The metrics used to decide what recommendation to make.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationMetrics.Builder} avoiding
         * the need to create one manually via {@link RecommendationMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommendationMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #metrics(RecommendationMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link RecommendationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(RecommendationMetrics)
         */
        default Builder metrics(Consumer<RecommendationMetrics.Builder> metrics) {
            return metrics(RecommendationMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * <p>
         * Defines the endpoint configuration parameters.
         * </p>
         * 
         * @param endpointConfiguration
         *        Defines the endpoint configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(EndpointOutputConfiguration endpointConfiguration);

        /**
         * <p>
         * Defines the endpoint configuration parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link EndpointOutputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointConfiguration(EndpointOutputConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link EndpointOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(EndpointOutputConfiguration)
         */
        default Builder endpointConfiguration(Consumer<EndpointOutputConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(EndpointOutputConfiguration.builder().applyMutation(endpointConfiguration).build());
        }

        /**
         * <p>
         * Defines the model configuration.
         * </p>
         * 
         * @param modelConfiguration
         *        Defines the model configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfiguration(ModelConfiguration modelConfiguration);

        /**
         * <p>
         * Defines the model configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelConfiguration.Builder} avoiding the
         * need to create one manually via {@link ModelConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #modelConfiguration(ModelConfiguration)}.
         * 
         * @param modelConfiguration
         *        a consumer that will call methods on {@link ModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelConfiguration(ModelConfiguration)
         */
        default Builder modelConfiguration(Consumer<ModelConfiguration.Builder> modelConfiguration) {
            return modelConfiguration(ModelConfiguration.builder().applyMutation(modelConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RecommendationMetrics metrics;

        private EndpointOutputConfiguration endpointConfiguration;

        private ModelConfiguration modelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceRecommendation model) {
            metrics(model.metrics);
            endpointConfiguration(model.endpointConfiguration);
            modelConfiguration(model.modelConfiguration);
        }

        public final RecommendationMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(RecommendationMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(RecommendationMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final EndpointOutputConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointOutputConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointOutputConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final ModelConfiguration.Builder getModelConfiguration() {
            return modelConfiguration != null ? modelConfiguration.toBuilder() : null;
        }

        public final void setModelConfiguration(ModelConfiguration.BuilderImpl modelConfiguration) {
            this.modelConfiguration = modelConfiguration != null ? modelConfiguration.build() : null;
        }

        @Override
        public final Builder modelConfiguration(ModelConfiguration modelConfiguration) {
            this.modelConfiguration = modelConfiguration;
            return this;
        }

        @Override
        public InferenceRecommendation build() {
            return new InferenceRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
