/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStageDevicesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListStageDevicesResponse.Builder, ListStageDevicesResponse> {
    private static final SdkField<List<DeviceDeploymentSummary>> DEVICE_DEPLOYMENT_SUMMARIES_FIELD = SdkField
            .<List<DeviceDeploymentSummary>> builder(MarshallingType.LIST)
            .memberName("DeviceDeploymentSummaries")
            .getter(getter(ListStageDevicesResponse::deviceDeploymentSummaries))
            .setter(setter(Builder::deviceDeploymentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDeploymentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceDeploymentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceDeploymentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStageDevicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEVICE_DEPLOYMENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<DeviceDeploymentSummary> deviceDeploymentSummaries;

    private final String nextToken;

    private ListStageDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceDeploymentSummaries = builder.deviceDeploymentSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceDeploymentSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeviceDeploymentSummaries() {
        return deviceDeploymentSummaries != null && !(deviceDeploymentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of summaries of devices allocated to the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceDeploymentSummaries} method.
     * </p>
     * 
     * @return List of summaries of devices allocated to the stage.
     */
    public final List<DeviceDeploymentSummary> deviceDeploymentSummaries() {
        return deviceDeploymentSummaries;
    }

    /**
     * <p>
     * The token to use when calling the next page of results.
     * </p>
     * 
     * @return The token to use when calling the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceDeploymentSummaries() ? deviceDeploymentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStageDevicesResponse)) {
            return false;
        }
        ListStageDevicesResponse other = (ListStageDevicesResponse) obj;
        return hasDeviceDeploymentSummaries() == other.hasDeviceDeploymentSummaries()
                && Objects.equals(deviceDeploymentSummaries(), other.deviceDeploymentSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStageDevicesResponse")
                .add("DeviceDeploymentSummaries", hasDeviceDeploymentSummaries() ? deviceDeploymentSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceDeploymentSummaries":
            return Optional.ofNullable(clazz.cast(deviceDeploymentSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStageDevicesResponse, T> g) {
        return obj -> g.apply((ListStageDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStageDevicesResponse> {
        /**
         * <p>
         * List of summaries of devices allocated to the stage.
         * </p>
         * 
         * @param deviceDeploymentSummaries
         *        List of summaries of devices allocated to the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDeploymentSummaries(Collection<DeviceDeploymentSummary> deviceDeploymentSummaries);

        /**
         * <p>
         * List of summaries of devices allocated to the stage.
         * </p>
         * 
         * @param deviceDeploymentSummaries
         *        List of summaries of devices allocated to the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDeploymentSummaries(DeviceDeploymentSummary... deviceDeploymentSummaries);

        /**
         * <p>
         * List of summaries of devices allocated to the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DeviceDeploymentSummary>.Builder}
         * avoiding the need to create one manually via {@link List<DeviceDeploymentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceDeploymentSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceDeploymentSummaries(List<DeviceDeploymentSummary>)}.
         * 
         * @param deviceDeploymentSummaries
         *        a consumer that will call methods on {@link List<DeviceDeploymentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceDeploymentSummaries(List<DeviceDeploymentSummary>)
         */
        Builder deviceDeploymentSummaries(Consumer<DeviceDeploymentSummary.Builder>... deviceDeploymentSummaries);

        /**
         * <p>
         * The token to use when calling the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use when calling the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<DeviceDeploymentSummary> deviceDeploymentSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStageDevicesResponse model) {
            super(model);
            deviceDeploymentSummaries(model.deviceDeploymentSummaries);
            nextToken(model.nextToken);
        }

        public final List<DeviceDeploymentSummary.Builder> getDeviceDeploymentSummaries() {
            List<DeviceDeploymentSummary.Builder> result = DeviceDeploymentSummariesCopier
                    .copyToBuilder(this.deviceDeploymentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceDeploymentSummaries(Collection<DeviceDeploymentSummary.BuilderImpl> deviceDeploymentSummaries) {
            this.deviceDeploymentSummaries = DeviceDeploymentSummariesCopier.copyFromBuilder(deviceDeploymentSummaries);
        }

        @Override
        public final Builder deviceDeploymentSummaries(Collection<DeviceDeploymentSummary> deviceDeploymentSummaries) {
            this.deviceDeploymentSummaries = DeviceDeploymentSummariesCopier.copy(deviceDeploymentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceDeploymentSummaries(DeviceDeploymentSummary... deviceDeploymentSummaries) {
            deviceDeploymentSummaries(Arrays.asList(deviceDeploymentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceDeploymentSummaries(Consumer<DeviceDeploymentSummary.Builder>... deviceDeploymentSummaries) {
            deviceDeploymentSummaries(Stream.of(deviceDeploymentSummaries)
                    .map(c -> DeviceDeploymentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStageDevicesResponse build() {
            return new ListStageDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
