/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelineParametersForExecutionRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListPipelineParametersForExecutionRequest.Builder, ListPipelineParametersForExecutionRequest> {
    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionArn").getter(getter(ListPipelineParametersForExecutionRequest::pipelineExecutionArn))
            .setter(setter(Builder::pipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipelineParametersForExecutionRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPipelineParametersForExecutionRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String pipelineExecutionArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListPipelineParametersForExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline execution.
     */
    public final String pipelineExecutionArn() {
        return pipelineExecutionArn;
    }

    /**
     * <p>
     * If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the
     *         response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the
     *         next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of parameters to return in the response.
     * </p>
     * 
     * @return The maximum number of parameters to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineParametersForExecutionRequest)) {
            return false;
        }
        ListPipelineParametersForExecutionRequest other = (ListPipelineParametersForExecutionRequest) obj;
        return Objects.equals(pipelineExecutionArn(), other.pipelineExecutionArn())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelineParametersForExecutionRequest").add("PipelineExecutionArn", pipelineExecutionArn())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(pipelineExecutionArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineParametersForExecutionRequest, T> g) {
        return obj -> g.apply((ListPipelineParametersForExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPipelineParametersForExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionArn
         *        The Amazon Resource Name (ARN) of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionArn(String pipelineExecutionArn);

        /**
         * <p>
         * If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the
         * response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated,
         *        the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token
         *        in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of parameters to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of parameters to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineExecutionArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineParametersForExecutionRequest model) {
            super(model);
            pipelineExecutionArn(model.pipelineExecutionArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPipelineExecutionArn() {
            return pipelineExecutionArn;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPipelineParametersForExecutionRequest build() {
            return new ListPipelineParametersForExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
