/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrialResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeTrialResponse.Builder, DescribeTrialResponse> {
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialName").getter(getter(DescribeTrialResponse::trialName)).setter(setter(Builder::trialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()).build();

    private static final SdkField<String> TRIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialArn").getter(getter(DescribeTrialResponse::trialArn)).setter(setter(Builder::trialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(DescribeTrialResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentName").getter(getter(DescribeTrialResponse::experimentName))
            .setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<TrialSource> SOURCE_FIELD = SdkField.<TrialSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(DescribeTrialResponse::source)).setter(setter(Builder::source))
            .constructor(TrialSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeTrialResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeTrialResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeTrialResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeTrialResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(DescribeTrialResponse::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_NAME_FIELD,
            TRIAL_ARN_FIELD, DISPLAY_NAME_FIELD, EXPERIMENT_NAME_FIELD, SOURCE_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, METADATA_PROPERTIES_FIELD));

    private final String trialName;

    private final String trialArn;

    private final String displayName;

    private final String experimentName;

    private final TrialSource source;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final MetadataProperties metadataProperties;

    private DescribeTrialResponse(BuilderImpl builder) {
        super(builder);
        this.trialName = builder.trialName;
        this.trialArn = builder.trialArn;
        this.displayName = builder.displayName;
        this.experimentName = builder.experimentName;
        this.source = builder.source;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.metadataProperties = builder.metadataProperties;
    }

    /**
     * <p>
     * The name of the trial.
     * </p>
     * 
     * @return The name of the trial.
     */
    public final String trialName() {
        return trialName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial.
     */
    public final String trialArn() {
        return trialArn;
    }

    /**
     * <p>
     * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
     * displayed.
     * </p>
     * 
     * @return The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code>
     *         is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The name of the experiment the trial is part of.
     * </p>
     * 
     * @return The name of the experiment the trial is part of.
     */
    public final String experimentName() {
        return experimentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source and, optionally, the job type.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source and, optionally, the job type.
     */
    public final TrialSource source() {
        return source;
    }

    /**
     * <p>
     * When the trial was created.
     * </p>
     * 
     * @return When the trial was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Who created the trial.
     * </p>
     * 
     * @return Who created the trial.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * When the trial was last modified.
     * </p>
     * 
     * @return When the trial was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Who last modified the trial.
     * </p>
     * 
     * @return Who last modified the trial.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trialName());
        hashCode = 31 * hashCode + Objects.hashCode(trialArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrialResponse)) {
            return false;
        }
        DescribeTrialResponse other = (DescribeTrialResponse) obj;
        return Objects.equals(trialName(), other.trialName()) && Objects.equals(trialArn(), other.trialArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(experimentName(), other.experimentName())
                && Objects.equals(source(), other.source()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(metadataProperties(), other.metadataProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrialResponse").add("TrialName", trialName()).add("TrialArn", trialArn())
                .add("DisplayName", displayName()).add("ExperimentName", experimentName()).add("Source", source())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("MetadataProperties", metadataProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialName":
            return Optional.ofNullable(clazz.cast(trialName()));
        case "TrialArn":
            return Optional.ofNullable(clazz.cast(trialArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrialResponse, T> g) {
        return obj -> g.apply((DescribeTrialResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrialResponse> {
        /**
         * <p>
         * The name of the trial.
         * </p>
         * 
         * @param trialName
         *        The name of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialName(String trialName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial.
         * </p>
         * 
         * @param trialArn
         *        The Amazon Resource Name (ARN) of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialArn(String trialArn);

        /**
         * <p>
         * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
         * displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the trial as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>TrialName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The name of the experiment the trial is part of.
         * </p>
         * 
         * @param experimentName
         *        The name of the experiment the trial is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source and, optionally, the job type.
         * </p>
         * 
         * @param source
         *        The Amazon Resource Name (ARN) of the source and, optionally, the job type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TrialSource source);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source and, optionally, the job type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrialSource.Builder} avoiding the need to
         * create one manually via {@link TrialSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(TrialSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TrialSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TrialSource)
         */
        default Builder source(Consumer<TrialSource.Builder> source) {
            return source(TrialSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * When the trial was created.
         * </p>
         * 
         * @param creationTime
         *        When the trial was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Who created the trial.
         * </p>
         * 
         * @param createdBy
         *        Who created the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * <p>
         * Who created the trial.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * When the trial was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the trial was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Who last modified the trial.
         * </p>
         * 
         * @param lastModifiedBy
         *        Who last modified the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * <p>
         * Who last modified the trial.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetadataProperties.Builder} avoiding the
         * need to create one manually via {@link MetadataProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trialName;

        private String trialArn;

        private String displayName;

        private String experimentName;

        private TrialSource source;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private MetadataProperties metadataProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrialResponse model) {
            super(model);
            trialName(model.trialName);
            trialArn(model.trialArn);
            displayName(model.displayName);
            experimentName(model.experimentName);
            source(model.source);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            metadataProperties(model.metadataProperties);
        }

        public final String getTrialName() {
            return trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getTrialArn() {
            return trialArn;
        }

        public final void setTrialArn(String trialArn) {
            this.trialArn = trialArn;
        }

        @Override
        public final Builder trialArn(String trialArn) {
            this.trialArn = trialArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getExperimentName() {
            return experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final TrialSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TrialSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TrialSource source) {
            this.source = source;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        @Override
        public DescribeTrialResponse build() {
            return new DescribeTrialResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
