/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEdgeDeploymentPlanResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeEdgeDeploymentPlanResponse.Builder, DescribeEdgeDeploymentPlanResponse> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanArn").getter(getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentPlanArn))
            .setter(setter(Builder::edgeDeploymentPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanArn").build())
            .build();

    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanName").getter(getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentPlanName))
            .setter(setter(Builder::edgeDeploymentPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build())
            .build();

    private static final SdkField<List<EdgeDeploymentModelConfig>> MODEL_CONFIGS_FIELD = SdkField
            .<List<EdgeDeploymentModelConfig>> builder(MarshallingType.LIST)
            .memberName("ModelConfigs")
            .getter(getter(DescribeEdgeDeploymentPlanResponse::modelConfigs))
            .setter(setter(Builder::modelConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgeDeploymentModelConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgeDeploymentModelConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(DescribeEdgeDeploymentPlanResponse::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_SUCCESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentSuccess").getter(getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentSuccess))
            .setter(setter(Builder::edgeDeploymentSuccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentSuccess").build())
            .build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentPending").getter(getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentPending))
            .setter(setter(Builder::edgeDeploymentPending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPending").build())
            .build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentFailed").getter(getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentFailed))
            .setter(setter(Builder::edgeDeploymentFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentFailed").build())
            .build();

    private static final SdkField<List<DeploymentStageStatusSummary>> STAGES_FIELD = SdkField
            .<List<DeploymentStageStatusSummary>> builder(MarshallingType.LIST)
            .memberName("Stages")
            .getter(getter(DescribeEdgeDeploymentPlanResponse::stages))
            .setter(setter(Builder::stages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentStageStatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentStageStatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEdgeDeploymentPlanResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeEdgeDeploymentPlanResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeEdgeDeploymentPlanResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EDGE_DEPLOYMENT_PLAN_ARN_FIELD, EDGE_DEPLOYMENT_PLAN_NAME_FIELD, MODEL_CONFIGS_FIELD, DEVICE_FLEET_NAME_FIELD,
            EDGE_DEPLOYMENT_SUCCESS_FIELD, EDGE_DEPLOYMENT_PENDING_FIELD, EDGE_DEPLOYMENT_FAILED_FIELD, STAGES_FIELD,
            NEXT_TOKEN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private final String edgeDeploymentPlanArn;

    private final String edgeDeploymentPlanName;

    private final List<EdgeDeploymentModelConfig> modelConfigs;

    private final String deviceFleetName;

    private final Integer edgeDeploymentSuccess;

    private final Integer edgeDeploymentPending;

    private final Integer edgeDeploymentFailed;

    private final List<DeploymentStageStatusSummary> stages;

    private final String nextToken;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private DescribeEdgeDeploymentPlanResponse(BuilderImpl builder) {
        super(builder);
        this.edgeDeploymentPlanArn = builder.edgeDeploymentPlanArn;
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.modelConfigs = builder.modelConfigs;
        this.deviceFleetName = builder.deviceFleetName;
        this.edgeDeploymentSuccess = builder.edgeDeploymentSuccess;
        this.edgeDeploymentPending = builder.edgeDeploymentPending;
        this.edgeDeploymentFailed = builder.edgeDeploymentFailed;
        this.stages = builder.stages;
        this.nextToken = builder.nextToken;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of edge deployment plan.
     * </p>
     * 
     * @return The ARN of edge deployment plan.
     */
    public final String edgeDeploymentPlanArn() {
        return edgeDeploymentPlanArn;
    }

    /**
     * <p>
     * The name of the edge deployment plan.
     * </p>
     * 
     * @return The name of the edge deployment plan.
     */
    public final String edgeDeploymentPlanName() {
        return edgeDeploymentPlanName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelConfigs() {
        return modelConfigs != null && !(modelConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of models associated with the edge deployment plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelConfigs} method.
     * </p>
     * 
     * @return List of models associated with the edge deployment plan.
     */
    public final List<EdgeDeploymentModelConfig> modelConfigs() {
        return modelConfigs;
    }

    /**
     * <p>
     * The device fleet used for this edge deployment plan.
     * </p>
     * 
     * @return The device fleet used for this edge deployment plan.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The number of edge devices with the successful deployment.
     * </p>
     * 
     * @return The number of edge devices with the successful deployment.
     */
    public final Integer edgeDeploymentSuccess() {
        return edgeDeploymentSuccess;
    }

    /**
     * <p>
     * The number of edge devices yet to pick up deployment, or in progress.
     * </p>
     * 
     * @return The number of edge devices yet to pick up deployment, or in progress.
     */
    public final Integer edgeDeploymentPending() {
        return edgeDeploymentPending;
    }

    /**
     * <p>
     * The number of edge devices that failed the deployment.
     * </p>
     * 
     * @return The number of edge devices that failed the deployment.
     */
    public final Integer edgeDeploymentFailed() {
        return edgeDeploymentFailed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Stages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStages() {
        return stages != null && !(stages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of stages in the edge deployment plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStages} method.
     * </p>
     * 
     * @return List of stages in the edge deployment plan.
     */
    public final List<DeploymentStageStatusSummary> stages() {
        return stages;
    }

    /**
     * <p>
     * Token to use when calling the next set of stages in the edge deployment plan.
     * </p>
     * 
     * @return Token to use when calling the next set of stages in the edge deployment plan.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The time when the edge deployment plan was created.
     * </p>
     * 
     * @return The time when the edge deployment plan was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the edge deployment plan was last updated.
     * </p>
     * 
     * @return The time when the edge deployment plan was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelConfigs() ? modelConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPending());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentFailed());
        hashCode = 31 * hashCode + Objects.hashCode(hasStages() ? stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEdgeDeploymentPlanResponse)) {
            return false;
        }
        DescribeEdgeDeploymentPlanResponse other = (DescribeEdgeDeploymentPlanResponse) obj;
        return Objects.equals(edgeDeploymentPlanArn(), other.edgeDeploymentPlanArn())
                && Objects.equals(edgeDeploymentPlanName(), other.edgeDeploymentPlanName())
                && hasModelConfigs() == other.hasModelConfigs() && Objects.equals(modelConfigs(), other.modelConfigs())
                && Objects.equals(deviceFleetName(), other.deviceFleetName())
                && Objects.equals(edgeDeploymentSuccess(), other.edgeDeploymentSuccess())
                && Objects.equals(edgeDeploymentPending(), other.edgeDeploymentPending())
                && Objects.equals(edgeDeploymentFailed(), other.edgeDeploymentFailed()) && hasStages() == other.hasStages()
                && Objects.equals(stages(), other.stages()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEdgeDeploymentPlanResponse").add("EdgeDeploymentPlanArn", edgeDeploymentPlanArn())
                .add("EdgeDeploymentPlanName", edgeDeploymentPlanName())
                .add("ModelConfigs", hasModelConfigs() ? modelConfigs() : null).add("DeviceFleetName", deviceFleetName())
                .add("EdgeDeploymentSuccess", edgeDeploymentSuccess()).add("EdgeDeploymentPending", edgeDeploymentPending())
                .add("EdgeDeploymentFailed", edgeDeploymentFailed()).add("Stages", hasStages() ? stages() : null)
                .add("NextToken", nextToken()).add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeDeploymentPlanArn":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanArn()));
        case "EdgeDeploymentPlanName":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanName()));
        case "ModelConfigs":
            return Optional.ofNullable(clazz.cast(modelConfigs()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "EdgeDeploymentSuccess":
            return Optional.ofNullable(clazz.cast(edgeDeploymentSuccess()));
        case "EdgeDeploymentPending":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPending()));
        case "EdgeDeploymentFailed":
            return Optional.ofNullable(clazz.cast(edgeDeploymentFailed()));
        case "Stages":
            return Optional.ofNullable(clazz.cast(stages()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEdgeDeploymentPlanResponse, T> g) {
        return obj -> g.apply((DescribeEdgeDeploymentPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEdgeDeploymentPlanResponse> {
        /**
         * <p>
         * The ARN of edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanArn
         *        The ARN of edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn);

        /**
         * <p>
         * The name of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanName
         *        The name of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanName(String edgeDeploymentPlanName);

        /**
         * <p>
         * List of models associated with the edge deployment plan.
         * </p>
         * 
         * @param modelConfigs
         *        List of models associated with the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfigs(Collection<EdgeDeploymentModelConfig> modelConfigs);

        /**
         * <p>
         * List of models associated with the edge deployment plan.
         * </p>
         * 
         * @param modelConfigs
         *        List of models associated with the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfigs(EdgeDeploymentModelConfig... modelConfigs);

        /**
         * <p>
         * List of models associated with the edge deployment plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EdgeDeploymentModelConfig>.Builder}
         * avoiding the need to create one manually via {@link List<EdgeDeploymentModelConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EdgeDeploymentModelConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #modelConfigs(List<EdgeDeploymentModelConfig>)}.
         * 
         * @param modelConfigs
         *        a consumer that will call methods on {@link List<EdgeDeploymentModelConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelConfigs(List<EdgeDeploymentModelConfig>)
         */
        Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder>... modelConfigs);

        /**
         * <p>
         * The device fleet used for this edge deployment plan.
         * </p>
         * 
         * @param deviceFleetName
         *        The device fleet used for this edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The number of edge devices with the successful deployment.
         * </p>
         * 
         * @param edgeDeploymentSuccess
         *        The number of edge devices with the successful deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentSuccess(Integer edgeDeploymentSuccess);

        /**
         * <p>
         * The number of edge devices yet to pick up deployment, or in progress.
         * </p>
         * 
         * @param edgeDeploymentPending
         *        The number of edge devices yet to pick up deployment, or in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPending(Integer edgeDeploymentPending);

        /**
         * <p>
         * The number of edge devices that failed the deployment.
         * </p>
         * 
         * @param edgeDeploymentFailed
         *        The number of edge devices that failed the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentFailed(Integer edgeDeploymentFailed);

        /**
         * <p>
         * List of stages in the edge deployment plan.
         * </p>
         * 
         * @param stages
         *        List of stages in the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Collection<DeploymentStageStatusSummary> stages);

        /**
         * <p>
         * List of stages in the edge deployment plan.
         * </p>
         * 
         * @param stages
         *        List of stages in the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(DeploymentStageStatusSummary... stages);

        /**
         * <p>
         * List of stages in the edge deployment plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <DeploymentStageStatusSummary>.Builder} avoiding the need to create one manually via {@link List
         * <DeploymentStageStatusSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentStageStatusSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #stages(List<DeploymentStageStatusSummary>)}.
         * 
         * @param stages
         *        a consumer that will call methods on {@link List<DeploymentStageStatusSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stages(List<DeploymentStageStatusSummary>)
         */
        Builder stages(Consumer<DeploymentStageStatusSummary.Builder>... stages);

        /**
         * <p>
         * Token to use when calling the next set of stages in the edge deployment plan.
         * </p>
         * 
         * @param nextToken
         *        Token to use when calling the next set of stages in the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The time when the edge deployment plan was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the edge deployment plan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the edge deployment plan was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the edge deployment plan was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String edgeDeploymentPlanArn;

        private String edgeDeploymentPlanName;

        private List<EdgeDeploymentModelConfig> modelConfigs = DefaultSdkAutoConstructList.getInstance();

        private String deviceFleetName;

        private Integer edgeDeploymentSuccess;

        private Integer edgeDeploymentPending;

        private Integer edgeDeploymentFailed;

        private List<DeploymentStageStatusSummary> stages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEdgeDeploymentPlanResponse model) {
            super(model);
            edgeDeploymentPlanArn(model.edgeDeploymentPlanArn);
            edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            modelConfigs(model.modelConfigs);
            deviceFleetName(model.deviceFleetName);
            edgeDeploymentSuccess(model.edgeDeploymentSuccess);
            edgeDeploymentPending(model.edgeDeploymentPending);
            edgeDeploymentFailed(model.edgeDeploymentFailed);
            stages(model.stages);
            nextToken(model.nextToken);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getEdgeDeploymentPlanArn() {
            return edgeDeploymentPlanArn;
        }

        public final void setEdgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
        }

        @Override
        public final Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
            return this;
        }

        public final String getEdgeDeploymentPlanName() {
            return edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final List<EdgeDeploymentModelConfig.Builder> getModelConfigs() {
            List<EdgeDeploymentModelConfig.Builder> result = EdgeDeploymentModelConfigsCopier.copyToBuilder(this.modelConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelConfigs(Collection<EdgeDeploymentModelConfig.BuilderImpl> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copyFromBuilder(modelConfigs);
        }

        @Override
        public final Builder modelConfigs(Collection<EdgeDeploymentModelConfig> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copy(modelConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(EdgeDeploymentModelConfig... modelConfigs) {
            modelConfigs(Arrays.asList(modelConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder>... modelConfigs) {
            modelConfigs(Stream.of(modelConfigs).map(c -> EdgeDeploymentModelConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final Integer getEdgeDeploymentSuccess() {
            return edgeDeploymentSuccess;
        }

        public final void setEdgeDeploymentSuccess(Integer edgeDeploymentSuccess) {
            this.edgeDeploymentSuccess = edgeDeploymentSuccess;
        }

        @Override
        public final Builder edgeDeploymentSuccess(Integer edgeDeploymentSuccess) {
            this.edgeDeploymentSuccess = edgeDeploymentSuccess;
            return this;
        }

        public final Integer getEdgeDeploymentPending() {
            return edgeDeploymentPending;
        }

        public final void setEdgeDeploymentPending(Integer edgeDeploymentPending) {
            this.edgeDeploymentPending = edgeDeploymentPending;
        }

        @Override
        public final Builder edgeDeploymentPending(Integer edgeDeploymentPending) {
            this.edgeDeploymentPending = edgeDeploymentPending;
            return this;
        }

        public final Integer getEdgeDeploymentFailed() {
            return edgeDeploymentFailed;
        }

        public final void setEdgeDeploymentFailed(Integer edgeDeploymentFailed) {
            this.edgeDeploymentFailed = edgeDeploymentFailed;
        }

        @Override
        public final Builder edgeDeploymentFailed(Integer edgeDeploymentFailed) {
            this.edgeDeploymentFailed = edgeDeploymentFailed;
            return this;
        }

        public final List<DeploymentStageStatusSummary.Builder> getStages() {
            List<DeploymentStageStatusSummary.Builder> result = DeploymentStageStatusSummariesCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<DeploymentStageStatusSummary.BuilderImpl> stages) {
            this.stages = DeploymentStageStatusSummariesCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<DeploymentStageStatusSummary> stages) {
            this.stages = DeploymentStageStatusSummariesCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(DeploymentStageStatusSummary... stages) {
            stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<DeploymentStageStatusSummary.Builder>... stages) {
            stages(Stream.of(stages).map(c -> DeploymentStageStatusSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeEdgeDeploymentPlanResponse build() {
            return new DescribeEdgeDeploymentPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
