/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of an AutoML candidate job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CandidateProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CandidateProperties.Builder, CandidateProperties> {
    private static final SdkField<CandidateArtifactLocations> CANDIDATE_ARTIFACT_LOCATIONS_FIELD = SdkField
            .<CandidateArtifactLocations> builder(MarshallingType.SDK_POJO)
            .memberName("CandidateArtifactLocations")
            .getter(getter(CandidateProperties::candidateArtifactLocations))
            .setter(setter(Builder::candidateArtifactLocations))
            .constructor(CandidateArtifactLocations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateArtifactLocations").build())
            .build();

    private static final SdkField<List<MetricDatum>> CANDIDATE_METRICS_FIELD = SdkField
            .<List<MetricDatum>> builder(MarshallingType.LIST)
            .memberName("CandidateMetrics")
            .getter(getter(CandidateProperties::candidateMetrics))
            .setter(setter(Builder::candidateMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDatum> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDatum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CANDIDATE_ARTIFACT_LOCATIONS_FIELD, CANDIDATE_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CandidateArtifactLocations candidateArtifactLocations;

    private final List<MetricDatum> candidateMetrics;

    private CandidateProperties(BuilderImpl builder) {
        this.candidateArtifactLocations = builder.candidateArtifactLocations;
        this.candidateMetrics = builder.candidateMetrics;
    }

    /**
     * <p>
     * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     * </p>
     * 
     * @return The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     */
    public final CandidateArtifactLocations candidateArtifactLocations() {
        return candidateArtifactLocations;
    }

    /**
     * For responses, this returns true if the service returned a value for the CandidateMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCandidateMetrics() {
        return candidateMetrics != null && !(candidateMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the candidate metrics for an AutoML job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCandidateMetrics} method.
     * </p>
     * 
     * @return Information about the candidate metrics for an AutoML job.
     */
    public final List<MetricDatum> candidateMetrics() {
        return candidateMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(candidateArtifactLocations());
        hashCode = 31 * hashCode + Objects.hashCode(hasCandidateMetrics() ? candidateMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateProperties)) {
            return false;
        }
        CandidateProperties other = (CandidateProperties) obj;
        return Objects.equals(candidateArtifactLocations(), other.candidateArtifactLocations())
                && hasCandidateMetrics() == other.hasCandidateMetrics()
                && Objects.equals(candidateMetrics(), other.candidateMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CandidateProperties").add("CandidateArtifactLocations", candidateArtifactLocations())
                .add("CandidateMetrics", hasCandidateMetrics() ? candidateMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CandidateArtifactLocations":
            return Optional.ofNullable(clazz.cast(candidateArtifactLocations()));
        case "CandidateMetrics":
            return Optional.ofNullable(clazz.cast(candidateMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CandidateProperties, T> g) {
        return obj -> g.apply((CandidateProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CandidateProperties> {
        /**
         * <p>
         * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
         * </p>
         * 
         * @param candidateArtifactLocations
         *        The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations);

        /**
         * <p>
         * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
         * </p>
         * This is a convenience method that creates an instance of the {@link CandidateArtifactLocations.Builder}
         * avoiding the need to create one manually via {@link CandidateArtifactLocations#builder()}.
         *
         * When the {@link Consumer} completes, {@link CandidateArtifactLocations.Builder#build()} is called immediately
         * and its result is passed to {@link #candidateArtifactLocations(CandidateArtifactLocations)}.
         * 
         * @param candidateArtifactLocations
         *        a consumer that will call methods on {@link CandidateArtifactLocations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateArtifactLocations(CandidateArtifactLocations)
         */
        default Builder candidateArtifactLocations(Consumer<CandidateArtifactLocations.Builder> candidateArtifactLocations) {
            return candidateArtifactLocations(CandidateArtifactLocations.builder().applyMutation(candidateArtifactLocations)
                    .build());
        }

        /**
         * <p>
         * Information about the candidate metrics for an AutoML job.
         * </p>
         * 
         * @param candidateMetrics
         *        Information about the candidate metrics for an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateMetrics(Collection<MetricDatum> candidateMetrics);

        /**
         * <p>
         * Information about the candidate metrics for an AutoML job.
         * </p>
         * 
         * @param candidateMetrics
         *        Information about the candidate metrics for an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateMetrics(MetricDatum... candidateMetrics);

        /**
         * <p>
         * Information about the candidate metrics for an AutoML job.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricDatum>.Builder} avoiding the
         * need to create one manually via {@link List<MetricDatum>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDatum>.Builder#build()} is called immediately and its
         * result is passed to {@link #candidateMetrics(List<MetricDatum>)}.
         * 
         * @param candidateMetrics
         *        a consumer that will call methods on {@link List<MetricDatum>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateMetrics(List<MetricDatum>)
         */
        Builder candidateMetrics(Consumer<MetricDatum.Builder>... candidateMetrics);
    }

    static final class BuilderImpl implements Builder {
        private CandidateArtifactLocations candidateArtifactLocations;

        private List<MetricDatum> candidateMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateProperties model) {
            candidateArtifactLocations(model.candidateArtifactLocations);
            candidateMetrics(model.candidateMetrics);
        }

        public final CandidateArtifactLocations.Builder getCandidateArtifactLocations() {
            return candidateArtifactLocations != null ? candidateArtifactLocations.toBuilder() : null;
        }

        public final void setCandidateArtifactLocations(CandidateArtifactLocations.BuilderImpl candidateArtifactLocations) {
            this.candidateArtifactLocations = candidateArtifactLocations != null ? candidateArtifactLocations.build() : null;
        }

        @Override
        public final Builder candidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations) {
            this.candidateArtifactLocations = candidateArtifactLocations;
            return this;
        }

        public final List<MetricDatum.Builder> getCandidateMetrics() {
            List<MetricDatum.Builder> result = MetricDataListCopier.copyToBuilder(this.candidateMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCandidateMetrics(Collection<MetricDatum.BuilderImpl> candidateMetrics) {
            this.candidateMetrics = MetricDataListCopier.copyFromBuilder(candidateMetrics);
        }

        @Override
        public final Builder candidateMetrics(Collection<MetricDatum> candidateMetrics) {
            this.candidateMetrics = MetricDataListCopier.copy(candidateMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateMetrics(MetricDatum... candidateMetrics) {
            candidateMetrics(Arrays.asList(candidateMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateMetrics(Consumer<MetricDatum.Builder>... candidateMetrics) {
            candidateMetrics(Stream.of(candidateMetrics).map(c -> MetricDatum.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CandidateProperties build() {
            return new CandidateProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
