/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImageVersionRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateImageVersionRequest.Builder, CreateImageVersionRequest> {
    private static final SdkField<String> BASE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseImage").getter(getter(CreateImageVersionRequest::baseImage)).setter(setter(Builder::baseImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImage").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateImageVersionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(CreateImageVersionRequest::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_IMAGE_FIELD,
            CLIENT_TOKEN_FIELD, IMAGE_NAME_FIELD));

    private final String baseImage;

    private final String clientToken;

    private final String imageName;

    private CreateImageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.baseImage = builder.baseImage;
        this.clientToken = builder.clientToken;
        this.imageName = builder.imageName;
    }

    /**
     * <p>
     * The registry path of the container image to use as the starting point for this version. The path is an Amazon
     * Elastic Container Registry (ECR) URI in the following format:
     * </p>
     * <p>
     * <code>&lt;acct-id&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com/&lt;repo-name[:tag] or [@digest]&gt;</code>
     * </p>
     * 
     * @return The registry path of the container image to use as the starting point for this version. The path is an
     *         Amazon Elastic Container Registry (ECR) URI in the following format:</p>
     *         <p>
     *         <code>&lt;acct-id&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com/&lt;repo-name[:tag] or [@digest]&gt;</code>
     */
    public final String baseImage() {
        return baseImage;
    }

    /**
     * <p>
     * A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for
     * Python (Boto3), add a unique value to the call.
     * </p>
     * 
     * @return A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK
     *         for Python (Boto3), add a unique value to the call.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The <code>ImageName</code> of the <code>Image</code> to create a version of.
     * </p>
     * 
     * @return The <code>ImageName</code> of the <code>Image</code> to create a version of.
     */
    public final String imageName() {
        return imageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baseImage());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageVersionRequest)) {
            return false;
        }
        CreateImageVersionRequest other = (CreateImageVersionRequest) obj;
        return Objects.equals(baseImage(), other.baseImage()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(imageName(), other.imageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateImageVersionRequest").add("BaseImage", baseImage()).add("ClientToken", clientToken())
                .add("ImageName", imageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseImage":
            return Optional.ofNullable(clazz.cast(baseImage()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageVersionRequest, T> g) {
        return obj -> g.apply((CreateImageVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateImageVersionRequest> {
        /**
         * <p>
         * The registry path of the container image to use as the starting point for this version. The path is an Amazon
         * Elastic Container Registry (ECR) URI in the following format:
         * </p>
         * <p>
         * <code>&lt;acct-id&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com/&lt;repo-name[:tag] or [@digest]&gt;</code>
         * </p>
         * 
         * @param baseImage
         *        The registry path of the container image to use as the starting point for this version. The path is an
         *        Amazon Elastic Container Registry (ECR) URI in the following format:</p>
         *        <p>
         *        <code>&lt;acct-id&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com/&lt;repo-name[:tag] or [@digest]&gt;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseImage(String baseImage);

        /**
         * <p>
         * A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for
         * Python (Boto3), add a unique value to the call.
         * </p>
         * 
         * @param clientToken
         *        A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the
         *        SDK for Python (Boto3), add a unique value to the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The <code>ImageName</code> of the <code>Image</code> to create a version of.
         * </p>
         * 
         * @param imageName
         *        The <code>ImageName</code> of the <code>Image</code> to create a version of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String baseImage;

        private String clientToken;

        private String imageName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageVersionRequest model) {
            super(model);
            baseImage(model.baseImage);
            clientToken(model.clientToken);
            imageName(model.imageName);
        }

        public final String getBaseImage() {
            return baseImage;
        }

        public final void setBaseImage(String baseImage) {
            this.baseImage = baseImage;
        }

        @Override
        public final Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageVersionRequest build() {
            return new CreateImageVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
