/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFeatureMetadataResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeFeatureMetadataResponse.Builder, DescribeFeatureMetadataResponse> {
    private static final SdkField<String> FEATURE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupArn").getter(getter(DescribeFeatureMetadataResponse::featureGroupArn))
            .setter(setter(Builder::featureGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupArn").build()).build();

    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(DescribeFeatureMetadataResponse::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureName").getter(getter(DescribeFeatureMetadataResponse::featureName))
            .setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()).build();

    private static final SdkField<String> FEATURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureType").getter(getter(DescribeFeatureMetadataResponse::featureTypeAsString))
            .setter(setter(Builder::featureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureType").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeFeatureMetadataResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeFeatureMetadataResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeFeatureMetadataResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<FeatureParameter>> PARAMETERS_FIELD = SdkField
            .<List<FeatureParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(DescribeFeatureMetadataResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_ARN_FIELD,
            FEATURE_GROUP_NAME_FIELD, FEATURE_NAME_FIELD, FEATURE_TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            DESCRIPTION_FIELD, PARAMETERS_FIELD));

    private final String featureGroupArn;

    private final String featureGroupName;

    private final String featureName;

    private final String featureType;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String description;

    private final List<FeatureParameter> parameters;

    private DescribeFeatureMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.featureGroupArn = builder.featureGroupArn;
        this.featureGroupName = builder.featureGroupName;
        this.featureName = builder.featureName;
        this.featureType = builder.featureType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the feature group that contains the feature.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the feature group that contains the feature.
     */
    public final String featureGroupArn() {
        return featureGroupArn;
    }

    /**
     * <p>
     * The name of the feature group that you've specified.
     * </p>
     * 
     * @return The name of the feature group that you've specified.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The name of the feature that you've specified.
     * </p>
     * 
     * @return The name of the feature that you've specified.
     */
    public final String featureName() {
        return featureName;
    }

    /**
     * <p>
     * The data type of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureType} will
     * return {@link FeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureTypeAsString}.
     * </p>
     * 
     * @return The data type of the feature.
     * @see FeatureType
     */
    public final FeatureType featureType() {
        return FeatureType.fromValue(featureType);
    }

    /**
     * <p>
     * The data type of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureType} will
     * return {@link FeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureTypeAsString}.
     * </p>
     * 
     * @return The data type of the feature.
     * @see FeatureType
     */
    public final String featureTypeAsString() {
        return featureType;
    }

    /**
     * <p>
     * A timestamp indicating when the feature was created.
     * </p>
     * 
     * @return A timestamp indicating when the feature was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp indicating when the metadata for the feature group was modified. For example, if you add a parameter
     * describing the feature, the timestamp changes to reflect the last time you
     * </p>
     * 
     * @return A timestamp indicating when the metadata for the feature group was modified. For example, if you add a
     *         parameter describing the feature, the timestamp changes to reflect the last time you
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The description you added to describe the feature.
     * </p>
     * 
     * @return The description you added to describe the feature.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pairs that you added to describe the feature.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The key-value pairs that you added to describe the feature.
     */
    public final List<FeatureParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(featureName());
        hashCode = 31 * hashCode + Objects.hashCode(featureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeatureMetadataResponse)) {
            return false;
        }
        DescribeFeatureMetadataResponse other = (DescribeFeatureMetadataResponse) obj;
        return Objects.equals(featureGroupArn(), other.featureGroupArn())
                && Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(featureName(), other.featureName())
                && Objects.equals(featureTypeAsString(), other.featureTypeAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(description(), other.description()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFeatureMetadataResponse").add("FeatureGroupArn", featureGroupArn())
                .add("FeatureGroupName", featureGroupName()).add("FeatureName", featureName())
                .add("FeatureType", featureTypeAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("Description", description())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupArn":
            return Optional.ofNullable(clazz.cast(featureGroupArn()));
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "FeatureName":
            return Optional.ofNullable(clazz.cast(featureName()));
        case "FeatureType":
            return Optional.ofNullable(clazz.cast(featureTypeAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeatureMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFeatureMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFeatureMetadataResponse> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the feature group that contains the feature.
         * </p>
         * 
         * @param featureGroupArn
         *        The Amazon Resource Number (ARN) of the feature group that contains the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupArn(String featureGroupArn);

        /**
         * <p>
         * The name of the feature group that you've specified.
         * </p>
         * 
         * @param featureGroupName
         *        The name of the feature group that you've specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The name of the feature that you've specified.
         * </p>
         * 
         * @param featureName
         *        The name of the feature that you've specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureName(String featureName);

        /**
         * <p>
         * The data type of the feature.
         * </p>
         * 
         * @param featureType
         *        The data type of the feature.
         * @see FeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureType
         */
        Builder featureType(String featureType);

        /**
         * <p>
         * The data type of the feature.
         * </p>
         * 
         * @param featureType
         *        The data type of the feature.
         * @see FeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureType
         */
        Builder featureType(FeatureType featureType);

        /**
         * <p>
         * A timestamp indicating when the feature was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp indicating when the feature was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp indicating when the metadata for the feature group was modified. For example, if you add a
         * parameter describing the feature, the timestamp changes to reflect the last time you
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp indicating when the metadata for the feature group was modified. For example, if you add a
         *        parameter describing the feature, the timestamp changes to reflect the last time you
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The description you added to describe the feature.
         * </p>
         * 
         * @param description
         *        The description you added to describe the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key-value pairs that you added to describe the feature.
         * </p>
         * 
         * @param parameters
         *        The key-value pairs that you added to describe the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<FeatureParameter> parameters);

        /**
         * <p>
         * The key-value pairs that you added to describe the feature.
         * </p>
         * 
         * @param parameters
         *        The key-value pairs that you added to describe the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(FeatureParameter... parameters);

        /**
         * <p>
         * The key-value pairs that you added to describe the feature.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FeatureParameter>.Builder} avoiding
         * the need to create one manually via {@link List<FeatureParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FeatureParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<FeatureParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<FeatureParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<FeatureParameter>)
         */
        Builder parameters(Consumer<FeatureParameter.Builder>... parameters);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String featureGroupArn;

        private String featureGroupName;

        private String featureName;

        private String featureType;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String description;

        private List<FeatureParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeatureMetadataResponse model) {
            super(model);
            featureGroupArn(model.featureGroupArn);
            featureGroupName(model.featureGroupName);
            featureName(model.featureName);
            featureType(model.featureType);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            description(model.description);
            parameters(model.parameters);
        }

        public final String getFeatureGroupArn() {
            return featureGroupArn;
        }

        public final void setFeatureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
        }

        @Override
        public final Builder featureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
            return this;
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getFeatureName() {
            return featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getFeatureType() {
            return featureType;
        }

        public final void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        @Override
        public final Builder featureType(String featureType) {
            this.featureType = featureType;
            return this;
        }

        @Override
        public final Builder featureType(FeatureType featureType) {
            this.featureType(featureType == null ? null : featureType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<FeatureParameter.Builder> getParameters() {
            List<FeatureParameter.Builder> result = FeatureParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<FeatureParameter.BuilderImpl> parameters) {
            this.parameters = FeatureParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<FeatureParameter> parameters) {
            this.parameters = FeatureParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(FeatureParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<FeatureParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> FeatureParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeFeatureMetadataResponse build() {
            return new DescribeFeatureMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
