/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceSummary implements SdkPojo, Serializable, ToCopyableBuilder<DeviceSummary.Builder, DeviceSummary> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(DeviceSummary::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceArn").getter(getter(DeviceSummary::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DeviceSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(DeviceSummary::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotThingName").getter(getter(DeviceSummary::iotThingName)).setter(setter(Builder::iotThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()).build();

    private static final SdkField<Instant> REGISTRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RegistrationTime").getter(getter(DeviceSummary::registrationTime))
            .setter(setter(Builder::registrationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationTime").build()).build();

    private static final SdkField<Instant> LATEST_HEARTBEAT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestHeartbeat").getter(getter(DeviceSummary::latestHeartbeat))
            .setter(setter(Builder::latestHeartbeat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestHeartbeat").build()).build();

    private static final SdkField<List<EdgeModelSummary>> MODELS_FIELD = SdkField
            .<List<EdgeModelSummary>> builder(MarshallingType.LIST)
            .memberName("Models")
            .getter(getter(DeviceSummary::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgeModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgeModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(DeviceSummary::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            DEVICE_ARN_FIELD, DESCRIPTION_FIELD, DEVICE_FLEET_NAME_FIELD, IOT_THING_NAME_FIELD, REGISTRATION_TIME_FIELD,
            LATEST_HEARTBEAT_FIELD, MODELS_FIELD, AGENT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String deviceArn;

    private final String description;

    private final String deviceFleetName;

    private final String iotThingName;

    private final Instant registrationTime;

    private final Instant latestHeartbeat;

    private final List<EdgeModelSummary> models;

    private final String agentVersion;

    private DeviceSummary(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.deviceArn = builder.deviceArn;
        this.description = builder.description;
        this.deviceFleetName = builder.deviceFleetName;
        this.iotThingName = builder.iotThingName;
        this.registrationTime = builder.registrationTime;
        this.latestHeartbeat = builder.latestHeartbeat;
        this.models = builder.models;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The unique identifier of the device.
     * </p>
     * 
     * @return The unique identifier of the device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the device.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the device.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * A description of the device.
     * </p>
     * 
     * @return A description of the device.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the fleet the device belongs to.
     * </p>
     * 
     * @return The name of the fleet the device belongs to.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The Amazon Web Services Internet of Things (IoT) object thing name associated with the device..
     * </p>
     * 
     * @return The Amazon Web Services Internet of Things (IoT) object thing name associated with the device..
     */
    public final String iotThingName() {
        return iotThingName;
    }

    /**
     * <p>
     * The timestamp of the last registration or de-reregistration.
     * </p>
     * 
     * @return The timestamp of the last registration or de-reregistration.
     */
    public final Instant registrationTime() {
        return registrationTime;
    }

    /**
     * <p>
     * The last heartbeat received from the device.
     * </p>
     * 
     * @return The last heartbeat received from the device.
     */
    public final Instant latestHeartbeat() {
        return latestHeartbeat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Models on the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return Models on the device.
     */
    public final List<EdgeModelSummary> models() {
        return models;
    }

    /**
     * <p>
     * Edge Manager agent version.
     * </p>
     * 
     * @return Edge Manager agent version.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(iotThingName());
        hashCode = 31 * hashCode + Objects.hashCode(registrationTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestHeartbeat());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(deviceFleetName(), other.deviceFleetName())
                && Objects.equals(iotThingName(), other.iotThingName())
                && Objects.equals(registrationTime(), other.registrationTime())
                && Objects.equals(latestHeartbeat(), other.latestHeartbeat()) && hasModels() == other.hasModels()
                && Objects.equals(models(), other.models()) && Objects.equals(agentVersion(), other.agentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceSummary").add("DeviceName", deviceName()).add("DeviceArn", deviceArn())
                .add("Description", description()).add("DeviceFleetName", deviceFleetName()).add("IotThingName", iotThingName())
                .add("RegistrationTime", registrationTime()).add("LatestHeartbeat", latestHeartbeat())
                .add("Models", hasModels() ? models() : null).add("AgentVersion", agentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "IotThingName":
            return Optional.ofNullable(clazz.cast(iotThingName()));
        case "RegistrationTime":
            return Optional.ofNullable(clazz.cast(registrationTime()));
        case "LatestHeartbeat":
            return Optional.ofNullable(clazz.cast(latestHeartbeat()));
        case "Models":
            return Optional.ofNullable(clazz.cast(models()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSummary, T> g) {
        return obj -> g.apply((DeviceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceSummary> {
        /**
         * <p>
         * The unique identifier of the device.
         * </p>
         * 
         * @param deviceName
         *        The unique identifier of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the device.
         * </p>
         * 
         * @param deviceArn
         *        Amazon Resource Name (ARN) of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * A description of the device.
         * </p>
         * 
         * @param description
         *        A description of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the fleet the device belongs to.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet the device belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The Amazon Web Services Internet of Things (IoT) object thing name associated with the device..
         * </p>
         * 
         * @param iotThingName
         *        The Amazon Web Services Internet of Things (IoT) object thing name associated with the device..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotThingName(String iotThingName);

        /**
         * <p>
         * The timestamp of the last registration or de-reregistration.
         * </p>
         * 
         * @param registrationTime
         *        The timestamp of the last registration or de-reregistration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationTime(Instant registrationTime);

        /**
         * <p>
         * The last heartbeat received from the device.
         * </p>
         * 
         * @param latestHeartbeat
         *        The last heartbeat received from the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestHeartbeat(Instant latestHeartbeat);

        /**
         * <p>
         * Models on the device.
         * </p>
         * 
         * @param models
         *        Models on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<EdgeModelSummary> models);

        /**
         * <p>
         * Models on the device.
         * </p>
         * 
         * @param models
         *        Models on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(EdgeModelSummary... models);

        /**
         * <p>
         * Models on the device.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EdgeModelSummary>.Builder} avoiding
         * the need to create one manually via {@link List<EdgeModelSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EdgeModelSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #models(List<EdgeModelSummary>)}.
         * 
         * @param models
         *        a consumer that will call methods on {@link List<EdgeModelSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(List<EdgeModelSummary>)
         */
        Builder models(Consumer<EdgeModelSummary.Builder>... models);

        /**
         * <p>
         * Edge Manager agent version.
         * </p>
         * 
         * @param agentVersion
         *        Edge Manager agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String deviceArn;

        private String description;

        private String deviceFleetName;

        private String iotThingName;

        private Instant registrationTime;

        private Instant latestHeartbeat;

        private List<EdgeModelSummary> models = DefaultSdkAutoConstructList.getInstance();

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSummary model) {
            deviceName(model.deviceName);
            deviceArn(model.deviceArn);
            description(model.description);
            deviceFleetName(model.deviceFleetName);
            iotThingName(model.iotThingName);
            registrationTime(model.registrationTime);
            latestHeartbeat(model.latestHeartbeat);
            models(model.models);
            agentVersion(model.agentVersion);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final String getIotThingName() {
            return iotThingName;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        @Override
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        public final Instant getRegistrationTime() {
            return registrationTime;
        }

        public final void setRegistrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
        }

        @Override
        public final Builder registrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
            return this;
        }

        public final Instant getLatestHeartbeat() {
            return latestHeartbeat;
        }

        public final void setLatestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
        }

        @Override
        public final Builder latestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
            return this;
        }

        public final List<EdgeModelSummary.Builder> getModels() {
            List<EdgeModelSummary.Builder> result = EdgeModelSummariesCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<EdgeModelSummary.BuilderImpl> models) {
            this.models = EdgeModelSummariesCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<EdgeModelSummary> models) {
            this.models = EdgeModelSummariesCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(EdgeModelSummary... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<EdgeModelSummary.Builder>... models) {
            models(Stream.of(models).map(c -> EdgeModelSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        @Override
        public DeviceSummary build() {
            return new DeviceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
