/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImageVersionsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListImageVersionsResponse.Builder, ListImageVersionsResponse> {
    private static final SdkField<List<ImageVersion>> IMAGE_VERSIONS_FIELD = SdkField
            .<List<ImageVersion>> builder(MarshallingType.LIST)
            .memberName("ImageVersions")
            .getter(getter(ListImageVersionsResponse::imageVersions))
            .setter(setter(Builder::imageVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListImageVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImageVersion> imageVersions;

    private final String nextToken;

    private ListImageVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.imageVersions = builder.imageVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageVersions() {
        return imageVersions != null && !(imageVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of versions and their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageVersions} method.
     * </p>
     * 
     * @return A list of versions and their properties.
     */
    public final List<ImageVersion> imageVersions() {
        return imageVersions;
    }

    /**
     * <p>
     * A token for getting the next set of versions, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of versions, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageVersions() ? imageVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageVersionsResponse)) {
            return false;
        }
        ListImageVersionsResponse other = (ListImageVersionsResponse) obj;
        return hasImageVersions() == other.hasImageVersions() && Objects.equals(imageVersions(), other.imageVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImageVersionsResponse").add("ImageVersions", hasImageVersions() ? imageVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageVersions":
            return Optional.ofNullable(clazz.cast(imageVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImageVersionsResponse, T> g) {
        return obj -> g.apply((ListImageVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImageVersionsResponse> {
        /**
         * <p>
         * A list of versions and their properties.
         * </p>
         * 
         * @param imageVersions
         *        A list of versions and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersions(Collection<ImageVersion> imageVersions);

        /**
         * <p>
         * A list of versions and their properties.
         * </p>
         * 
         * @param imageVersions
         *        A list of versions and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersions(ImageVersion... imageVersions);

        /**
         * <p>
         * A list of versions and their properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ImageVersion>.Builder} avoiding the
         * need to create one manually via {@link List<ImageVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageVersion>.Builder#build()} is called immediately and its
         * result is passed to {@link #imageVersions(List<ImageVersion>)}.
         * 
         * @param imageVersions
         *        a consumer that will call methods on {@link List<ImageVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageVersions(List<ImageVersion>)
         */
        Builder imageVersions(Consumer<ImageVersion.Builder>... imageVersions);

        /**
         * <p>
         * A token for getting the next set of versions, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of versions, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ImageVersion> imageVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageVersionsResponse model) {
            super(model);
            imageVersions(model.imageVersions);
            nextToken(model.nextToken);
        }

        public final List<ImageVersion.Builder> getImageVersions() {
            List<ImageVersion.Builder> result = ImageVersionsCopier.copyToBuilder(this.imageVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageVersions(Collection<ImageVersion.BuilderImpl> imageVersions) {
            this.imageVersions = ImageVersionsCopier.copyFromBuilder(imageVersions);
        }

        @Override
        public final Builder imageVersions(Collection<ImageVersion> imageVersions) {
            this.imageVersions = ImageVersionsCopier.copy(imageVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersions(ImageVersion... imageVersions) {
            imageVersions(Arrays.asList(imageVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersions(Consumer<ImageVersion.Builder>... imageVersions) {
            imageVersions(Stream.of(imageVersions).map(c -> ImageVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImageVersionsResponse build() {
            return new ListImageVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
