/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and
 * outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfig implements SdkPojo, Serializable, ToCopyableBuilder<NetworkConfig.Builder, NetworkConfig> {
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInterContainerTrafficEncryption")
            .getter(getter(NetworkConfig::enableInterContainerTrafficEncryption))
            .setter(setter(Builder::enableInterContainerTrafficEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableInterContainerTrafficEncryption").build()).build();

    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableNetworkIsolation").getter(getter(NetworkConfig::enableNetworkIsolation))
            .setter(setter(Builder::enableNetworkIsolation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build())
            .build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(NetworkConfig::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, VPC_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableInterContainerTrafficEncryption;

    private final Boolean enableNetworkIsolation;

    private final VpcConfig vpcConfig;

    private NetworkConfig(BuilderImpl builder) {
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to encrypt
     * communications. Encryption provides greater security for distributed processing jobs, but the processing might
     * take longer.
     * </p>
     * 
     * @return Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to
     *         encrypt communications. Encryption provides greater security for distributed processing jobs, but the
     *         processing might take longer.
     */
    public final Boolean enableInterContainerTrafficEncryption() {
        return enableInterContainerTrafficEncryption;
    }

    /**
     * <p>
     * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
     * </p>
     * 
     * @return Whether to allow inbound and outbound network calls to and from the containers used for the processing
     *         job.
     */
    public final Boolean enableNetworkIsolation() {
        return enableNetworkIsolation;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfig)) {
            return false;
        }
        NetworkConfig other = (NetworkConfig) obj;
        return Objects.equals(enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption())
                && Objects.equals(enableNetworkIsolation(), other.enableNetworkIsolation())
                && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConfig")
                .add("EnableInterContainerTrafficEncryption", enableInterContainerTrafficEncryption())
                .add("EnableNetworkIsolation", enableNetworkIsolation()).add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableInterContainerTrafficEncryption":
            return Optional.ofNullable(clazz.cast(enableInterContainerTrafficEncryption()));
        case "EnableNetworkIsolation":
            return Optional.ofNullable(clazz.cast(enableNetworkIsolation()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfig, T> g) {
        return obj -> g.apply((NetworkConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConfig> {
        /**
         * <p>
         * Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to
         * encrypt communications. Encryption provides greater security for distributed processing jobs, but the
         * processing might take longer.
         * </p>
         * 
         * @param enableInterContainerTrafficEncryption
         *        Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to
         *        encrypt communications. Encryption provides greater security for distributed processing jobs, but the
         *        processing might take longer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption);

        /**
         * <p>
         * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
         * </p>
         * 
         * @param enableNetworkIsolation
         *        Whether to allow inbound and outbound network calls to and from the containers used for the processing
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNetworkIsolation(Boolean enableNetworkIsolation);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableInterContainerTrafficEncryption;

        private Boolean enableNetworkIsolation;

        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfig model) {
            enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            enableNetworkIsolation(model.enableNetworkIsolation);
            vpcConfig(model.vpcConfig);
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return enableInterContainerTrafficEncryption;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public NetworkConfig build() {
            return new NetworkConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
