/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches.
 * The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the
 * combination of values that result in the training job with the best performance as measured by the objective metric
 * of the hyperparameter tuning job.
 * </p>
 * <note>
 * <p>
 * The maximum number of items specified for <code>Array Members</code> refers to the maximum number of hyperparameters
 * for each range and also the maximum for the hyperparameter tuning job itself. That is, the sum of the number of
 * hyperparameters for all the ranges can't exceed the maximum number specified.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterRanges implements SdkPojo, Serializable, ToCopyableBuilder<ParameterRanges.Builder, ParameterRanges> {
    private static final SdkField<List<IntegerParameterRange>> INTEGER_PARAMETER_RANGES_FIELD = SdkField
            .<List<IntegerParameterRange>> builder(MarshallingType.LIST)
            .memberName("IntegerParameterRanges")
            .getter(getter(ParameterRanges::integerParameterRanges))
            .setter(setter(Builder::integerParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameterRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegerParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegerParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContinuousParameterRange>> CONTINUOUS_PARAMETER_RANGES_FIELD = SdkField
            .<List<ContinuousParameterRange>> builder(MarshallingType.LIST)
            .memberName("ContinuousParameterRanges")
            .getter(getter(ParameterRanges::continuousParameterRanges))
            .setter(setter(Builder::continuousParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousParameterRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContinuousParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContinuousParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CategoricalParameterRange>> CATEGORICAL_PARAMETER_RANGES_FIELD = SdkField
            .<List<CategoricalParameterRange>> builder(MarshallingType.LIST)
            .memberName("CategoricalParameterRanges")
            .getter(getter(ParameterRanges::categoricalParameterRanges))
            .setter(setter(Builder::categoricalParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalParameterRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CategoricalParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoricalParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGER_PARAMETER_RANGES_FIELD, CONTINUOUS_PARAMETER_RANGES_FIELD, CATEGORICAL_PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<IntegerParameterRange> integerParameterRanges;

    private final List<ContinuousParameterRange> continuousParameterRanges;

    private final List<CategoricalParameterRange> categoricalParameterRanges;

    private ParameterRanges(BuilderImpl builder) {
        this.integerParameterRanges = builder.integerParameterRanges;
        this.continuousParameterRanges = builder.continuousParameterRanges;
        this.categoricalParameterRanges = builder.categoricalParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerParameterRanges property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIntegerParameterRanges() {
        return integerParameterRanges != null && !(integerParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a
     * hyperparameter tuning job searches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerParameterRanges} method.
     * </p>
     * 
     * @return The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a
     *         hyperparameter tuning job searches.
     */
    public final List<IntegerParameterRange> integerParameterRanges() {
        return integerParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContinuousParameterRanges property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContinuousParameterRanges() {
        return continuousParameterRanges != null && !(continuousParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a
     * hyperparameter tuning job searches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContinuousParameterRanges} method.
     * </p>
     * 
     * @return The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters
     *         that a hyperparameter tuning job searches.
     */
    public final List<ContinuousParameterRange> continuousParameterRanges() {
        return continuousParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoricalParameterRanges property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCategoricalParameterRanges() {
        return categoricalParameterRanges != null && !(categoricalParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that a
     * hyperparameter tuning job searches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoricalParameterRanges} method.
     * </p>
     * 
     * @return The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters
     *         that a hyperparameter tuning job searches.
     */
    public final List<CategoricalParameterRange> categoricalParameterRanges() {
        return categoricalParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerParameterRanges() ? integerParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContinuousParameterRanges() ? continuousParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCategoricalParameterRanges() ? categoricalParameterRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterRanges)) {
            return false;
        }
        ParameterRanges other = (ParameterRanges) obj;
        return hasIntegerParameterRanges() == other.hasIntegerParameterRanges()
                && Objects.equals(integerParameterRanges(), other.integerParameterRanges())
                && hasContinuousParameterRanges() == other.hasContinuousParameterRanges()
                && Objects.equals(continuousParameterRanges(), other.continuousParameterRanges())
                && hasCategoricalParameterRanges() == other.hasCategoricalParameterRanges()
                && Objects.equals(categoricalParameterRanges(), other.categoricalParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterRanges")
                .add("IntegerParameterRanges", hasIntegerParameterRanges() ? integerParameterRanges() : null)
                .add("ContinuousParameterRanges", hasContinuousParameterRanges() ? continuousParameterRanges() : null)
                .add("CategoricalParameterRanges", hasCategoricalParameterRanges() ? categoricalParameterRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegerParameterRanges":
            return Optional.ofNullable(clazz.cast(integerParameterRanges()));
        case "ContinuousParameterRanges":
            return Optional.ofNullable(clazz.cast(continuousParameterRanges()));
        case "CategoricalParameterRanges":
            return Optional.ofNullable(clazz.cast(categoricalParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterRanges, T> g) {
        return obj -> g.apply((ParameterRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterRanges> {
        /**
         * <p>
         * The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a
         * hyperparameter tuning job searches.
         * </p>
         * 
         * @param integerParameterRanges
         *        The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that
         *        a hyperparameter tuning job searches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameterRanges(Collection<IntegerParameterRange> integerParameterRanges);

        /**
         * <p>
         * The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a
         * hyperparameter tuning job searches.
         * </p>
         * 
         * @param integerParameterRanges
         *        The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that
         *        a hyperparameter tuning job searches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameterRanges(IntegerParameterRange... integerParameterRanges);

        /**
         * <p>
         * The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a
         * hyperparameter tuning job searches.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<IntegerParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<IntegerParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntegerParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #integerParameterRanges(List<IntegerParameterRange>)}.
         * 
         * @param integerParameterRanges
         *        a consumer that will call methods on {@link List<IntegerParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerParameterRanges(List<IntegerParameterRange>)
         */
        Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder>... integerParameterRanges);

        /**
         * <p>
         * The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a
         * hyperparameter tuning job searches.
         * </p>
         * 
         * @param continuousParameterRanges
         *        The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters
         *        that a hyperparameter tuning job searches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousParameterRanges(Collection<ContinuousParameterRange> continuousParameterRanges);

        /**
         * <p>
         * The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a
         * hyperparameter tuning job searches.
         * </p>
         * 
         * @param continuousParameterRanges
         *        The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters
         *        that a hyperparameter tuning job searches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousParameterRanges(ContinuousParameterRange... continuousParameterRanges);

        /**
         * <p>
         * The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a
         * hyperparameter tuning job searches.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ContinuousParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<ContinuousParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContinuousParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #continuousParameterRanges(List<ContinuousParameterRange>)}.
         * 
         * @param continuousParameterRanges
         *        a consumer that will call methods on {@link List<ContinuousParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousParameterRanges(List<ContinuousParameterRange>)
         */
        Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder>... continuousParameterRanges);

        /**
         * <p>
         * The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that
         * a hyperparameter tuning job searches.
         * </p>
         * 
         * @param categoricalParameterRanges
         *        The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical
         *        hyperparameters that a hyperparameter tuning job searches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalParameterRanges(Collection<CategoricalParameterRange> categoricalParameterRanges);

        /**
         * <p>
         * The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that
         * a hyperparameter tuning job searches.
         * </p>
         * 
         * @param categoricalParameterRanges
         *        The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical
         *        hyperparameters that a hyperparameter tuning job searches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalParameterRanges(CategoricalParameterRange... categoricalParameterRanges);

        /**
         * <p>
         * The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that
         * a hyperparameter tuning job searches.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CategoricalParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<CategoricalParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CategoricalParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #categoricalParameterRanges(List<CategoricalParameterRange>)}.
         * 
         * @param categoricalParameterRanges
         *        a consumer that will call methods on {@link List<CategoricalParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalParameterRanges(List<CategoricalParameterRange>)
         */
        Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder>... categoricalParameterRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<IntegerParameterRange> integerParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<ContinuousParameterRange> continuousParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<CategoricalParameterRange> categoricalParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterRanges model) {
            integerParameterRanges(model.integerParameterRanges);
            continuousParameterRanges(model.continuousParameterRanges);
            categoricalParameterRanges(model.categoricalParameterRanges);
        }

        public final List<IntegerParameterRange.Builder> getIntegerParameterRanges() {
            List<IntegerParameterRange.Builder> result = IntegerParameterRangesCopier.copyToBuilder(this.integerParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegerParameterRanges(Collection<IntegerParameterRange.BuilderImpl> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copyFromBuilder(integerParameterRanges);
        }

        @Override
        public final Builder integerParameterRanges(Collection<IntegerParameterRange> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copy(integerParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(IntegerParameterRange... integerParameterRanges) {
            integerParameterRanges(Arrays.asList(integerParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder>... integerParameterRanges) {
            integerParameterRanges(Stream.of(integerParameterRanges)
                    .map(c -> IntegerParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContinuousParameterRange.Builder> getContinuousParameterRanges() {
            List<ContinuousParameterRange.Builder> result = ContinuousParameterRangesCopier
                    .copyToBuilder(this.continuousParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContinuousParameterRanges(Collection<ContinuousParameterRange.BuilderImpl> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copyFromBuilder(continuousParameterRanges);
        }

        @Override
        public final Builder continuousParameterRanges(Collection<ContinuousParameterRange> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copy(continuousParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(ContinuousParameterRange... continuousParameterRanges) {
            continuousParameterRanges(Arrays.asList(continuousParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder>... continuousParameterRanges) {
            continuousParameterRanges(Stream.of(continuousParameterRanges)
                    .map(c -> ContinuousParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CategoricalParameterRange.Builder> getCategoricalParameterRanges() {
            List<CategoricalParameterRange.Builder> result = CategoricalParameterRangesCopier
                    .copyToBuilder(this.categoricalParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoricalParameterRanges(
                Collection<CategoricalParameterRange.BuilderImpl> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copyFromBuilder(categoricalParameterRanges);
        }

        @Override
        public final Builder categoricalParameterRanges(Collection<CategoricalParameterRange> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copy(categoricalParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(CategoricalParameterRange... categoricalParameterRanges) {
            categoricalParameterRanges(Arrays.asList(categoricalParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder>... categoricalParameterRanges) {
            categoricalParameterRanges(Stream.of(categoricalParameterRanges)
                    .map(c -> CategoricalParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ParameterRanges build() {
            return new ParameterRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
