/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the input needed to run a training job using the algorithm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingJobDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingJobDefinition.Builder, TrainingJobDefinition> {
    private static final SdkField<String> TRAINING_INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingInputMode").getter(getter(TrainingJobDefinition::trainingInputModeAsString))
            .setter(setter(Builder::trainingInputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingInputMode").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("HyperParameters")
            .getter(getter(TrainingJobDefinition::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<Channel>> builder(MarshallingType.LIST)
            .memberName("InputDataConfig")
            .getter(getter(TrainingJobDefinition::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Channel> builder(MarshallingType.SDK_POJO)
                                            .constructor(Channel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(TrainingJobDefinition::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<ResourceConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceConfig")
            .getter(getter(TrainingJobDefinition::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(ResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(TrainingJobDefinition::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_INPUT_MODE_FIELD,
            HYPER_PARAMETERS_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD,
            STOPPING_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trainingInputMode;

    private final Map<String, String> hyperParameters;

    private final List<Channel> inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final ResourceConfig resourceConfig;

    private final StoppingCondition stoppingCondition;

    private TrainingJobDefinition(BuilderImpl builder) {
        this.trainingInputMode = builder.trainingInputMode;
        this.hyperParameters = builder.hyperParameters;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
    }

    /**
     * Returns the value of the TrainingInputMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingInputMode}
     * will return {@link TrainingInputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingInputModeAsString}.
     * </p>
     * 
     * @return The value of the TrainingInputMode property for this object.
     * @see TrainingInputMode
     */
    public final TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(trainingInputMode);
    }

    /**
     * Returns the value of the TrainingInputMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingInputMode}
     * will return {@link TrainingInputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingInputModeAsString}.
     * </p>
     * 
     * @return The value of the TrainingInputMode property for this object.
     * @see TrainingInputMode
     */
    public final String trainingInputModeAsString() {
        return trainingInputMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the HyperParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The hyperparameters used for the training job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperParameters} method.
     * </p>
     * 
     * @return The hyperparameters used for the training job.
     */
    public final Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDataConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Channel</code> objects, each of which specifies an input source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDataConfig} method.
     * </p>
     * 
     * @return An array of <code>Channel</code> objects, each of which specifies an input source.
     */
    public final List<Channel> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * the path to the S3 bucket where you want to store model artifacts. SageMaker creates subfolders for the
     * artifacts.
     * </p>
     * 
     * @return the path to the S3 bucket where you want to store model artifacts. SageMaker creates subfolders for the
     *         artifacts.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The resources, including the ML compute instances and ML storage volumes, to use for model training.
     * </p>
     * 
     * @return The resources, including the ML compute instances and ML storage volumes, to use for model training.
     */
    public final ResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training
     * job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this API to cap
     * model training costs.
     * </p>
     * <p>
     * To stop a job, SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds.
     * Algorithms can use this 120-second window to save the model artifacts.
     * </p>
     * 
     * @return Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot
     *         training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use
     *         this API to cap model training costs.</p>
     *         <p>
     *         To stop a job, SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120
     *         seconds. Algorithms can use this 120-second window to save the model artifacts.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingInputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobDefinition)) {
            return false;
        }
        TrainingJobDefinition other = (TrainingJobDefinition) obj;
        return Objects.equals(trainingInputModeAsString(), other.trainingInputModeAsString())
                && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters())
                && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(stoppingCondition(), other.stoppingCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingJobDefinition").add("TrainingInputMode", trainingInputModeAsString())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null)
                .add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null)
                .add("OutputDataConfig", outputDataConfig()).add("ResourceConfig", resourceConfig())
                .add("StoppingCondition", stoppingCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingInputMode":
            return Optional.ofNullable(clazz.cast(trainingInputModeAsString()));
        case "HyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingJobDefinition, T> g) {
        return obj -> g.apply((TrainingJobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingJobDefinition> {
        /**
         * Sets the value of the TrainingInputMode property for this object.
         *
         * @param trainingInputMode
         *        The new value for the TrainingInputMode property for this object.
         * @see TrainingInputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInputMode
         */
        Builder trainingInputMode(String trainingInputMode);

        /**
         * Sets the value of the TrainingInputMode property for this object.
         *
         * @param trainingInputMode
         *        The new value for the TrainingInputMode property for this object.
         * @see TrainingInputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInputMode
         */
        Builder trainingInputMode(TrainingInputMode trainingInputMode);

        /**
         * <p>
         * The hyperparameters used for the training job.
         * </p>
         * 
         * @param hyperParameters
         *        The hyperparameters used for the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * An array of <code>Channel</code> objects, each of which specifies an input source.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <code>Channel</code> objects, each of which specifies an input source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<Channel> inputDataConfig);

        /**
         * <p>
         * An array of <code>Channel</code> objects, each of which specifies an input source.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <code>Channel</code> objects, each of which specifies an input source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Channel... inputDataConfig);

        /**
         * <p>
         * An array of <code>Channel</code> objects, each of which specifies an input source.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Channel>.Builder} avoiding the need
         * to create one manually via {@link List<Channel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Channel>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(List<Channel>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link List<Channel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(List<Channel>)
         */
        Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig);

        /**
         * <p>
         * the path to the S3 bucket where you want to store model artifacts. SageMaker creates subfolders for the
         * artifacts.
         * </p>
         * 
         * @param outputDataConfig
         *        the path to the S3 bucket where you want to store model artifacts. SageMaker creates subfolders for
         *        the artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * the path to the S3 bucket where you want to store model artifacts. SageMaker creates subfolders for the
         * artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The resources, including the ML compute instances and ML storage volumes, to use for model training.
         * </p>
         * 
         * @param resourceConfig
         *        The resources, including the ML compute instances and ML storage volumes, to use for model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(ResourceConfig resourceConfig);

        /**
         * <p>
         * The resources, including the ML compute instances and ML storage volumes, to use for model training.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceConfig.Builder} avoiding the need
         * to create one manually via {@link ResourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceConfig(ResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link ResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(ResourceConfig)
         */
        default Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return resourceConfig(ResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot
         * training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this
         * API to cap model training costs.
         * </p>
         * <p>
         * To stop a job, SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120
         * seconds. Algorithms can use this 120-second window to save the model artifacts.
         * </p>
         * 
         * @param stoppingCondition
         *        Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot
         *        training job has to complete. When the job reaches the time limit, SageMaker ends the training job.
         *        Use this API to cap model training costs.</p>
         *        <p>
         *        To stop a job, SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120
         *        seconds. Algorithms can use this 120-second window to save the model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot
         * training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this
         * API to cap model training costs.
         * </p>
         * <p>
         * To stop a job, SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120
         * seconds. Algorithms can use this 120-second window to save the model artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String trainingInputMode;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private OutputDataConfig outputDataConfig;

        private ResourceConfig resourceConfig;

        private StoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobDefinition model) {
            trainingInputMode(model.trainingInputMode);
            hyperParameters(model.hyperParameters);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            resourceConfig(model.resourceConfig);
            stoppingCondition(model.stoppingCondition);
        }

        public final String getTrainingInputMode() {
            return trainingInputMode;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode == null ? null : trainingInputMode.toString());
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final List<Channel.Builder> getInputDataConfig() {
            List<Channel.Builder> result = InputDataConfigCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> Channel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        @Override
        public TrainingJobDefinition build() {
            return new TrainingJobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
