/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFeatureGroupResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeFeatureGroupResponse.Builder, DescribeFeatureGroupResponse> {
    private static final SdkField<String> FEATURE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupArn").getter(getter(DescribeFeatureGroupResponse::featureGroupArn))
            .setter(setter(Builder::featureGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupArn").build()).build();

    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(DescribeFeatureGroupResponse::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> RECORD_IDENTIFIER_FEATURE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordIdentifierFeatureName")
            .getter(getter(DescribeFeatureGroupResponse::recordIdentifierFeatureName))
            .setter(setter(Builder::recordIdentifierFeatureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifierFeatureName")
                    .build()).build();

    private static final SdkField<String> EVENT_TIME_FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTimeFeatureName").getter(getter(DescribeFeatureGroupResponse::eventTimeFeatureName))
            .setter(setter(Builder::eventTimeFeatureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeFeatureName").build())
            .build();

    private static final SdkField<List<FeatureDefinition>> FEATURE_DEFINITIONS_FIELD = SdkField
            .<List<FeatureDefinition>> builder(MarshallingType.LIST)
            .memberName("FeatureDefinitions")
            .getter(getter(DescribeFeatureGroupResponse::featureDefinitions))
            .setter(setter(Builder::featureDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeFeatureGroupResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeFeatureGroupResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<OnlineStoreConfig> ONLINE_STORE_CONFIG_FIELD = SdkField
            .<OnlineStoreConfig> builder(MarshallingType.SDK_POJO).memberName("OnlineStoreConfig")
            .getter(getter(DescribeFeatureGroupResponse::onlineStoreConfig)).setter(setter(Builder::onlineStoreConfig))
            .constructor(OnlineStoreConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreConfig").build()).build();

    private static final SdkField<OfflineStoreConfig> OFFLINE_STORE_CONFIG_FIELD = SdkField
            .<OfflineStoreConfig> builder(MarshallingType.SDK_POJO).memberName("OfflineStoreConfig")
            .getter(getter(DescribeFeatureGroupResponse::offlineStoreConfig)).setter(setter(Builder::offlineStoreConfig))
            .constructor(OfflineStoreConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreConfig").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeFeatureGroupResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> FEATURE_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupStatus").getter(getter(DescribeFeatureGroupResponse::featureGroupStatusAsString))
            .setter(setter(Builder::featureGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupStatus").build())
            .build();

    private static final SdkField<OfflineStoreStatus> OFFLINE_STORE_STATUS_FIELD = SdkField
            .<OfflineStoreStatus> builder(MarshallingType.SDK_POJO).memberName("OfflineStoreStatus")
            .getter(getter(DescribeFeatureGroupResponse::offlineStoreStatus)).setter(setter(Builder::offlineStoreStatus))
            .constructor(OfflineStoreStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreStatus").build())
            .build();

    private static final SdkField<LastUpdateStatus> LAST_UPDATE_STATUS_FIELD = SdkField
            .<LastUpdateStatus> builder(MarshallingType.SDK_POJO).memberName("LastUpdateStatus")
            .getter(getter(DescribeFeatureGroupResponse::lastUpdateStatus)).setter(setter(Builder::lastUpdateStatus))
            .constructor(LastUpdateStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeFeatureGroupResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeFeatureGroupResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFeatureGroupResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Long> ONLINE_STORE_TOTAL_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OnlineStoreTotalSizeBytes").getter(getter(DescribeFeatureGroupResponse::onlineStoreTotalSizeBytes))
            .setter(setter(Builder::onlineStoreTotalSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreTotalSizeBytes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_ARN_FIELD,
            FEATURE_GROUP_NAME_FIELD, RECORD_IDENTIFIER_FEATURE_NAME_FIELD, EVENT_TIME_FEATURE_NAME_FIELD,
            FEATURE_DEFINITIONS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ONLINE_STORE_CONFIG_FIELD,
            OFFLINE_STORE_CONFIG_FIELD, ROLE_ARN_FIELD, FEATURE_GROUP_STATUS_FIELD, OFFLINE_STORE_STATUS_FIELD,
            LAST_UPDATE_STATUS_FIELD, FAILURE_REASON_FIELD, DESCRIPTION_FIELD, NEXT_TOKEN_FIELD,
            ONLINE_STORE_TOTAL_SIZE_BYTES_FIELD));

    private final String featureGroupArn;

    private final String featureGroupName;

    private final String recordIdentifierFeatureName;

    private final String eventTimeFeatureName;

    private final List<FeatureDefinition> featureDefinitions;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final OnlineStoreConfig onlineStoreConfig;

    private final OfflineStoreConfig offlineStoreConfig;

    private final String roleArn;

    private final String featureGroupStatus;

    private final OfflineStoreStatus offlineStoreStatus;

    private final LastUpdateStatus lastUpdateStatus;

    private final String failureReason;

    private final String description;

    private final String nextToken;

    private final Long onlineStoreTotalSizeBytes;

    private DescribeFeatureGroupResponse(BuilderImpl builder) {
        super(builder);
        this.featureGroupArn = builder.featureGroupArn;
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierFeatureName = builder.recordIdentifierFeatureName;
        this.eventTimeFeatureName = builder.eventTimeFeatureName;
        this.featureDefinitions = builder.featureDefinitions;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.onlineStoreConfig = builder.onlineStoreConfig;
        this.offlineStoreConfig = builder.offlineStoreConfig;
        this.roleArn = builder.roleArn;
        this.featureGroupStatus = builder.featureGroupStatus;
        this.offlineStoreStatus = builder.offlineStoreStatus;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.failureReason = builder.failureReason;
        this.description = builder.description;
        this.nextToken = builder.nextToken;
        this.onlineStoreTotalSizeBytes = builder.onlineStoreTotalSizeBytes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>.
     */
    public final String featureGroupArn() {
        return featureGroupArn;
    }

    /**
     * <p>
     * he name of the <code>FeatureGroup</code>.
     * </p>
     * 
     * @return he name of the <code>FeatureGroup</code>.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a
     * record stored in the feature store.
     * </p>
     * 
     * @return The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely
     *         identifies a record stored in the feature store.
     */
    public final String recordIdentifierFeatureName() {
        return recordIdentifierFeatureName;
    }

    /**
     * <p>
     * The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.
     * </p>
     * <p>
     * An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update
     * of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
     * <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.
     * </p>
     * 
     * @return The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>
     *         .</p>
     *         <p>
     *         An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or
     *         update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
     *         <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.
     */
    public final String eventTimeFeatureName() {
        return eventTimeFeatureName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureDefinitions() {
        return featureDefinitions != null && !(featureDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a
     * <code>FeatureName</code> and <code>FeatureType</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureDefinitions} method.
     * </p>
     * 
     * @return A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a
     *         <code>FeatureName</code> and <code>FeatureType</code>.
     */
    public final List<FeatureDefinition> featureDefinitions() {
        return featureDefinitions;
    }

    /**
     * <p>
     * A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.
     * </p>
     * 
     * @return A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp indicating when the feature group was last updated.
     * </p>
     * 
     * @return A timestamp indicating when the feature group was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The configuration for the <code>OnlineStore</code>.
     * </p>
     * 
     * @return The configuration for the <code>OnlineStore</code>.
     */
    public final OnlineStoreConfig onlineStoreConfig() {
        return onlineStoreConfig;
    }

    /**
     * <p>
     * The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>,
     * Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security
     * configuration.
     * </p>
     * 
     * @return The configuration of the <code>OfflineStore</code>, inducing the S3 location of the
     *         <code>OfflineStore</code>, Amazon Web Services Glue or Amazon Web Services Hive data catalogue
     *         configurations, and the security configuration.
     */
    public final OfflineStoreConfig offlineStoreConfig() {
        return offlineStoreConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code>
     * if an <code>OfflineStoreConfig</code> is provided.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
     *         <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the feature group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featureGroupStatus} will return {@link FeatureGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #featureGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the feature group.
     * @see FeatureGroupStatus
     */
    public final FeatureGroupStatus featureGroupStatus() {
        return FeatureGroupStatus.fromValue(featureGroupStatus);
    }

    /**
     * <p>
     * The status of the feature group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featureGroupStatus} will return {@link FeatureGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #featureGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the feature group.
     * @see FeatureGroupStatus
     */
    public final String featureGroupStatusAsString() {
        return featureGroupStatus;
    }

    /**
     * <p>
     * The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code>
     * has failed. Returns either: <code>Active</code> or <code>Blocked</code>
     * </p>
     * 
     * @return The status of the <code>OfflineStore</code>. Notifies you if replicating data into the
     *         <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code>
     */
    public final OfflineStoreStatus offlineStoreStatus() {
        return offlineStoreStatus;
    }

    /**
     * <p>
     * A value indicating whether the update made to the feature group was successful.
     * </p>
     * 
     * @return A value indicating whether the update made to the feature group was successful.
     */
    public final LastUpdateStatus lastUpdateStatus() {
        return lastUpdateStatus;
    }

    /**
     * <p>
     * The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is
     * failure can occur because:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>.
     *         This is failure can occur because:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.
     *         </p>
     *         </li>
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * A free form description of the feature group.
     * </p>
     * 
     * @return A free form description of the feature group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).
     * </p>
     * 
     * @return A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The size of the <code>OnlineStore</code> in bytes.
     * </p>
     * 
     * @return The size of the <code>OnlineStore</code> in bytes.
     */
    public final Long onlineStoreTotalSizeBytes() {
        return onlineStoreTotalSizeBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(recordIdentifierFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimeFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureDefinitions() ? featureDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(onlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(offlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offlineStoreStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(onlineStoreTotalSizeBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeatureGroupResponse)) {
            return false;
        }
        DescribeFeatureGroupResponse other = (DescribeFeatureGroupResponse) obj;
        return Objects.equals(featureGroupArn(), other.featureGroupArn())
                && Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(recordIdentifierFeatureName(), other.recordIdentifierFeatureName())
                && Objects.equals(eventTimeFeatureName(), other.eventTimeFeatureName())
                && hasFeatureDefinitions() == other.hasFeatureDefinitions()
                && Objects.equals(featureDefinitions(), other.featureDefinitions())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(onlineStoreConfig(), other.onlineStoreConfig())
                && Objects.equals(offlineStoreConfig(), other.offlineStoreConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(featureGroupStatusAsString(), other.featureGroupStatusAsString())
                && Objects.equals(offlineStoreStatus(), other.offlineStoreStatus())
                && Objects.equals(lastUpdateStatus(), other.lastUpdateStatus())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(description(), other.description())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(onlineStoreTotalSizeBytes(), other.onlineStoreTotalSizeBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFeatureGroupResponse").add("FeatureGroupArn", featureGroupArn())
                .add("FeatureGroupName", featureGroupName()).add("RecordIdentifierFeatureName", recordIdentifierFeatureName())
                .add("EventTimeFeatureName", eventTimeFeatureName())
                .add("FeatureDefinitions", hasFeatureDefinitions() ? featureDefinitions() : null)
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("OnlineStoreConfig", onlineStoreConfig()).add("OfflineStoreConfig", offlineStoreConfig())
                .add("RoleArn", roleArn()).add("FeatureGroupStatus", featureGroupStatusAsString())
                .add("OfflineStoreStatus", offlineStoreStatus()).add("LastUpdateStatus", lastUpdateStatus())
                .add("FailureReason", failureReason()).add("Description", description()).add("NextToken", nextToken())
                .add("OnlineStoreTotalSizeBytes", onlineStoreTotalSizeBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupArn":
            return Optional.ofNullable(clazz.cast(featureGroupArn()));
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "RecordIdentifierFeatureName":
            return Optional.ofNullable(clazz.cast(recordIdentifierFeatureName()));
        case "EventTimeFeatureName":
            return Optional.ofNullable(clazz.cast(eventTimeFeatureName()));
        case "FeatureDefinitions":
            return Optional.ofNullable(clazz.cast(featureDefinitions()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "OnlineStoreConfig":
            return Optional.ofNullable(clazz.cast(onlineStoreConfig()));
        case "OfflineStoreConfig":
            return Optional.ofNullable(clazz.cast(offlineStoreConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "FeatureGroupStatus":
            return Optional.ofNullable(clazz.cast(featureGroupStatusAsString()));
        case "OfflineStoreStatus":
            return Optional.ofNullable(clazz.cast(offlineStoreStatus()));
        case "LastUpdateStatus":
            return Optional.ofNullable(clazz.cast(lastUpdateStatus()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OnlineStoreTotalSizeBytes":
            return Optional.ofNullable(clazz.cast(onlineStoreTotalSizeBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeatureGroupResponse, T> g) {
        return obj -> g.apply((DescribeFeatureGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFeatureGroupResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param featureGroupArn
         *        The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupArn(String featureGroupArn);

        /**
         * <p>
         * he name of the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param featureGroupName
         *        he name of the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies
         * a record stored in the feature store.
         * </p>
         * 
         * @param recordIdentifierFeatureName
         *        The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely
         *        identifies a record stored in the feature store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIdentifierFeatureName(String recordIdentifierFeatureName);

        /**
         * <p>
         * The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.
         * </p>
         * <p>
         * An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or
         * update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
         * <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.
         * </p>
         * 
         * @param eventTimeFeatureName
         *        The name of the feature that stores the <code>EventTime</code> of a Record in a
         *        <code>FeatureGroup</code>.</p>
         *        <p>
         *        An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation
         *        or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the
         *        <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimeFeatureName(String eventTimeFeatureName);

        /**
         * <p>
         * A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a
         * <code>FeatureName</code> and <code>FeatureType</code>.
         * </p>
         * 
         * @param featureDefinitions
         *        A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a
         *        <code>FeatureName</code> and <code>FeatureType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureDefinitions(Collection<FeatureDefinition> featureDefinitions);

        /**
         * <p>
         * A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a
         * <code>FeatureName</code> and <code>FeatureType</code>.
         * </p>
         * 
         * @param featureDefinitions
         *        A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a
         *        <code>FeatureName</code> and <code>FeatureType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureDefinitions(FeatureDefinition... featureDefinitions);

        /**
         * <p>
         * A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a
         * <code>FeatureName</code> and <code>FeatureType</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FeatureDefinition>.Builder} avoiding
         * the need to create one manually via {@link List<FeatureDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FeatureDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #featureDefinitions(List<FeatureDefinition>)}.
         * 
         * @param featureDefinitions
         *        a consumer that will call methods on {@link List<FeatureDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureDefinitions(List<FeatureDefinition>)
         */
        Builder featureDefinitions(Consumer<FeatureDefinition.Builder>... featureDefinitions);

        /**
         * <p>
         * A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param creationTime
         *        A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp indicating when the feature group was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp indicating when the feature group was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The configuration for the <code>OnlineStore</code>.
         * </p>
         * 
         * @param onlineStoreConfig
         *        The configuration for the <code>OnlineStore</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlineStoreConfig(OnlineStoreConfig onlineStoreConfig);

        /**
         * <p>
         * The configuration for the <code>OnlineStore</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnlineStoreConfig.Builder} avoiding the
         * need to create one manually via {@link OnlineStoreConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnlineStoreConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onlineStoreConfig(OnlineStoreConfig)}.
         * 
         * @param onlineStoreConfig
         *        a consumer that will call methods on {@link OnlineStoreConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onlineStoreConfig(OnlineStoreConfig)
         */
        default Builder onlineStoreConfig(Consumer<OnlineStoreConfig.Builder> onlineStoreConfig) {
            return onlineStoreConfig(OnlineStoreConfig.builder().applyMutation(onlineStoreConfig).build());
        }

        /**
         * <p>
         * The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>
         * , Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security
         * configuration.
         * </p>
         * 
         * @param offlineStoreConfig
         *        The configuration of the <code>OfflineStore</code>, inducing the S3 location of the
         *        <code>OfflineStore</code>, Amazon Web Services Glue or Amazon Web Services Hive data catalogue
         *        configurations, and the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offlineStoreConfig(OfflineStoreConfig offlineStoreConfig);

        /**
         * <p>
         * The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>
         * , Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfflineStoreConfig.Builder} avoiding the
         * need to create one manually via {@link OfflineStoreConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OfflineStoreConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #offlineStoreConfig(OfflineStoreConfig)}.
         * 
         * @param offlineStoreConfig
         *        a consumer that will call methods on {@link OfflineStoreConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offlineStoreConfig(OfflineStoreConfig)
         */
        default Builder offlineStoreConfig(Consumer<OfflineStoreConfig.Builder> offlineStoreConfig) {
            return offlineStoreConfig(OfflineStoreConfig.builder().applyMutation(offlineStoreConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
         * <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
         *        <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the feature group.
         * </p>
         * 
         * @param featureGroupStatus
         *        The status of the feature group.
         * @see FeatureGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupStatus
         */
        Builder featureGroupStatus(String featureGroupStatus);

        /**
         * <p>
         * The status of the feature group.
         * </p>
         * 
         * @param featureGroupStatus
         *        The status of the feature group.
         * @see FeatureGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupStatus
         */
        Builder featureGroupStatus(FeatureGroupStatus featureGroupStatus);

        /**
         * <p>
         * The status of the <code>OfflineStore</code>. Notifies you if replicating data into the
         * <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code>
         * </p>
         * 
         * @param offlineStoreStatus
         *        The status of the <code>OfflineStore</code>. Notifies you if replicating data into the
         *        <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offlineStoreStatus(OfflineStoreStatus offlineStoreStatus);

        /**
         * <p>
         * The status of the <code>OfflineStore</code>. Notifies you if replicating data into the
         * <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link OfflineStoreStatus.Builder} avoiding the
         * need to create one manually via {@link OfflineStoreStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link OfflineStoreStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #offlineStoreStatus(OfflineStoreStatus)}.
         * 
         * @param offlineStoreStatus
         *        a consumer that will call methods on {@link OfflineStoreStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offlineStoreStatus(OfflineStoreStatus)
         */
        default Builder offlineStoreStatus(Consumer<OfflineStoreStatus.Builder> offlineStoreStatus) {
            return offlineStoreStatus(OfflineStoreStatus.builder().applyMutation(offlineStoreStatus).build());
        }

        /**
         * <p>
         * A value indicating whether the update made to the feature group was successful.
         * </p>
         * 
         * @param lastUpdateStatus
         *        A value indicating whether the update made to the feature group was successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateStatus(LastUpdateStatus lastUpdateStatus);

        /**
         * <p>
         * A value indicating whether the update made to the feature group was successful.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastUpdateStatus.Builder} avoiding the
         * need to create one manually via {@link LastUpdateStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link LastUpdateStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #lastUpdateStatus(LastUpdateStatus)}.
         * 
         * @param lastUpdateStatus
         *        a consumer that will call methods on {@link LastUpdateStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdateStatus(LastUpdateStatus)
         */
        default Builder lastUpdateStatus(Consumer<LastUpdateStatus.Builder> lastUpdateStatus) {
            return lastUpdateStatus(LastUpdateStatus.builder().applyMutation(lastUpdateStatus).build());
        }

        /**
         * <p>
         * The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This
         * is failure can occur because:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureReason
         *        The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>
         *        . This is failure can occur because:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * A free form description of the feature group.
         * </p>
         * 
         * @param description
         *        A free form description of the feature group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The size of the <code>OnlineStore</code> in bytes.
         * </p>
         * 
         * @param onlineStoreTotalSizeBytes
         *        The size of the <code>OnlineStore</code> in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlineStoreTotalSizeBytes(Long onlineStoreTotalSizeBytes);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String featureGroupArn;

        private String featureGroupName;

        private String recordIdentifierFeatureName;

        private String eventTimeFeatureName;

        private List<FeatureDefinition> featureDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastModifiedTime;

        private OnlineStoreConfig onlineStoreConfig;

        private OfflineStoreConfig offlineStoreConfig;

        private String roleArn;

        private String featureGroupStatus;

        private OfflineStoreStatus offlineStoreStatus;

        private LastUpdateStatus lastUpdateStatus;

        private String failureReason;

        private String description;

        private String nextToken;

        private Long onlineStoreTotalSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeatureGroupResponse model) {
            super(model);
            featureGroupArn(model.featureGroupArn);
            featureGroupName(model.featureGroupName);
            recordIdentifierFeatureName(model.recordIdentifierFeatureName);
            eventTimeFeatureName(model.eventTimeFeatureName);
            featureDefinitions(model.featureDefinitions);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            onlineStoreConfig(model.onlineStoreConfig);
            offlineStoreConfig(model.offlineStoreConfig);
            roleArn(model.roleArn);
            featureGroupStatus(model.featureGroupStatus);
            offlineStoreStatus(model.offlineStoreStatus);
            lastUpdateStatus(model.lastUpdateStatus);
            failureReason(model.failureReason);
            description(model.description);
            nextToken(model.nextToken);
            onlineStoreTotalSizeBytes(model.onlineStoreTotalSizeBytes);
        }

        public final String getFeatureGroupArn() {
            return featureGroupArn;
        }

        public final void setFeatureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
        }

        @Override
        public final Builder featureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
            return this;
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierFeatureName() {
            return recordIdentifierFeatureName;
        }

        public final void setRecordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
        }

        @Override
        public final Builder recordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
            return this;
        }

        public final String getEventTimeFeatureName() {
            return eventTimeFeatureName;
        }

        public final void setEventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
        }

        @Override
        public final Builder eventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
            return this;
        }

        public final List<FeatureDefinition.Builder> getFeatureDefinitions() {
            List<FeatureDefinition.Builder> result = FeatureDefinitionsCopier.copyToBuilder(this.featureDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatureDefinitions(Collection<FeatureDefinition.BuilderImpl> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copyFromBuilder(featureDefinitions);
        }

        @Override
        public final Builder featureDefinitions(Collection<FeatureDefinition> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copy(featureDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(FeatureDefinition... featureDefinitions) {
            featureDefinitions(Arrays.asList(featureDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(Consumer<FeatureDefinition.Builder>... featureDefinitions) {
            featureDefinitions(Stream.of(featureDefinitions).map(c -> FeatureDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final OnlineStoreConfig.Builder getOnlineStoreConfig() {
            return onlineStoreConfig != null ? onlineStoreConfig.toBuilder() : null;
        }

        public final void setOnlineStoreConfig(OnlineStoreConfig.BuilderImpl onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig != null ? onlineStoreConfig.build() : null;
        }

        @Override
        public final Builder onlineStoreConfig(OnlineStoreConfig onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        public final OfflineStoreConfig.Builder getOfflineStoreConfig() {
            return offlineStoreConfig != null ? offlineStoreConfig.toBuilder() : null;
        }

        public final void setOfflineStoreConfig(OfflineStoreConfig.BuilderImpl offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig != null ? offlineStoreConfig.build() : null;
        }

        @Override
        public final Builder offlineStoreConfig(OfflineStoreConfig offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFeatureGroupStatus() {
            return featureGroupStatus;
        }

        public final void setFeatureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
        }

        @Override
        public final Builder featureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
            return this;
        }

        @Override
        public final Builder featureGroupStatus(FeatureGroupStatus featureGroupStatus) {
            this.featureGroupStatus(featureGroupStatus == null ? null : featureGroupStatus.toString());
            return this;
        }

        public final OfflineStoreStatus.Builder getOfflineStoreStatus() {
            return offlineStoreStatus != null ? offlineStoreStatus.toBuilder() : null;
        }

        public final void setOfflineStoreStatus(OfflineStoreStatus.BuilderImpl offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus != null ? offlineStoreStatus.build() : null;
        }

        @Override
        public final Builder offlineStoreStatus(OfflineStoreStatus offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus;
            return this;
        }

        public final LastUpdateStatus.Builder getLastUpdateStatus() {
            return lastUpdateStatus != null ? lastUpdateStatus.toBuilder() : null;
        }

        public final void setLastUpdateStatus(LastUpdateStatus.BuilderImpl lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus != null ? lastUpdateStatus.build() : null;
        }

        @Override
        public final Builder lastUpdateStatus(LastUpdateStatus lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getOnlineStoreTotalSizeBytes() {
            return onlineStoreTotalSizeBytes;
        }

        public final void setOnlineStoreTotalSizeBytes(Long onlineStoreTotalSizeBytes) {
            this.onlineStoreTotalSizeBytes = onlineStoreTotalSizeBytes;
        }

        @Override
        public final Builder onlineStoreTotalSizeBytes(Long onlineStoreTotalSizeBytes) {
            this.onlineStoreTotalSizeBytes = onlineStoreTotalSizeBytes;
            return this;
        }

        @Override
        public DescribeFeatureGroupResponse build() {
            return new DescribeFeatureGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
