/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserProfileResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeUserProfileResponse.Builder, DescribeUserProfileResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DescribeUserProfileResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileArn").getter(getter(DescribeUserProfileResponse::userProfileArn))
            .setter(setter(Builder::userProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileArn").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(DescribeUserProfileResponse::userProfileName))
            .setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeEfsFileSystemUid").getter(getter(DescribeUserProfileResponse::homeEfsFileSystemUid))
            .setter(setter(Builder::homeEfsFileSystemUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemUid").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeUserProfileResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeUserProfileResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeUserProfileResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeUserProfileResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnUserIdentifier")
            .getter(getter(DescribeUserProfileResponse::singleSignOnUserIdentifier))
            .setter(setter(Builder::singleSignOnUserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserIdentifier").build())
            .build();

    private static final SdkField<String> SINGLE_SIGN_ON_USER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnUserValue").getter(getter(DescribeUserProfileResponse::singleSignOnUserValue))
            .setter(setter(Builder::singleSignOnUserValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserValue").build())
            .build();

    private static final SdkField<UserSettings> USER_SETTINGS_FIELD = SdkField.<UserSettings> builder(MarshallingType.SDK_POJO)
            .memberName("UserSettings").getter(getter(DescribeUserProfileResponse::userSettings))
            .setter(setter(Builder::userSettings)).constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_ARN_FIELD, USER_PROFILE_NAME_FIELD, HOME_EFS_FILE_SYSTEM_UID_FIELD, STATUS_FIELD,
            LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD,
            SINGLE_SIGN_ON_USER_VALUE_FIELD, USER_SETTINGS_FIELD));

    private final String domainId;

    private final String userProfileArn;

    private final String userProfileName;

    private final String homeEfsFileSystemUid;

    private final String status;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private final String failureReason;

    private final String singleSignOnUserIdentifier;

    private final String singleSignOnUserValue;

    private final UserSettings userSettings;

    private DescribeUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileArn = builder.userProfileArn;
        this.userProfileName = builder.userProfileName;
        this.homeEfsFileSystemUid = builder.homeEfsFileSystemUid;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.singleSignOnUserIdentifier = builder.singleSignOnUserIdentifier;
        this.singleSignOnUserValue = builder.singleSignOnUserValue;
        this.userSettings = builder.userSettings;
    }

    /**
     * <p>
     * The ID of the domain that contains the profile.
     * </p>
     * 
     * @return The ID of the domain that contains the profile.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The user profile Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The user profile Amazon Resource Name (ARN).
     */
    public final String userProfileArn() {
        return userProfileArn;
    }

    /**
     * <p>
     * The user profile name.
     * </p>
     * 
     * @return The user profile name.
     */
    public final String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The ID of the user's profile in the Amazon Elastic File System (EFS) volume.
     * </p>
     * 
     * @return The ID of the user's profile in the Amazon Elastic File System (EFS) volume.
     */
    public final String homeEfsFileSystemUid() {
        return homeEfsFileSystemUid;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see UserProfileStatus
     */
    public final UserProfileStatus status() {
        return UserProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see UserProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The last modified time.
     * </p>
     * 
     * @return The last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The failure reason.
     * </p>
     * 
     * @return The failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The Amazon Web Services SSO user identifier.
     * </p>
     * 
     * @return The Amazon Web Services SSO user identifier.
     */
    public final String singleSignOnUserIdentifier() {
        return singleSignOnUserIdentifier;
    }

    /**
     * <p>
     * The Amazon Web Services SSO user value.
     * </p>
     * 
     * @return The Amazon Web Services SSO user value.
     */
    public final String singleSignOnUserValue() {
        return singleSignOnUserValue;
    }

    /**
     * <p>
     * A collection of settings.
     * </p>
     * 
     * @return A collection of settings.
     */
    public final UserSettings userSettings() {
        return userSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemUid());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnUserValue());
        hashCode = 31 * hashCode + Objects.hashCode(userSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfileResponse)) {
            return false;
        }
        DescribeUserProfileResponse other = (DescribeUserProfileResponse) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileArn(), other.userProfileArn())
                && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(homeEfsFileSystemUid(), other.homeEfsFileSystemUid())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(singleSignOnUserIdentifier(), other.singleSignOnUserIdentifier())
                && Objects.equals(singleSignOnUserValue(), other.singleSignOnUserValue())
                && Objects.equals(userSettings(), other.userSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserProfileResponse").add("DomainId", domainId())
                .add("UserProfileArn", userProfileArn()).add("UserProfileName", userProfileName())
                .add("HomeEfsFileSystemUid", homeEfsFileSystemUid()).add("Status", statusAsString())
                .add("LastModifiedTime", lastModifiedTime()).add("CreationTime", creationTime())
                .add("FailureReason", failureReason()).add("SingleSignOnUserIdentifier", singleSignOnUserIdentifier())
                .add("SingleSignOnUserValue", singleSignOnUserValue()).add("UserSettings", userSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileArn":
            return Optional.ofNullable(clazz.cast(userProfileArn()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "HomeEfsFileSystemUid":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemUid()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "SingleSignOnUserIdentifier":
            return Optional.ofNullable(clazz.cast(singleSignOnUserIdentifier()));
        case "SingleSignOnUserValue":
            return Optional.ofNullable(clazz.cast(singleSignOnUserValue()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfileResponse, T> g) {
        return obj -> g.apply((DescribeUserProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserProfileResponse> {
        /**
         * <p>
         * The ID of the domain that contains the profile.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain that contains the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The user profile Amazon Resource Name (ARN).
         * </p>
         * 
         * @param userProfileArn
         *        The user profile Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileArn(String userProfileArn);

        /**
         * <p>
         * The user profile name.
         * </p>
         * 
         * @param userProfileName
         *        The user profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The ID of the user's profile in the Amazon Elastic File System (EFS) volume.
         * </p>
         * 
         * @param homeEfsFileSystemUid
         *        The ID of the user's profile in the Amazon Elastic File System (EFS) volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeEfsFileSystemUid(String homeEfsFileSystemUid);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see UserProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see UserProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileStatus
         */
        Builder status(UserProfileStatus status);

        /**
         * <p>
         * The last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The failure reason.
         * </p>
         * 
         * @param failureReason
         *        The failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The Amazon Web Services SSO user identifier.
         * </p>
         * 
         * @param singleSignOnUserIdentifier
         *        The Amazon Web Services SSO user identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnUserIdentifier(String singleSignOnUserIdentifier);

        /**
         * <p>
         * The Amazon Web Services SSO user value.
         * </p>
         * 
         * @param singleSignOnUserValue
         *        The Amazon Web Services SSO user value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnUserValue(String singleSignOnUserValue);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * 
         * @param userSettings
         *        A collection of settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSettings userSettings);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserSettings.Builder} avoiding the need
         * to create one manually via {@link UserSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(UserSettings)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(UserSettings)
         */
        default Builder userSettings(Consumer<UserSettings.Builder> userSettings) {
            return userSettings(UserSettings.builder().applyMutation(userSettings).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String domainId;

        private String userProfileArn;

        private String userProfileName;

        private String homeEfsFileSystemUid;

        private String status;

        private Instant lastModifiedTime;

        private Instant creationTime;

        private String failureReason;

        private String singleSignOnUserIdentifier;

        private String singleSignOnUserValue;

        private UserSettings userSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfileResponse model) {
            super(model);
            domainId(model.domainId);
            userProfileArn(model.userProfileArn);
            userProfileName(model.userProfileName);
            homeEfsFileSystemUid(model.homeEfsFileSystemUid);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            singleSignOnUserIdentifier(model.singleSignOnUserIdentifier);
            singleSignOnUserValue(model.singleSignOnUserValue);
            userSettings(model.userSettings);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileArn() {
            return userProfileArn;
        }

        public final void setUserProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
        }

        @Override
        public final Builder userProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
            return this;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final String getHomeEfsFileSystemUid() {
            return homeEfsFileSystemUid;
        }

        public final void setHomeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
        }

        @Override
        public final Builder homeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getSingleSignOnUserIdentifier() {
            return singleSignOnUserIdentifier;
        }

        public final void setSingleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
        }

        @Override
        public final Builder singleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
            return this;
        }

        public final String getSingleSignOnUserValue() {
            return singleSignOnUserValue;
        }

        public final void setSingleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
        }

        @Override
        public final Builder singleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
            return this;
        }

        public final UserSettings.Builder getUserSettings() {
            return userSettings != null ? userSettings.toBuilder() : null;
        }

        public final void setUserSettings(UserSettings.BuilderImpl userSettings) {
            this.userSettings = userSettings != null ? userSettings.build() : null;
        }

        @Override
        public final Builder userSettings(UserSettings userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        @Override
        public DescribeUserProfileResponse build() {
            return new DescribeUserProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
