/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.ConflictException;
import software.amazon.awssdk.services.sagemaker.model.CreateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListActionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListActionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListContextsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListContextsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceInUseException;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.sagemaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.SageMakerException;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListContextsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListImagesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionStepsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineParametersForExecutionIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelinesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListProcessingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListStageDevicesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListStudioLifecycleConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialComponentsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListUserProfilesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkforcesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.QueryLineageIterable;
import software.amazon.awssdk.services.sagemaker.paginators.SearchIterable;
import software.amazon.awssdk.services.sagemaker.transform.AddAssociationRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.AssociateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.BatchDescribeModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedDomainUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedNotebookInstanceUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAssociationRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeregisterDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFeatureMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeLineageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineDefinitionForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeSubscribedWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DisableSagemakerServicecatalogPortfolioRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DisassociateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.EnableSagemakerServicecatalogPortfolioRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetDeviceFleetReportRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetLineageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetSagemakerServicecatalogPortfolioStatusRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetSearchSuggestionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListActionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAlgorithmsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAppImageConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListArtifactsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAutoMlJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCandidatesForAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCodeRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCompilationJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListContextsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDataQualityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDeviceFleetsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEdgeDeploymentPlansRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEdgePackagingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListExperimentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListFeatureGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListFlowDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHumanTaskUisRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHyperParameterTuningJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListImageVersionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListInferenceRecommendationsJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLabelingJobsForWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLabelingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLineageGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelBiasJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelExplainabilityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelPackageGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelPackagesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelQualityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringSchedulesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstanceLifecycleConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstancesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineExecutionStepsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineParametersForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListProcessingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListStageDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListStudioLifecycleConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListSubscribedWorkteamsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsForHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTransformJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrialComponentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrialsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListUserProfilesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListWorkforcesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListWorkteamsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.PutModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.QueryLineageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RegisterDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RenderUiTemplateRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RetryPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SearchRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SendPipelineExecutionStepFailureRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SendPipelineExecutionStepSuccessRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointWeightsAndCapacitiesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateFeatureMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdatePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.waiters.SageMakerWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link SageMakerClient}.
 *
 * @see SageMakerClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSageMakerClient implements SageMakerClient {
    private static final Logger log = Logger.loggerFor(DefaultSageMakerClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSageMakerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates an <i>association</i> between the source and the destination. A source can be associated with multiple
     * destinations, and a destination can be associated with multiple sources. An association is a lineage tracking
     * entity. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param addAssociationRequest
     * @return Result of the AddAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddAssociationResponse addAssociation(AddAssociationRequest addAssociationRequest) throws ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddAssociation");

            return clientHandler.execute(new ClientExecutionParams<AddAssociationRequest, AddAssociationResponse>()
                    .withOperationName("AddAssociation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances,
     * training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
     * configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging
     * Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of
     * <a>CreateHyperParameterTuningJob</a>
     * </p>
     * </note> <note>
     * <p>
     * Tags that you add to a SageMaker Studio Domain or User Profile by calling this API are also added to any Apps
     * that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile
     * launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also
     * added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User
     * Profile by specifying them in the <code>Tags</code> parameter of <a>CreateDomain</a> or <a>CreateUserProfile</a>.
     * </p>
     * </note>
     *
     * @param addTagsRequest
     * @return Result of the AddTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");

            return clientHandler.execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>()
                    .withOperationName("AddTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addTagsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new AddTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To
     * disassociate a trial component from a trial, call the <a>DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param associateTrialComponentRequest
     * @return Result of the AssociateTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AssociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTrialComponentResponse associateTrialComponent(AssociateTrialComponentRequest associateTrialComponentRequest)
            throws ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateTrialComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrialComponent");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTrialComponentRequest, AssociateTrialComponentResponse>()
                            .withOperationName("AssociateTrialComponent").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateTrialComponentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTrialComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action batch describes a list of versioned model packages
     * </p>
     *
     * @param batchDescribeModelPackageRequest
     * @return Result of the BatchDescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.BatchDescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDescribeModelPackageResponse batchDescribeModelPackage(
            BatchDescribeModelPackageRequest batchDescribeModelPackageRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDescribeModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDescribeModelPackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDescribeModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDescribeModelPackage");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeModelPackageRequest, BatchDescribeModelPackageResponse>()
                            .withOperationName("BatchDescribeModelPackage").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(batchDescribeModelPackageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDescribeModelPackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For
     * example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon
     * SageMaker ML Lineage Tracking</a>.
     * </p>
     *
     * @param createActionRequest
     * @return Result of the CreateAction operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateActionResponse createAction(CreateActionRequest createActionRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAction");

            return clientHandler.execute(new ClientExecutionParams<CreateActionRequest, CreateActionResponse>()
                    .withOperationName("CreateAction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services
     * Marketplace.
     * </p>
     *
     * @param createAlgorithmRequest
     * @return Result of the CreateAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAlgorithmResponse createAlgorithm(CreateAlgorithmRequest createAlgorithmRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAlgorithmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlgorithm");

            return clientHandler.execute(new ClientExecutionParams<CreateAlgorithmRequest, CreateAlgorithmResponse>()
                    .withOperationName("CreateAlgorithm").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAlgorithmRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAlgorithmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a running app for the specified UserProfile. Supported apps are <code>JupyterServer</code> and
     * <code>KernelGateway</code>. This operation is automatically invoked by Amazon SageMaker Studio upon access to the
     * associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps
     * active simultaneously.
     * </p>
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws ResourceLimitExceededException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");

            return clientHandler.execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>()
                    .withOperationName("CreateApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAppRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the
     * Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.
     * </p>
     *
     * @param createAppImageConfigRequest
     * @return Result of the CreateAppImageConfig operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAppImageConfigResponse createAppImageConfig(CreateAppImageConfigRequest createAppImageConfigRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAppImageConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppImageConfig");

            return clientHandler.execute(new ClientExecutionParams<CreateAppImageConfigRequest, CreateAppImageConfigResponse>()
                    .withOperationName("CreateAppImageConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAppImageConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAppImageConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or
     * data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createArtifactRequest
     * @return Result of the CreateArtifact operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateArtifactResponse createArtifact(CreateArtifactRequest createArtifactRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateArtifactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateArtifact");

            return clientHandler.execute(new ClientExecutionParams<CreateArtifactRequest, CreateArtifactResponse>()
                    .withOperationName("CreateArtifact").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createArtifactRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Autopilot job.
     * </p>
     * <p>
     * Find the best-performing model after you run an Autopilot job by calling .
     * </p>
     * <p>
     * For information about how to use Autopilot, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html">Automate Model
     * Development with Amazon SageMaker Autopilot</a>.
     * </p>
     *
     * @param createAutoMlJobRequest
     * @return Result of the CreateAutoMLJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAutoMlJobResponse createAutoMLJob(CreateAutoMlJobRequest createAutoMlJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAutoMlJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAutoMLJob");

            return clientHandler.execute(new ClientExecutionParams<CreateAutoMlJobRequest, CreateAutoMlJobResponse>()
                    .withOperationName("CreateAutoMLJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAutoMlJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAutoMlJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook
     * instances so that you can use Git source control for the notebooks you create. The Git repository is a resource
     * in your SageMaker account, so it can be associated with more than one notebook instance, and it persists
     * independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository.
     * </p>
     *
     * @param createCodeRepositoryRequest
     * @return Result of the CreateCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCodeRepositoryResponse createCodeRepository(CreateCodeRepositoryRequest createCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCodeRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCodeRepository");

            return clientHandler.execute(new ClientExecutionParams<CreateCodeRepositoryRequest, CreateCodeRepositoryResponse>()
                    .withOperationName("CreateCodeRepository").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createCodeRepositoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCodeRepositoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that
     * case, deploy them as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a>StopCompilationJob</a>. To get information about a particular model
     * compilation job, use <a>DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use
     * <a>ListCompilationJobs</a>.
     * </p>
     *
     * @param createCompilationJobRequest
     * @return Result of the CreateCompilationJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCompilationJobResponse createCompilationJob(CreateCompilationJobRequest createCompilationJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCompilationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCompilationJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCompilationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCompilationJob");

            return clientHandler.execute(new ClientExecutionParams<CreateCompilationJobRequest, CreateCompilationJobResponse>()
                    .withOperationName("CreateCompilationJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createCompilationJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCompilationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other
     * tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createContextRequest
     * @return Result of the CreateContext operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateContextResponse createContext(CreateContextRequest createContextRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateContextResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContext");

            return clientHandler.execute(new ClientExecutionParams<CreateContextRequest, CreateContextResponse>()
                    .withOperationName("CreateContext").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createContextRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateContextRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.
     * </p>
     *
     * @param createDataQualityJobDefinitionRequest
     * @return Result of the CreateDataQualityJobDefinition operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDataQualityJobDefinitionResponse createDataQualityJobDefinition(
            CreateDataQualityJobDefinitionRequest createDataQualityJobDefinitionRequest) throws ResourceLimitExceededException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDataQualityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataQualityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDataQualityJobDefinitionRequest, CreateDataQualityJobDefinitionResponse>()
                            .withOperationName("CreateDataQualityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDataQualityJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDataQualityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a device fleet.
     * </p>
     *
     * @param createDeviceFleetRequest
     * @return Result of the CreateDeviceFleet operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDeviceFleetResponse createDeviceFleet(CreateDeviceFleetRequest createDeviceFleetRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDeviceFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceFleet");

            return clientHandler.execute(new ClientExecutionParams<CreateDeviceFleetRequest, CreateDeviceFleetResponse>()
                    .withOperationName("CreateDeviceFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDeviceFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDeviceFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>Domain</code> used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic
     * File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon
     * Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region.
     * Users within a domain can share notebook files and other artifacts with each other.
     * </p>
     * <p>
     * <b>EFS storage</b>
     * </p>
     * <p>
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user
     * receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     * </p>
     * <p>
     * SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume
     * attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a
     * customer managed key. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using
     * Encryption</a>.
     * </p>
     * <p>
     * <b>VPC configuration</b>
     * </p>
     * <p>
     * All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For
     * other Studio traffic, you can specify the <code>AppNetworkAccessType</code> parameter.
     * <code>AppNetworkAccessType</code> corresponds to the network access type that you choose when you onboard to
     * Studio. The following options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows
     * internet access. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets. Internet access is disabled
     * by default. To allow internet access, you must specify a NAT gateway.
     * </p>
     * <p>
     * When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless
     * your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups
     * allow outbound connections.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a
     * SageMaker Studio app successfully.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect
     * SageMaker Studio Notebooks to Resources in a VPC</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws ResourceLimitExceededException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomain");

            return clientHandler.execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                    .withOperationName("CreateDomain").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment
     * configuration and devices.
     * </p>
     *
     * @param createEdgeDeploymentPlanRequest
     * @return Result of the CreateEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEdgeDeploymentPlanResponse createEdgeDeploymentPlan(
            CreateEdgeDeploymentPlanRequest createEdgeDeploymentPlanRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEdgeDeploymentPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgeDeploymentPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEdgeDeploymentPlanRequest, CreateEdgeDeploymentPlanResponse>()
                            .withOperationName("CreateEdgeDeploymentPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createEdgeDeploymentPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEdgeDeploymentPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new stage in an existing edge deployment plan.
     * </p>
     *
     * @param createEdgeDeploymentStageRequest
     * @return Result of the CreateEdgeDeploymentStage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEdgeDeploymentStageResponse createEdgeDeploymentStage(
            CreateEdgeDeploymentStageRequest createEdgeDeploymentStageRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEdgeDeploymentStageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEdgeDeploymentStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgeDeploymentStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgeDeploymentStage");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEdgeDeploymentStageRequest, CreateEdgeDeploymentStageResponse>()
                            .withOperationName("CreateEdgeDeploymentStage").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createEdgeDeploymentStageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEdgeDeploymentStageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon
     * Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the
     * resulting artifacts to an S3 bucket that you specify.
     * </p>
     *
     * @param createEdgePackagingJobRequest
     * @return Result of the CreateEdgePackagingJob operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEdgePackagingJobResponse createEdgePackagingJob(CreateEdgePackagingJobRequest createEdgePackagingJobRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEdgePackagingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEdgePackagingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgePackagingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgePackagingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEdgePackagingJobRequest, CreateEdgePackagingJobResponse>()
                            .withOperationName("CreateEdgePackagingJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createEdgePackagingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEdgePackagingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to
     * provision resources and deploy models. You create the endpoint configuration with the <a>CreateEndpointConfig</a>
     * API.
     * </p>
     * <p>
     * Use this API to deploy models using SageMaker hosting services.
     * </p>
     * <p>
     * For an example that calls this method when deploying a model to SageMaker hosting services, see the <a href=
     * "https://github.com/aws/amazon-sagemaker-examples/blob/master/sagemaker-fundamentals/create-endpoint/create_endpoint.ipynb"
     * >Create Endpoint example notebook.</a>
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     * </p>
     * <p>
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and
     * deploys the model(s) on them.
     * </p>
     * <note>
     * <p>
     * When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration
     * exists. When you read data from a DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a
     * DynamoDB eventually consistent read.
     * </p>
     * </note>
     * <p>
     * When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the
     * endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for
     * inferences. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web
     * Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services
     * STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a
     * region, you need to reactivate Amazon Web Services STS for that region. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services Identity
     * and Access Management User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To add the IAM role policies for using this API operation, go to the <a
     * href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search
     * the IAM role that you want to grant access to use the <a>CreateEndpoint</a> and <a>CreateEndpointConfig</a> API
     * operations, add the following policies to the role.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the
     * JSON file of the IAM role:
     * </p>
     * <p>
     * <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code>
     * </p>
     * <p>
     * <code>"Resource": [</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions:
     * Actions, Permissions, and Resources Reference</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpoint");

            return clientHandler.execute(new ClientExecutionParams<CreateEndpointRequest, CreateEndpointResponse>()
                    .withOperationName("CreateEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration,
     * you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that
     * you want SageMaker to provision. Then you call the <a>CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API if you want to use SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This
     * includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and
     * one-third to model B.
     * </p>
     * <note>
     * <p>
     * When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration
     * exists. When you read data from a DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a
     * DynamoDB eventually consistent read.
     * </p>
     * </note>
     *
     * @param createEndpointConfigRequest
     * @return Result of the CreateEndpointConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEndpointConfigResponse createEndpointConfig(CreateEndpointConfigRequest createEndpointConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEndpointConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointConfig");

            return clientHandler.execute(new ClientExecutionParams<CreateEndpointConfigRequest, CreateEndpointConfigResponse>()
                    .withOperationName("CreateEndpointConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createEndpointConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEndpointConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed,
     * compared and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a
     * machine learning model.
     * </p>
     * <p>
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are
     * performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the
     * remaining inputs constant.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to experiments, trials, trial components and then use the <a>Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a
     * description later, or to change the description, call the <a>UpdateExperiment</a> API.
     * </p>
     * <p>
     * To get a list of all your experiments, call the <a>ListExperiments</a> API. To view an experiment's properties,
     * call the <a>DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the
     * <a>ListTrials</a> API. To create a trial call the <a>CreateTrial</a> API.
     * </p>
     *
     * @param createExperimentRequest
     * @return Result of the CreateExperiment operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateExperimentResponse createExperiment(CreateExperimentRequest createExperimentRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateExperimentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateExperimentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExperiment");

            return clientHandler.execute(new ClientExecutionParams<CreateExperimentRequest, CreateExperimentResponse>()
                    .withOperationName("CreateExperiment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createExperimentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateExperimentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined
     * in the <code>FeatureStore</code> to describe a <code>Record</code>.
     * </p>
     * <p>
     * The <code>FeatureGroup</code> defines the schema and features contained in the FeatureGroup. A
     * <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a
     * <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service
     * quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.
     * </p>
     * <important>
     * <p>
     * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a
     * <code>FeatureGroup</code>.
     * </p>
     * </important>
     *
     * @param createFeatureGroupRequest
     * @return Result of the CreateFeatureGroup operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateFeatureGroupResponse createFeatureGroup(CreateFeatureGroupRequest createFeatureGroupRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFeatureGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFeatureGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateFeatureGroupRequest, CreateFeatureGroupResponse>()
                    .withOperationName("CreateFeatureGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createFeatureGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFeatureGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a flow definition.
     * </p>
     *
     * @param createFlowDefinitionRequest
     * @return Result of the CreateFlowDefinition operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFlowDefinitionResponse createFlowDefinition(CreateFlowDefinitionRequest createFlowDefinitionRequest)
            throws ResourceLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFlowDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlowDefinition");

            return clientHandler.execute(new ClientExecutionParams<CreateFlowDefinitionRequest, CreateFlowDefinitionResponse>()
                    .withOperationName("CreateFlowDefinition").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createFlowDefinitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFlowDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel
     * interface with an instruction area, the item to review, and an input area.
     * </p>
     *
     * @param createHumanTaskUiRequest
     * @return Result of the CreateHumanTaskUi operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateHumanTaskUiResponse createHumanTaskUi(CreateHumanTaskUiRequest createHumanTaskUiRequest)
            throws ResourceLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateHumanTaskUiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHumanTaskUi");

            return clientHandler.execute(new ClientExecutionParams<CreateHumanTaskUiRequest, CreateHumanTaskUiResponse>()
                    .withOperationName("CreateHumanTaskUi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createHumanTaskUiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateHumanTaskUiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     *
     * @param createHyperParameterTuningJobRequest
     * @return Result of the CreateHyperParameterTuningJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateHyperParameterTuningJobResponse createHyperParameterTuningJob(
            CreateHyperParameterTuningJobRequest createHyperParameterTuningJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateHyperParameterTuningJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateHyperParameterTuningJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHyperParameterTuningJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateHyperParameterTuningJobRequest, CreateHyperParameterTuningJobResponse>()
                            .withOperationName("CreateHyperParameterTuningJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createHyperParameterTuningJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateHyperParameterTuningJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a
     * container image stored in Amazon Elastic Container Registry (ECR). For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.
     * </p>
     *
     * @param createImageRequest
     * @return Result of the CreateImage operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateImageResponse createImage(CreateImageRequest createImageRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");

            return clientHandler.execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                    .withOperationName("CreateImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a version of the SageMaker image specified by <code>ImageName</code>. The version represents the Amazon
     * Elastic Container Registry (ECR) container image specified by <code>BaseImage</code>.
     * </p>
     *
     * @param createImageVersionRequest
     * @return Result of the CreateImageVersion operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateImageVersionResponse createImageVersion(CreateImageVersionRequest createImageVersionRequest)
            throws ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateImageVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateImageVersionRequest, CreateImageVersionResponse>()
                    .withOperationName("CreateImageVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createImageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     * </p>
     *
     * @param createInferenceRecommendationsJobRequest
     * @return Result of the CreateInferenceRecommendationsJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInferenceRecommendationsJobResponse createInferenceRecommendationsJob(
            CreateInferenceRecommendationsJobRequest createInferenceRecommendationsJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInferenceRecommendationsJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateInferenceRecommendationsJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInferenceRecommendationsJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInferenceRecommendationsJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInferenceRecommendationsJobRequest, CreateInferenceRecommendationsJobResponse>()
                            .withOperationName("CreateInferenceRecommendationsJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createInferenceRecommendationsJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateInferenceRecommendationsJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in
     * specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <p>
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job
     * stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled.
     * A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send
     * new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to
     * create a static labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job
     * (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling
     * Job</a>.
     * </p>
     *
     * @param createLabelingJobRequest
     * @return Result of the CreateLabelingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateLabelingJobResponse createLabelingJob(CreateLabelingJobRequest createLabelingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLabelingJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateLabelingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLabelingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLabelingJob");

            return clientHandler.execute(new ClientExecutionParams<CreateLabelingJobRequest, CreateLabelingJobResponse>()
                    .withOperationName("CreateLabelingJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createLabelingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLabelingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the Docker image that contains inference code, artifacts (from prior training),
     * and a custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that
     * you defined for the model in the hosting environment.
     * </p>
     * <p>
     * For an example that calls this method when deploying a model to SageMaker hosting services, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/realtime-endpoints-deployment.html#realtime-endpoints-deployment-create-model"
     * >Create a Model (Amazon Web Services SDK for Python (Boto 3)).</a>
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API.
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image
     * for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM
     * role to manage permissions the inference code needs. For example, if the inference code access any other Amazon
     * Web Services resources, you grant necessary permissions via this role.
     * </p>
     *
     * @param createModelRequest
     * @return Result of the CreateModel operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateModelResponse createModel(CreateModelRequest createModelRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");

            return clientHandler.execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                    .withOperationName("CreateModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the definition for a model bias job.
     * </p>
     *
     * @param createModelBiasJobDefinitionRequest
     * @return Result of the CreateModelBiasJobDefinition operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateModelBiasJobDefinitionResponse createModelBiasJobDefinition(
            CreateModelBiasJobDefinitionRequest createModelBiasJobDefinitionRequest) throws ResourceLimitExceededException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateModelBiasJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelBiasJobDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelBiasJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateModelBiasJobDefinitionRequest, CreateModelBiasJobDefinitionResponse>()
                            .withOperationName("CreateModelBiasJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createModelBiasJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateModelBiasJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the definition for a model explainability job.
     * </p>
     *
     * @param createModelExplainabilityJobDefinitionRequest
     * @return Result of the CreateModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateModelExplainabilityJobDefinitionResponse createModelExplainabilityJobDefinition(
            CreateModelExplainabilityJobDefinitionRequest createModelExplainabilityJobDefinitionRequest)
            throws ResourceLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateModelExplainabilityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelExplainabilityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateModelExplainabilityJobDefinitionRequest, CreateModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("CreateModelExplainabilityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(createModelExplainabilityJobDefinitionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace,
     * or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web
     * Services Marketplace to create models in SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <note>
     * <p>
     * There are two types of model packages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Versioned - a model that is part of a model group in the model registry.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unversioned - a model package that is not part of a model group.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createModelPackageRequest
     * @return Result of the CreateModelPackage operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateModelPackageResponse createModelPackage(CreateModelPackageRequest createModelPackageRequest)
            throws ConflictException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateModelPackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelPackage");

            return clientHandler.execute(new ClientExecutionParams<CreateModelPackageRequest, CreateModelPackageResponse>()
                    .withOperationName("CreateModelPackage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createModelPackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateModelPackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a model group. A model group contains a group of model versions.
     * </p>
     *
     * @param createModelPackageGroupRequest
     * @return Result of the CreateModelPackageGroup operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateModelPackageGroupResponse createModelPackageGroup(CreateModelPackageGroupRequest createModelPackageGroupRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateModelPackageGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelPackageGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateModelPackageGroupRequest, CreateModelPackageGroupResponse>()
                            .withOperationName("CreateModelPackageGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createModelPackageGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateModelPackageGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.
     * </p>
     *
     * @param createModelQualityJobDefinitionRequest
     * @return Result of the CreateModelQualityJobDefinition operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateModelQualityJobDefinitionResponse createModelQualityJobDefinition(
            CreateModelQualityJobDefinitionRequest createModelQualityJobDefinitionRequest) throws ResourceLimitExceededException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateModelQualityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelQualityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateModelQualityJobDefinitionRequest, CreateModelQualityJobDefinitionResponse>()
                            .withOperationName("CreateModelQualityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createModelQualityJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateModelQualityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an
     * Amazon SageMaker Endoint.
     * </p>
     *
     * @param createMonitoringScheduleRequest
     * @return Result of the CreateMonitoringSchedule operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMonitoringScheduleResponse createMonitoringSchedule(
            CreateMonitoringScheduleRequest createMonitoringScheduleRequest) throws ResourceLimitExceededException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMonitoringScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMonitoringSchedule");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMonitoringScheduleRequest, CreateMonitoringScheduleResponse>()
                            .withOperationName("CreateMonitoringSchedule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createMonitoringScheduleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMonitoringScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running
     * on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * SageMaker launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker with a
     * specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, SageMaker does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the SageMaker VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, SageMaker creates a network interface in your own VPC, which is
     * inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker
     * attaches the security group that you specified in the request to the network interface that it creates in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the SageMaker VPC. If you specified
     * <code>SubnetId</code> of your VPC, SageMaker specifies both network interfaces when launching this instance. This
     * enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, SageMaker returns its Amazon Resource Name (ARN). You can't change the name
     * of a notebook instance after you create it.
     * </p>
     * <p>
     * After SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating SageMaker endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     *
     * @param createNotebookInstanceRequest
     * @return Result of the CreateNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNotebookInstanceResponse createNotebookInstance(CreateNotebookInstanceRequest createNotebookInstanceRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateNotebookInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebookInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNotebookInstanceRequest, CreateNotebookInstanceResponse>()
                            .withOperationName("CreateNotebookInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createNotebookInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNotebookInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     * @return Result of the CreateNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNotebookInstanceLifecycleConfigResponse createNotebookInstanceLifecycleConfig(
            CreateNotebookInstanceLifecycleConfigRequest createNotebookInstanceLifecycleConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateNotebookInstanceLifecycleConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebookInstanceLifecycleConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNotebookInstanceLifecycleConfigRequest, CreateNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("CreateNotebookInstanceLifecycleConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(createNotebookInstanceLifecycleConfigRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a pipeline using a JSON pipeline definition.
     * </p>
     *
     * @param createPipelineRequest
     * @return Result of the CreatePipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePipelineResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePipeline");

            return clientHandler.execute(new ClientExecutionParams<CreatePipelineRequest, CreatePipelineResponse>()
                    .withOperationName("CreatePipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be
     * automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated
     * with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the
     * authentication mode equals IAM.
     * </p>
     * <p>
     * The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is
     * created, no additional permission is required to access this URL. IAM authorization policies for this API are
     * also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or
     * Amazon VPC Endpoints that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to SageMaker Studio
     * Through an Interface VPC Endpoint</a> .
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You
     * can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit
     * expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </note>
     *
     * @param createPresignedDomainUrlRequest
     * @return Result of the CreatePresignedDomainUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedDomainUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePresignedDomainUrlResponse createPresignedDomainUrl(
            CreatePresignedDomainUrlRequest createPresignedDomainUrlRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePresignedDomainUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePresignedDomainUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPresignedDomainUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedDomainUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedDomainUrlRequest, CreatePresignedDomainUrlResponse>()
                            .withOperationName("CreatePresignedDomainUrl").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createPresignedDomainUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePresignedDomainUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker
     * console, when you choose <code>Open</code> next to a notebook instance, SageMaker opens a new tab showing the
     * Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the
     * presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for
     * this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook
     * instance.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify.
     * Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to
     * specify the list of IP addresses that you want to have access to the notebook instance. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter"
     * >Limit Access to a Notebook Instance by IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <a>CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you
     * try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in
     * page.
     * </p>
     * </note>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     * @return Result of the CreatePresignedNotebookInstanceUrl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePresignedNotebookInstanceUrlResponse createPresignedNotebookInstanceUrl(
            CreatePresignedNotebookInstanceUrlRequest createPresignedNotebookInstanceUrlRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePresignedNotebookInstanceUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePresignedNotebookInstanceUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPresignedNotebookInstanceUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedNotebookInstanceUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedNotebookInstanceUrlRequest, CreatePresignedNotebookInstanceUrlResponse>()
                            .withOperationName("CreatePresignedNotebookInstanceUrl").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createPresignedNotebookInstanceUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePresignedNotebookInstanceUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a processing job.
     * </p>
     *
     * @param createProcessingJobRequest
     * @return Result of the CreateProcessingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateProcessingJobResponse createProcessingJob(CreateProcessingJobRequest createProcessingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProcessingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProcessingJob");

            return clientHandler.execute(new ClientExecutionParams<CreateProcessingJobRequest, CreateProcessingJobResponse>()
                    .withOperationName("CreateProcessingJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createProcessingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateProcessingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from
     * training to deploying an approved model.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");

            return clientHandler.execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                    .withOperationName("CreateProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Studio Lifecycle Configuration.
     * </p>
     *
     * @param createStudioLifecycleConfigRequest
     * @return Result of the CreateStudioLifecycleConfig operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStudioLifecycleConfigResponse createStudioLifecycleConfig(
            CreateStudioLifecycleConfigRequest createStudioLifecycleConfigRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStudioLifecycleConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStudioLifecycleConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStudioLifecycleConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateStudioLifecycleConfigRequest, CreateStudioLifecycleConfigResponse>()
                            .withOperationName("CreateStudioLifecycleConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createStudioLifecycleConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateStudioLifecycleConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon
     * S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as
     * part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided
     * that you know how to use them for inference.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <important>
     * <p>
     * You must not include any security-sensitive information, such as account access IDs, secrets, and tokens, in the
     * dictionary for configuring hyperparameters. SageMaker rejects the training job request and returns an exception
     * error for detected credentials, if such user input is found.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of
     * model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf
     * during model training. You must grant this role the necessary permissions so that SageMaker can successfully
     * complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> - The environment variables to set in the Docker container.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an
     * <code>InternalServerError</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     *
     * @param createTrainingJobRequest
     * @return Result of the CreateTrainingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTrainingJobResponse createTrainingJob(CreateTrainingJobRequest createTrainingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTrainingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainingJob");

            return clientHandler.execute(new ClientExecutionParams<CreateTrainingJobRequest, CreateTrainingJobResponse>()
                    .withOperationName("CreateTrainingJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTrainingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrainingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web
     * Services Region in an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on
     * creating a model, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances for the transform job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     *
     * @param createTransformJobRequest
     * @return Result of the CreateTransformJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTransformJobResponse createTransformJob(CreateTransformJobRequest createTransformJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTransformJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransformJob");

            return clientHandler.execute(new ClientExecutionParams<CreateTransformJobRequest, CreateTransformJobResponse>()
                    .withOperationName("CreateTransformJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTransformJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTransformJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a
     * machine learning model. A trial is part of a single SageMaker <i>experiment</i>.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial and then use the <a>Search</a> API to search for the tags.
     * </p>
     * <p>
     * To get a list of all your trials, call the <a>ListTrials</a> API. To view a trial's properties, call the
     * <a>DescribeTrial</a> API. To create a trial component, call the <a>CreateTrialComponent</a> API.
     * </p>
     *
     * @param createTrialRequest
     * @return Result of the CreateTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTrialResponse createTrial(CreateTrialRequest createTrialRequest) throws ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTrialResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrial");

            return clientHandler.execute(new ClientExecutionParams<CreateTrialRequest, CreateTrialResponse>()
                    .withOperationName("CreateTrial").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTrialRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrialRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one
     * or more trial components. A trial component can be used in multiple trials.
     * </p>
     * <p>
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial component and then use the <a>Search</a> API to search for the tags.
     * </p>
     *
     * @param createTrialComponentRequest
     * @return Result of the CreateTrialComponent operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrialComponentResponse createTrialComponent(CreateTrialComponentRequest createTrialComponentRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTrialComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrialComponent");

            return clientHandler.execute(new ClientExecutionParams<CreateTrialComponentRequest, CreateTrialComponentResponse>()
                    .withOperationName("CreateTrialComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTrialComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrialComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference
     * a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when
     * a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from
     * Amazon Web Services SSO, a user profile is automatically created. A user profile is the primary holder of
     * settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home
     * directory.
     * </p>
     *
     * @param createUserProfileRequest
     * @return Result of the CreateUserProfile operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUserProfileResponse createUserProfile(CreateUserProfileRequest createUserProfileRequest)
            throws ResourceLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateUserProfileRequest, CreateUserProfileResponse>()
                    .withOperationName("CreateUserProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUserProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in
     * the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services
     * Region per Amazon Web Services account.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the
     * API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new
     * workforce.
     * </p>
     * <p>
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in
     * <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private
     * Workforce (Amazon Cognito)</a>.
     * </p>
     * <p>
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in
     * <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and
     * Amazon A2I to create work teams. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private
     * Workforce (OIDC IdP)</a>.
     * </p>
     *
     * @param createWorkforceRequest
     * @return Result of the CreateWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkforceResponse createWorkforce(CreateWorkforceRequest createWorkforceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkforceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkforce");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkforceRequest, CreateWorkforceResponse>()
                    .withOperationName("CreateWorkforce").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWorkforceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkforceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     *
     * @param createWorkteamRequest
     * @return Result of the CreateWorkteam operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkteamResponse createWorkteam(CreateWorkteamRequest createWorkteamRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkteamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkteam");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkteamRequest, CreateWorkteamResponse>()
                    .withOperationName("CreateWorkteam").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWorkteamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkteamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an action.
     * </p>
     *
     * @param deleteActionRequest
     * @return Result of the DeleteAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteActionResponse deleteAction(DeleteActionRequest deleteActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAction");

            return clientHandler.execute(new ClientExecutionParams<DeleteActionRequest, DeleteActionResponse>()
                    .withOperationName("DeleteAction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     *
     * @param deleteAlgorithmRequest
     * @return Result of the DeleteAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAlgorithmResponse deleteAlgorithm(DeleteAlgorithmRequest deleteAlgorithmRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAlgorithmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlgorithm");

            return clientHandler.execute(new ClientExecutionParams<DeleteAlgorithmRequest, DeleteAlgorithmResponse>()
                    .withOperationName("DeleteAlgorithm").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAlgorithmRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAlgorithmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Used to stop and delete an app.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws ResourceInUseException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>()
                    .withOperationName("DeleteApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAppRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an AppImageConfig.
     * </p>
     *
     * @param deleteAppImageConfigRequest
     * @return Result of the DeleteAppImageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppImageConfigResponse deleteAppImageConfig(DeleteAppImageConfigRequest deleteAppImageConfigRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppImageConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppImageConfig");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppImageConfigRequest, DeleteAppImageConfigResponse>()
                    .withOperationName("DeleteAppImageConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAppImageConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppImageConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.
     * </p>
     *
     * @param deleteArtifactRequest
     * @return Result of the DeleteArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteArtifactResponse deleteArtifact(DeleteArtifactRequest deleteArtifactRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteArtifactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteArtifact");

            return clientHandler.execute(new ClientExecutionParams<DeleteArtifactRequest, DeleteArtifactResponse>()
                    .withOperationName("DeleteArtifact").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteArtifactRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an association.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAssociationResponse deleteAssociation(DeleteAssociationRequest deleteAssociationRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssociation");

            return clientHandler.execute(new ClientExecutionParams<DeleteAssociationRequest, DeleteAssociationResponse>()
                    .withOperationName("DeleteAssociation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     * @return Result of the DeleteCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCodeRepositoryResponse deleteCodeRepository(DeleteCodeRepositoryRequest deleteCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCodeRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCodeRepository");

            return clientHandler.execute(new ClientExecutionParams<DeleteCodeRepositoryRequest, DeleteCodeRepositoryResponse>()
                    .withOperationName("DeleteCodeRepository").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteCodeRepositoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCodeRepositoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an context.
     * </p>
     *
     * @param deleteContextRequest
     * @return Result of the DeleteContext operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteContextResponse deleteContext(DeleteContextRequest deleteContextRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteContextResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContext");

            return clientHandler.execute(new ClientExecutionParams<DeleteContextRequest, DeleteContextResponse>()
                    .withOperationName("DeleteContext").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteContextRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteContextRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a data quality monitoring job definition.
     * </p>
     *
     * @param deleteDataQualityJobDefinitionRequest
     * @return Result of the DeleteDataQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDataQualityJobDefinitionResponse deleteDataQualityJobDefinition(
            DeleteDataQualityJobDefinitionRequest deleteDataQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDataQualityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataQualityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDataQualityJobDefinitionRequest, DeleteDataQualityJobDefinitionResponse>()
                            .withOperationName("DeleteDataQualityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDataQualityJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDataQualityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteDeviceFleetRequest
     * @return Result of the DeleteDeviceFleet operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDeviceFleetResponse deleteDeviceFleet(DeleteDeviceFleetRequest deleteDeviceFleetRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDeviceFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeviceFleet");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeviceFleetRequest, DeleteDeviceFleetResponse>()
                    .withOperationName("DeleteDeviceFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDeviceFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeviceFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again
     * using Amazon Web Services SSO. Use with caution. All of the members of the domain will lose access to their EFS
     * volume, including data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws ResourceInUseException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomain");

            return clientHandler.execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                    .withOperationName("DeleteDomain").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages
     * in the plan.
     * </p>
     *
     * @param deleteEdgeDeploymentPlanRequest
     * @return Result of the DeleteEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEdgeDeploymentPlanResponse deleteEdgeDeploymentPlan(
            DeleteEdgeDeploymentPlanRequest deleteEdgeDeploymentPlanRequest) throws ResourceInUseException, AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEdgeDeploymentPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEdgeDeploymentPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEdgeDeploymentPlanRequest, DeleteEdgeDeploymentPlanResponse>()
                            .withOperationName("DeleteEdgeDeploymentPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteEdgeDeploymentPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEdgeDeploymentPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
     * </p>
     *
     * @param deleteEdgeDeploymentStageRequest
     * @return Result of the DeleteEdgeDeploymentStage operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEdgeDeploymentStageResponse deleteEdgeDeploymentStage(
            DeleteEdgeDeploymentStageRequest deleteEdgeDeploymentStageRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEdgeDeploymentStageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEdgeDeploymentStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEdgeDeploymentStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEdgeDeploymentStage");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEdgeDeploymentStageRequest, DeleteEdgeDeploymentStageResponse>()
                            .withOperationName("DeleteEdgeDeploymentStage").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteEdgeDeploymentStageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEdgeDeploymentStageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     * </p>
     * <p>
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <p>
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key
     * grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do
     * not delete or revoke the permissions for your
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>
     * , otherwise SageMaker cannot delete these resources.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                    .withOperationName("DeleteEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you
     * delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose
     * visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring
     * charges.
     * </p>
     *
     * @param deleteEndpointConfigRequest
     * @return Result of the DeleteEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEndpointConfigResponse deleteEndpointConfig(DeleteEndpointConfigRequest deleteEndpointConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEndpointConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointConfig");

            return clientHandler.execute(new ClientExecutionParams<DeleteEndpointConfigRequest, DeleteEndpointConfigResponse>()
                    .withOperationName("DeleteEndpointConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteEndpointConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEndpointConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the
     * <a>ListTrials</a> API to get a list of the trials associated with the experiment.
     * </p>
     *
     * @param deleteExperimentRequest
     * @return Result of the DeleteExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteExperimentResponse deleteExperiment(DeleteExperimentRequest deleteExperimentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteExperimentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteExperimentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExperiment");

            return clientHandler.execute(new ClientExecutionParams<DeleteExperimentRequest, DeleteExperimentResponse>()
                    .withOperationName("DeleteExperiment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteExperimentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteExperimentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the
     * <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after
     * <code>DeleteFeatureGroup</code> is called.
     * </p>
     * <p>
     * Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and
     * tables that are automatically created for your <code>OfflineStore</code> are not deleted.
     * </p>
     *
     * @param deleteFeatureGroupRequest
     * @return Result of the DeleteFeatureGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteFeatureGroupResponse deleteFeatureGroup(DeleteFeatureGroupRequest deleteFeatureGroupRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFeatureGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFeatureGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteFeatureGroupRequest, DeleteFeatureGroupResponse>()
                    .withOperationName("DeleteFeatureGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteFeatureGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFeatureGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified flow definition.
     * </p>
     *
     * @param deleteFlowDefinitionRequest
     * @return Result of the DeleteFlowDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFlowDefinitionResponse deleteFlowDefinition(DeleteFlowDefinitionRequest deleteFlowDefinitionRequest)
            throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFlowDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlowDefinition");

            return clientHandler.execute(new ClientExecutionParams<DeleteFlowDefinitionRequest, DeleteFlowDefinitionResponse>()
                    .withOperationName("DeleteFlowDefinition").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteFlowDefinitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFlowDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to delete a human task user interface (worker task template).
     * </p>
     * <p>
     * To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker
     * task template, it no longer appears when you call <code>ListHumanTaskUis</code>.
     * </p>
     *
     * @param deleteHumanTaskUiRequest
     * @return Result of the DeleteHumanTaskUi operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteHumanTaskUiResponse deleteHumanTaskUi(DeleteHumanTaskUiRequest deleteHumanTaskUiRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteHumanTaskUiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHumanTaskUi");

            return clientHandler.execute(new ClientExecutionParams<DeleteHumanTaskUiRequest, DeleteHumanTaskUiResponse>()
                    .withOperationName("DeleteHumanTaskUi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteHumanTaskUiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteHumanTaskUiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a SageMaker image and all versions of the image. The container images aren't deleted.
     * </p>
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ResourceInUseException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                    .withOperationName("DeleteImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a version of a SageMaker image. The container image the version represents isn't deleted.
     * </p>
     *
     * @param deleteImageVersionRequest
     * @return Result of the DeleteImageVersion operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteImageVersionResponse deleteImageVersion(DeleteImageVersionRequest deleteImageVersionRequest)
            throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteImageVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageVersionRequest, DeleteImageVersionResponse>()
                    .withOperationName("DeleteImageVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when
     * you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role
     * that you specified when creating the model.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");

            return clientHandler.execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                    .withOperationName("DeleteModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker model bias job definition.
     * </p>
     *
     * @param deleteModelBiasJobDefinitionRequest
     * @return Result of the DeleteModelBiasJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteModelBiasJobDefinitionResponse deleteModelBiasJobDefinition(
            DeleteModelBiasJobDefinitionRequest deleteModelBiasJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteModelBiasJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelBiasJobDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelBiasJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteModelBiasJobDefinitionRequest, DeleteModelBiasJobDefinitionResponse>()
                            .withOperationName("DeleteModelBiasJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelBiasJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteModelBiasJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker model explainability job definition.
     * </p>
     *
     * @param deleteModelExplainabilityJobDefinitionRequest
     * @return Result of the DeleteModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteModelExplainabilityJobDefinitionResponse deleteModelExplainabilityJobDefinition(
            DeleteModelExplainabilityJobDefinitionRequest deleteModelExplainabilityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteModelExplainabilityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelExplainabilityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteModelExplainabilityJobDefinitionRequest, DeleteModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("DeleteModelExplainabilityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteModelExplainabilityJobDefinitionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can
     * subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     * </p>
     *
     * @param deleteModelPackageRequest
     * @return Result of the DeleteModelPackage operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteModelPackageResponse deleteModelPackage(DeleteModelPackageRequest deleteModelPackageRequest)
            throws ConflictException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteModelPackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackage");

            return clientHandler.execute(new ClientExecutionParams<DeleteModelPackageRequest, DeleteModelPackageResponse>()
                    .withOperationName("DeleteModelPackage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelPackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteModelPackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified model group.
     * </p>
     *
     * @param deleteModelPackageGroupRequest
     * @return Result of the DeleteModelPackageGroup operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteModelPackageGroupResponse deleteModelPackageGroup(DeleteModelPackageGroupRequest deleteModelPackageGroupRequest)
            throws ConflictException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteModelPackageGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackageGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageGroupRequest, DeleteModelPackageGroupResponse>()
                            .withOperationName("DeleteModelPackageGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelPackageGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteModelPackageGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a model group resource policy.
     * </p>
     *
     * @param deleteModelPackageGroupPolicyRequest
     * @return Result of the DeleteModelPackageGroupPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteModelPackageGroupPolicyResponse deleteModelPackageGroupPolicy(
            DeleteModelPackageGroupPolicyRequest deleteModelPackageGroupPolicyRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelPackageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteModelPackageGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelPackageGroupPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackageGroupPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageGroupPolicyRequest, DeleteModelPackageGroupPolicyResponse>()
                            .withOperationName("DeleteModelPackageGroupPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelPackageGroupPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteModelPackageGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the secified model quality monitoring job definition.
     * </p>
     *
     * @param deleteModelQualityJobDefinitionRequest
     * @return Result of the DeleteModelQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteModelQualityJobDefinitionResponse deleteModelQualityJobDefinition(
            DeleteModelQualityJobDefinitionRequest deleteModelQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteModelQualityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelQualityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteModelQualityJobDefinitionRequest, DeleteModelQualityJobDefinitionResponse>()
                            .withOperationName("DeleteModelQualityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelQualityJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteModelQualityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job
     * execution history of the monitoring schedule.
     * </p>
     *
     * @param deleteMonitoringScheduleRequest
     * @return Result of the DeleteMonitoringSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMonitoringScheduleResponse deleteMonitoringSchedule(
            DeleteMonitoringScheduleRequest deleteMonitoringScheduleRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMonitoringScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMonitoringSchedule");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMonitoringScheduleRequest, DeleteMonitoringScheduleResponse>()
                            .withOperationName("DeleteMonitoringSchedule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteMonitoringScheduleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMonitoringScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an SageMaker notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. SageMaker removes the ML compute instance, and
     * deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important>
     *
     * @param deleteNotebookInstanceRequest
     * @return Result of the DeleteNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNotebookInstanceResponse deleteNotebookInstance(DeleteNotebookInstanceRequest deleteNotebookInstanceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteNotebookInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebookInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNotebookInstanceRequest, DeleteNotebookInstanceResponse>()
                            .withOperationName("DeleteNotebookInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteNotebookInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNotebookInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     * @return Result of the DeleteNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNotebookInstanceLifecycleConfigResponse deleteNotebookInstanceLifecycleConfig(
            DeleteNotebookInstanceLifecycleConfigRequest deleteNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteNotebookInstanceLifecycleConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebookInstanceLifecycleConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNotebookInstanceLifecycleConfigRequest, DeleteNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("DeleteNotebookInstanceLifecycleConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNotebookInstanceLifecycleConfigRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all
     * running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline,
     * all instances of the pipeline are deleted.
     * </p>
     *
     * @param deletePipelineRequest
     * @return Result of the DeletePipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePipelineResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePipeline");

            return clientHandler.execute(new ClientExecutionParams<DeletePipelineRequest, DeletePipelineResponse>()
                    .withOperationName("DeletePipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the specified project.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ConflictException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");

            return clientHandler.execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                    .withOperationName("DeleteProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no
     * running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from
     * UserSettings in all Domains and UserProfiles.
     * </p>
     *
     * @param deleteStudioLifecycleConfigRequest
     * @return Result of the DeleteStudioLifecycleConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteStudioLifecycleConfigResponse deleteStudioLifecycleConfig(
            DeleteStudioLifecycleConfigRequest deleteStudioLifecycleConfigRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteStudioLifecycleConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioLifecycleConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudioLifecycleConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteStudioLifecycleConfigRequest, DeleteStudioLifecycleConfigResponse>()
                            .withOperationName("DeleteStudioLifecycleConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteStudioLifecycleConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteStudioLifecycleConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified tags from an SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note> <note>
     * <p>
     * When you call this API to delete tags from a SageMaker Studio Domain or User Profile, the deleted tags are not
     * removed from Apps that the SageMaker Studio Domain or User Profile launched before you called this API.
     * </p>
     * </note>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTagsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the
     * <a>DescribeTrialComponent</a> API to get the list of trial components.
     * </p>
     *
     * @param deleteTrialRequest
     * @return Result of the DeleteTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTrialResponse deleteTrial(DeleteTrialRequest deleteTrialRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTrialResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrial");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrialRequest, DeleteTrialResponse>()
                    .withOperationName("DeleteTrial").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTrialRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrialRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial
     * component can be deleted. To disassociate a trial component from a trial, call the
     * <a>DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param deleteTrialComponentRequest
     * @return Result of the DeleteTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrialComponentResponse deleteTrialComponent(DeleteTrialComponentRequest deleteTrialComponentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTrialComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrialComponent");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrialComponentRequest, DeleteTrialComponentResponse>()
                    .withOperationName("DeleteTrialComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTrialComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrialComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including
     * data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteUserProfileRequest
     * @return Result of the DeleteUserProfile operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUserProfileResponse deleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest)
            throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserProfileRequest, DeleteUserProfileResponse>()
                    .withOperationName("DeleteUserProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to delete a workforce.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this
     * operation to delete the existing workforce and then use to create a new workforce.
     * </p>
     * <important>
     * <p>
     * If a private workforce contains one or more work teams, you must use the operation to delete all work teams
     * before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will
     * recieve a <code>ResourceInUse</code> error.
     * </p>
     * </important>
     *
     * @param deleteWorkforceRequest
     * @return Result of the DeleteWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWorkforceResponse deleteWorkforce(DeleteWorkforceRequest deleteWorkforceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkforceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkforce");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkforceRequest, DeleteWorkforceResponse>()
                    .withOperationName("DeleteWorkforce").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteWorkforceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkforceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     *
     * @param deleteWorkteamRequest
     * @return Result of the DeleteWorkteam operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWorkteamResponse deleteWorkteam(DeleteWorkteamRequest deleteWorkteamRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkteamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkteam");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkteamRequest, DeleteWorkteamResponse>()
                    .withOperationName("DeleteWorkteam").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteWorkteamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkteamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     * </p>
     *
     * @param deregisterDevicesRequest
     * @return Result of the DeregisterDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeregisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeregisterDevicesResponse deregisterDevices(DeregisterDevicesRequest deregisterDevicesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeregisterDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterDevices");

            return clientHandler.execute(new ClientExecutionParams<DeregisterDevicesRequest, DeregisterDevicesResponse>()
                    .withOperationName("DeregisterDevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deregisterDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeregisterDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an action.
     * </p>
     *
     * @param describeActionRequest
     * @return Result of the DescribeAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeActionResponse describeAction(DescribeActionRequest describeActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAction");

            return clientHandler.execute(new ClientExecutionParams<DescribeActionRequest, DescribeActionResponse>()
                    .withOperationName("DescribeAction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return Result of the DescribeAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAlgorithmResponse describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAlgorithmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAlgorithm");

            return clientHandler.execute(new ClientExecutionParams<DescribeAlgorithmRequest, DescribeAlgorithmResponse>()
                    .withOperationName("DescribeAlgorithm").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAlgorithmRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAlgorithmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the app.
     * </p>
     *
     * @param describeAppRequest
     * @return Result of the DescribeApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAppResponse describeApp(DescribeAppRequest describeAppRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApp");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppRequest, DescribeAppResponse>()
                    .withOperationName("DescribeApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAppRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an AppImageConfig.
     * </p>
     *
     * @param describeAppImageConfigRequest
     * @return Result of the DescribeAppImageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppImageConfigResponse describeAppImageConfig(DescribeAppImageConfigRequest describeAppImageConfigRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppImageConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppImageConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppImageConfigRequest, DescribeAppImageConfigResponse>()
                            .withOperationName("DescribeAppImageConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAppImageConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppImageConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an artifact.
     * </p>
     *
     * @param describeArtifactRequest
     * @return Result of the DescribeArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeArtifactResponse describeArtifact(DescribeArtifactRequest describeArtifactRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeArtifactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeArtifact");

            return clientHandler.execute(new ClientExecutionParams<DescribeArtifactRequest, DescribeArtifactResponse>()
                    .withOperationName("DescribeArtifact").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeArtifactRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about an Amazon SageMaker AutoML job.
     * </p>
     *
     * @param describeAutoMlJobRequest
     * @return Result of the DescribeAutoMLJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAutoMlJobResponse describeAutoMLJob(DescribeAutoMlJobRequest describeAutoMlJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAutoMlJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutoMLJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeAutoMlJobRequest, DescribeAutoMlJobResponse>()
                    .withOperationName("DescribeAutoMLJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAutoMlJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAutoMlJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     *
     * @param describeCodeRepositoryRequest
     * @return Result of the DescribeCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCodeRepositoryResponse describeCodeRepository(DescribeCodeRepositoryRequest describeCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCodeRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCodeRepository");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCodeRepositoryRequest, DescribeCodeRepositoryResponse>()
                            .withOperationName("DescribeCodeRepository").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeCodeRepositoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCodeRepositoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about multiple model
     * compilation jobs, use <a>ListCompilationJobs</a>.
     * </p>
     *
     * @param describeCompilationJobRequest
     * @return Result of the DescribeCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCompilationJobResponse describeCompilationJob(DescribeCompilationJobRequest describeCompilationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCompilationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCompilationJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCompilationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCompilationJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCompilationJobRequest, DescribeCompilationJobResponse>()
                            .withOperationName("DescribeCompilationJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeCompilationJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCompilationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a context.
     * </p>
     *
     * @param describeContextRequest
     * @return Result of the DescribeContext operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeContextResponse describeContext(DescribeContextRequest describeContextRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeContextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeContextResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeContext");

            return clientHandler.execute(new ClientExecutionParams<DescribeContextRequest, DescribeContextResponse>()
                    .withOperationName("DescribeContext").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeContextRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeContextRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the details of a data quality monitoring job definition.
     * </p>
     *
     * @param describeDataQualityJobDefinitionRequest
     * @return Result of the DescribeDataQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDataQualityJobDefinitionResponse describeDataQualityJobDefinition(
            DescribeDataQualityJobDefinitionRequest describeDataQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDataQualityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataQualityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDataQualityJobDefinitionRequest, DescribeDataQualityJobDefinitionResponse>()
                            .withOperationName("DescribeDataQualityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDataQualityJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDataQualityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDevice");

            return clientHandler.execute(new ClientExecutionParams<DescribeDeviceRequest, DescribeDeviceResponse>()
                    .withOperationName("DescribeDevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A description of the fleet the device belongs to.
     * </p>
     *
     * @param describeDeviceFleetRequest
     * @return Result of the DescribeDeviceFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDeviceFleetResponse describeDeviceFleet(DescribeDeviceFleetRequest describeDeviceFleetRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDeviceFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeviceFleet");

            return clientHandler.execute(new ClientExecutionParams<DescribeDeviceFleetRequest, DescribeDeviceFleetResponse>()
                    .withOperationName("DescribeDeviceFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDeviceFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDeviceFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomain");

            return clientHandler.execute(new ClientExecutionParams<DescribeDomainRequest, DescribeDomainResponse>()
                    .withOperationName("DescribeDomain").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an edge deployment plan with deployment status per stage.
     * </p>
     *
     * @param describeEdgeDeploymentPlanRequest
     * @return Result of the DescribeEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEdgeDeploymentPlanResponse describeEdgeDeploymentPlan(
            DescribeEdgeDeploymentPlanRequest describeEdgeDeploymentPlanRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEdgeDeploymentPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEdgeDeploymentPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEdgeDeploymentPlanRequest, DescribeEdgeDeploymentPlanResponse>()
                            .withOperationName("DescribeEdgeDeploymentPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEdgeDeploymentPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEdgeDeploymentPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A description of edge packaging jobs.
     * </p>
     *
     * @param describeEdgePackagingJobRequest
     * @return Result of the DescribeEdgePackagingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEdgePackagingJobResponse describeEdgePackagingJob(
            DescribeEdgePackagingJobRequest describeEdgePackagingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEdgePackagingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEdgePackagingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEdgePackagingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEdgePackagingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEdgePackagingJobRequest, DescribeEdgePackagingJobResponse>()
                            .withOperationName("DescribeEdgePackagingJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEdgePackagingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEdgePackagingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                    .withOperationName("DescribeEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     *
     * @param describeEndpointConfigRequest
     * @return Result of the DescribeEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEndpointConfigResponse describeEndpointConfig(DescribeEndpointConfigRequest describeEndpointConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEndpointConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointConfigRequest, DescribeEndpointConfigResponse>()
                            .withOperationName("DescribeEndpointConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEndpointConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEndpointConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of an experiment's properties.
     * </p>
     *
     * @param describeExperimentRequest
     * @return Result of the DescribeExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeExperimentResponse describeExperiment(DescribeExperimentRequest describeExperimentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeExperimentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExperiment");

            return clientHandler.execute(new ClientExecutionParams<DescribeExperimentRequest, DescribeExperimentResponse>()
                    .withOperationName("DescribeExperiment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeExperimentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeExperimentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation
     * time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.
     * </p>
     *
     * @param describeFeatureGroupRequest
     * @return Result of the DescribeFeatureGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFeatureGroupResponse describeFeatureGroup(DescribeFeatureGroupRequest describeFeatureGroupRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFeatureGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeatureGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeFeatureGroupRequest, DescribeFeatureGroupResponse>()
                    .withOperationName("DescribeFeatureGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeFeatureGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFeatureGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Shows the metadata for a feature within a feature group.
     * </p>
     *
     * @param describeFeatureMetadataRequest
     * @return Result of the DescribeFeatureMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFeatureMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFeatureMetadataResponse describeFeatureMetadata(DescribeFeatureMetadataRequest describeFeatureMetadataRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFeatureMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFeatureMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFeatureMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeatureMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFeatureMetadataRequest, DescribeFeatureMetadataResponse>()
                            .withOperationName("DescribeFeatureMetadata").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeFeatureMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFeatureMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified flow definition.
     * </p>
     *
     * @param describeFlowDefinitionRequest
     * @return Result of the DescribeFlowDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFlowDefinitionResponse describeFlowDefinition(DescribeFlowDefinitionRequest describeFlowDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFlowDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowDefinitionRequest, DescribeFlowDefinitionResponse>()
                            .withOperationName("DescribeFlowDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeFlowDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFlowDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the requested human task user interface (worker task template).
     * </p>
     *
     * @param describeHumanTaskUiRequest
     * @return Result of the DescribeHumanTaskUi operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeHumanTaskUiResponse describeHumanTaskUi(DescribeHumanTaskUiRequest describeHumanTaskUiRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeHumanTaskUiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHumanTaskUi");

            return clientHandler.execute(new ClientExecutionParams<DescribeHumanTaskUiRequest, DescribeHumanTaskUiResponse>()
                    .withOperationName("DescribeHumanTaskUi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeHumanTaskUiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeHumanTaskUiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a description of a hyperparameter tuning job.
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     * @return Result of the DescribeHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeHyperParameterTuningJobResponse describeHyperParameterTuningJob(
            DescribeHyperParameterTuningJobRequest describeHyperParameterTuningJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeHyperParameterTuningJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeHyperParameterTuningJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHyperParameterTuningJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeHyperParameterTuningJobRequest, DescribeHyperParameterTuningJobResponse>()
                            .withOperationName("DescribeHyperParameterTuningJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeHyperParameterTuningJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeHyperParameterTuningJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a SageMaker image.
     * </p>
     *
     * @param describeImageRequest
     * @return Result of the DescribeImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeImageResponse describeImage(DescribeImageRequest describeImageRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImage");

            return clientHandler.execute(new ClientExecutionParams<DescribeImageRequest, DescribeImageResponse>()
                    .withOperationName("DescribeImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a version of a SageMaker image.
     * </p>
     *
     * @param describeImageVersionRequest
     * @return Result of the DescribeImageVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeImageVersionResponse describeImageVersion(DescribeImageVersionRequest describeImageVersionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeImageVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImageVersion");

            return clientHandler.execute(new ClientExecutionParams<DescribeImageVersionRequest, DescribeImageVersionResponse>()
                    .withOperationName("DescribeImageVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeImageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeImageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     * </p>
     *
     * @param describeInferenceRecommendationsJobRequest
     * @return Result of the DescribeInferenceRecommendationsJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInferenceRecommendationsJobResponse describeInferenceRecommendationsJob(
            DescribeInferenceRecommendationsJobRequest describeInferenceRecommendationsJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInferenceRecommendationsJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInferenceRecommendationsJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInferenceRecommendationsJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInferenceRecommendationsJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInferenceRecommendationsJobRequest, DescribeInferenceRecommendationsJobResponse>()
                            .withOperationName("DescribeInferenceRecommendationsJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeInferenceRecommendationsJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInferenceRecommendationsJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     *
     * @param describeLabelingJobRequest
     * @return Result of the DescribeLabelingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeLabelingJobResponse describeLabelingJob(DescribeLabelingJobRequest describeLabelingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLabelingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeLabelingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLabelingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLabelingJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeLabelingJobRequest, DescribeLabelingJobResponse>()
                    .withOperationName("DescribeLabelingJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeLabelingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLabelingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of properties for the requested lineage group. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param describeLineageGroupRequest
     * @return Result of the DescribeLineageGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLineageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLineageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeLineageGroupResponse describeLineageGroup(DescribeLineageGroupRequest describeLineageGroupRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLineageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeLineageGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLineageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLineageGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeLineageGroupRequest, DescribeLineageGroupResponse>()
                    .withOperationName("DescribeLineageGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeLineageGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLineageGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     *
     * @param describeModelRequest
     * @return Result of the DescribeModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeModelResponse describeModel(DescribeModelRequest describeModelRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModel");

            return clientHandler.execute(new ClientExecutionParams<DescribeModelRequest, DescribeModelResponse>()
                    .withOperationName("DescribeModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of a model bias job definition.
     * </p>
     *
     * @param describeModelBiasJobDefinitionRequest
     * @return Result of the DescribeModelBiasJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeModelBiasJobDefinitionResponse describeModelBiasJobDefinition(
            DescribeModelBiasJobDefinitionRequest describeModelBiasJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeModelBiasJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelBiasJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelBiasJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeModelBiasJobDefinitionRequest, DescribeModelBiasJobDefinitionResponse>()
                            .withOperationName("DescribeModelBiasJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeModelBiasJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeModelBiasJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of a model explainability job definition.
     * </p>
     *
     * @param describeModelExplainabilityJobDefinitionRequest
     * @return Result of the DescribeModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeModelExplainabilityJobDefinitionResponse describeModelExplainabilityJobDefinition(
            DescribeModelExplainabilityJobDefinitionRequest describeModelExplainabilityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeModelExplainabilityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelExplainabilityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeModelExplainabilityJobDefinitionRequest, DescribeModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("DescribeModelExplainabilityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeModelExplainabilityJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on
     * Amazon Web Services Marketplace.
     * </p>
     * <p>
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeModelPackageRequest
     * @return Result of the DescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeModelPackageResponse describeModelPackage(DescribeModelPackageRequest describeModelPackageRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeModelPackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelPackage");

            return clientHandler.execute(new ClientExecutionParams<DescribeModelPackageRequest, DescribeModelPackageResponse>()
                    .withOperationName("DescribeModelPackage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeModelPackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeModelPackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a description for the specified model group.
     * </p>
     *
     * @param describeModelPackageGroupRequest
     * @return Result of the DescribeModelPackageGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeModelPackageGroupResponse describeModelPackageGroup(
            DescribeModelPackageGroupRequest describeModelPackageGroupRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeModelPackageGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelPackageGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeModelPackageGroupRequest, DescribeModelPackageGroupResponse>()
                            .withOperationName("DescribeModelPackageGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeModelPackageGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeModelPackageGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of a model quality job definition.
     * </p>
     *
     * @param describeModelQualityJobDefinitionRequest
     * @return Result of the DescribeModelQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeModelQualityJobDefinitionResponse describeModelQualityJobDefinition(
            DescribeModelQualityJobDefinitionRequest describeModelQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeModelQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeModelQualityJobDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelQualityJobDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeModelQualityJobDefinitionRequest, DescribeModelQualityJobDefinitionResponse>()
                            .withOperationName("DescribeModelQualityJobDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeModelQualityJobDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeModelQualityJobDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the schedule for a monitoring job.
     * </p>
     *
     * @param describeMonitoringScheduleRequest
     * @return Result of the DescribeMonitoringSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMonitoringScheduleResponse describeMonitoringSchedule(
            DescribeMonitoringScheduleRequest describeMonitoringScheduleRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMonitoringScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMonitoringSchedule");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMonitoringScheduleRequest, DescribeMonitoringScheduleResponse>()
                            .withOperationName("DescribeMonitoringSchedule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeMonitoringScheduleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMonitoringScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     *
     * @param describeNotebookInstanceRequest
     * @return Result of the DescribeNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeNotebookInstanceResponse describeNotebookInstance(
            DescribeNotebookInstanceRequest describeNotebookInstanceRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeNotebookInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNotebookInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>()
                            .withOperationName("DescribeNotebookInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeNotebookInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeNotebookInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     * @return Result of the DescribeNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeNotebookInstanceLifecycleConfigResponse describeNotebookInstanceLifecycleConfig(
            DescribeNotebookInstanceLifecycleConfigRequest describeNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeNotebookInstanceLifecycleConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNotebookInstanceLifecycleConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeNotebookInstanceLifecycleConfigRequest, DescribeNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("DescribeNotebookInstanceLifecycleConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNotebookInstanceLifecycleConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the details of a pipeline.
     * </p>
     *
     * @param describePipelineRequest
     * @return Result of the DescribePipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePipelineResponse describePipeline(DescribePipelineRequest describePipelineRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePipelineResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipeline");

            return clientHandler.execute(new ClientExecutionParams<DescribePipelineRequest, DescribePipelineResponse>()
                    .withOperationName("DescribePipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the details of an execution's pipeline definition.
     * </p>
     *
     * @param describePipelineDefinitionForExecutionRequest
     * @return Result of the DescribePipelineDefinitionForExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipelineDefinitionForExecution
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePipelineDefinitionForExecutionResponse describePipelineDefinitionForExecution(
            DescribePipelineDefinitionForExecutionRequest describePipelineDefinitionForExecutionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePipelineDefinitionForExecutionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribePipelineDefinitionForExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePipelineDefinitionForExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipelineDefinitionForExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineDefinitionForExecutionRequest, DescribePipelineDefinitionForExecutionResponse>()
                            .withOperationName("DescribePipelineDefinitionForExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePipelineDefinitionForExecutionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePipelineDefinitionForExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the details of a pipeline execution.
     * </p>
     *
     * @param describePipelineExecutionRequest
     * @return Result of the DescribePipelineExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePipelineExecutionResponse describePipelineExecution(
            DescribePipelineExecutionRequest describePipelineExecutionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePipelineExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipelineExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineExecutionRequest, DescribePipelineExecutionResponse>()
                            .withOperationName("DescribePipelineExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePipelineExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePipelineExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of a processing job.
     * </p>
     *
     * @param describeProcessingJobRequest
     * @return Result of the DescribeProcessingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProcessingJobResponse describeProcessingJob(DescribeProcessingJobRequest describeProcessingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProcessingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProcessingJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeProcessingJobRequest, DescribeProcessingJobResponse>()
                    .withOperationName("DescribeProcessingJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeProcessingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeProcessingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the details of a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProject");

            return clientHandler.execute(new ClientExecutionParams<DescribeProjectRequest, DescribeProjectResponse>()
                    .withOperationName("DescribeProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the Studio Lifecycle Configuration.
     * </p>
     *
     * @param describeStudioLifecycleConfigRequest
     * @return Result of the DescribeStudioLifecycleConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStudioLifecycleConfigResponse describeStudioLifecycleConfig(
            DescribeStudioLifecycleConfigRequest describeStudioLifecycleConfigRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeStudioLifecycleConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeStudioLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStudioLifecycleConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeStudioLifecycleConfigRequest, DescribeStudioLifecycleConfigResponse>()
                            .withOperationName("DescribeStudioLifecycleConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeStudioLifecycleConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeStudioLifecycleConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     * @return Result of the DescribeSubscribedWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeSubscribedWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSubscribedWorkteamResponse describeSubscribedWorkteam(
            DescribeSubscribedWorkteamRequest describeSubscribedWorkteamRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSubscribedWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSubscribedWorkteamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSubscribedWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSubscribedWorkteam");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSubscribedWorkteamRequest, DescribeSubscribedWorkteamResponse>()
                            .withOperationName("DescribeSubscribedWorkteam").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeSubscribedWorkteamRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSubscribedWorkteamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <p>
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails,
     * <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>,
     * attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>,
     * and <code>BillableTimeInSeconds</code> may not be present in the response.
     * </p>
     *
     * @param describeTrainingJobRequest
     * @return Result of the DescribeTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTrainingJobResponse describeTrainingJob(DescribeTrainingJobRequest describeTrainingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTrainingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrainingJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeTrainingJobRequest, DescribeTrainingJobResponse>()
                    .withOperationName("DescribeTrainingJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTrainingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTrainingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     *
     * @param describeTransformJobRequest
     * @return Result of the DescribeTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTransformJobResponse describeTransformJob(DescribeTransformJobRequest describeTransformJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTransformJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTransformJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeTransformJobRequest, DescribeTransformJobResponse>()
                    .withOperationName("DescribeTransformJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTransformJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTransformJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of a trial's properties.
     * </p>
     *
     * @param describeTrialRequest
     * @return Result of the DescribeTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeTrialResponse describeTrial(DescribeTrialRequest describeTrialRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTrialResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrial");

            return clientHandler.execute(new ClientExecutionParams<DescribeTrialRequest, DescribeTrialResponse>()
                    .withOperationName("DescribeTrial").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTrialRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTrialRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of a trials component's properties.
     * </p>
     *
     * @param describeTrialComponentRequest
     * @return Result of the DescribeTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTrialComponentResponse describeTrialComponent(DescribeTrialComponentRequest describeTrialComponentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTrialComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrialComponent");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTrialComponentRequest, DescribeTrialComponentResponse>()
                            .withOperationName("DescribeTrialComponent").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeTrialComponentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTrialComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a user profile. For more information, see <code>CreateUserProfile</code>.
     * </p>
     *
     * @param describeUserProfileRequest
     * @return Result of the DescribeUserProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeUserProfileResponse describeUserProfile(DescribeUserProfileRequest describeUserProfileRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeUserProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserProfile");

            return clientHandler.execute(new ClientExecutionParams<DescribeUserProfileRequest, DescribeUserProfileResponse>()
                    .withOperationName("DescribeUserProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeUserProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUserProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable,
     * allowed IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges
     * are the IP addresses that workers can use to access tasks.
     * </p>
     * <important>
     * <p>
     * This operation applies only to private workforces.
     * </p>
     * </important>
     *
     * @param describeWorkforceRequest
     * @return Result of the DescribeWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeWorkforceResponse describeWorkforce(DescribeWorkforceRequest describeWorkforceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeWorkforceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkforce");

            return clientHandler.execute(new ClientExecutionParams<DescribeWorkforceRequest, DescribeWorkforceResponse>()
                    .withOperationName("DescribeWorkforce").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkforceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeWorkforceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the create date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeWorkteamRequest
     * @return Result of the DescribeWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeWorkteamResponse describeWorkteam(DescribeWorkteamRequest describeWorkteamRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeWorkteamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkteam");

            return clientHandler.execute(new ClientExecutionParams<DescribeWorkteamRequest, DescribeWorkteamResponse>()
                    .withOperationName("DescribeWorkteam").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkteamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeWorkteamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param disableSagemakerServicecatalogPortfolioRequest
     * @return Result of the DisableSagemakerServicecatalogPortfolio operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DisableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisableSagemakerServicecatalogPortfolioResponse disableSagemakerServicecatalogPortfolio(
            DisableSagemakerServicecatalogPortfolioRequest disableSagemakerServicecatalogPortfolioRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableSagemakerServicecatalogPortfolioResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisableSagemakerServicecatalogPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableSagemakerServicecatalogPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableSagemakerServicecatalogPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<DisableSagemakerServicecatalogPortfolioRequest, DisableSagemakerServicecatalogPortfolioResponse>()
                            .withOperationName("DisableSagemakerServicecatalogPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(disableSagemakerServicecatalogPortfolioRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisableSagemakerServicecatalogPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with.
     * Before you can delete a component, you must disassociate the component from all trials it is associated with. To
     * associate a trial component with a trial, call the <a>AssociateTrialComponent</a> API.
     * </p>
     * <p>
     * To get a list of the trials a component is associated with, use the <a>Search</a> API. Specify
     * <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response
     * under <code>Results.TrialComponent.Parents</code>.
     * </p>
     *
     * @param disassociateTrialComponentRequest
     * @return Result of the DisassociateTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DisassociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateTrialComponentResponse disassociateTrialComponent(
            DisassociateTrialComponentRequest disassociateTrialComponentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateTrialComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTrialComponent");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateTrialComponentRequest, DisassociateTrialComponentResponse>()
                            .withOperationName("DisassociateTrialComponent").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateTrialComponentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateTrialComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param enableSagemakerServicecatalogPortfolioRequest
     * @return Result of the EnableSagemakerServicecatalogPortfolio operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.EnableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EnableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public EnableSagemakerServicecatalogPortfolioResponse enableSagemakerServicecatalogPortfolio(
            EnableSagemakerServicecatalogPortfolioRequest enableSagemakerServicecatalogPortfolioRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableSagemakerServicecatalogPortfolioResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, EnableSagemakerServicecatalogPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                enableSagemakerServicecatalogPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableSagemakerServicecatalogPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<EnableSagemakerServicecatalogPortfolioRequest, EnableSagemakerServicecatalogPortfolioResponse>()
                            .withOperationName("EnableSagemakerServicecatalogPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(enableSagemakerServicecatalogPortfolioRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new EnableSagemakerServicecatalogPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     *
     * @param getDeviceFleetReportRequest
     * @return Result of the GetDeviceFleetReport operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetDeviceFleetReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetDeviceFleetReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeviceFleetReportResponse getDeviceFleetReport(GetDeviceFleetReportRequest getDeviceFleetReportRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceFleetReportResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeviceFleetReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceFleetReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceFleetReport");

            return clientHandler.execute(new ClientExecutionParams<GetDeviceFleetReportRequest, GetDeviceFleetReportResponse>()
                    .withOperationName("GetDeviceFleetReport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceFleetReportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeviceFleetReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The resource policy for the lineage group.
     * </p>
     *
     * @param getLineageGroupPolicyRequest
     * @return Result of the GetLineageGroupPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetLineageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetLineageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLineageGroupPolicyResponse getLineageGroupPolicy(GetLineageGroupPolicyRequest getLineageGroupPolicyRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLineageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLineageGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLineageGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLineageGroupPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetLineageGroupPolicyRequest, GetLineageGroupPolicyResponse>()
                    .withOperationName("GetLineageGroupPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLineageGroupPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLineageGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a resource policy that manages access for a model group. For information about resource policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User
     * Guide.</i>.
     * </p>
     *
     * @param getModelPackageGroupPolicyRequest
     * @return Result of the GetModelPackageGroupPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetModelPackageGroupPolicyResponse getModelPackageGroupPolicy(
            GetModelPackageGroupPolicyRequest getModelPackageGroupPolicyRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelPackageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetModelPackageGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelPackageGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelPackageGroupPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetModelPackageGroupPolicyRequest, GetModelPackageGroupPolicyResponse>()
                            .withOperationName("GetModelPackageGroupPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getModelPackageGroupPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetModelPackageGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param getSagemakerServicecatalogPortfolioStatusRequest
     * @return Result of the GetSagemakerServicecatalogPortfolioStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSagemakerServicecatalogPortfolioStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSagemakerServicecatalogPortfolioStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSagemakerServicecatalogPortfolioStatusResponse getSagemakerServicecatalogPortfolioStatus(
            GetSagemakerServicecatalogPortfolioStatusRequest getSagemakerServicecatalogPortfolioStatusRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSagemakerServicecatalogPortfolioStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetSagemakerServicecatalogPortfolioStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSagemakerServicecatalogPortfolioStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSagemakerServicecatalogPortfolioStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSagemakerServicecatalogPortfolioStatusRequest, GetSagemakerServicecatalogPortfolioStatusResponse>()
                            .withOperationName("GetSagemakerServicecatalogPortfolioStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSagemakerServicecatalogPortfolioStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSagemakerServicecatalogPortfolioStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of
     * possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for
     * <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.
     * </p>
     *
     * @param getSearchSuggestionsRequest
     * @return Result of the GetSearchSuggestions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSearchSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSearchSuggestionsResponse getSearchSuggestions(GetSearchSuggestionsRequest getSearchSuggestionsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSearchSuggestionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSearchSuggestionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSearchSuggestionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSearchSuggestions");

            return clientHandler.execute(new ClientExecutionParams<GetSearchSuggestionsRequest, GetSearchSuggestionsResponse>()
                    .withOperationName("GetSearchSuggestions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSearchSuggestionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSearchSuggestionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the actions in your account and their properties.
     * </p>
     *
     * @param listActionsRequest
     * @return Result of the ListActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListActionsResponse listActions(ListActionsRequest listActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListActionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListActions");

            return clientHandler.execute(new ClientExecutionParams<ListActionsRequest, ListActionsResponse>()
                    .withOperationName("ListActions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the actions in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)} operation.</b>
     * </p>
     *
     * @param listActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListActionsIterable listActionsPaginator(ListActionsRequest listActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListActionsIterable(this, applyPaginatorUserAgent(listActionsRequest));
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     *
     * @param listAlgorithmsRequest
     * @return Result of the ListAlgorithms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAlgorithmsResponse listAlgorithms(ListAlgorithmsRequest listAlgorithmsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAlgorithmsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAlgorithmsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAlgorithmsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAlgorithms");

            return clientHandler.execute(new ClientExecutionParams<ListAlgorithmsRequest, ListAlgorithmsResponse>()
                    .withOperationName("ListAlgorithms").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAlgorithmsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAlgorithmsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client
     *             .listAlgorithmsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation.</b>
     * </p>
     *
     * @param listAlgorithmsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAlgorithmsIterable listAlgorithmsPaginator(ListAlgorithmsRequest listAlgorithmsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListAlgorithmsIterable(this, applyPaginatorUserAgent(listAlgorithmsRequest));
    }

    /**
     * <p>
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or
     * modified time, and whether the AppImageConfig name contains a specified string.
     * </p>
     *
     * @param listAppImageConfigsRequest
     * @return Result of the ListAppImageConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAppImageConfigsResponse listAppImageConfigs(ListAppImageConfigsRequest listAppImageConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppImageConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppImageConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppImageConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppImageConfigs");

            return clientHandler.execute(new ClientExecutionParams<ListAppImageConfigsRequest, ListAppImageConfigsResponse>()
                    .withOperationName("ListAppImageConfigs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAppImageConfigsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppImageConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or
     * modified time, and whether the AppImageConfig name contains a specified string.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client.listAppImageConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client
     *             .listAppImageConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client.listAppImageConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppImageConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAppImageConfigsIterable listAppImageConfigsPaginator(ListAppImageConfigsRequest listAppImageConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListAppImageConfigsIterable(this, applyPaginatorUserAgent(listAppImageConfigsRequest));
    }

    /**
     * <p>
     * Lists apps.
     * </p>
     *
     * @param listAppsRequest
     * @return Result of the ListApps operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAppsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApps");

            return clientHandler.execute(new ClientExecutionParams<ListAppsRequest, ListAppsResponse>()
                    .withOperationName("ListApps").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAppsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListAppsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists apps.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAppsIterable listAppsPaginator(ListAppsRequest listAppsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListAppsIterable(this, applyPaginatorUserAgent(listAppsRequest));
    }

    /**
     * <p>
     * Lists the artifacts in your account and their properties.
     * </p>
     *
     * @param listArtifactsRequest
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListArtifactsResponse listArtifacts(ListArtifactsRequest listArtifactsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListArtifactsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listArtifactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListArtifacts");

            return clientHandler.execute(new ClientExecutionParams<ListArtifactsRequest, ListArtifactsResponse>()
                    .withOperationName("ListArtifacts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listArtifactsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListArtifactsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the artifacts in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)} operation.</b>
     * </p>
     *
     * @param listArtifactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListArtifactsIterable listArtifactsPaginator(ListArtifactsRequest listArtifactsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListArtifactsIterable(this, applyPaginatorUserAgent(listArtifactsRequest));
    }

    /**
     * <p>
     * Lists the associations in your account and their properties.
     * </p>
     *
     * @param listAssociationsRequest
     * @return Result of the ListAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAssociationsResponse listAssociations(ListAssociationsRequest listAssociationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociations");

            return clientHandler.execute(new ClientExecutionParams<ListAssociationsRequest, ListAssociationsResponse>()
                    .withOperationName("ListAssociations").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAssociationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the associations in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client
     *             .listAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @param listAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAssociationsIterable listAssociationsPaginator(ListAssociationsRequest listAssociationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListAssociationsIterable(this, applyPaginatorUserAgent(listAssociationsRequest));
    }

    /**
     * <p>
     * Request a list of jobs.
     * </p>
     *
     * @param listAutoMlJobsRequest
     * @return Result of the ListAutoMLJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAutoMlJobsResponse listAutoMLJobs(ListAutoMlJobsRequest listAutoMlJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAutoMlJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAutoMlJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAutoMlJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAutoMLJobs");

            return clientHandler.execute(new ClientExecutionParams<ListAutoMlJobsRequest, ListAutoMlJobsResponse>()
                    .withOperationName("ListAutoMLJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAutoMlJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAutoMlJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Request a list of jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client.listAutoMLJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client
     *             .listAutoMLJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client.listAutoMLJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation.</b>
     * </p>
     *
     * @param listAutoMlJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAutoMLJobsIterable listAutoMLJobsPaginator(ListAutoMlJobsRequest listAutoMlJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListAutoMLJobsIterable(this, applyPaginatorUserAgent(listAutoMlJobsRequest));
    }

    /**
     * <p>
     * List the candidates created for the job.
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     * @return Result of the ListCandidatesForAutoMLJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCandidatesForAutoMlJobResponse listCandidatesForAutoMLJob(
            ListCandidatesForAutoMlJobRequest listCandidatesForAutoMlJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCandidatesForAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCandidatesForAutoMlJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCandidatesForAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCandidatesForAutoMLJob");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCandidatesForAutoMlJobRequest, ListCandidatesForAutoMlJobResponse>()
                            .withOperationName("ListCandidatesForAutoMLJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listCandidatesForAutoMlJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCandidatesForAutoMlJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the candidates created for the job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client.listCandidatesForAutoMLJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client
     *             .listCandidatesForAutoMLJobPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client.listCandidatesForAutoMLJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCandidatesForAutoMLJobIterable listCandidatesForAutoMLJobPaginator(
            ListCandidatesForAutoMlJobRequest listCandidatesForAutoMlJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListCandidatesForAutoMLJobIterable(this, applyPaginatorUserAgent(listCandidatesForAutoMlJobRequest));
    }

    /**
     * <p>
     * Gets a list of the Git repositories in your account.
     * </p>
     *
     * @param listCodeRepositoriesRequest
     * @return Result of the ListCodeRepositories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCodeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCodeRepositoriesResponse listCodeRepositories(ListCodeRepositoriesRequest listCodeRepositoriesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCodeRepositoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCodeRepositoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCodeRepositoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCodeRepositories");

            return clientHandler.execute(new ClientExecutionParams<ListCodeRepositoriesRequest, ListCodeRepositoriesResponse>()
                    .withOperationName("ListCodeRepositories").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listCodeRepositoriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCodeRepositoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the Git repositories in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCodeRepositories(software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesIterable responses = client.listCodeRepositoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesIterable responses = client
     *             .listCodeRepositoriesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesIterable responses = client.listCodeRepositoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeRepositories(software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodeRepositoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCodeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCodeRepositoriesIterable listCodeRepositoriesPaginator(ListCodeRepositoriesRequest listCodeRepositoriesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListCodeRepositoriesIterable(this, applyPaginatorUserAgent(listCodeRepositoriesRequest));
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     *
     * @param listCompilationJobsRequest
     * @return Result of the ListCompilationJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCompilationJobsResponse listCompilationJobs(ListCompilationJobsRequest listCompilationJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCompilationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCompilationJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCompilationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCompilationJobs");

            return clientHandler.execute(new ClientExecutionParams<ListCompilationJobsRequest, ListCompilationJobsResponse>()
                    .withOperationName("ListCompilationJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listCompilationJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCompilationJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client
     *             .listCompilationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCompilationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCompilationJobsIterable listCompilationJobsPaginator(ListCompilationJobsRequest listCompilationJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListCompilationJobsIterable(this, applyPaginatorUserAgent(listCompilationJobsRequest));
    }

    /**
     * <p>
     * Lists the contexts in your account and their properties.
     * </p>
     *
     * @param listContextsRequest
     * @return Result of the ListContexts operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListContexts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListContexts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListContextsResponse listContexts(ListContextsRequest listContextsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListContextsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListContextsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContextsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContexts");

            return clientHandler.execute(new ClientExecutionParams<ListContextsRequest, ListContextsResponse>()
                    .withOperationName("ListContexts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listContextsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListContextsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the contexts in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listContexts(software.amazon.awssdk.services.sagemaker.model.ListContextsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListContextsIterable responses = client.listContextsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListContextsIterable responses = client.listContextsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListContextsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListContextsIterable responses = client.listContextsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContexts(software.amazon.awssdk.services.sagemaker.model.ListContextsRequest)} operation.</b>
     * </p>
     *
     * @param listContextsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListContexts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListContexts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListContextsIterable listContextsPaginator(ListContextsRequest listContextsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListContextsIterable(this, applyPaginatorUserAgent(listContextsRequest));
    }

    /**
     * <p>
     * Lists the data quality job definitions in your account.
     * </p>
     *
     * @param listDataQualityJobDefinitionsRequest
     * @return Result of the ListDataQualityJobDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDataQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDataQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDataQualityJobDefinitionsResponse listDataQualityJobDefinitions(
            ListDataQualityJobDefinitionsRequest listDataQualityJobDefinitionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataQualityJobDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDataQualityJobDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDataQualityJobDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataQualityJobDefinitions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDataQualityJobDefinitionsRequest, ListDataQualityJobDefinitionsResponse>()
                            .withOperationName("ListDataQualityJobDefinitions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listDataQualityJobDefinitionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDataQualityJobDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the data quality job definitions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsIterable responses = client.listDataQualityJobDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsIterable responses = client
     *             .listDataQualityJobDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsIterable responses = client.listDataQualityJobDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataQualityJobDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDataQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDataQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDataQualityJobDefinitionsIterable listDataQualityJobDefinitionsPaginator(
            ListDataQualityJobDefinitionsRequest listDataQualityJobDefinitionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListDataQualityJobDefinitionsIterable(this, applyPaginatorUserAgent(listDataQualityJobDefinitionsRequest));
    }

    /**
     * <p>
     * Returns a list of devices in the fleet.
     * </p>
     *
     * @param listDeviceFleetsRequest
     * @return Result of the ListDeviceFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDeviceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDeviceFleets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDeviceFleetsResponse listDeviceFleets(ListDeviceFleetsRequest listDeviceFleetsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeviceFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDeviceFleetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceFleets");

            return clientHandler.execute(new ClientExecutionParams<ListDeviceFleetsRequest, ListDeviceFleetsResponse>()
                    .withOperationName("ListDeviceFleets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDeviceFleetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDeviceFleetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of devices in the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceFleets(software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsIterable responses = client.listDeviceFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsIterable responses = client
     *             .listDeviceFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsIterable responses = client.listDeviceFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceFleets(software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listDeviceFleetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDeviceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDeviceFleets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDeviceFleetsIterable listDeviceFleetsPaginator(ListDeviceFleetsRequest listDeviceFleetsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListDeviceFleetsIterable(this, applyPaginatorUserAgent(listDeviceFleetsRequest));
    }

    /**
     * <p>
     * A list of devices.
     * </p>
     *
     * @param listDevicesRequest
     * @return Result of the ListDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevices");

            return clientHandler.execute(new ClientExecutionParams<ListDevicesRequest, ListDevicesResponse>()
                    .withOperationName("ListDevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListDevicesIterable(this, applyPaginatorUserAgent(listDevicesRequest));
    }

    /**
     * <p>
     * Lists the domains.
     * </p>
     *
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDomainsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDomainsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomains");

            return clientHandler.execute(new ClientExecutionParams<ListDomainsRequest, ListDomainsResponse>()
                    .withOperationName("ListDomains").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDomainsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDomainsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the domains.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListDomainsIterable(this, applyPaginatorUserAgent(listDomainsRequest));
    }

    /**
     * <p>
     * Lists all edge deployment plans.
     * </p>
     *
     * @param listEdgeDeploymentPlansRequest
     * @return Result of the ListEdgeDeploymentPlans operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEdgeDeploymentPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgeDeploymentPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEdgeDeploymentPlansResponse listEdgeDeploymentPlans(ListEdgeDeploymentPlansRequest listEdgeDeploymentPlansRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEdgeDeploymentPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEdgeDeploymentPlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEdgeDeploymentPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEdgeDeploymentPlans");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEdgeDeploymentPlansRequest, ListEdgeDeploymentPlansResponse>()
                            .withOperationName("ListEdgeDeploymentPlans").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listEdgeDeploymentPlansRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEdgeDeploymentPlansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all edge deployment plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEdgeDeploymentPlans(software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansIterable responses = client.listEdgeDeploymentPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansIterable responses = client
     *             .listEdgeDeploymentPlansPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansIterable responses = client.listEdgeDeploymentPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEdgeDeploymentPlans(software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEdgeDeploymentPlansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEdgeDeploymentPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgeDeploymentPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEdgeDeploymentPlansIterable listEdgeDeploymentPlansPaginator(
            ListEdgeDeploymentPlansRequest listEdgeDeploymentPlansRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListEdgeDeploymentPlansIterable(this, applyPaginatorUserAgent(listEdgeDeploymentPlansRequest));
    }

    /**
     * <p>
     * Returns a list of edge packaging jobs.
     * </p>
     *
     * @param listEdgePackagingJobsRequest
     * @return Result of the ListEdgePackagingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEdgePackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgePackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEdgePackagingJobsResponse listEdgePackagingJobs(ListEdgePackagingJobsRequest listEdgePackagingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEdgePackagingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEdgePackagingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEdgePackagingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEdgePackagingJobs");

            return clientHandler.execute(new ClientExecutionParams<ListEdgePackagingJobsRequest, ListEdgePackagingJobsResponse>()
                    .withOperationName("ListEdgePackagingJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEdgePackagingJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEdgePackagingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of edge packaging jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEdgePackagingJobs(software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsIterable responses = client.listEdgePackagingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsIterable responses = client
     *             .listEdgePackagingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsIterable responses = client.listEdgePackagingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEdgePackagingJobs(software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEdgePackagingJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEdgePackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgePackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEdgePackagingJobsIterable listEdgePackagingJobsPaginator(ListEdgePackagingJobsRequest listEdgePackagingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListEdgePackagingJobsIterable(this, applyPaginatorUserAgent(listEdgePackagingJobsRequest));
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     *
     * @param listEndpointConfigsRequest
     * @return Result of the ListEndpointConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListEndpointConfigsResponse listEndpointConfigs(ListEndpointConfigsRequest listEndpointConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEndpointConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEndpointConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpointConfigs");

            return clientHandler.execute(new ClientExecutionParams<ListEndpointConfigsRequest, ListEndpointConfigsResponse>()
                    .withOperationName("ListEndpointConfigs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEndpointConfigsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEndpointConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client
     *             .listEndpointConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListEndpointConfigsIterable listEndpointConfigsPaginator(ListEndpointConfigsRequest listEndpointConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListEndpointConfigsIterable(this, applyPaginatorUserAgent(listEndpointConfigsRequest));
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     *
     * @param listEndpointsRequest
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListEndpointsResponse listEndpoints(ListEndpointsRequest listEndpointsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpoints");

            return clientHandler.execute(new ClientExecutionParams<ListEndpointsRequest, ListEndpointsResponse>()
                    .withOperationName("ListEndpoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param listEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListEndpointsIterable listEndpointsPaginator(ListEndpointsRequest listEndpointsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListEndpointsIterable(this, applyPaginatorUserAgent(listEndpointsRequest));
    }

    /**
     * <p>
     * Lists all the experiments in your account. The list can be filtered to show only experiments that were created in
     * a specific time range. The list can be sorted by experiment name or creation time.
     * </p>
     *
     * @param listExperimentsRequest
     * @return Result of the ListExperiments operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExperimentsResponse listExperiments(ListExperimentsRequest listExperimentsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListExperimentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListExperimentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExperimentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExperiments");

            return clientHandler.execute(new ClientExecutionParams<ListExperimentsRequest, ListExperimentsResponse>()
                    .withOperationName("ListExperiments").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listExperimentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListExperimentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the experiments in your account. The list can be filtered to show only experiments that were created in
     * a specific time range. The list can be sorted by experiment name or creation time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiments(software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsIterable responses = client
     *             .listExperimentsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest)} operation.</b>
     * </p>
     *
     * @param listExperimentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExperimentsIterable listExperimentsPaginator(ListExperimentsRequest listExperimentsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListExperimentsIterable(this, applyPaginatorUserAgent(listExperimentsRequest));
    }

    /**
     * <p>
     * List <code>FeatureGroup</code>s based on given filter and order.
     * </p>
     *
     * @param listFeatureGroupsRequest
     * @return Result of the ListFeatureGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListFeatureGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFeatureGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFeatureGroupsResponse listFeatureGroups(ListFeatureGroupsRequest listFeatureGroupsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFeatureGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFeatureGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFeatureGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFeatureGroups");

            return clientHandler.execute(new ClientExecutionParams<ListFeatureGroupsRequest, ListFeatureGroupsResponse>()
                    .withOperationName("ListFeatureGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listFeatureGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFeatureGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List <code>FeatureGroup</code>s based on given filter and order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFeatureGroups(software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsIterable responses = client.listFeatureGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsIterable responses = client
     *             .listFeatureGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsIterable responses = client.listFeatureGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFeatureGroups(software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFeatureGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListFeatureGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFeatureGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFeatureGroupsIterable listFeatureGroupsPaginator(ListFeatureGroupsRequest listFeatureGroupsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListFeatureGroupsIterable(this, applyPaginatorUserAgent(listFeatureGroupsRequest));
    }

    /**
     * <p>
     * Returns information about the flow definitions in your account.
     * </p>
     *
     * @param listFlowDefinitionsRequest
     * @return Result of the ListFlowDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListFlowDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFlowDefinitionsResponse listFlowDefinitions(ListFlowDefinitionsRequest listFlowDefinitionsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFlowDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFlowDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlowDefinitions");

            return clientHandler.execute(new ClientExecutionParams<ListFlowDefinitionsRequest, ListFlowDefinitionsResponse>()
                    .withOperationName("ListFlowDefinitions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listFlowDefinitionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFlowDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the flow definitions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlowDefinitions(software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsIterable responses = client.listFlowDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsIterable responses = client
     *             .listFlowDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsIterable responses = client.listFlowDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowDefinitions(software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListFlowDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFlowDefinitionsIterable listFlowDefinitionsPaginator(ListFlowDefinitionsRequest listFlowDefinitionsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListFlowDefinitionsIterable(this, applyPaginatorUserAgent(listFlowDefinitionsRequest));
    }

    /**
     * <p>
     * Returns information about the human task user interfaces in your account.
     * </p>
     *
     * @param listHumanTaskUisRequest
     * @return Result of the ListHumanTaskUis operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHumanTaskUis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListHumanTaskUisResponse listHumanTaskUis(ListHumanTaskUisRequest listHumanTaskUisRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListHumanTaskUisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListHumanTaskUisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHumanTaskUisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHumanTaskUis");

            return clientHandler.execute(new ClientExecutionParams<ListHumanTaskUisRequest, ListHumanTaskUisResponse>()
                    .withOperationName("ListHumanTaskUis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listHumanTaskUisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListHumanTaskUisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the human task user interfaces in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHumanTaskUis(software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisIterable responses = client.listHumanTaskUisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisIterable responses = client
     *             .listHumanTaskUisPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisIterable responses = client.listHumanTaskUisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanTaskUis(software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest)} operation.</b>
     * </p>
     *
     * @param listHumanTaskUisRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHumanTaskUis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListHumanTaskUisIterable listHumanTaskUisPaginator(ListHumanTaskUisRequest listHumanTaskUisRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListHumanTaskUisIterable(this, applyPaginatorUserAgent(listHumanTaskUisRequest));
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     * @return Result of the ListHyperParameterTuningJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListHyperParameterTuningJobsResponse listHyperParameterTuningJobs(
            ListHyperParameterTuningJobsRequest listHyperParameterTuningJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListHyperParameterTuningJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListHyperParameterTuningJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHyperParameterTuningJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHyperParameterTuningJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListHyperParameterTuningJobsRequest, ListHyperParameterTuningJobsResponse>()
                            .withOperationName("ListHyperParameterTuningJobs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listHyperParameterTuningJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListHyperParameterTuningJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client
     *             .listHyperParameterTuningJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListHyperParameterTuningJobsIterable listHyperParameterTuningJobsPaginator(
            ListHyperParameterTuningJobsRequest listHyperParameterTuningJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListHyperParameterTuningJobsIterable(this, applyPaginatorUserAgent(listHyperParameterTuningJobsRequest));
    }

    /**
     * <p>
     * Lists the versions of a specified image and their properties. The list can be filtered by creation time or
     * modified time.
     * </p>
     *
     * @param listImageVersionsRequest
     * @return Result of the ListImageVersions operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListImageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImageVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListImageVersionsResponse listImageVersions(ListImageVersionsRequest listImageVersionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImageVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImageVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageVersions");

            return clientHandler.execute(new ClientExecutionParams<ListImageVersionsRequest, ListImageVersionsResponse>()
                    .withOperationName("ListImageVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listImageVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImageVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the versions of a specified image and their properties. The list can be filtered by creation time or
     * modified time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageVersions(software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsIterable responses = client.listImageVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsIterable responses = client
     *             .listImageVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsIterable responses = client.listImageVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageVersions(software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListImageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImageVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListImageVersionsIterable listImageVersionsPaginator(ListImageVersionsRequest listImageVersionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListImageVersionsIterable(this, applyPaginatorUserAgent(listImageVersionsRequest));
    }

    /**
     * <p>
     * Lists the images in your account and their properties. The list can be filtered by creation time or modified
     * time, and whether the image name contains a specified string.
     * </p>
     *
     * @param listImagesRequest
     * @return Result of the ListImages operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImages");

            return clientHandler
                    .execute(new ClientExecutionParams<ListImagesRequest, ListImagesResponse>().withOperationName("ListImages")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listImagesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the images in your account and their properties. The list can be filtered by creation time or modified
     * time, and whether the image name contains a specified string.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.sagemaker.model.ListImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.sagemaker.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImagesIterable listImagesPaginator(ListImagesRequest listImagesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListImagesIterable(this, applyPaginatorUserAgent(listImagesRequest));
    }

    /**
     * <p>
     * Lists recommendation jobs that satisfy various filters.
     * </p>
     *
     * @param listInferenceRecommendationsJobsRequest
     * @return Result of the ListInferenceRecommendationsJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListInferenceRecommendationsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListInferenceRecommendationsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInferenceRecommendationsJobsResponse listInferenceRecommendationsJobs(
            ListInferenceRecommendationsJobsRequest listInferenceRecommendationsJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInferenceRecommendationsJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInferenceRecommendationsJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listInferenceRecommendationsJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInferenceRecommendationsJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListInferenceRecommendationsJobsRequest, ListInferenceRecommendationsJobsResponse>()
                            .withOperationName("ListInferenceRecommendationsJobs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listInferenceRecommendationsJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListInferenceRecommendationsJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists recommendation jobs that satisfy various filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceRecommendationsJobs(software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsIterable responses = client.listInferenceRecommendationsJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsIterable responses = client
     *             .listInferenceRecommendationsJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsIterable responses = client.listInferenceRecommendationsJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceRecommendationsJobs(software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceRecommendationsJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListInferenceRecommendationsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListInferenceRecommendationsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInferenceRecommendationsJobsIterable listInferenceRecommendationsJobsPaginator(
            ListInferenceRecommendationsJobsRequest listInferenceRecommendationsJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListInferenceRecommendationsJobsIterable(this,
                applyPaginatorUserAgent(listInferenceRecommendationsJobsRequest));
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     *
     * @param listLabelingJobsRequest
     * @return Result of the ListLabelingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLabelingJobsResponse listLabelingJobs(ListLabelingJobsRequest listLabelingJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLabelingJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLabelingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLabelingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLabelingJobs");

            return clientHandler.execute(new ClientExecutionParams<ListLabelingJobsRequest, ListLabelingJobsResponse>()
                    .withOperationName("ListLabelingJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listLabelingJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLabelingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client
     *             .listLabelingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation.</b>
     * </p>
     *
     * @param listLabelingJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLabelingJobsIterable listLabelingJobsPaginator(ListLabelingJobsRequest listLabelingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListLabelingJobsIterable(this, applyPaginatorUserAgent(listLabelingJobsRequest));
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     * @return Result of the ListLabelingJobsForWorkteam operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobsForWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLabelingJobsForWorkteamResponse listLabelingJobsForWorkteam(
            ListLabelingJobsForWorkteamRequest listLabelingJobsForWorkteamRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLabelingJobsForWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLabelingJobsForWorkteamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLabelingJobsForWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLabelingJobsForWorkteam");

            return clientHandler
                    .execute(new ClientExecutionParams<ListLabelingJobsForWorkteamRequest, ListLabelingJobsForWorkteamResponse>()
                            .withOperationName("ListLabelingJobsForWorkteam").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listLabelingJobsForWorkteamRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListLabelingJobsForWorkteamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client.listLabelingJobsForWorkteamPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client
     *             .listLabelingJobsForWorkteamPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client.listLabelingJobsForWorkteamPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobsForWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLabelingJobsForWorkteamIterable listLabelingJobsForWorkteamPaginator(
            ListLabelingJobsForWorkteamRequest listLabelingJobsForWorkteamRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListLabelingJobsForWorkteamIterable(this, applyPaginatorUserAgent(listLabelingJobsForWorkteamRequest));
    }

    /**
     * <p>
     * A list of lineage groups shared with your Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param listLineageGroupsRequest
     * @return Result of the ListLineageGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLineageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLineageGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLineageGroupsResponse listLineageGroups(ListLineageGroupsRequest listLineageGroupsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLineageGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLineageGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLineageGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLineageGroups");

            return clientHandler.execute(new ClientExecutionParams<ListLineageGroupsRequest, ListLineageGroupsResponse>()
                    .withOperationName("ListLineageGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listLineageGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLineageGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of lineage groups shared with your Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLineageGroups(software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsIterable responses = client.listLineageGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsIterable responses = client
     *             .listLineageGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsIterable responses = client.listLineageGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageGroups(software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLineageGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLineageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLineageGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLineageGroupsIterable listLineageGroupsPaginator(ListLineageGroupsRequest listLineageGroupsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListLineageGroupsIterable(this, applyPaginatorUserAgent(listLineageGroupsRequest));
    }

    /**
     * <p>
     * Lists model bias jobs definitions that satisfy various filters.
     * </p>
     *
     * @param listModelBiasJobDefinitionsRequest
     * @return Result of the ListModelBiasJobDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelBiasJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelBiasJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelBiasJobDefinitionsResponse listModelBiasJobDefinitions(
            ListModelBiasJobDefinitionsRequest listModelBiasJobDefinitionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelBiasJobDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListModelBiasJobDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelBiasJobDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelBiasJobDefinitions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListModelBiasJobDefinitionsRequest, ListModelBiasJobDefinitionsResponse>()
                            .withOperationName("ListModelBiasJobDefinitions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listModelBiasJobDefinitionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListModelBiasJobDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists model bias jobs definitions that satisfy various filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelBiasJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsIterable responses = client.listModelBiasJobDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsIterable responses = client
     *             .listModelBiasJobDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsIterable responses = client.listModelBiasJobDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelBiasJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelBiasJobDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelBiasJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelBiasJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelBiasJobDefinitionsIterable listModelBiasJobDefinitionsPaginator(
            ListModelBiasJobDefinitionsRequest listModelBiasJobDefinitionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListModelBiasJobDefinitionsIterable(this, applyPaginatorUserAgent(listModelBiasJobDefinitionsRequest));
    }

    /**
     * <p>
     * Lists model explainability job definitions that satisfy various filters.
     * </p>
     *
     * @param listModelExplainabilityJobDefinitionsRequest
     * @return Result of the ListModelExplainabilityJobDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelExplainabilityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelExplainabilityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelExplainabilityJobDefinitionsResponse listModelExplainabilityJobDefinitions(
            ListModelExplainabilityJobDefinitionsRequest listModelExplainabilityJobDefinitionsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelExplainabilityJobDefinitionsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListModelExplainabilityJobDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listModelExplainabilityJobDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelExplainabilityJobDefinitions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListModelExplainabilityJobDefinitionsRequest, ListModelExplainabilityJobDefinitionsResponse>()
                            .withOperationName("ListModelExplainabilityJobDefinitions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listModelExplainabilityJobDefinitionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListModelExplainabilityJobDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists model explainability job definitions that satisfy various filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelExplainabilityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsIterable responses = client.listModelExplainabilityJobDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsIterable responses = client
     *             .listModelExplainabilityJobDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsIterable responses = client.listModelExplainabilityJobDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelExplainabilityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelExplainabilityJobDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelExplainabilityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelExplainabilityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelExplainabilityJobDefinitionsIterable listModelExplainabilityJobDefinitionsPaginator(
            ListModelExplainabilityJobDefinitionsRequest listModelExplainabilityJobDefinitionsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListModelExplainabilityJobDefinitionsIterable(this,
                applyPaginatorUserAgent(listModelExplainabilityJobDefinitionsRequest));
    }

    /**
     * <p>
     * Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
     * </p>
     *
     * @param listModelMetadataRequest
     * @return Result of the ListModelMetadata operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListModelMetadataResponse listModelMetadata(ListModelMetadataRequest listModelMetadataRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListModelMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelMetadata");

            return clientHandler.execute(new ClientExecutionParams<ListModelMetadataRequest, ListModelMetadataResponse>()
                    .withOperationName("ListModelMetadata").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listModelMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListModelMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelMetadata(software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataIterable responses = client.listModelMetadataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataIterable responses = client
     *             .listModelMetadataPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataIterable responses = client.listModelMetadataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelMetadata(software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelMetadataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListModelMetadataIterable listModelMetadataPaginator(ListModelMetadataRequest listModelMetadataRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListModelMetadataIterable(this, applyPaginatorUserAgent(listModelMetadataRequest));
    }

    /**
     * <p>
     * Gets a list of the model groups in your Amazon Web Services account.
     * </p>
     *
     * @param listModelPackageGroupsRequest
     * @return Result of the ListModelPackageGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelPackageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackageGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelPackageGroupsResponse listModelPackageGroups(ListModelPackageGroupsRequest listModelPackageGroupsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelPackageGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListModelPackageGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelPackageGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelPackageGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListModelPackageGroupsRequest, ListModelPackageGroupsResponse>()
                            .withOperationName("ListModelPackageGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listModelPackageGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListModelPackageGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the model groups in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelPackageGroups(software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsIterable responses = client.listModelPackageGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsIterable responses = client
     *             .listModelPackageGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsIterable responses = client.listModelPackageGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelPackageGroups(software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelPackageGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelPackageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackageGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelPackageGroupsIterable listModelPackageGroupsPaginator(
            ListModelPackageGroupsRequest listModelPackageGroupsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListModelPackageGroupsIterable(this, applyPaginatorUserAgent(listModelPackageGroupsRequest));
    }

    /**
     * <p>
     * Lists the model packages that have been created.
     * </p>
     *
     * @param listModelPackagesRequest
     * @return Result of the ListModelPackages operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListModelPackagesResponse listModelPackages(ListModelPackagesRequest listModelPackagesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelPackagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListModelPackagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelPackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelPackages");

            return clientHandler.execute(new ClientExecutionParams<ListModelPackagesRequest, ListModelPackagesResponse>()
                    .withOperationName("ListModelPackages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listModelPackagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListModelPackagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the model packages that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelPackages(software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesIterable responses = client.listModelPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesIterable responses = client
     *             .listModelPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesIterable responses = client.listModelPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelPackages(software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelPackagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListModelPackagesIterable listModelPackagesPaginator(ListModelPackagesRequest listModelPackagesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListModelPackagesIterable(this, applyPaginatorUserAgent(listModelPackagesRequest));
    }

    /**
     * <p>
     * Gets a list of model quality monitoring job definitions in your account.
     * </p>
     *
     * @param listModelQualityJobDefinitionsRequest
     * @return Result of the ListModelQualityJobDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelQualityJobDefinitionsResponse listModelQualityJobDefinitions(
            ListModelQualityJobDefinitionsRequest listModelQualityJobDefinitionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelQualityJobDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListModelQualityJobDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listModelQualityJobDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelQualityJobDefinitions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListModelQualityJobDefinitionsRequest, ListModelQualityJobDefinitionsResponse>()
                            .withOperationName("ListModelQualityJobDefinitions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listModelQualityJobDefinitionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListModelQualityJobDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of model quality monitoring job definitions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsIterable responses = client.listModelQualityJobDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsIterable responses = client
     *             .listModelQualityJobDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsIterable responses = client.listModelQualityJobDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelQualityJobDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelQualityJobDefinitionsIterable listModelQualityJobDefinitionsPaginator(
            ListModelQualityJobDefinitionsRequest listModelQualityJobDefinitionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListModelQualityJobDefinitionsIterable(this, applyPaginatorUserAgent(listModelQualityJobDefinitionsRequest));
    }

    /**
     * <p>
     * Lists models created with the <code>CreateModel</code> API.
     * </p>
     *
     * @param listModelsRequest
     * @return Result of the ListModels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListModelsResponse listModels(ListModelsRequest listModelsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModels");

            return clientHandler
                    .execute(new ClientExecutionParams<ListModelsRequest, ListModelsResponse>().withOperationName("ListModels")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listModelsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists models created with the <code>CreateModel</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)} operation.</b>
     * </p>
     *
     * @param listModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListModelsIterable listModelsPaginator(ListModelsRequest listModelsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListModelsIterable(this, applyPaginatorUserAgent(listModelsRequest));
    }

    /**
     * <p>
     * Returns list of all monitoring job executions.
     * </p>
     *
     * @param listMonitoringExecutionsRequest
     * @return Result of the ListMonitoringExecutions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListMonitoringExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMonitoringExecutionsResponse listMonitoringExecutions(
            ListMonitoringExecutionsRequest listMonitoringExecutionsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMonitoringExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMonitoringExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMonitoringExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMonitoringExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMonitoringExecutionsRequest, ListMonitoringExecutionsResponse>()
                            .withOperationName("ListMonitoringExecutions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listMonitoringExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMonitoringExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns list of all monitoring job executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitoringExecutions(software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsIterable responses = client.listMonitoringExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsIterable responses = client
     *             .listMonitoringExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsIterable responses = client.listMonitoringExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoringExecutions(software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitoringExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListMonitoringExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMonitoringExecutionsIterable listMonitoringExecutionsPaginator(
            ListMonitoringExecutionsRequest listMonitoringExecutionsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListMonitoringExecutionsIterable(this, applyPaginatorUserAgent(listMonitoringExecutionsRequest));
    }

    /**
     * <p>
     * Returns list of all monitoring schedules.
     * </p>
     *
     * @param listMonitoringSchedulesRequest
     * @return Result of the ListMonitoringSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListMonitoringSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMonitoringSchedulesResponse listMonitoringSchedules(ListMonitoringSchedulesRequest listMonitoringSchedulesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMonitoringSchedulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMonitoringSchedulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMonitoringSchedulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMonitoringSchedules");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMonitoringSchedulesRequest, ListMonitoringSchedulesResponse>()
                            .withOperationName("ListMonitoringSchedules").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listMonitoringSchedulesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMonitoringSchedulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns list of all monitoring schedules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitoringSchedules(software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesIterable responses = client.listMonitoringSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesIterable responses = client
     *             .listMonitoringSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesIterable responses = client.listMonitoringSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoringSchedules(software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitoringSchedulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListMonitoringSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMonitoringSchedulesIterable listMonitoringSchedulesPaginator(
            ListMonitoringSchedulesRequest listMonitoringSchedulesRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListMonitoringSchedulesIterable(this, applyPaginatorUserAgent(listMonitoringSchedulesRequest));
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     * @return Result of the ListNotebookInstanceLifecycleConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNotebookInstanceLifecycleConfigsResponse listNotebookInstanceLifecycleConfigs(
            ListNotebookInstanceLifecycleConfigsRequest listNotebookInstanceLifecycleConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNotebookInstanceLifecycleConfigsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListNotebookInstanceLifecycleConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listNotebookInstanceLifecycleConfigsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookInstanceLifecycleConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListNotebookInstanceLifecycleConfigsRequest, ListNotebookInstanceLifecycleConfigsResponse>()
                            .withOperationName("ListNotebookInstanceLifecycleConfigs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listNotebookInstanceLifecycleConfigsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListNotebookInstanceLifecycleConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client
     *             .listNotebookInstanceLifecycleConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNotebookInstanceLifecycleConfigsIterable listNotebookInstanceLifecycleConfigsPaginator(
            ListNotebookInstanceLifecycleConfigsRequest listNotebookInstanceLifecycleConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListNotebookInstanceLifecycleConfigsIterable(this,
                applyPaginatorUserAgent(listNotebookInstanceLifecycleConfigsRequest));
    }

    /**
     * <p>
     * Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
     * </p>
     *
     * @param listNotebookInstancesRequest
     * @return Result of the ListNotebookInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNotebookInstancesResponse listNotebookInstances(ListNotebookInstancesRequest listNotebookInstancesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNotebookInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListNotebookInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNotebookInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookInstances");

            return clientHandler.execute(new ClientExecutionParams<ListNotebookInstancesRequest, ListNotebookInstancesResponse>()
                    .withOperationName("ListNotebookInstances").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listNotebookInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNotebookInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client
     *             .listNotebookInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotebookInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNotebookInstancesIterable listNotebookInstancesPaginator(ListNotebookInstancesRequest listNotebookInstancesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListNotebookInstancesIterable(this, applyPaginatorUserAgent(listNotebookInstancesRequest));
    }

    /**
     * <p>
     * Gets a list of <code>PipeLineExecutionStep</code> objects.
     * </p>
     *
     * @param listPipelineExecutionStepsRequest
     * @return Result of the ListPipelineExecutionSteps operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelineExecutionSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutionSteps"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPipelineExecutionStepsResponse listPipelineExecutionSteps(
            ListPipelineExecutionStepsRequest listPipelineExecutionStepsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPipelineExecutionStepsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPipelineExecutionStepsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPipelineExecutionStepsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPipelineExecutionSteps");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPipelineExecutionStepsRequest, ListPipelineExecutionStepsResponse>()
                            .withOperationName("ListPipelineExecutionSteps").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPipelineExecutionStepsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPipelineExecutionStepsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of <code>PipeLineExecutionStep</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPipelineExecutionSteps(software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionStepsIterable responses = client.listPipelineExecutionStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionStepsIterable responses = client
     *             .listPipelineExecutionStepsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionStepsIterable responses = client.listPipelineExecutionStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineExecutionSteps(software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPipelineExecutionStepsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelineExecutionSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutionSteps"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPipelineExecutionStepsIterable listPipelineExecutionStepsPaginator(
            ListPipelineExecutionStepsRequest listPipelineExecutionStepsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListPipelineExecutionStepsIterable(this, applyPaginatorUserAgent(listPipelineExecutionStepsRequest));
    }

    /**
     * <p>
     * Gets a list of the pipeline executions.
     * </p>
     *
     * @param listPipelineExecutionsRequest
     * @return Result of the ListPipelineExecutions operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelineExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPipelineExecutionsResponse listPipelineExecutions(ListPipelineExecutionsRequest listPipelineExecutionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPipelineExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPipelineExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPipelineExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPipelineExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPipelineExecutionsRequest, ListPipelineExecutionsResponse>()
                            .withOperationName("ListPipelineExecutions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPipelineExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPipelineExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the pipeline executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPipelineExecutions(software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionsIterable responses = client.listPipelineExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionsIterable responses = client
     *             .listPipelineExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionsIterable responses = client.listPipelineExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineExecutions(software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPipelineExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelineExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPipelineExecutionsIterable listPipelineExecutionsPaginator(
            ListPipelineExecutionsRequest listPipelineExecutionsRequest) throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListPipelineExecutionsIterable(this, applyPaginatorUserAgent(listPipelineExecutionsRequest));
    }

    /**
     * <p>
     * Gets a list of parameters for a pipeline execution.
     * </p>
     *
     * @param listPipelineParametersForExecutionRequest
     * @return Result of the ListPipelineParametersForExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelineParametersForExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineParametersForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPipelineParametersForExecutionResponse listPipelineParametersForExecution(
            ListPipelineParametersForExecutionRequest listPipelineParametersForExecutionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPipelineParametersForExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPipelineParametersForExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPipelineParametersForExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPipelineParametersForExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPipelineParametersForExecutionRequest, ListPipelineParametersForExecutionResponse>()
                            .withOperationName("ListPipelineParametersForExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPipelineParametersForExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPipelineParametersForExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of parameters for a pipeline execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPipelineParametersForExecution(software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelineParametersForExecutionIterable responses = client.listPipelineParametersForExecutionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListPipelineParametersForExecutionIterable responses = client
     *             .listPipelineParametersForExecutionPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelineParametersForExecutionIterable responses = client.listPipelineParametersForExecutionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineParametersForExecution(software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPipelineParametersForExecutionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelineParametersForExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineParametersForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPipelineParametersForExecutionIterable listPipelineParametersForExecutionPaginator(
            ListPipelineParametersForExecutionRequest listPipelineParametersForExecutionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListPipelineParametersForExecutionIterable(this,
                applyPaginatorUserAgent(listPipelineParametersForExecutionRequest));
    }

    /**
     * <p>
     * Gets a list of pipelines.
     * </p>
     *
     * @param listPipelinesRequest
     * @return Result of the ListPipelines operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelines" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPipelinesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPipelinesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPipelines");

            return clientHandler.execute(new ClientExecutionParams<ListPipelinesRequest, ListPipelinesResponse>()
                    .withOperationName("ListPipelines").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPipelinesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPipelinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of pipelines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPipelines(software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @param listPipelinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelines" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListPipelinesIterable(this, applyPaginatorUserAgent(listPipelinesRequest));
    }

    /**
     * <p>
     * Lists processing jobs that satisfy various filters.
     * </p>
     *
     * @param listProcessingJobsRequest
     * @return Result of the ListProcessingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProcessingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListProcessingJobsResponse listProcessingJobs(ListProcessingJobsRequest listProcessingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProcessingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProcessingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProcessingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProcessingJobs");

            return clientHandler.execute(new ClientExecutionParams<ListProcessingJobsRequest, ListProcessingJobsResponse>()
                    .withOperationName("ListProcessingJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listProcessingJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListProcessingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists processing jobs that satisfy various filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProcessingJobs(software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListProcessingJobsIterable responses = client.listProcessingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListProcessingJobsIterable responses = client
     *             .listProcessingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListProcessingJobsIterable responses = client.listProcessingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProcessingJobs(software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProcessingJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProcessingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListProcessingJobsIterable listProcessingJobsPaginator(ListProcessingJobsRequest listProcessingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListProcessingJobsIterable(this, applyPaginatorUserAgent(listProcessingJobsRequest));
    }

    /**
     * <p>
     * Gets a list of the projects in an Amazon Web Services account.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProjectsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListProjectsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjects");

            return clientHandler.execute(new ClientExecutionParams<ListProjectsRequest, ListProjectsResponse>()
                    .withOperationName("ListProjects").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listProjectsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListProjectsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the projects in an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListProjectsIterable(this, applyPaginatorUserAgent(listProjectsRequest));
    }

    /**
     * <p>
     * Lists devices allocated to the stage, containing detailed device information and deployment status.
     * </p>
     *
     * @param listStageDevicesRequest
     * @return Result of the ListStageDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListStageDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListStageDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStageDevicesResponse listStageDevices(ListStageDevicesRequest listStageDevicesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStageDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListStageDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStageDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStageDevices");

            return clientHandler.execute(new ClientExecutionParams<ListStageDevicesRequest, ListStageDevicesResponse>()
                    .withOperationName("ListStageDevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listStageDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStageDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists devices allocated to the stage, containing detailed device information and deployment status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStageDevices(software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListStageDevicesIterable responses = client.listStageDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListStageDevicesIterable responses = client
     *             .listStageDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListStageDevicesIterable responses = client.listStageDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStageDevices(software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listStageDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListStageDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListStageDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStageDevicesIterable listStageDevicesPaginator(ListStageDevicesRequest listStageDevicesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListStageDevicesIterable(this, applyPaginatorUserAgent(listStageDevicesRequest));
    }

    /**
     * <p>
     * Lists the Studio Lifecycle Configurations in your Amazon Web Services Account.
     * </p>
     *
     * @param listStudioLifecycleConfigsRequest
     * @return Result of the ListStudioLifecycleConfigs operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListStudioLifecycleConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListStudioLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStudioLifecycleConfigsResponse listStudioLifecycleConfigs(
            ListStudioLifecycleConfigsRequest listStudioLifecycleConfigsRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStudioLifecycleConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStudioLifecycleConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStudioLifecycleConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStudioLifecycleConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStudioLifecycleConfigsRequest, ListStudioLifecycleConfigsResponse>()
                            .withOperationName("ListStudioLifecycleConfigs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listStudioLifecycleConfigsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStudioLifecycleConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Studio Lifecycle Configurations in your Amazon Web Services Account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListStudioLifecycleConfigsIterable responses = client.listStudioLifecycleConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListStudioLifecycleConfigsIterable responses = client
     *             .listStudioLifecycleConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListStudioLifecycleConfigsIterable responses = client.listStudioLifecycleConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStudioLifecycleConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListStudioLifecycleConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListStudioLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStudioLifecycleConfigsIterable listStudioLifecycleConfigsPaginator(
            ListStudioLifecycleConfigsRequest listStudioLifecycleConfigsRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListStudioLifecycleConfigsIterable(this, applyPaginatorUserAgent(listStudioLifecycleConfigsRequest));
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be
     * empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     *
     * @param listSubscribedWorkteamsRequest
     * @return Result of the ListSubscribedWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSubscribedWorkteamsResponse listSubscribedWorkteams(ListSubscribedWorkteamsRequest listSubscribedWorkteamsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSubscribedWorkteamsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSubscribedWorkteamsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSubscribedWorkteamsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSubscribedWorkteams");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSubscribedWorkteamsRequest, ListSubscribedWorkteamsResponse>()
                            .withOperationName("ListSubscribedWorkteams").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listSubscribedWorkteamsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSubscribedWorkteamsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be
     * empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client
     *             .listSubscribedWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscribedWorkteamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSubscribedWorkteamsIterable listSubscribedWorkteamsPaginator(
            ListSubscribedWorkteamsRequest listSubscribedWorkteamsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListSubscribedWorkteamsIterable(this, applyPaginatorUserAgent(listSubscribedWorkteamsRequest));
    }

    /**
     * <p>
     * Returns the tags for the specified SageMaker resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");

            return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                    .withOperationName("ListTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the tags for the specified SageMaker resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.sagemaker.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.sagemaker.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListTagsIterable(this, applyPaginatorUserAgent(listTagsRequest));
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     * <note>
     * <p>
     * When <code>StatusEquals</code> and <code>MaxResults</code> are set at the same time, the <code>MaxResults</code>
     * number of training jobs are first retrieved ignoring the <code>StatusEquals</code> parameter and then they are
     * filtered by the <code>StatusEquals</code> parameter, which is returned as a response.
     * </p>
     * <p>
     * For example, if <code>ListTrainingJobs</code> is invoked with the following parameters:
     * </p>
     * <p>
     * <code>{ ... MaxResults: 100, StatusEquals: InProgress ... }</code>
     * </p>
     * <p>
     * First, 100 trainings jobs with any status, including those other than <code>InProgress</code>, are selected
     * (sorted according to the creation time, from the most current to the oldest). Next, those with a status of
     * <code>InProgress</code> are returned.
     * </p>
     * <p>
     * You can quickly test the API using the following Amazon Web Services CLI code.
     * </p>
     * <p>
     * <code>aws sagemaker list-training-jobs --max-results 100 --status-equals InProgress</code>
     * </p>
     * </note>
     *
     * @param listTrainingJobsRequest
     * @return Result of the ListTrainingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTrainingJobsResponse listTrainingJobs(ListTrainingJobsRequest listTrainingJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrainingJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTrainingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrainingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainingJobs");

            return clientHandler.execute(new ClientExecutionParams<ListTrainingJobsRequest, ListTrainingJobsResponse>()
                    .withOperationName("ListTrainingJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTrainingJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTrainingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     * <note>
     * <p>
     * When <code>StatusEquals</code> and <code>MaxResults</code> are set at the same time, the <code>MaxResults</code>
     * number of training jobs are first retrieved ignoring the <code>StatusEquals</code> parameter and then they are
     * filtered by the <code>StatusEquals</code> parameter, which is returned as a response.
     * </p>
     * <p>
     * For example, if <code>ListTrainingJobs</code> is invoked with the following parameters:
     * </p>
     * <p>
     * <code>{ ... MaxResults: 100, StatusEquals: InProgress ... }</code>
     * </p>
     * <p>
     * First, 100 trainings jobs with any status, including those other than <code>InProgress</code>, are selected
     * (sorted according to the creation time, from the most current to the oldest). Next, those with a status of
     * <code>InProgress</code> are returned.
     * </p>
     * <p>
     * You can quickly test the API using the following Amazon Web Services CLI code.
     * </p>
     * <p>
     * <code>aws sagemaker list-training-jobs --max-results 100 --status-equals InProgress</code>
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client
     *             .listTrainingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation.</b>
     * </p>
     *
     * @param listTrainingJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTrainingJobsIterable listTrainingJobsPaginator(ListTrainingJobsRequest listTrainingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListTrainingJobsIterable(this, applyPaginatorUserAgent(listTrainingJobsRequest));
    }

    /**
     * <p>
     * Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job
     * launched.
     * </p>
     *
     * @param listTrainingJobsForHyperParameterTuningJobRequest
     * @return Result of the ListTrainingJobsForHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobsForHyperParameterTuningJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrainingJobsForHyperParameterTuningJobResponse listTrainingJobsForHyperParameterTuningJob(
            ListTrainingJobsForHyperParameterTuningJobRequest listTrainingJobsForHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrainingJobsForHyperParameterTuningJobResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListTrainingJobsForHyperParameterTuningJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTrainingJobsForHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainingJobsForHyperParameterTuningJob");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrainingJobsForHyperParameterTuningJobRequest, ListTrainingJobsForHyperParameterTuningJobResponse>()
                            .withOperationName("ListTrainingJobsForHyperParameterTuningJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTrainingJobsForHyperParameterTuningJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTrainingJobsForHyperParameterTuningJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job
     * launched.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingJobsForHyperParameterTuningJob(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client.listTrainingJobsForHyperParameterTuningJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client
     *             .listTrainingJobsForHyperParameterTuningJobPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client.listTrainingJobsForHyperParameterTuningJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingJobsForHyperParameterTuningJob(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainingJobsForHyperParameterTuningJobRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobsForHyperParameterTuningJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrainingJobsForHyperParameterTuningJobIterable listTrainingJobsForHyperParameterTuningJobPaginator(
            ListTrainingJobsForHyperParameterTuningJobRequest listTrainingJobsForHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListTrainingJobsForHyperParameterTuningJobIterable(this,
                applyPaginatorUserAgent(listTrainingJobsForHyperParameterTuningJobRequest));
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     *
     * @param listTransformJobsRequest
     * @return Result of the ListTransformJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTransformJobsResponse listTransformJobs(ListTransformJobsRequest listTransformJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTransformJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTransformJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTransformJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTransformJobs");

            return clientHandler.execute(new ClientExecutionParams<ListTransformJobsRequest, ListTransformJobsResponse>()
                    .withOperationName("ListTransformJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTransformJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTransformJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client
     *             .listTransformJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTransformJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTransformJobsIterable listTransformJobsPaginator(ListTransformJobsRequest listTransformJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListTransformJobsIterable(this, applyPaginatorUserAgent(listTransformJobsRequest));
    }

    /**
     * <p>
     * Lists the trial components in your account. You can sort the list by trial component name or creation time. You
     * can filter the list to show only components that were created in a specific time range. You can also filter on
     * one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ExperimentName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TrialName</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param listTrialComponentsRequest
     * @return Result of the ListTrialComponents operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrialComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrialComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTrialComponentsResponse listTrialComponents(ListTrialComponentsRequest listTrialComponentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrialComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTrialComponentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrialComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrialComponents");

            return clientHandler.execute(new ClientExecutionParams<ListTrialComponentsRequest, ListTrialComponentsResponse>()
                    .withOperationName("ListTrialComponents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTrialComponentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTrialComponentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the trial components in your account. You can sort the list by trial component name or creation time. You
     * can filter the list to show only components that were created in a specific time range. You can also filter on
     * one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ExperimentName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TrialName</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrialComponents(software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrialComponentsIterable responses = client.listTrialComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrialComponentsIterable responses = client
     *             .listTrialComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrialComponentsIterable responses = client.listTrialComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrialComponents(software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrialComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrialComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrialComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTrialComponentsIterable listTrialComponentsPaginator(ListTrialComponentsRequest listTrialComponentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListTrialComponentsIterable(this, applyPaginatorUserAgent(listTrialComponentsRequest));
    }

    /**
     * <p>
     * Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of
     * that experiment. Specify a trial component name to limit the list to the trials that associated with that trial
     * component. The list can be filtered to show only trials that were created in a specific time range. The list can
     * be sorted by trial name or creation time.
     * </p>
     *
     * @param listTrialsRequest
     * @return Result of the ListTrials operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrials" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTrialsResponse listTrials(ListTrialsRequest listTrialsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrialsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTrialsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrials");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrialsRequest, ListTrialsResponse>().withOperationName("ListTrials")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTrialsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTrialsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of
     * that experiment. Specify a trial component name to limit the list to the trials that associated with that trial
     * component. The list can be filtered to show only trials that were created in a specific time range. The list can
     * be sorted by trial name or creation time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTrials(software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrialsIterable responses = client.listTrialsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrialsIterable responses = client.listTrialsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrialsIterable responses = client.listTrialsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrials(software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest)} operation.</b>
     * </p>
     *
     * @param listTrialsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrials" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTrialsIterable listTrialsPaginator(ListTrialsRequest listTrialsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListTrialsIterable(this, applyPaginatorUserAgent(listTrialsRequest));
    }

    /**
     * <p>
     * Lists user profiles.
     * </p>
     *
     * @param listUserProfilesRequest
     * @return Result of the ListUserProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListUserProfilesResponse listUserProfiles(ListUserProfilesRequest listUserProfilesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUserProfilesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUserProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListUserProfilesRequest, ListUserProfilesResponse>()
                    .withOperationName("ListUserProfiles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUserProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUserProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists user profiles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserProfiles(software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListUserProfilesIterable responses = client.listUserProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListUserProfilesIterable responses = client
     *             .listUserProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListUserProfilesIterable responses = client.listUserProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserProfiles(software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listUserProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListUserProfilesIterable listUserProfilesPaginator(ListUserProfilesRequest listUserProfilesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListUserProfilesIterable(this, applyPaginatorUserAgent(listUserProfilesRequest));
    }

    /**
     * <p>
     * Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can
     * only have one private workforce per Amazon Web Services Region.
     * </p>
     *
     * @param listWorkforcesRequest
     * @return Result of the ListWorkforces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkforces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkforces" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkforcesResponse listWorkforces(ListWorkforcesRequest listWorkforcesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkforcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkforcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkforcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkforces");

            return clientHandler.execute(new ClientExecutionParams<ListWorkforcesRequest, ListWorkforcesResponse>()
                    .withOperationName("ListWorkforces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listWorkforcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkforcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can
     * only have one private workforce per Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkforces(software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkforcesIterable responses = client.listWorkforcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListWorkforcesIterable responses = client
     *             .listWorkforcesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkforcesIterable responses = client.listWorkforcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkforces(software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest)} operation.</b>
     * </p>
     *
     * @param listWorkforcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkforces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkforces" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkforcesIterable listWorkforcesPaginator(ListWorkforcesRequest listWorkforcesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListWorkforcesIterable(this, applyPaginatorUserAgent(listWorkforcesRequest));
    }

    /**
     * <p>
     * Gets a list of private work teams that you have defined in a region. The list may be empty if no work team
     * satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     *
     * @param listWorkteamsRequest
     * @return Result of the ListWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkteamsResponse listWorkteams(ListWorkteamsRequest listWorkteamsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkteamsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkteamsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkteamsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkteams");

            return clientHandler.execute(new ClientExecutionParams<ListWorkteamsRequest, ListWorkteamsResponse>()
                    .withOperationName("ListWorkteams").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listWorkteamsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkteamsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of private work teams that you have defined in a region. The list may be empty if no work team
     * satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkteamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkteamsIterable listWorkteamsPaginator(ListWorkteamsRequest listWorkteamsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListWorkteamsIterable(this, applyPaginatorUserAgent(listWorkteamsRequest));
    }

    /**
     * <p>
     * Adds a resouce policy to control access to a model group. For information about resoure policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User
     * Guide.</i>.
     * </p>
     *
     * @param putModelPackageGroupPolicyRequest
     * @return Result of the PutModelPackageGroupPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.PutModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/PutModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutModelPackageGroupPolicyResponse putModelPackageGroupPolicy(
            PutModelPackageGroupPolicyRequest putModelPackageGroupPolicyRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutModelPackageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutModelPackageGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putModelPackageGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutModelPackageGroupPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<PutModelPackageGroupPolicyRequest, PutModelPackageGroupPolicyResponse>()
                            .withOperationName("PutModelPackageGroupPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putModelPackageGroupPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutModelPackageGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to inspect your lineage and discover relationships between entities. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html"> Querying Lineage
     * Entities</a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param queryLineageRequest
     * @return Result of the QueryLineage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.QueryLineage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/QueryLineage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public QueryLineageResponse queryLineage(QueryLineageRequest queryLineageRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<QueryLineageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                QueryLineageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, queryLineageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "QueryLineage");

            return clientHandler.execute(new ClientExecutionParams<QueryLineageRequest, QueryLineageResponse>()
                    .withOperationName("QueryLineage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(queryLineageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new QueryLineageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to inspect your lineage and discover relationships between entities. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html"> Querying Lineage
     * Entities</a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #queryLineage(software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.QueryLineageIterable responses = client.queryLineagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.QueryLineageIterable responses = client.queryLineagePaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.QueryLineageIterable responses = client.queryLineagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryLineage(software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest)} operation.</b>
     * </p>
     *
     * @param queryLineageRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.QueryLineage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/QueryLineage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public QueryLineageIterable queryLineagePaginator(QueryLineageRequest queryLineageRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new QueryLineageIterable(this, applyPaginatorUserAgent(queryLineageRequest));
    }

    /**
     * <p>
     * Register devices.
     * </p>
     *
     * @param registerDevicesRequest
     * @return Result of the RegisterDevices operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.RegisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RegisterDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RegisterDevicesResponse registerDevices(RegisterDevicesRequest registerDevicesRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RegisterDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterDevices");

            return clientHandler.execute(new ClientExecutionParams<RegisterDevicesRequest, RegisterDevicesResponse>()
                    .withOperationName("RegisterDevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(registerDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Renders the UI template so that you can preview the worker's experience.
     * </p>
     *
     * @param renderUiTemplateRequest
     * @return Result of the RenderUiTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.RenderUiTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RenderUiTemplateResponse renderUiTemplate(RenderUiTemplateRequest renderUiTemplateRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RenderUiTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RenderUiTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, renderUiTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RenderUiTemplate");

            return clientHandler.execute(new ClientExecutionParams<RenderUiTemplateRequest, RenderUiTemplateResponse>()
                    .withOperationName("RenderUiTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(renderUiTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RenderUiTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retry the execution of the pipeline.
     * </p>
     *
     * @param retryPipelineExecutionRequest
     * @return Result of the RetryPipelineExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.RetryPipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RetryPipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RetryPipelineExecutionResponse retryPipelineExecution(RetryPipelineExecutionRequest retryPipelineExecutionRequest)
            throws ResourceNotFoundException, ResourceLimitExceededException, ConflictException, AwsServiceException,
            SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RetryPipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RetryPipelineExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, retryPipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RetryPipelineExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<RetryPipelineExecutionRequest, RetryPipelineExecutionResponse>()
                            .withOperationName("RetryPipelineExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(retryPipelineExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RetryPipelineExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of
     * <code>SearchRecord</code> objects in the response. You can sort the search results by any resource property in a
     * ascending or descending order.
     * </p>
     * <p>
     * You can query against the following value types: numeric, text, Boolean, and timestamp.
     * </p>
     *
     * @param searchRequest
     * @return Result of the Search operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchResponse search(SearchRequest searchRequest) throws AwsServiceException, SdkClientException, SageMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "Search");

            return clientHandler.execute(new ClientExecutionParams<SearchRequest, SearchResponse>().withOperationName("Search")
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(searchRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new SearchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of
     * <code>SearchRecord</code> objects in the response. You can sort the search results by any resource property in a
     * ascending or descending order.
     * </p>
     * <p>
     * You can query against the following value types: numeric, text, Boolean, and timestamp.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.sagemaker.model.SearchRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.SearchResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.sagemaker.model.SearchRequest)} operation.</b>
     * </p>
     *
     * @param searchRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchIterable searchPaginator(SearchRequest searchRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new SearchIterable(this, applyPaginatorUserAgent(searchRequest));
    }

    /**
     * <p>
     * Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a
     * callback step is run, the pipeline generates a callback token a