/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inputs for a processing job. The processing input must specify exactly one of either <code>S3Input</code> or
 * <code>DatasetDefinition</code> types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingInput implements SdkPojo, Serializable, ToCopyableBuilder<ProcessingInput.Builder, ProcessingInput> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputName").getter(getter(ProcessingInput::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputName").build()).build();

    private static final SdkField<Boolean> APP_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AppManaged").getter(getter(ProcessingInput::appManaged)).setter(setter(Builder::appManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppManaged").build()).build();

    private static final SdkField<ProcessingS3Input> S3_INPUT_FIELD = SdkField
            .<ProcessingS3Input> builder(MarshallingType.SDK_POJO).memberName("S3Input").getter(getter(ProcessingInput::s3Input))
            .setter(setter(Builder::s3Input)).constructor(ProcessingS3Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Input").build()).build();

    private static final SdkField<DatasetDefinition> DATASET_DEFINITION_FIELD = SdkField
            .<DatasetDefinition> builder(MarshallingType.SDK_POJO).memberName("DatasetDefinition")
            .getter(getter(ProcessingInput::datasetDefinition)).setter(setter(Builder::datasetDefinition))
            .constructor(DatasetDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            APP_MANAGED_FIELD, S3_INPUT_FIELD, DATASET_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputName;

    private final Boolean appManaged;

    private final ProcessingS3Input s3Input;

    private final DatasetDefinition datasetDefinition;

    private ProcessingInput(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.appManaged = builder.appManaged;
        this.s3Input = builder.s3Input;
        this.datasetDefinition = builder.datasetDefinition;
    }

    /**
     * <p>
     * The name for the processing job input.
     * </p>
     * 
     * @return The name for the processing job input.
     */
    public final String inputName() {
        return inputName;
    }

    /**
     * <p>
     * When <code>True</code>, input operations such as data download are managed natively by the processing job
     * application. When <code>False</code> (default), input operations are managed by Amazon SageMaker.
     * </p>
     * 
     * @return When <code>True</code>, input operations such as data download are managed natively by the processing job
     *         application. When <code>False</code> (default), input operations are managed by Amazon SageMaker.
     */
    public final Boolean appManaged() {
        return appManaged;
    }

    /**
     * <p>
     * Configuration for downloading input data from Amazon S3 into the processing container.
     * </p>
     * 
     * @return Configuration for downloading input data from Amazon S3 into the processing container.
     */
    public final ProcessingS3Input s3Input() {
        return s3Input;
    }

    /**
     * <p>
     * Configuration for a Dataset Definition input.
     * </p>
     * 
     * @return Configuration for a Dataset Definition input.
     */
    public final DatasetDefinition datasetDefinition() {
        return datasetDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(appManaged());
        hashCode = 31 * hashCode + Objects.hashCode(s3Input());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingInput)) {
            return false;
        }
        ProcessingInput other = (ProcessingInput) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(appManaged(), other.appManaged())
                && Objects.equals(s3Input(), other.s3Input()) && Objects.equals(datasetDefinition(), other.datasetDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessingInput").add("InputName", inputName()).add("AppManaged", appManaged())
                .add("S3Input", s3Input()).add("DatasetDefinition", datasetDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "AppManaged":
            return Optional.ofNullable(clazz.cast(appManaged()));
        case "S3Input":
            return Optional.ofNullable(clazz.cast(s3Input()));
        case "DatasetDefinition":
            return Optional.ofNullable(clazz.cast(datasetDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingInput, T> g) {
        return obj -> g.apply((ProcessingInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingInput> {
        /**
         * <p>
         * The name for the processing job input.
         * </p>
         * 
         * @param inputName
         *        The name for the processing job input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * When <code>True</code>, input operations such as data download are managed natively by the processing job
         * application. When <code>False</code> (default), input operations are managed by Amazon SageMaker.
         * </p>
         * 
         * @param appManaged
         *        When <code>True</code>, input operations such as data download are managed natively by the processing
         *        job application. When <code>False</code> (default), input operations are managed by Amazon SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appManaged(Boolean appManaged);

        /**
         * <p>
         * Configuration for downloading input data from Amazon S3 into the processing container.
         * </p>
         * 
         * @param s3Input
         *        Configuration for downloading input data from Amazon S3 into the processing container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Input(ProcessingS3Input s3Input);

        /**
         * <p>
         * Configuration for downloading input data from Amazon S3 into the processing container.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcessingS3Input.Builder} avoiding the
         * need to create one manually via {@link ProcessingS3Input#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingS3Input.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Input(ProcessingS3Input)}.
         * 
         * @param s3Input
         *        a consumer that will call methods on {@link ProcessingS3Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Input(ProcessingS3Input)
         */
        default Builder s3Input(Consumer<ProcessingS3Input.Builder> s3Input) {
            return s3Input(ProcessingS3Input.builder().applyMutation(s3Input).build());
        }

        /**
         * <p>
         * Configuration for a Dataset Definition input.
         * </p>
         * 
         * @param datasetDefinition
         *        Configuration for a Dataset Definition input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDefinition(DatasetDefinition datasetDefinition);

        /**
         * <p>
         * Configuration for a Dataset Definition input.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetDefinition.Builder} avoiding the
         * need to create one manually via {@link DatasetDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetDefinition(DatasetDefinition)}.
         * 
         * @param datasetDefinition
         *        a consumer that will call methods on {@link DatasetDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetDefinition(DatasetDefinition)
         */
        default Builder datasetDefinition(Consumer<DatasetDefinition.Builder> datasetDefinition) {
            return datasetDefinition(DatasetDefinition.builder().applyMutation(datasetDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputName;

        private Boolean appManaged;

        private ProcessingS3Input s3Input;

        private DatasetDefinition datasetDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingInput model) {
            inputName(model.inputName);
            appManaged(model.appManaged);
            s3Input(model.s3Input);
            datasetDefinition(model.datasetDefinition);
        }

        public final String getInputName() {
            return inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final Boolean getAppManaged() {
            return appManaged;
        }

        public final void setAppManaged(Boolean appManaged) {
            this.appManaged = appManaged;
        }

        @Override
        public final Builder appManaged(Boolean appManaged) {
            this.appManaged = appManaged;
            return this;
        }

        public final ProcessingS3Input.Builder getS3Input() {
            return s3Input != null ? s3Input.toBuilder() : null;
        }

        public final void setS3Input(ProcessingS3Input.BuilderImpl s3Input) {
            this.s3Input = s3Input != null ? s3Input.build() : null;
        }

        @Override
        public final Builder s3Input(ProcessingS3Input s3Input) {
            this.s3Input = s3Input;
            return this;
        }

        public final DatasetDefinition.Builder getDatasetDefinition() {
            return datasetDefinition != null ? datasetDefinition.toBuilder() : null;
        }

        public final void setDatasetDefinition(DatasetDefinition.BuilderImpl datasetDefinition) {
            this.datasetDefinition = datasetDefinition != null ? datasetDefinition.build() : null;
        }

        @Override
        public final Builder datasetDefinition(DatasetDefinition datasetDefinition) {
            this.datasetDefinition = datasetDefinition;
            return this;
        }

        @Override
        public ProcessingInput build() {
            return new ProcessingInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
