/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrainingJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateTrainingJobRequest.Builder, UpdateTrainingJobRequest> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingJobName").getter(getter(UpdateTrainingJobRequest::trainingJobName))
            .setter(setter(Builder::trainingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()).build();

    private static final SdkField<ProfilerConfigForUpdate> PROFILER_CONFIG_FIELD = SdkField
            .<ProfilerConfigForUpdate> builder(MarshallingType.SDK_POJO).memberName("ProfilerConfig")
            .getter(getter(UpdateTrainingJobRequest::profilerConfig)).setter(setter(Builder::profilerConfig))
            .constructor(ProfilerConfigForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerConfig").build()).build();

    private static final SdkField<List<ProfilerRuleConfiguration>> PROFILER_RULE_CONFIGURATIONS_FIELD = SdkField
            .<List<ProfilerRuleConfiguration>> builder(MarshallingType.LIST)
            .memberName("ProfilerRuleConfigurations")
            .getter(getter(UpdateTrainingJobRequest::profilerRuleConfigurations))
            .setter(setter(Builder::profilerRuleConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerRuleConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfilerRuleConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfilerRuleConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD,
            PROFILER_CONFIG_FIELD, PROFILER_RULE_CONFIGURATIONS_FIELD));

    private final String trainingJobName;

    private final ProfilerConfigForUpdate profilerConfig;

    private final List<ProfilerRuleConfiguration> profilerRuleConfigurations;

    private UpdateTrainingJobRequest(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.profilerConfig = builder.profilerConfig;
        this.profilerRuleConfigurations = builder.profilerRuleConfigurations;
    }

    /**
     * <p>
     * The name of a training job to update the Debugger profiling configuration.
     * </p>
     * 
     * @return The name of a training job to update the Debugger profiling configuration.
     */
    public final String trainingJobName() {
        return trainingJobName;
    }

    /**
     * <p>
     * Configuration information for Debugger system monitoring, framework profiling, and storage paths.
     * </p>
     * 
     * @return Configuration information for Debugger system monitoring, framework profiling, and storage paths.
     */
    public final ProfilerConfigForUpdate profilerConfig() {
        return profilerConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfilerRuleConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProfilerRuleConfigurations() {
        return profilerRuleConfigurations != null && !(profilerRuleConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for Debugger rules for profiling system and framework metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfilerRuleConfigurations} method.
     * </p>
     * 
     * @return Configuration information for Debugger rules for profiling system and framework metrics.
     */
    public final List<ProfilerRuleConfiguration> profilerRuleConfigurations() {
        return profilerRuleConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(profilerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfilerRuleConfigurations() ? profilerRuleConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrainingJobRequest)) {
            return false;
        }
        UpdateTrainingJobRequest other = (UpdateTrainingJobRequest) obj;
        return Objects.equals(trainingJobName(), other.trainingJobName())
                && Objects.equals(profilerConfig(), other.profilerConfig())
                && hasProfilerRuleConfigurations() == other.hasProfilerRuleConfigurations()
                && Objects.equals(profilerRuleConfigurations(), other.profilerRuleConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrainingJobRequest").add("TrainingJobName", trainingJobName())
                .add("ProfilerConfig", profilerConfig())
                .add("ProfilerRuleConfigurations", hasProfilerRuleConfigurations() ? profilerRuleConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJobName":
            return Optional.ofNullable(clazz.cast(trainingJobName()));
        case "ProfilerConfig":
            return Optional.ofNullable(clazz.cast(profilerConfig()));
        case "ProfilerRuleConfigurations":
            return Optional.ofNullable(clazz.cast(profilerRuleConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrainingJobRequest, T> g) {
        return obj -> g.apply((UpdateTrainingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrainingJobRequest> {
        /**
         * <p>
         * The name of a training job to update the Debugger profiling configuration.
         * </p>
         * 
         * @param trainingJobName
         *        The name of a training job to update the Debugger profiling configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobName(String trainingJobName);

        /**
         * <p>
         * Configuration information for Debugger system monitoring, framework profiling, and storage paths.
         * </p>
         * 
         * @param profilerConfig
         *        Configuration information for Debugger system monitoring, framework profiling, and storage paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerConfig(ProfilerConfigForUpdate profilerConfig);

        /**
         * <p>
         * Configuration information for Debugger system monitoring, framework profiling, and storage paths.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfilerConfigForUpdate.Builder} avoiding
         * the need to create one manually via {@link ProfilerConfigForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfilerConfigForUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #profilerConfig(ProfilerConfigForUpdate)}.
         * 
         * @param profilerConfig
         *        a consumer that will call methods on {@link ProfilerConfigForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilerConfig(ProfilerConfigForUpdate)
         */
        default Builder profilerConfig(Consumer<ProfilerConfigForUpdate.Builder> profilerConfig) {
            return profilerConfig(ProfilerConfigForUpdate.builder().applyMutation(profilerConfig).build());
        }

        /**
         * <p>
         * Configuration information for Debugger rules for profiling system and framework metrics.
         * </p>
         * 
         * @param profilerRuleConfigurations
         *        Configuration information for Debugger rules for profiling system and framework metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations);

        /**
         * <p>
         * Configuration information for Debugger rules for profiling system and framework metrics.
         * </p>
         * 
         * @param profilerRuleConfigurations
         *        Configuration information for Debugger rules for profiling system and framework metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilerRuleConfigurations(ProfilerRuleConfiguration... profilerRuleConfigurations);

        /**
         * <p>
         * Configuration information for Debugger rules for profiling system and framework metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #profilerRuleConfigurations(List<ProfilerRuleConfiguration>)}.
         * 
         * @param profilerRuleConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilerRuleConfigurations(java.util.Collection<ProfilerRuleConfiguration>)
         */
        Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder>... profilerRuleConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trainingJobName;

        private ProfilerConfigForUpdate profilerConfig;

        private List<ProfilerRuleConfiguration> profilerRuleConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrainingJobRequest model) {
            super(model);
            trainingJobName(model.trainingJobName);
            profilerConfig(model.profilerConfig);
            profilerRuleConfigurations(model.profilerRuleConfigurations);
        }

        public final String getTrainingJobName() {
            return trainingJobName;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final ProfilerConfigForUpdate.Builder getProfilerConfig() {
            return profilerConfig != null ? profilerConfig.toBuilder() : null;
        }

        public final void setProfilerConfig(ProfilerConfigForUpdate.BuilderImpl profilerConfig) {
            this.profilerConfig = profilerConfig != null ? profilerConfig.build() : null;
        }

        @Override
        public final Builder profilerConfig(ProfilerConfigForUpdate profilerConfig) {
            this.profilerConfig = profilerConfig;
            return this;
        }

        public final List<ProfilerRuleConfiguration.Builder> getProfilerRuleConfigurations() {
            List<ProfilerRuleConfiguration.Builder> result = ProfilerRuleConfigurationsCopier
                    .copyToBuilder(this.profilerRuleConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfilerRuleConfigurations(
                Collection<ProfilerRuleConfiguration.BuilderImpl> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copyFromBuilder(profilerRuleConfigurations);
        }

        @Override
        public final Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copy(profilerRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(ProfilerRuleConfiguration... profilerRuleConfigurations) {
            profilerRuleConfigurations(Arrays.asList(profilerRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder>... profilerRuleConfigurations) {
            profilerRuleConfigurations(Stream.of(profilerRuleConfigurations)
                    .map(c -> ProfilerRuleConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrainingJobRequest build() {
            return new UpdateTrainingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
