/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.ConflictException;
import software.amazon.awssdk.services.sagemaker.model.CreateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListActionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListActionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListContextsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListContextsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceInUseException;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.sagemaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.SageMakerException;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.paginators.ListActionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListContextsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDevicesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListImagesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionStepsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineParametersForExecutionPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelinesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListProcessingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListStageDevicesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListStudioLifecycleConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTagsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialComponentsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListUserProfilesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkforcesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.QueryLineagePublisher;
import software.amazon.awssdk.services.sagemaker.paginators.SearchPublisher;
import software.amazon.awssdk.services.sagemaker.transform.AddAssociationRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.AssociateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.BatchDescribeModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedDomainUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedNotebookInstanceUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAssociationRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeregisterDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFeatureMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeLineageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineDefinitionForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeSubscribedWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DisableSagemakerServicecatalogPortfolioRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DisassociateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.EnableSagemakerServicecatalogPortfolioRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetDeviceFleetReportRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetLineageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetSagemakerServicecatalogPortfolioStatusRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetSearchSuggestionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListActionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAlgorithmsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAppImageConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListArtifactsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAutoMlJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCandidatesForAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCodeRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCompilationJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListContextsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDataQualityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDeviceFleetsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEdgeDeploymentPlansRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEdgePackagingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListExperimentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListFeatureGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListFlowDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHumanTaskUisRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHyperParameterTuningJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListImageVersionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListInferenceRecommendationsJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLabelingJobsForWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLabelingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLineageGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelBiasJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelExplainabilityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelPackageGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelPackagesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelQualityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringSchedulesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstanceLifecycleConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstancesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineExecutionStepsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineParametersForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListProcessingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListStageDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListStudioLifecycleConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListSubscribedWorkteamsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsForHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTransformJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrialComponentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrialsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListUserProfilesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListWorkforcesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListWorkteamsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.PutModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.QueryLineageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RegisterDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RenderUiTemplateRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RetryPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SearchRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SendPipelineExecutionStepFailureRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SendPipelineExecutionStepSuccessRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointWeightsAndCapacitiesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateFeatureMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdatePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.waiters.SageMakerAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link SageMakerAsyncClient}.
 *
 * @see SageMakerAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSageMakerAsyncClient implements SageMakerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSageMakerAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultSageMakerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates an <i>association</i> between the source and the destination. A source can be associated with multiple
     * destinations, and a destination can be associated with multiple sources. An association is a lineage tracking
     * entity. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param addAssociationRequest
     * @return A Java Future containing the result of the AddAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddAssociationResponse> addAssociation(AddAssociationRequest addAssociationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddAssociationRequest, AddAssociationResponse>()
                            .withOperationName("AddAssociation")
                            .withMarshaller(new AddAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addAssociationRequest));
            CompletableFuture<AddAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances,
     * training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
     * configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging
     * Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of
     * <a>CreateHyperParameterTuningJob</a>
     * </p>
     * </note> <note>
     * <p>
     * Tags that you add to a SageMaker Studio Domain or User Profile by calling this API are also added to any Apps
     * that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile
     * launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also
     * added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User
     * Profile by specifying them in the <code>Tags</code> parameter of <a>CreateDomain</a> or <a>CreateUserProfile</a>.
     * </p>
     * </note>
     *
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>().withOperationName("AddTags")
                            .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsRequest));
            CompletableFuture<AddTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To
     * disassociate a trial component from a trial, call the <a>DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param associateTrialComponentRequest
     * @return A Java Future containing the result of the AssociateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AssociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTrialComponentResponse> associateTrialComponent(
            AssociateTrialComponentRequest associateTrialComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTrialComponentRequest, AssociateTrialComponentResponse>()
                            .withOperationName("AssociateTrialComponent")
                            .withMarshaller(new AssociateTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateTrialComponentRequest));
            CompletableFuture<AssociateTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action batch describes a list of versioned model packages
     * </p>
     *
     * @param batchDescribeModelPackageRequest
     * @return A Java Future containing the result of the BatchDescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchDescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDescribeModelPackageResponse> batchDescribeModelPackage(
            BatchDescribeModelPackageRequest batchDescribeModelPackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDescribeModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDescribeModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDescribeModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDescribeModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDescribeModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeModelPackageRequest, BatchDescribeModelPackageResponse>()
                            .withOperationName("BatchDescribeModelPackage")
                            .withMarshaller(new BatchDescribeModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDescribeModelPackageRequest));
            CompletableFuture<BatchDescribeModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For
     * example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon
     * SageMaker ML Lineage Tracking</a>.
     * </p>
     *
     * @param createActionRequest
     * @return A Java Future containing the result of the CreateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateActionResponse> createAction(CreateActionRequest createActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateActionRequest, CreateActionResponse>()
                            .withOperationName("CreateAction").withMarshaller(new CreateActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createActionRequest));
            CompletableFuture<CreateActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services
     * Marketplace.
     * </p>
     *
     * @param createAlgorithmRequest
     * @return A Java Future containing the result of the CreateAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAlgorithmResponse> createAlgorithm(CreateAlgorithmRequest createAlgorithmRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAlgorithmRequest, CreateAlgorithmResponse>()
                            .withOperationName("CreateAlgorithm")
                            .withMarshaller(new CreateAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAlgorithmRequest));
            CompletableFuture<CreateAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker
     * Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user
     * may have multiple Apps active simultaneously.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>().withOperationName("CreateApp")
                            .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAppRequest));
            CompletableFuture<CreateAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the
     * Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.
     * </p>
     *
     * @param createAppImageConfigRequest
     * @return A Java Future containing the result of the CreateAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppImageConfigResponse> createAppImageConfig(
            CreateAppImageConfigRequest createAppImageConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppImageConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAppImageConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppImageConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppImageConfigRequest, CreateAppImageConfigResponse>()
                            .withOperationName("CreateAppImageConfig")
                            .withMarshaller(new CreateAppImageConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAppImageConfigRequest));
            CompletableFuture<CreateAppImageConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or
     * data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createArtifactRequest
     * @return A Java Future containing the result of the CreateArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateArtifactResponse> createArtifact(CreateArtifactRequest createArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateArtifactRequest, CreateArtifactResponse>()
                            .withOperationName("CreateArtifact")
                            .withMarshaller(new CreateArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createArtifactRequest));
            CompletableFuture<CreateArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Autopilot job.
     * </p>
     * <p>
     * Find the best-performing model after you run an Autopilot job by calling .
     * </p>
     * <p>
     * For information about how to use Autopilot, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html">Automate Model
     * Development with Amazon SageMaker Autopilot</a>.
     * </p>
     *
     * @param createAutoMlJobRequest
     * @return A Java Future containing the result of the CreateAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAutoMlJobResponse> createAutoMLJob(CreateAutoMlJobRequest createAutoMlJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAutoMLJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAutoMlJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAutoMlJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAutoMlJobRequest, CreateAutoMlJobResponse>()
                            .withOperationName("CreateAutoMLJob")
                            .withMarshaller(new CreateAutoMlJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAutoMlJobRequest));
            CompletableFuture<CreateAutoMlJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook
     * instances so that you can use Git source control for the notebooks you create. The Git repository is a resource
     * in your SageMaker account, so it can be associated with more than one notebook instance, and it persists
     * independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository.
     * </p>
     *
     * @param createCodeRepositoryRequest
     * @return A Java Future containing the result of the CreateCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCodeRepositoryResponse> createCodeRepository(
            CreateCodeRepositoryRequest createCodeRepositoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCodeRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCodeRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCodeRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCodeRepositoryRequest, CreateCodeRepositoryResponse>()
                            .withOperationName("CreateCodeRepository")
                            .withMarshaller(new CreateCodeRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCodeRepositoryRequest));
            CompletableFuture<CreateCodeRepositoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that
     * case, deploy them as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a>StopCompilationJob</a>. To get information about a particular model
     * compilation job, use <a>DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use
     * <a>ListCompilationJobs</a>.
     * </p>
     *
     * @param createCompilationJobRequest
     * @return A Java Future containing the result of the CreateCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCompilationJobResponse> createCompilationJob(
            CreateCompilationJobRequest createCompilationJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCompilationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCompilationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCompilationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCompilationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCompilationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCompilationJobRequest, CreateCompilationJobResponse>()
                            .withOperationName("CreateCompilationJob")
                            .withMarshaller(new CreateCompilationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCompilationJobRequest));
            CompletableFuture<CreateCompilationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other
     * tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createContextRequest
     * @return A Java Future containing the result of the CreateContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContextResponse> createContext(CreateContextRequest createContextRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateContextResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContextResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContextRequest, CreateContextResponse>()
                            .withOperationName("CreateContext")
                            .withMarshaller(new CreateContextRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createContextRequest));
            CompletableFuture<CreateContextResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.
     * </p>
     *
     * @param createDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataQualityJobDefinitionResponse> createDataQualityJobDefinition(
            CreateDataQualityJobDefinitionRequest createDataQualityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDataQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataQualityJobDefinitionRequest, CreateDataQualityJobDefinitionResponse>()
                            .withOperationName("CreateDataQualityJobDefinition")
                            .withMarshaller(new CreateDataQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDataQualityJobDefinitionRequest));
            CompletableFuture<CreateDataQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a device fleet.
     * </p>
     *
     * @param createDeviceFleetRequest
     * @return A Java Future containing the result of the CreateDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceFleetResponse> createDeviceFleet(CreateDeviceFleetRequest createDeviceFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeviceFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceFleetRequest, CreateDeviceFleetResponse>()
                            .withOperationName("CreateDeviceFleet")
                            .withMarshaller(new CreateDeviceFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDeviceFleetRequest));
            CompletableFuture<CreateDeviceFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <code>Domain</code> used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic
     * File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon
     * Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region.
     * Users within a domain can share notebook files and other artifacts with each other.
     * </p>
     * <p>
     * <b>EFS storage</b>
     * </p>
     * <p>
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user
     * receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     * </p>
     * <p>
     * SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume
     * attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a
     * customer managed key. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using
     * Encryption</a>.
     * </p>
     * <p>
     * <b>VPC configuration</b>
     * </p>
     * <p>
     * All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For
     * other Studio traffic, you can specify the <code>AppNetworkAccessType</code> parameter.
     * <code>AppNetworkAccessType</code> corresponds to the network access type that you choose when you onboard to
     * Studio. The following options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows
     * internet access. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets. Internet access is disabled
     * by default. To allow internet access, you must specify a NAT gateway.
     * </p>
     * <p>
     * When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless
     * your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups
     * allow outbound connections.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a
     * SageMaker Studio app successfully.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect
     * SageMaker Studio Notebooks to Resources in a VPC</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                            .withOperationName("CreateDomain").withMarshaller(new CreateDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDomainRequest));
            CompletableFuture<CreateDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment
     * configuration and devices.
     * </p>
     *
     * @param createEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the CreateEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEdgeDeploymentPlanResponse> createEdgeDeploymentPlan(
            CreateEdgeDeploymentPlanRequest createEdgeDeploymentPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgeDeploymentPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEdgeDeploymentPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEdgeDeploymentPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEdgeDeploymentPlanRequest, CreateEdgeDeploymentPlanResponse>()
                            .withOperationName("CreateEdgeDeploymentPlan")
                            .withMarshaller(new CreateEdgeDeploymentPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEdgeDeploymentPlanRequest));
            CompletableFuture<CreateEdgeDeploymentPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new stage in an existing edge deployment plan.
     * </p>
     *
     * @param createEdgeDeploymentStageRequest
     * @return A Java Future containing the result of the CreateEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEdgeDeploymentStageResponse> createEdgeDeploymentStage(
            CreateEdgeDeploymentStageRequest createEdgeDeploymentStageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgeDeploymentStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgeDeploymentStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEdgeDeploymentStageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEdgeDeploymentStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEdgeDeploymentStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEdgeDeploymentStageRequest, CreateEdgeDeploymentStageResponse>()
                            .withOperationName("CreateEdgeDeploymentStage")
                            .withMarshaller(new CreateEdgeDeploymentStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEdgeDeploymentStageRequest));
            CompletableFuture<CreateEdgeDeploymentStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon
     * Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the
     * resulting artifacts to an S3 bucket that you specify.
     * </p>
     *
     * @param createEdgePackagingJobRequest
     * @return A Java Future containing the result of the CreateEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEdgePackagingJobResponse> createEdgePackagingJob(
            CreateEdgePackagingJobRequest createEdgePackagingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgePackagingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgePackagingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEdgePackagingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEdgePackagingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEdgePackagingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEdgePackagingJobRequest, CreateEdgePackagingJobResponse>()
                            .withOperationName("CreateEdgePackagingJob")
                            .withMarshaller(new CreateEdgePackagingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEdgePackagingJobRequest));
            CompletableFuture<CreateEdgePackagingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to
     * provision resources and deploy models. You create the endpoint configuration with the <a>CreateEndpointConfig</a>
     * API.
     * </p>
     * <p>
     * Use this API to deploy models using SageMaker hosting services.
     * </p>
     * <p>
     * For an example that calls this method when deploying a model to SageMaker hosting services, see the <a href=
     * "https://github.com/aws/amazon-sagemaker-examples/blob/master/sagemaker-fundamentals/create-endpoint/create_endpoint.ipynb"
     * >Create Endpoint example notebook.</a>
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     * </p>
     * <p>
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and
     * deploys the model(s) on them.
     * </p>
     * <note>
     * <p>
     * When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration
     * exists. When you read data from a DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a
     * DynamoDB eventually consistent read.
     * </p>
     * </note>
     * <p>
     * When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the
     * endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for
     * inferences. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web
     * Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services
     * STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a
     * region, you need to reactivate Amazon Web Services STS for that region. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services Identity
     * and Access Management User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To add the IAM role policies for using this API operation, go to the <a
     * href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search
     * the IAM role that you want to grant access to use the <a>CreateEndpoint</a> and <a>CreateEndpointConfig</a> API
     * operations, add the following policies to the role.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the
     * JSON file of the IAM role:
     * </p>
     * <p>
     * <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code>
     * </p>
     * <p>
     * <code>"Resource": [</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions:
     * Actions, Permissions, and Resources Reference</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointRequest, CreateEndpointResponse>()
                            .withOperationName("CreateEndpoint")
                            .withMarshaller(new CreateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEndpointRequest));
            CompletableFuture<CreateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration,
     * you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that
     * you want SageMaker to provision. Then you call the <a>CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API if you want to use SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This
     * includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and
     * one-third to model B.
     * </p>
     * <note>
     * <p>
     * When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration
     * exists. When you read data from a DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a
     * DynamoDB eventually consistent read.
     * </p>
     * </note>
     *
     * @param createEndpointConfigRequest
     * @return A Java Future containing the result of the CreateEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointConfigResponse> createEndpointConfig(
            CreateEndpointConfigRequest createEndpointConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEndpointConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointConfigRequest, CreateEndpointConfigResponse>()
                            .withOperationName("CreateEndpointConfig")
                            .withMarshaller(new CreateEndpointConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEndpointConfigRequest));
            CompletableFuture<CreateEndpointConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed,
     * compared and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a
     * machine learning model.
     * </p>
     * <p>
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are
     * performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the
     * remaining inputs constant.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to experiments, trials, trial components and then use the <a>Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a
     * description later, or to change the description, call the <a>UpdateExperiment</a> API.
     * </p>
     * <p>
     * To get a list of all your experiments, call the <a>ListExperiments</a> API. To view an experiment's properties,
     * call the <a>DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the
     * <a>ListTrials</a> API. To create a trial call the <a>CreateTrial</a> API.
     * </p>
     *
     * @param createExperimentRequest
     * @return A Java Future containing the result of the CreateExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateExperimentResponse> createExperiment(CreateExperimentRequest createExperimentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateExperimentRequest, CreateExperimentResponse>()
                            .withOperationName("CreateExperiment")
                            .withMarshaller(new CreateExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createExperimentRequest));
            CompletableFuture<CreateExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined
     * in the <code>FeatureStore</code> to describe a <code>Record</code>.
     * </p>
     * <p>
     * The <code>FeatureGroup</code> defines the schema and features contained in the FeatureGroup. A
     * <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a
     * <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service
     * quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.
     * </p>
     * <important>
     * <p>
     * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a
     * <code>FeatureGroup</code>.
     * </p>
     * </important>
     *
     * @param createFeatureGroupRequest
     * @return A Java Future containing the result of the CreateFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFeatureGroupResponse> createFeatureGroup(CreateFeatureGroupRequest createFeatureGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFeatureGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFeatureGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFeatureGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFeatureGroupRequest, CreateFeatureGroupResponse>()
                            .withOperationName("CreateFeatureGroup")
                            .withMarshaller(new CreateFeatureGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFeatureGroupRequest));
            CompletableFuture<CreateFeatureGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a flow definition.
     * </p>
     *
     * @param createFlowDefinitionRequest
     * @return A Java Future containing the result of the CreateFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlowDefinitionResponse> createFlowDefinition(
            CreateFlowDefinitionRequest createFlowDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlowDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFlowDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFlowDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFlowDefinitionRequest, CreateFlowDefinitionResponse>()
                            .withOperationName("CreateFlowDefinition")
                            .withMarshaller(new CreateFlowDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFlowDefinitionRequest));
            CompletableFuture<CreateFlowDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel
     * interface with an instruction area, the item to review, and an input area.
     * </p>
     *
     * @param createHumanTaskUiRequest
     * @return A Java Future containing the result of the CreateHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHumanTaskUiResponse> createHumanTaskUi(CreateHumanTaskUiRequest createHumanTaskUiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHumanTaskUi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateHumanTaskUiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateHumanTaskUiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHumanTaskUiRequest, CreateHumanTaskUiResponse>()
                            .withOperationName("CreateHumanTaskUi")
                            .withMarshaller(new CreateHumanTaskUiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createHumanTaskUiRequest));
            CompletableFuture<CreateHumanTaskUiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     *
     * @param createHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the CreateHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHyperParameterTuningJobResponse> createHyperParameterTuningJob(
            CreateHyperParameterTuningJobRequest createHyperParameterTuningJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHyperParameterTuningJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateHyperParameterTuningJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateHyperParameterTuningJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateHyperParameterTuningJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHyperParameterTuningJobRequest, CreateHyperParameterTuningJobResponse>()
                            .withOperationName("CreateHyperParameterTuningJob")
                            .withMarshaller(new CreateHyperParameterTuningJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createHyperParameterTuningJobRequest));
            CompletableFuture<CreateHyperParameterTuningJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a
     * container image stored in Amazon Elastic Container Registry (ECR). For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                            .withOperationName("CreateImage").withMarshaller(new CreateImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createImageRequest));
            CompletableFuture<CreateImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a version of the SageMaker image specified by <code>ImageName</code>. The version represents the Amazon
     * Elastic Container Registry (ECR) container image specified by <code>BaseImage</code>.
     * </p>
     *
     * @param createImageVersionRequest
     * @return A Java Future containing the result of the CreateImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageVersionResponse> createImageVersion(CreateImageVersionRequest createImageVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImageVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageVersionRequest, CreateImageVersionResponse>()
                            .withOperationName("CreateImageVersion")
                            .withMarshaller(new CreateImageVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createImageVersionRequest));
            CompletableFuture<CreateImageVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     * </p>
     *
     * @param createInferenceRecommendationsJobRequest
     * @return A Java Future containing the result of the CreateInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInferenceRecommendationsJobResponse> createInferenceRecommendationsJob(
            CreateInferenceRecommendationsJobRequest createInferenceRecommendationsJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInferenceRecommendationsJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInferenceRecommendationsJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInferenceRecommendationsJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateInferenceRecommendationsJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInferenceRecommendationsJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInferenceRecommendationsJobRequest, CreateInferenceRecommendationsJobResponse>()
                            .withOperationName("CreateInferenceRecommendationsJob")
                            .withMarshaller(new CreateInferenceRecommendationsJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createInferenceRecommendationsJobRequest));
            CompletableFuture<CreateInferenceRecommendationsJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in
     * specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <p>
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job
     * stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled.
     * A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send
     * new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to
     * create a static labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job
     * (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling
     * Job</a>.
     * </p>
     *
     * @param createLabelingJobRequest
     * @return A Java Future containing the result of the CreateLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLabelingJobResponse> createLabelingJob(CreateLabelingJobRequest createLabelingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLabelingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLabelingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLabelingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLabelingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLabelingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLabelingJobRequest, CreateLabelingJobResponse>()
                            .withOperationName("CreateLabelingJob")
                            .withMarshaller(new CreateLabelingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createLabelingJobRequest));
            CompletableFuture<CreateLabelingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the Docker image that contains inference code, artifacts (from prior training),
     * and a custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that
     * you defined for the model in the hosting environment.
     * </p>
     * <p>
     * For an example that calls this method when deploying a model to SageMaker hosting services, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/realtime-endpoints-deployment.html#realtime-endpoints-deployment-create-model"
     * >Create a Model (Amazon Web Services SDK for Python (Boto 3)).</a>
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API.
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image
     * for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM
     * role to manage permissions the inference code needs. For example, if the inference code access any other Amazon
     * Web Services resources, you grant necessary permissions via this role.
     * </p>
     *
     * @param createModelRequest
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                            .withOperationName("CreateModel").withMarshaller(new CreateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelRequest));
            CompletableFuture<CreateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the definition for a model bias job.
     * </p>
     *
     * @param createModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelBiasJobDefinitionResponse> createModelBiasJobDefinition(
            CreateModelBiasJobDefinitionRequest createModelBiasJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelBiasJobDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelBiasJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelBiasJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelBiasJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelBiasJobDefinitionRequest, CreateModelBiasJobDefinitionResponse>()
                            .withOperationName("CreateModelBiasJobDefinition")
                            .withMarshaller(new CreateModelBiasJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelBiasJobDefinitionRequest));
            CompletableFuture<CreateModelBiasJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the definition for a model explainability job.
     * </p>
     *
     * @param createModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> createModelExplainabilityJobDefinition(
            CreateModelExplainabilityJobDefinitionRequest createModelExplainabilityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelExplainabilityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateModelExplainabilityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelExplainabilityJobDefinitionRequest, CreateModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("CreateModelExplainabilityJobDefinition")
                            .withMarshaller(new CreateModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelExplainabilityJobDefinitionRequest));
            CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace,
     * or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web
     * Services Marketplace to create models in SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <note>
     * <p>
     * There are two types of model packages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Versioned - a model that is part of a model group in the model registry.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unversioned - a model package that is not part of a model group.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createModelPackageRequest
     * @return A Java Future containing the result of the CreateModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelPackageResponse> createModelPackage(CreateModelPackageRequest createModelPackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelPackageRequest, CreateModelPackageResponse>()
                            .withOperationName("CreateModelPackage")
                            .withMarshaller(new CreateModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelPackageRequest));
            CompletableFuture<CreateModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model group. A model group contains a group of model versions.
     * </p>
     *
     * @param createModelPackageGroupRequest
     * @return A Java Future containing the result of the CreateModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelPackageGroupResponse> createModelPackageGroup(
            CreateModelPackageGroupRequest createModelPackageGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelPackageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelPackageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelPackageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelPackageGroupRequest, CreateModelPackageGroupResponse>()
                            .withOperationName("CreateModelPackageGroup")
                            .withMarshaller(new CreateModelPackageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelPackageGroupRequest));
            CompletableFuture<CreateModelPackageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.
     * </p>
     *
     * @param createModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelQualityJobDefinitionResponse> createModelQualityJobDefinition(
            CreateModelQualityJobDefinitionRequest createModelQualityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelQualityJobDefinitionRequest, CreateModelQualityJobDefinitionResponse>()
                            .withOperationName("CreateModelQualityJobDefinition")
                            .withMarshaller(new CreateModelQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelQualityJobDefinitionRequest));
            CompletableFuture<CreateModelQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an
     * Amazon SageMaker Endoint.
     * </p>
     *
     * @param createMonitoringScheduleRequest
     * @return A Java Future containing the result of the CreateMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMonitoringScheduleResponse> createMonitoringSchedule(
            CreateMonitoringScheduleRequest createMonitoringScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMonitoringSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMonitoringScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMonitoringScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMonitoringScheduleRequest, CreateMonitoringScheduleResponse>()
                            .withOperationName("CreateMonitoringSchedule")
                            .withMarshaller(new CreateMonitoringScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createMonitoringScheduleRequest));
            CompletableFuture<CreateMonitoringScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running
     * on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * SageMaker launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker with a
     * specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, SageMaker does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the SageMaker VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, SageMaker creates a network interface in your own VPC, which is
     * inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker
     * attaches the security group that you specified in the request to the network interface that it creates in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the SageMaker VPC. If you specified
     * <code>SubnetId</code> of your VPC, SageMaker specifies both network interfaces when launching this instance. This
     * enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, SageMaker returns its Amazon Resource Name (ARN). You can't change the name
     * of a notebook instance after you create it.
     * </p>
     * <p>
     * After SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating SageMaker endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     *
     * @param createNotebookInstanceRequest
     * @return A Java Future containing the result of the CreateNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNotebookInstanceResponse> createNotebookInstance(
            CreateNotebookInstanceRequest createNotebookInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebookInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNotebookInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNotebookInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNotebookInstanceRequest, CreateNotebookInstanceResponse>()
                            .withOperationName("CreateNotebookInstance")
                            .withMarshaller(new CreateNotebookInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createNotebookInstanceRequest));
            CompletableFuture<CreateNotebookInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the CreateNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> createNotebookInstanceLifecycleConfig(
            CreateNotebookInstanceLifecycleConfigRequest createNotebookInstanceLifecycleConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebookInstanceLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateNotebookInstanceLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNotebookInstanceLifecycleConfigRequest, CreateNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("CreateNotebookInstanceLifecycleConfig")
                            .withMarshaller(new CreateNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createNotebookInstanceLifecycleConfigRequest));
            CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a pipeline using a JSON pipeline definition.
     * </p>
     *
     * @param createPipelineRequest
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePipelineRequest, CreatePipelineResponse>()
                            .withOperationName("CreatePipeline")
                            .withMarshaller(new CreatePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPipelineRequest));
            CompletableFuture<CreatePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be
     * automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated
     * with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the
     * authentication mode equals IAM.
     * </p>
     * <p>
     * The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is
     * created, no additional permission is required to access this URL. IAM authorization policies for this API are
     * also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or
     * Amazon VPC Endpoints that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to SageMaker Studio
     * Through an Interface VPC Endpoint</a> .
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You
     * can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit
     * expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </note>
     *
     * @param createPresignedDomainUrlRequest
     * @return A Java Future containing the result of the CreatePresignedDomainUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedDomainUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePresignedDomainUrlResponse> createPresignedDomainUrl(
            CreatePresignedDomainUrlRequest createPresignedDomainUrlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPresignedDomainUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedDomainUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePresignedDomainUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePresignedDomainUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePresignedDomainUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedDomainUrlRequest, CreatePresignedDomainUrlResponse>()
                            .withOperationName("CreatePresignedDomainUrl")
                            .withMarshaller(new CreatePresignedDomainUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPresignedDomainUrlRequest));
            CompletableFuture<CreatePresignedDomainUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker
     * console, when you choose <code>Open</code> next to a notebook instance, SageMaker opens a new tab showing the
     * Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the
     * presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for
     * this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook
     * instance.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify.
     * Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to
     * specify the list of IP addresses that you want to have access to the notebook instance. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter"
     * >Limit Access to a Notebook Instance by IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <a>CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you
     * try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in
     * page.
     * </p>
     * </note>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     * @return A Java Future containing the result of the CreatePresignedNotebookInstanceUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> createPresignedNotebookInstanceUrl(
            CreatePresignedNotebookInstanceUrlRequest createPresignedNotebookInstanceUrlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPresignedNotebookInstanceUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedNotebookInstanceUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePresignedNotebookInstanceUrlResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreatePresignedNotebookInstanceUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedNotebookInstanceUrlRequest, CreatePresignedNotebookInstanceUrlResponse>()
                            .withOperationName("CreatePresignedNotebookInstanceUrl")
                            .withMarshaller(new CreatePresignedNotebookInstanceUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPresignedNotebookInstanceUrlRequest));
            CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a processing job.
     * </p>
     *
     * @param createProcessingJobRequest
     * @return A Java Future containing the result of the CreateProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProcessingJobResponse> createProcessingJob(
            CreateProcessingJobRequest createProcessingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProcessingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProcessingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProcessingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProcessingJobRequest, CreateProcessingJobResponse>()
                            .withOperationName("CreateProcessingJob")
                            .withMarshaller(new CreateProcessingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createProcessingJobRequest));
            CompletableFuture<CreateProcessingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from
     * training to deploying an approved model.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                            .withOperationName("CreateProject")
                            .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createProjectRequest));
            CompletableFuture<CreateProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Studio Lifecycle Configuration.
     * </p>
     *
     * @param createStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the CreateStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStudioLifecycleConfigResponse> createStudioLifecycleConfig(
            CreateStudioLifecycleConfigRequest createStudioLifecycleConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStudioLifecycleConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStudioLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStudioLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStudioLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStudioLifecycleConfigRequest, CreateStudioLifecycleConfigResponse>()
                            .withOperationName("CreateStudioLifecycleConfig")
                            .withMarshaller(new CreateStudioLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStudioLifecycleConfigRequest));
            CompletableFuture<CreateStudioLifecycleConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon
     * S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as
     * part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided
     * that you know how to use them for inference.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <important>
     * <p>
     * You must not include any security-sensitive information, such as account access IDs, secrets, and tokens, in the
     * dictionary for configuring hyperparameters. SageMaker rejects the training job request and returns an exception
     * error for detected credentials, if such user input is found.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of
     * model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf
     * during model training. You must grant this role the necessary permissions so that SageMaker can successfully
     * complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> - The environment variables to set in the Docker container.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an
     * <code>InternalServerError</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     *
     * @param createTrainingJobRequest
     * @return A Java Future containing the result of the CreateTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrainingJobResponse> createTrainingJob(CreateTrainingJobRequest createTrainingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrainingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrainingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrainingJobRequest, CreateTrainingJobResponse>()
                            .withOperationName("CreateTrainingJob")
                            .withMarshaller(new CreateTrainingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTrainingJobRequest));
            CompletableFuture<CreateTrainingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web
     * Services Region in an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on
     * creating a model, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances for the transform job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     *
     * @param createTransformJobRequest
     * @return A Java Future containing the result of the CreateTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransformJobResponse> createTransformJob(CreateTransformJobRequest createTransformJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransformJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTransformJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTransformJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransformJobRequest, CreateTransformJobResponse>()
                            .withOperationName("CreateTransformJob")
                            .withMarshaller(new CreateTransformJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTransformJobRequest));
            CompletableFuture<CreateTransformJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a
     * machine learning model. A trial is part of a single SageMaker <i>experiment</i>.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial and then use the <a>Search</a> API to search for the tags.
     * </p>
     * <p>
     * To get a list of all your trials, call the <a>ListTrials</a> API. To view a trial's properties, call the
     * <a>DescribeTrial</a> API. To create a trial component, call the <a>CreateTrialComponent</a> API.
     * </p>
     *
     * @param createTrialRequest
     * @return A Java Future containing the result of the CreateTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrialResponse> createTrial(CreateTrialRequest createTrialRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTrialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrialRequest, CreateTrialResponse>()
                            .withOperationName("CreateTrial").withMarshaller(new CreateTrialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTrialRequest));
            CompletableFuture<CreateTrialResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one
     * or more trial components. A trial component can be used in multiple trials.
     * </p>
     * <p>
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial component and then use the <a>Search</a> API to search for the tags.
     * </p>
     *
     * @param createTrialComponentRequest
     * @return A Java Future containing the result of the CreateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrialComponentResponse> createTrialComponent(
            CreateTrialComponentRequest createTrialComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrialComponentRequest, CreateTrialComponentResponse>()
                            .withOperationName("CreateTrialComponent")
                            .withMarshaller(new CreateTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTrialComponentRequest));
            CompletableFuture<CreateTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference
     * a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when
     * a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from
     * Amazon Web Services SSO, a user profile is automatically created. A user profile is the primary holder of
     * settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home
     * directory.
     * </p>
     *
     * @param createUserProfileRequest
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserProfileResponse> createUserProfile(CreateUserProfileRequest createUserProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserProfileRequest, CreateUserProfileResponse>()
                            .withOperationName("CreateUserProfile")
                            .withMarshaller(new CreateUserProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUserProfileRequest));
            CompletableFuture<CreateUserProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in
     * the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services
     * Region per Amazon Web Services account.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the
     * API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new
     * workforce.
     * </p>
     * <p>
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in
     * <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private
     * Workforce (Amazon Cognito)</a>.
     * </p>
     * <p>
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in
     * <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and
     * Amazon A2I to create work teams. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private
     * Workforce (OIDC IdP)</a>.
     * </p>
     *
     * @param createWorkforceRequest
     * @return A Java Future containing the result of the CreateWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkforceResponse> createWorkforce(CreateWorkforceRequest createWorkforceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkforce");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkforceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorkforceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkforceRequest, CreateWorkforceResponse>()
                            .withOperationName("CreateWorkforce")
                            .withMarshaller(new CreateWorkforceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createWorkforceRequest));
            CompletableFuture<CreateWorkforceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     *
     * @param createWorkteamRequest
     * @return A Java Future containing the result of the CreateWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkteamResponse> createWorkteam(CreateWorkteamRequest createWorkteamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkteamRequest, CreateWorkteamResponse>()
                            .withOperationName("CreateWorkteam")
                            .withMarshaller(new CreateWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createWorkteamRequest));
            CompletableFuture<CreateWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an action.
     * </p>
     *
     * @param deleteActionRequest
     * @return A Java Future containing the result of the DeleteAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteActionResponse> deleteAction(DeleteActionRequest deleteActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteActionRequest, DeleteActionResponse>()
                            .withOperationName("DeleteAction").withMarshaller(new DeleteActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteActionRequest));
            CompletableFuture<DeleteActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     *
     * @param deleteAlgorithmRequest
     * @return A Java Future containing the result of the DeleteAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAlgorithmResponse> deleteAlgorithm(DeleteAlgorithmRequest deleteAlgorithmRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAlgorithmRequest, DeleteAlgorithmResponse>()
                            .withOperationName("DeleteAlgorithm")
                            .withMarshaller(new DeleteAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAlgorithmRequest));
            CompletableFuture<DeleteAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to stop and delete an app.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>().withOperationName("DeleteApp")
                            .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAppRequest));
            CompletableFuture<DeleteAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an AppImageConfig.
     * </p>
     *
     * @param deleteAppImageConfigRequest
     * @return A Java Future containing the result of the DeleteAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppImageConfigResponse> deleteAppImageConfig(
            DeleteAppImageConfigRequest deleteAppImageConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppImageConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAppImageConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppImageConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppImageConfigRequest, DeleteAppImageConfigResponse>()
                            .withOperationName("DeleteAppImageConfig")
                            .withMarshaller(new DeleteAppImageConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAppImageConfigRequest));
            CompletableFuture<DeleteAppImageConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.
     * </p>
     *
     * @param deleteArtifactRequest
     * @return A Java Future containing the result of the DeleteArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteArtifactResponse> deleteArtifact(DeleteArtifactRequest deleteArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteArtifactRequest, DeleteArtifactResponse>()
                            .withOperationName("DeleteArtifact")
                            .withMarshaller(new DeleteArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteArtifactRequest));
            CompletableFuture<DeleteArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an association.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssociationResponse> deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssociationRequest, DeleteAssociationResponse>()
                            .withOperationName("DeleteAssociation")
                            .withMarshaller(new DeleteAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAssociationRequest));
            CompletableFuture<DeleteAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     * @return A Java Future containing the result of the DeleteCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCodeRepositoryResponse> deleteCodeRepository(
            DeleteCodeRepositoryRequest deleteCodeRepositoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCodeRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCodeRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCodeRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCodeRepositoryRequest, DeleteCodeRepositoryResponse>()
                            .withOperationName("DeleteCodeRepository")
                            .withMarshaller(new DeleteCodeRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCodeRepositoryRequest));
            CompletableFuture<DeleteCodeRepositoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an context.
     * </p>
     *
     * @param deleteContextRequest
     * @return A Java Future containing the result of the DeleteContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContextResponse> deleteContext(DeleteContextRequest deleteContextRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteContextResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContextResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContextRequest, DeleteContextResponse>()
                            .withOperationName("DeleteContext")
                            .withMarshaller(new DeleteContextRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteContextRequest));
            CompletableFuture<DeleteContextResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a data quality monitoring job definition.
     * </p>
     *
     * @param deleteDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataQualityJobDefinitionResponse> deleteDataQualityJobDefinition(
            DeleteDataQualityJobDefinitionRequest deleteDataQualityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDataQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataQualityJobDefinitionRequest, DeleteDataQualityJobDefinitionResponse>()
                            .withOperationName("DeleteDataQualityJobDefinition")
                            .withMarshaller(new DeleteDataQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDataQualityJobDefinitionRequest));
            CompletableFuture<DeleteDataQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteDeviceFleetRequest
     * @return A Java Future containing the result of the DeleteDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceFleetResponse> deleteDeviceFleet(DeleteDeviceFleetRequest deleteDeviceFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeviceFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeviceFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeviceFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceFleetRequest, DeleteDeviceFleetResponse>()
                            .withOperationName("DeleteDeviceFleet")
                            .withMarshaller(new DeleteDeviceFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDeviceFleetRequest));
            CompletableFuture<DeleteDeviceFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again
     * using Amazon Web Services SSO. Use with caution. All of the members of the domain will lose access to their EFS
     * volume, including data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                            .withOperationName("DeleteDomain").withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDomainRequest));
            CompletableFuture<DeleteDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages
     * in the plan.
     * </p>
     *
     * @param deleteEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the DeleteEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEdgeDeploymentPlanResponse> deleteEdgeDeploymentPlan(
            DeleteEdgeDeploymentPlanRequest deleteEdgeDeploymentPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEdgeDeploymentPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEdgeDeploymentPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEdgeDeploymentPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEdgeDeploymentPlanRequest, DeleteEdgeDeploymentPlanResponse>()
                            .withOperationName("DeleteEdgeDeploymentPlan")
                            .withMarshaller(new DeleteEdgeDeploymentPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEdgeDeploymentPlanRequest));
            CompletableFuture<DeleteEdgeDeploymentPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
     * </p>
     *
     * @param deleteEdgeDeploymentStageRequest
     * @return A Java Future containing the result of the DeleteEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEdgeDeploymentStageResponse> deleteEdgeDeploymentStage(
            DeleteEdgeDeploymentStageRequest deleteEdgeDeploymentStageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEdgeDeploymentStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEdgeDeploymentStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEdgeDeploymentStageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEdgeDeploymentStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEdgeDeploymentStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEdgeDeploymentStageRequest, DeleteEdgeDeploymentStageResponse>()
                            .withOperationName("DeleteEdgeDeploymentStage")
                            .withMarshaller(new DeleteEdgeDeploymentStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEdgeDeploymentStageRequest));
            CompletableFuture<DeleteEdgeDeploymentStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     * </p>
     * <p>
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <p>
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key
     * grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do
     * not delete or revoke the permissions for your
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>
     * , otherwise SageMaker cannot delete these resources.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                            .withOperationName("DeleteEndpoint")
                            .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEndpointRequest));
            CompletableFuture<DeleteEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you
     * delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose
     * visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring
     * charges.
     * </p>
     *
     * @param deleteEndpointConfigRequest
     * @return A Java Future containing the result of the DeleteEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointConfigResponse> deleteEndpointConfig(
            DeleteEndpointConfigRequest deleteEndpointConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointConfigRequest, DeleteEndpointConfigResponse>()
                            .withOperationName("DeleteEndpointConfig")
                            .withMarshaller(new DeleteEndpointConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEndpointConfigRequest));
            CompletableFuture<DeleteEndpointConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the
     * <a>ListTrials</a> API to get a list of the trials associated with the experiment.
     * </p>
     *
     * @param deleteExperimentRequest
     * @return A Java Future containing the result of the DeleteExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteExperimentResponse> deleteExperiment(DeleteExperimentRequest deleteExperimentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteExperimentRequest, DeleteExperimentResponse>()
                            .withOperationName("DeleteExperiment")
                            .withMarshaller(new DeleteExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteExperimentRequest));
            CompletableFuture<DeleteExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the
     * <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after
     * <code>DeleteFeatureGroup</code> is called.
     * </p>
     * <p>
     * Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and
     * tables that are automatically created for your <code>OfflineStore</code> are not deleted.
     * </p>
     *
     * @param deleteFeatureGroupRequest
     * @return A Java Future containing the result of the DeleteFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFeatureGroupResponse> deleteFeatureGroup(DeleteFeatureGroupRequest deleteFeatureGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFeatureGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFeatureGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFeatureGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFeatureGroupRequest, DeleteFeatureGroupResponse>()
                            .withOperationName("DeleteFeatureGroup")
                            .withMarshaller(new DeleteFeatureGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFeatureGroupRequest));
            CompletableFuture<DeleteFeatureGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified flow definition.
     * </p>
     *
     * @param deleteFlowDefinitionRequest
     * @return A Java Future containing the result of the DeleteFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlowDefinitionResponse> deleteFlowDefinition(
            DeleteFlowDefinitionRequest deleteFlowDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlowDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFlowDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFlowDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFlowDefinitionRequest, DeleteFlowDefinitionResponse>()
                            .withOperationName("DeleteFlowDefinition")
                            .withMarshaller(new DeleteFlowDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFlowDefinitionRequest));
            CompletableFuture<DeleteFlowDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to delete a human task user interface (worker task template).
     * </p>
     * <p>
     * To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker
     * task template, it no longer appears when you call <code>ListHumanTaskUis</code>.
     * </p>
     *
     * @param deleteHumanTaskUiRequest
     * @return A Java Future containing the result of the DeleteHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHumanTaskUiResponse> deleteHumanTaskUi(DeleteHumanTaskUiRequest deleteHumanTaskUiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHumanTaskUi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteHumanTaskUiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteHumanTaskUiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHumanTaskUiRequest, DeleteHumanTaskUiResponse>()
                            .withOperationName("DeleteHumanTaskUi")
                            .withMarshaller(new DeleteHumanTaskUiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteHumanTaskUiRequest));
            CompletableFuture<DeleteHumanTaskUiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a SageMaker image and all versions of the image. The container images aren't deleted.
     * </p>
     *
     * @param deleteImageRequest
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageResponse> deleteImage(DeleteImageRequest deleteImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                            .withOperationName("DeleteImage").withMarshaller(new DeleteImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteImageRequest));
            CompletableFuture<DeleteImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a version of a SageMaker image. The container image the version represents isn't deleted.
     * </p>
     *
     * @param deleteImageVersionRequest
     * @return A Java Future containing the result of the DeleteImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageVersionResponse> deleteImageVersion(DeleteImageVersionRequest deleteImageVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImageVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageVersionRequest, DeleteImageVersionResponse>()
                            .withOperationName("DeleteImageVersion")
                            .withMarshaller(new DeleteImageVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteImageVersionRequest));
            CompletableFuture<DeleteImageVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when
     * you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role
     * that you specified when creating the model.
     * </p>
     *
     * @param deleteModelRequest
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                            .withOperationName("DeleteModel").withMarshaller(new DeleteModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelRequest));
            CompletableFuture<DeleteModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker model bias job definition.
     * </p>
     *
     * @param deleteModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelBiasJobDefinitionResponse> deleteModelBiasJobDefinition(
            DeleteModelBiasJobDefinitionRequest deleteModelBiasJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelBiasJobDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelBiasJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelBiasJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelBiasJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelBiasJobDefinitionRequest, DeleteModelBiasJobDefinitionResponse>()
                            .withOperationName("DeleteModelBiasJobDefinition")
                            .withMarshaller(new DeleteModelBiasJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelBiasJobDefinitionRequest));
            CompletableFuture<DeleteModelBiasJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker model explainability job definition.
     * </p>
     *
     * @param deleteModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> deleteModelExplainabilityJobDefinition(
            DeleteModelExplainabilityJobDefinitionRequest deleteModelExplainabilityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelExplainabilityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteModelExplainabilityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelExplainabilityJobDefinitionRequest, DeleteModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("DeleteModelExplainabilityJobDefinition")
                            .withMarshaller(new DeleteModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelExplainabilityJobDefinitionRequest));
            CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can
     * subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     * </p>
     *
     * @param deleteModelPackageRequest
     * @return A Java Future containing the result of the DeleteModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelPackageResponse> deleteModelPackage(DeleteModelPackageRequest deleteModelPackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageRequest, DeleteModelPackageResponse>()
                            .withOperationName("DeleteModelPackage")
                            .withMarshaller(new DeleteModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelPackageRequest));
            CompletableFuture<DeleteModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified model group.
     * </p>
     *
     * @param deleteModelPackageGroupRequest
     * @return A Java Future containing the result of the DeleteModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelPackageGroupResponse> deleteModelPackageGroup(
            DeleteModelPackageGroupRequest deleteModelPackageGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelPackageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelPackageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageGroupRequest, DeleteModelPackageGroupResponse>()
                            .withOperationName("DeleteModelPackageGroup")
                            .withMarshaller(new DeleteModelPackageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelPackageGroupRequest));
            CompletableFuture<DeleteModelPackageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model group resource policy.
     * </p>
     *
     * @param deleteModelPackageGroupPolicyRequest
     * @return A Java Future containing the result of the DeleteModelPackageGroupPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelPackageGroupPolicyResponse> deleteModelPackageGroupPolicy(
            DeleteModelPackageGroupPolicyRequest deleteModelPackageGroupPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelPackageGroupPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackageGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelPackageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelPackageGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelPackageGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageGroupPolicyRequest, DeleteModelPackageGroupPolicyResponse>()
                            .withOperationName("DeleteModelPackageGroupPolicy")
                            .withMarshaller(new DeleteModelPackageGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelPackageGroupPolicyRequest));
            CompletableFuture<DeleteModelPackageGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the secified model quality monitoring job definition.
     * </p>
     *
     * @param deleteModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelQualityJobDefinitionResponse> deleteModelQualityJobDefinition(
            DeleteModelQualityJobDefinitionRequest deleteModelQualityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelQualityJobDefinitionRequest, DeleteModelQualityJobDefinitionResponse>()
                            .withOperationName("DeleteModelQualityJobDefinition")
                            .withMarshaller(new DeleteModelQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelQualityJobDefinitionRequest));
            CompletableFuture<DeleteModelQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job
     * execution history of the monitoring schedule.
     * </p>
     *
     * @param deleteMonitoringScheduleRequest
     * @return A Java Future containing the result of the DeleteMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMonitoringScheduleResponse> deleteMonitoringSchedule(
            DeleteMonitoringScheduleRequest deleteMonitoringScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMonitoringSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMonitoringScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMonitoringScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMonitoringScheduleRequest, DeleteMonitoringScheduleResponse>()
                            .withOperationName("DeleteMonitoringSchedule")
                            .withMarshaller(new DeleteMonitoringScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMonitoringScheduleRequest));
            CompletableFuture<DeleteMonitoringScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SageMaker notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. SageMaker removes the ML compute instance, and
     * deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important>
     *
     * @param deleteNotebookInstanceRequest
     * @return A Java Future containing the result of the DeleteNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNotebookInstanceResponse> deleteNotebookInstance(
            DeleteNotebookInstanceRequest deleteNotebookInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebookInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNotebookInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNotebookInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNotebookInstanceRequest, DeleteNotebookInstanceResponse>()
                            .withOperationName("DeleteNotebookInstance")
                            .withMarshaller(new DeleteNotebookInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteNotebookInstanceRequest));
            CompletableFuture<DeleteNotebookInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the DeleteNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> deleteNotebookInstanceLifecycleConfig(
            DeleteNotebookInstanceLifecycleConfigRequest deleteNotebookInstanceLifecycleConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebookInstanceLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteNotebookInstanceLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNotebookInstanceLifecycleConfigRequest, DeleteNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("DeleteNotebookInstanceLifecycleConfig")
                            .withMarshaller(new DeleteNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteNotebookInstanceLifecycleConfigRequest));
            CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all
     * running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline,
     * all instances of the pipeline are deleted.
     * </p>
     *
     * @param deletePipelineRequest
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePipelineRequest, DeletePipelineResponse>()
                            .withOperationName("DeletePipeline")
                            .withMarshaller(new DeletePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePipelineRequest));
            CompletableFuture<DeletePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the specified project.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                            .withOperationName("DeleteProject")
                            .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteProjectRequest));
            CompletableFuture<DeleteProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no
     * running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from
     * UserSettings in all Domains and UserProfiles.
     * </p>
     *
     * @param deleteStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the DeleteStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStudioLifecycleConfigResponse> deleteStudioLifecycleConfig(
            DeleteStudioLifecycleConfigRequest deleteStudioLifecycleConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioLifecycleConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudioLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStudioLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStudioLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStudioLifecycleConfigRequest, DeleteStudioLifecycleConfigResponse>()
                            .withOperationName("DeleteStudioLifecycleConfig")
                            .withMarshaller(new DeleteStudioLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStudioLifecycleConfigRequest));
            CompletableFuture<DeleteStudioLifecycleConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified tags from an SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note> <note>
     * <p>
     * When you call this API to delete tags from a SageMaker Studio Domain or User Profile, the deleted tags are not
     * removed from Apps that the SageMaker Studio Domain or User Profile launched before you called this API.
     * </p>
     * </note>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTagsRequest));
            CompletableFuture<DeleteTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the
     * <a>DescribeTrialComponent</a> API to get the list of trial components.
     * </p>
     *
     * @param deleteTrialRequest
     * @return A Java Future containing the result of the DeleteTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrialResponse> deleteTrial(DeleteTrialRequest deleteTrialRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTrialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrialRequest, DeleteTrialResponse>()
                            .withOperationName("DeleteTrial").withMarshaller(new DeleteTrialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTrialRequest));
            CompletableFuture<DeleteTrialResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial
     * component can be deleted. To disassociate a trial component from a trial, call the
     * <a>DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param deleteTrialComponentRequest
     * @return A Java Future containing the result of the DeleteTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrialComponentResponse> deleteTrialComponent(
            DeleteTrialComponentRequest deleteTrialComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrialComponentRequest, DeleteTrialComponentResponse>()
                            .withOperationName("DeleteTrialComponent")
                            .withMarshaller(new DeleteTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTrialComponentRequest));
            CompletableFuture<DeleteTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including
     * data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteUserProfileRequest
     * @return A Java Future containing the result of the DeleteUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserProfileResponse> deleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserProfileRequest, DeleteUserProfileResponse>()
                            .withOperationName("DeleteUserProfile")
                            .withMarshaller(new DeleteUserProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserProfileRequest));
            CompletableFuture<DeleteUserProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to delete a workforce.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this
     * operation to delete the existing workforce and then use to create a new workforce.
     * </p>
     * <important>
     * <p>
     * If a private workforce contains one or more work teams, you must use the operation to delete all work teams
     * before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will
     * recieve a <code>ResourceInUse</code> error.
     * </p>
     * </important>
     *
     * @param deleteWorkforceRequest
     * @return A Java Future containing the result of the DeleteWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkforceResponse> deleteWorkforce(DeleteWorkforceRequest deleteWorkforceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkforce");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkforceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWorkforceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkforceRequest, DeleteWorkforceResponse>()
                            .withOperationName("DeleteWorkforce")
                            .withMarshaller(new DeleteWorkforceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteWorkforceRequest));
            CompletableFuture<DeleteWorkforceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     *
     * @param deleteWorkteamRequest
     * @return A Java Future containing the result of the DeleteWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkteamResponse> deleteWorkteam(DeleteWorkteamRequest deleteWorkteamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkteamRequest, DeleteWorkteamResponse>()
                            .withOperationName("DeleteWorkteam")
                            .withMarshaller(new DeleteWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteWorkteamRequest));
            CompletableFuture<DeleteWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     * </p>
     *
     * @param deregisterDevicesRequest
     * @return A Java Future containing the result of the DeregisterDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeregisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterDevicesResponse> deregisterDevices(DeregisterDevicesRequest deregisterDevicesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterDevicesRequest, DeregisterDevicesResponse>()
                            .withOperationName("DeregisterDevices")
                            .withMarshaller(new DeregisterDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterDevicesRequest));
            CompletableFuture<DeregisterDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an action.
     * </p>
     *
     * @param describeActionRequest
     * @return A Java Future containing the result of the DescribeAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeActionResponse> describeAction(DescribeActionRequest describeActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeActionRequest, DescribeActionResponse>()
                            .withOperationName("DescribeAction")
                            .withMarshaller(new DescribeActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeActionRequest));
            CompletableFuture<DescribeActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return A Java Future containing the result of the DescribeAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlgorithmResponse> describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAlgorithmRequest, DescribeAlgorithmResponse>()
                            .withOperationName("DescribeAlgorithm")
                            .withMarshaller(new DescribeAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAlgorithmRequest));
            CompletableFuture<DescribeAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the app.
     * </p>
     *
     * @param describeAppRequest
     * @return A Java Future containing the result of the DescribeApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppResponse> describeApp(DescribeAppRequest describeAppRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppRequest, DescribeAppResponse>()
                            .withOperationName("DescribeApp").withMarshaller(new DescribeAppRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAppRequest));
            CompletableFuture<DescribeAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an AppImageConfig.
     * </p>
     *
     * @param describeAppImageConfigRequest
     * @return A Java Future containing the result of the DescribeAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppImageConfigResponse> describeAppImageConfig(
            DescribeAppImageConfigRequest describeAppImageConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppImageConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAppImageConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppImageConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppImageConfigRequest, DescribeAppImageConfigResponse>()
                            .withOperationName("DescribeAppImageConfig")
                            .withMarshaller(new DescribeAppImageConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAppImageConfigRequest));
            CompletableFuture<DescribeAppImageConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an artifact.
     * </p>
     *
     * @param describeArtifactRequest
     * @return A Java Future containing the result of the DescribeArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeArtifactResponse> describeArtifact(DescribeArtifactRequest describeArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeArtifactRequest, DescribeArtifactResponse>()
                            .withOperationName("DescribeArtifact")
                            .withMarshaller(new DescribeArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeArtifactRequest));
            CompletableFuture<DescribeArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an Amazon SageMaker AutoML job.
     * </p>
     *
     * @param describeAutoMlJobRequest
     * @return A Java Future containing the result of the DescribeAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutoMlJobResponse> describeAutoMLJob(DescribeAutoMlJobRequest describeAutoMlJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutoMLJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAutoMlJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAutoMlJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAutoMlJobRequest, DescribeAutoMlJobResponse>()
                            .withOperationName("DescribeAutoMLJob")
                            .withMarshaller(new DescribeAutoMlJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAutoMlJobRequest));
            CompletableFuture<DescribeAutoMlJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     *
     * @param describeCodeRepositoryRequest
     * @return A Java Future containing the result of the DescribeCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCodeRepositoryResponse> describeCodeRepository(
            DescribeCodeRepositoryRequest describeCodeRepositoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCodeRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCodeRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCodeRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCodeRepositoryRequest, DescribeCodeRepositoryResponse>()
                            .withOperationName("DescribeCodeRepository")
                            .withMarshaller(new DescribeCodeRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCodeRepositoryRequest));
            CompletableFuture<DescribeCodeRepositoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about multiple model
     * compilation jobs, use <a>ListCompilationJobs</a>.
     * </p>
     *
     * @param describeCompilationJobRequest
     * @return A Java Future containing the result of the DescribeCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCompilationJobResponse> describeCompilationJob(
            DescribeCompilationJobRequest describeCompilationJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCompilationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCompilationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCompilationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCompilationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCompilationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCompilationJobRequest, DescribeCompilationJobResponse>()
                            .withOperationName("DescribeCompilationJob")
                            .withMarshaller(new DescribeCompilationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCompilationJobRequest));
            CompletableFuture<DescribeCompilationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a context.
     * </p>
     *
     * @param describeContextRequest
     * @return A Java Future containing the result of the DescribeContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeContextResponse> describeContext(DescribeContextRequest describeContextRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeContext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeContextResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeContextResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeContextResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeContextRequest, DescribeContextResponse>()
                            .withOperationName("DescribeContext")
                            .withMarshaller(new DescribeContextRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeContextRequest));
            CompletableFuture<DescribeContextResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details of a data quality monitoring job definition.
     * </p>
     *
     * @param describeDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataQualityJobDefinitionResponse> describeDataQualityJobDefinition(
            DescribeDataQualityJobDefinitionRequest describeDataQualityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataQualityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDataQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDataQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataQualityJobDefinitionRequest, DescribeDataQualityJobDefinitionResponse>()
                            .withOperationName("DescribeDataQualityJobDefinition")
                            .withMarshaller(new DescribeDataQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDataQualityJobDefinitionRequest));
            CompletableFuture<DescribeDataQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeviceRequest, DescribeDeviceResponse>()
                            .withOperationName("DescribeDevice")
                            .withMarshaller(new DescribeDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDeviceRequest));
            CompletableFuture<DescribeDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A description of the fleet the device belongs to.
     * </p>
     *
     * @param describeDeviceFleetRequest
     * @return A Java Future containing the result of the DescribeDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeviceFleetResponse> describeDeviceFleet(
            DescribeDeviceFleetRequest describeDeviceFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeviceFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeviceFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDeviceFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeviceFleetRequest, DescribeDeviceFleetResponse>()
                            .withOperationName("DescribeDeviceFleet")
                            .withMarshaller(new DescribeDeviceFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDeviceFleetRequest));
            CompletableFuture<DescribeDeviceFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainRequest, DescribeDomainResponse>()
                            .withOperationName("DescribeDomain")
                            .withMarshaller(new DescribeDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDomainRequest));
            CompletableFuture<DescribeDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an edge deployment plan with deployment status per stage.
     * </p>
     *
     * @param describeEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the DescribeEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEdgeDeploymentPlanResponse> describeEdgeDeploymentPlan(
            DescribeEdgeDeploymentPlanRequest describeEdgeDeploymentPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEdgeDeploymentPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEdgeDeploymentPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEdgeDeploymentPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEdgeDeploymentPlanRequest, DescribeEdgeDeploymentPlanResponse>()
                            .withOperationName("DescribeEdgeDeploymentPlan")
                            .withMarshaller(new DescribeEdgeDeploymentPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEdgeDeploymentPlanRequest));
            CompletableFuture<DescribeEdgeDeploymentPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A description of edge packaging jobs.
     * </p>
     *
     * @param describeEdgePackagingJobRequest
     * @return A Java Future containing the result of the DescribeEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEdgePackagingJobResponse> describeEdgePackagingJob(
            DescribeEdgePackagingJobRequest describeEdgePackagingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEdgePackagingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEdgePackagingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEdgePackagingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEdgePackagingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEdgePackagingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEdgePackagingJobRequest, DescribeEdgePackagingJobResponse>()
                            .withOperationName("DescribeEdgePackagingJob")
                            .withMarshaller(new DescribeEdgePackagingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEdgePackagingJobRequest));
            CompletableFuture<DescribeEdgePackagingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                            .withOperationName("DescribeEndpoint")
                            .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEndpointRequest));
            CompletableFuture<DescribeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     *
     * @param describeEndpointConfigRequest
     * @return A Java Future containing the result of the DescribeEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointConfigResponse> describeEndpointConfig(
            DescribeEndpointConfigRequest describeEndpointConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEndpointConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointConfigRequest, DescribeEndpointConfigResponse>()
                            .withOperationName("DescribeEndpointConfig")
                            .withMarshaller(new DescribeEndpointConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEndpointConfigRequest));
            CompletableFuture<DescribeEndpointConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of an experiment's properties.
     * </p>
     *
     * @param describeExperimentRequest
     * @return A Java Future containing the result of the DescribeExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExperimentResponse> describeExperiment(DescribeExperimentRequest describeExperimentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExperimentRequest, DescribeExperimentResponse>()
                            .withOperationName("DescribeExperiment")
                            .withMarshaller(new DescribeExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeExperimentRequest));
            CompletableFuture<DescribeExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation
     * time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.
     * </p>
     *
     * @param describeFeatureGroupRequest
     * @return A Java Future containing the result of the DescribeFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFeatureGroupResponse> describeFeatureGroup(
            DescribeFeatureGroupRequest describeFeatureGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeatureGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFeatureGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFeatureGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFeatureGroupRequest, DescribeFeatureGroupResponse>()
                            .withOperationName("DescribeFeatureGroup")
                            .withMarshaller(new DescribeFeatureGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFeatureGroupRequest));
            CompletableFuture<DescribeFeatureGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shows the metadata for a feature within a feature group.
     * </p>
     *
     * @param describeFeatureMetadataRequest
     * @return A Java Future containing the result of the DescribeFeatureMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFeatureMetadataResponse> describeFeatureMetadata(
            DescribeFeatureMetadataRequest describeFeatureMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFeatureMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeatureMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFeatureMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFeatureMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFeatureMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFeatureMetadataRequest, DescribeFeatureMetadataResponse>()
                            .withOperationName("DescribeFeatureMetadata")
                            .withMarshaller(new DescribeFeatureMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFeatureMetadataRequest));
            CompletableFuture<DescribeFeatureMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified flow definition.
     * </p>
     *
     * @param describeFlowDefinitionRequest
     * @return A Java Future containing the result of the DescribeFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowDefinitionResponse> describeFlowDefinition(
            DescribeFlowDefinitionRequest describeFlowDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFlowDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFlowDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowDefinitionRequest, DescribeFlowDefinitionResponse>()
                            .withOperationName("DescribeFlowDefinition")
                            .withMarshaller(new DescribeFlowDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFlowDefinitionRequest));
            CompletableFuture<DescribeFlowDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the requested human task user interface (worker task template).
     * </p>
     *
     * @param describeHumanTaskUiRequest
     * @return A Java Future containing the result of the DescribeHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHumanTaskUiResponse> describeHumanTaskUi(
            DescribeHumanTaskUiRequest describeHumanTaskUiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHumanTaskUi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeHumanTaskUiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeHumanTaskUiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHumanTaskUiRequest, DescribeHumanTaskUiResponse>()
                            .withOperationName("DescribeHumanTaskUi")
                            .withMarshaller(new DescribeHumanTaskUiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeHumanTaskUiRequest));
            CompletableFuture<DescribeHumanTaskUiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a description of a hyperparameter tuning job.
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the DescribeHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHyperParameterTuningJobResponse> describeHyperParameterTuningJob(
            DescribeHyperParameterTuningJobRequest describeHyperParameterTuningJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHyperParameterTuningJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHyperParameterTuningJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeHyperParameterTuningJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeHyperParameterTuningJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHyperParameterTuningJobRequest, DescribeHyperParameterTuningJobResponse>()
                            .withOperationName("DescribeHyperParameterTuningJob")
                            .withMarshaller(new DescribeHyperParameterTuningJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeHyperParameterTuningJobRequest));
            CompletableFuture<DescribeHyperParameterTuningJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a SageMaker image.
     * </p>
     *
     * @param describeImageRequest
     * @return A Java Future containing the result of the DescribeImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImageResponse> describeImage(DescribeImageRequest describeImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImageRequest, DescribeImageResponse>()
                            .withOperationName("DescribeImage")
                            .withMarshaller(new DescribeImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeImageRequest));
            CompletableFuture<DescribeImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a version of a SageMaker image.
     * </p>
     *
     * @param describeImageVersionRequest
     * @return A Java Future containing the result of the DescribeImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImageVersionResponse> describeImageVersion(
            DescribeImageVersionRequest describeImageVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImageVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeImageVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeImageVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImageVersionRequest, DescribeImageVersionResponse>()
                            .withOperationName("DescribeImageVersion")
                            .withMarshaller(new DescribeImageVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeImageVersionRequest));
            CompletableFuture<DescribeImageVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     * </p>
     *
     * @param describeInferenceRecommendationsJobRequest
     * @return A Java Future containing the result of the DescribeInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInferenceRecommendationsJobResponse> describeInferenceRecommendationsJob(
            DescribeInferenceRecommendationsJobRequest describeInferenceRecommendationsJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInferenceRecommendationsJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInferenceRecommendationsJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInferenceRecommendationsJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeInferenceRecommendationsJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInferenceRecommendationsJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInferenceRecommendationsJobRequest, DescribeInferenceRecommendationsJobResponse>()
                            .withOperationName("DescribeInferenceRecommendationsJob")
                            .withMarshaller(new DescribeInferenceRecommendationsJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeInferenceRecommendationsJobRequest));
            CompletableFuture<DescribeInferenceRecommendationsJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     *
     * @param describeLabelingJobRequest
     * @return A Java Future containing the result of the DescribeLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLabelingJobResponse> describeLabelingJob(
            DescribeLabelingJobRequest describeLabelingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLabelingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLabelingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLabelingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLabelingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeLabelingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLabelingJobRequest, DescribeLabelingJobResponse>()
                            .withOperationName("DescribeLabelingJob")
                            .withMarshaller(new DescribeLabelingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeLabelingJobRequest));
            CompletableFuture<DescribeLabelingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of properties for the requested lineage group. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param describeLineageGroupRequest
     * @return A Java Future containing the result of the DescribeLineageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLineageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLineageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLineageGroupResponse> describeLineageGroup(
            DescribeLineageGroupRequest describeLineageGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLineageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLineageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLineageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLineageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeLineageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLineageGroupRequest, DescribeLineageGroupResponse>()
                            .withOperationName("DescribeLineageGroup")
                            .withMarshaller(new DescribeLineageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeLineageGroupRequest));
            CompletableFuture<DescribeLineageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     *
     * @param describeModelRequest
     * @return A Java Future containing the result of the DescribeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelResponse> describeModel(DescribeModelRequest describeModelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelRequest, DescribeModelResponse>()
                            .withOperationName("DescribeModel")
                            .withMarshaller(new DescribeModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeModelRequest));
            CompletableFuture<DescribeModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a model bias job definition.
     * </p>
     *
     * @param describeModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelBiasJobDefinitionResponse> describeModelBiasJobDefinition(
            DescribeModelBiasJobDefinitionRequest describeModelBiasJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelBiasJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelBiasJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelBiasJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelBiasJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelBiasJobDefinitionRequest, DescribeModelBiasJobDefinitionResponse>()
                            .withOperationName("DescribeModelBiasJobDefinition")
                            .withMarshaller(new DescribeModelBiasJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeModelBiasJobDefinitionRequest));
            CompletableFuture<DescribeModelBiasJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a model explainability job definition.
     * </p>
     *
     * @param describeModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> describeModelExplainabilityJobDefinition(
            DescribeModelExplainabilityJobDefinitionRequest describeModelExplainabilityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelExplainabilityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeModelExplainabilityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelExplainabilityJobDefinitionRequest, DescribeModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("DescribeModelExplainabilityJobDefinition")
                            .withMarshaller(new DescribeModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelExplainabilityJobDefinitionRequest));
            CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on
     * Amazon Web Services Marketplace.
     * </p>
     * <p>
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeModelPackageRequest
     * @return A Java Future containing the result of the DescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelPackageResponse> describeModelPackage(
            DescribeModelPackageRequest describeModelPackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelPackageRequest, DescribeModelPackageResponse>()
                            .withOperationName("DescribeModelPackage")
                            .withMarshaller(new DescribeModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeModelPackageRequest));
            CompletableFuture<DescribeModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a description for the specified model group.
     * </p>
     *
     * @param describeModelPackageGroupRequest
     * @return A Java Future containing the result of the DescribeModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelPackageGroupResponse> describeModelPackageGroup(
            DescribeModelPackageGroupRequest describeModelPackageGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelPackageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelPackageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelPackageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelPackageGroupRequest, DescribeModelPackageGroupResponse>()
                            .withOperationName("DescribeModelPackageGroup")
                            .withMarshaller(new DescribeModelPackageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeModelPackageGroupRequest));
            CompletableFuture<DescribeModelPackageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a model quality job definition.
     * </p>
     *
     * @param describeModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelQualityJobDefinitionResponse> describeModelQualityJobDefinition(
            DescribeModelQualityJobDefinitionRequest describeModelQualityJobDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelQualityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeModelQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelQualityJobDefinitionRequest, DescribeModelQualityJobDefinitionResponse>()
                            .withOperationName("DescribeModelQualityJobDefinition")
                            .withMarshaller(new DescribeModelQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeModelQualityJobDefinitionRequest));
            CompletableFuture<DescribeModelQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the schedule for a monitoring job.
     * </p>
     *
     * @param describeMonitoringScheduleRequest
     * @return A Java Future containing the result of the DescribeMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMonitoringScheduleResponse> describeMonitoringSchedule(
            DescribeMonitoringScheduleRequest describeMonitoringScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMonitoringSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMonitoringScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMonitoringScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMonitoringScheduleRequest, DescribeMonitoringScheduleResponse>()
                            .withOperationName("DescribeMonitoringSchedule")
                            .withMarshaller(new DescribeMonitoringScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMonitoringScheduleRequest));
            CompletableFuture<DescribeMonitoringScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     *
     * @param describeNotebookInstanceRequest
     * @return A Java Future containing the result of the DescribeNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNotebookInstanceResponse> describeNotebookInstance(
            DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNotebookInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeNotebookInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNotebookInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>()
                            .withOperationName("DescribeNotebookInstance")
                            .withMarshaller(new DescribeNotebookInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeNotebookInstanceRequest));
            CompletableFuture<DescribeNotebookInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the DescribeNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> describeNotebookInstanceLifecycleConfig(
            DescribeNotebookInstanceLifecycleConfigRequest describeNotebookInstanceLifecycleConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNotebookInstanceLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeNotebookInstanceLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNotebookInstanceLifecycleConfigRequest, DescribeNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("DescribeNotebookInstanceLifecycleConfig")
                            .withMarshaller(new DescribeNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeNotebookInstanceLifecycleConfigRequest));
            CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of a pipeline.
     * </p>
     *
     * @param describePipelineRequest
     * @return A Java Future containing the result of the DescribePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePipelineResponse> describePipeline(DescribePipelineRequest describePipelineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineRequest, DescribePipelineResponse>()
                            .withOperationName("DescribePipeline")
                            .withMarshaller(new DescribePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePipelineRequest));
            CompletableFuture<DescribePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of an execution's pipeline definition.
     * </p>
     *
     * @param describePipelineDefinitionForExecutionRequest
     * @return A Java Future containing the result of the DescribePipelineDefinitionForExecution operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineDefinitionForExecution
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePipelineDefinitionForExecutionResponse> describePipelineDefinitionForExecution(
            DescribePipelineDefinitionForExecutionRequest describePipelineDefinitionForExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePipelineDefinitionForExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipelineDefinitionForExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePipelineDefinitionForExecutionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribePipelineDefinitionForExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePipelineDefinitionForExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineDefinitionForExecutionRequest, DescribePipelineDefinitionForExecutionResponse>()
                            .withOperationName("DescribePipelineDefinitionForExecution")
                            .withMarshaller(new DescribePipelineDefinitionForExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePipelineDefinitionForExecutionRequest));
            CompletableFuture<DescribePipelineDefinitionForExecutionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of a pipeline execution.
     * </p>
     *
     * @param describePipelineExecutionRequest
     * @return A Java Future containing the result of the DescribePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePipelineExecutionResponse> describePipelineExecution(
            DescribePipelineExecutionRequest describePipelineExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipelineExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePipelineExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePipelineExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineExecutionRequest, DescribePipelineExecutionResponse>()
                            .withOperationName("DescribePipelineExecution")
                            .withMarshaller(new DescribePipelineExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePipelineExecutionRequest));
            CompletableFuture<DescribePipelineExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a processing job.
     * </p>
     *
     * @param describeProcessingJobRequest
     * @return A Java Future containing the result of the DescribeProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProcessingJobResponse> describeProcessingJob(
            DescribeProcessingJobRequest describeProcessingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProcessingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProcessingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProcessingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProcessingJobRequest, DescribeProcessingJobResponse>()
                            .withOperationName("DescribeProcessingJob")
                            .withMarshaller(new DescribeProcessingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProcessingJobRequest));
            CompletableFuture<DescribeProcessingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProjectRequest, DescribeProjectResponse>()
                            .withOperationName("DescribeProject")
                            .withMarshaller(new DescribeProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProjectRequest));
            CompletableFuture<DescribeProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the Studio Lifecycle Configuration.
     * </p>
     *
     * @param describeStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the DescribeStudioLifecycleConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStudioLifecycleConfigResponse> describeStudioLifecycleConfig(
            DescribeStudioLifecycleConfigRequest describeStudioLifecycleConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeStudioLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStudioLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeStudioLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeStudioLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStudioLifecycleConfigRequest, DescribeStudioLifecycleConfigResponse>()
                            .withOperationName("DescribeStudioLifecycleConfig")
                            .withMarshaller(new DescribeStudioLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStudioLifecycleConfigRequest));
            CompletableFuture<DescribeStudioLifecycleConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     * @return A Java Future containing the result of the DescribeSubscribedWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeSubscribedWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSubscribedWorkteamResponse> describeSubscribedWorkteam(
            DescribeSubscribedWorkteamRequest describeSubscribedWorkteamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSubscribedWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSubscribedWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSubscribedWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSubscribedWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSubscribedWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSubscribedWorkteamRequest, DescribeSubscribedWorkteamResponse>()
                            .withOperationName("DescribeSubscribedWorkteam")
                            .withMarshaller(new DescribeSubscribedWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSubscribedWorkteamRequest));
            CompletableFuture<DescribeSubscribedWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <p>
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails,
     * <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>,
     * attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>,
     * and <code>BillableTimeInSeconds</code> may not be present in the response.
     * </p>
     *
     * @param describeTrainingJobRequest
     * @return A Java Future containing the result of the DescribeTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrainingJobResponse> describeTrainingJob(
            DescribeTrainingJobRequest describeTrainingJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrainingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrainingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrainingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrainingJobRequest, DescribeTrainingJobResponse>()
                            .withOperationName("DescribeTrainingJob")
                            .withMarshaller(new DescribeTrainingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTrainingJobRequest));
            CompletableFuture<DescribeTrainingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     *
     * @param describeTransformJobRequest
     * @return A Java Future containing the result of the DescribeTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTransformJobResponse> describeTransformJob(
            DescribeTransformJobRequest describeTransformJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTransformJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTransformJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTransformJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTransformJobRequest, DescribeTransformJobResponse>()
                            .withOperationName("DescribeTransformJob")
                            .withMarshaller(new DescribeTransformJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTransformJobRequest));
            CompletableFuture<DescribeTransformJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of a trial's properties.
     * </p>
     *
     * @param describeTrialRequest
     * @return A Java Future containing the result of the DescribeTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrialResponse> describeTrial(DescribeTrialRequest describeTrialRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeTrialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrialRequest, DescribeTrialResponse>()
                            .withOperationName("DescribeTrial")
                            .withMarshaller(new DescribeTrialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTrialRequest));
            CompletableFuture<DescribeTrialResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of a trials component's properties.
     * </p>
     *
     * @param describeTrialComponentRequest
     * @return A Java Future containing the result of the DescribeTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrialComponentResponse> describeTrialComponent(
            DescribeTrialComponentRequest describeTrialComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrialComponentRequest, DescribeTrialComponentResponse>()
                            .withOperationName("DescribeTrialComponent")
                            .withMarshaller(new DescribeTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTrialComponentRequest));
            CompletableFuture<DescribeTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a user profile. For more information, see <code>CreateUserProfile</code>.
     * </p>
     *
     * @param describeUserProfileRequest
     * @return A Java Future containing the result of the DescribeUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserProfileResponse> describeUserProfile(
            DescribeUserProfileRequest describeUserProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserProfileRequest, DescribeUserProfileResponse>()
                            .withOperationName("DescribeUserProfile")
                            .withMarshaller(new DescribeUserProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeUserProfileRequest));
            CompletableFuture<DescribeUserProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable,
     * allowed IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges
     * are the IP addresses that workers can use to access tasks.
     * </p>
     * <important>
     * <p>
     * This operation applies only to private workforces.
     * </p>
     * </important>
     *
     * @param describeWorkforceRequest
     * @return A Java Future containing the result of the DescribeWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorkforceResponse> describeWorkforce(DescribeWorkforceRequest describeWorkforceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkforce");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorkforceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorkforceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkforceRequest, DescribeWorkforceResponse>()
                            .withOperationName("DescribeWorkforce")
                            .withMarshaller(new DescribeWorkforceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeWorkforceRequest));
            CompletableFuture<DescribeWorkforceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the create date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeWorkteamRequest
     * @return A Java Future containing the result of the DescribeWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorkteamResponse> describeWorkteam(DescribeWorkteamRequest describeWorkteamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkteamRequest, DescribeWorkteamResponse>()
                            .withOperationName("DescribeWorkteam")
                            .withMarshaller(new DescribeWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeWorkteamRequest));
            CompletableFuture<DescribeWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param disableSagemakerServicecatalogPortfolioRequest
     * @return A Java Future containing the result of the DisableSagemakerServicecatalogPortfolio operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DisableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableSagemakerServicecatalogPortfolioResponse> disableSagemakerServicecatalogPortfolio(
            DisableSagemakerServicecatalogPortfolioRequest disableSagemakerServicecatalogPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableSagemakerServicecatalogPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableSagemakerServicecatalogPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableSagemakerServicecatalogPortfolioResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisableSagemakerServicecatalogPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableSagemakerServicecatalogPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableSagemakerServicecatalogPortfolioRequest, DisableSagemakerServicecatalogPortfolioResponse>()
                            .withOperationName("DisableSagemakerServicecatalogPortfolio")
                            .withMarshaller(new DisableSagemakerServicecatalogPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(disableSagemakerServicecatalogPortfolioRequest));
            CompletableFuture<DisableSagemakerServicecatalogPortfolioResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with.
     * Before you can delete a component, you must disassociate the component from all trials it is associated with. To
     * associate a trial component with a trial, call the <a>AssociateTrialComponent</a> API.
     * </p>
     * <p>
     * To get a list of the trials a component is associated with, use the <a>Search</a> API. Specify
     * <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response
     * under <code>Results.TrialComponent.Parents</code>.
     * </p>
     *
     * @param disassociateTrialComponentRequest
     * @return A Java Future containing the result of the DisassociateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DisassociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateTrialComponentResponse> disassociateTrialComponent(
            DisassociateTrialComponentRequest disassociateTrialComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateTrialComponentRequest, DisassociateTrialComponentResponse>()
                            .withOperationName("DisassociateTrialComponent")
                            .withMarshaller(new DisassociateTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateTrialComponentRequest));
            CompletableFuture<DisassociateTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param enableSagemakerServicecatalogPortfolioRequest
     * @return A Java Future containing the result of the EnableSagemakerServicecatalogPortfolio operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.EnableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EnableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableSagemakerServicecatalogPortfolioResponse> enableSagemakerServicecatalogPortfolio(
            EnableSagemakerServicecatalogPortfolioRequest enableSagemakerServicecatalogPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                enableSagemakerServicecatalogPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableSagemakerServicecatalogPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableSagemakerServicecatalogPortfolioResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, EnableSagemakerServicecatalogPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableSagemakerServicecatalogPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableSagemakerServicecatalogPortfolioRequest, EnableSagemakerServicecatalogPortfolioResponse>()
                            .withOperationName("EnableSagemakerServicecatalogPortfolio")
                            .withMarshaller(new EnableSagemakerServicecatalogPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableSagemakerServicecatalogPortfolioRequest));
            CompletableFuture<EnableSagemakerServicecatalogPortfolioResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     *
     * @param getDeviceFleetReportRequest
     * @return A Java Future containing the result of the GetDeviceFleetReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetDeviceFleetReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetDeviceFleetReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceFleetReportResponse> getDeviceFleetReport(
            GetDeviceFleetReportRequest getDeviceFleetReportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceFleetReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceFleetReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceFleetReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceFleetReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceFleetReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceFleetReportRequest, GetDeviceFleetReportResponse>()
                            .withOperationName("GetDeviceFleetReport")
                            .withMarshaller(new GetDeviceFleetReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeviceFleetReportRequest));
            CompletableFuture<GetDeviceFleetReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The resource policy for the lineage group.
     * </p>
     *
     * @param getLineageGroupPolicyRequest
     * @return A Java Future containing the result of the GetLineageGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetLineageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetLineageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLineageGroupPolicyResponse> getLineageGroupPolicy(
            GetLineageGroupPolicyRequest getLineageGroupPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLineageGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLineageGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLineageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLineageGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLineageGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLineageGroupPolicyRequest, GetLineageGroupPolicyResponse>()
                            .withOperationName("GetLineageGroupPolicy")
                            .withMarshaller(new GetLineageGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLineageGroupPolicyRequest));
            CompletableFuture<GetLineageGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a resource policy that manages access for a model group. For information about resource policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User
     * Guide.</i>.
     * </p>
     *
     * @param getModelPackageGroupPolicyRequest
     * @return A Java Future containing the result of the GetModelPackageGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetModelPackageGroupPolicyResponse> getModelPackageGroupPolicy(
            GetModelPackageGroupPolicyRequest getModelPackageGroupPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelPackageGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelPackageGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelPackageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetModelPackageGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelPackageGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelPackageGroupPolicyRequest, GetModelPackageGroupPolicyResponse>()
                            .withOperationName("GetModelPackageGroupPolicy")
                            .withMarshaller(new GetModelPackageGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getModelPackageGroupPolicyRequest));
            CompletableFuture<GetModelPackageGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param getSagemakerServicecatalogPortfolioStatusRequest
     * @return A Java Future containing the result of the GetSagemakerServicecatalogPortfolioStatus operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetSagemakerServicecatalogPortfolioStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSagemakerServicecatalogPortfolioStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSagemakerServicecatalogPortfolioStatusResponse> getSagemakerServicecatalogPortfolioStatus(
            GetSagemakerServicecatalogPortfolioStatusRequest getSagemakerServicecatalogPortfolioStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSagemakerServicecatalogPortfolioStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSagemakerServicecatalogPortfolioStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSagemakerServicecatalogPortfolioStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSagemakerServicecatalogPortfolioStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSagemakerServicecatalogPortfolioStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSagemakerServicecatalogPortfolioStatusRequest, GetSagemakerServicecatalogPortfolioStatusResponse>()
                            .withOperationName("GetSagemakerServicecatalogPortfolioStatus")
                            .withMarshaller(new GetSagemakerServicecatalogPortfolioStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getSagemakerServicecatalogPortfolioStatusRequest));
            CompletableFuture<GetSagemakerServicecatalogPortfolioStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of
     * possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for
     * <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.
     * </p>
     *
     * @param getSearchSuggestionsRequest
     * @return A Java Future containing the result of the GetSearchSuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetSearchSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSearchSuggestionsResponse> getSearchSuggestions(
            GetSearchSuggestionsRequest getSearchSuggestionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSearchSuggestionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSearchSuggestions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSearchSuggestionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSearchSuggestionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSearchSuggestionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSearchSuggestionsRequest, GetSearchSuggestionsResponse>()
                            .withOperationName("GetSearchSuggestions")
                            .withMarshaller(new GetSearchSuggestionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSearchSuggestionsRequest));
            CompletableFuture<GetSearchSuggestionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the actions in your account and their properties.
     * </p>
     *
     * @param listActionsRequest
     * @return A Java Future containing the result of the ListActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListActionsResponse> listActions(ListActionsRequest listActionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListActions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListActionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListActionsRequest, ListActionsResponse>()
                            .withOperationName("ListActions").withMarshaller(new ListActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listActionsRequest));
            CompletableFuture<ListActionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the actions in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)} operation.</b>
     * </p>
     *
     * @param listActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    public ListActionsPublisher listActionsPaginator(ListActionsRequest listActionsRequest) {
        return new ListActionsPublisher(this, applyPaginatorUserAgent(listActionsRequest));
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     *
     * @param listAlgorithmsRequest
     * @return A Java Future containing the result of the ListAlgorithms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAlgorithmsResponse> listAlgorithms(ListAlgorithmsRequest listAlgorithmsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAlgorithmsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAlgorithms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAlgorithmsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAlgorithmsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAlgorithmsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAlgorithmsRequest, ListAlgorithmsResponse>()
                            .withOperationName("ListAlgorithms")
                            .withMarshaller(new ListAlgorithmsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAlgorithmsRequest));
            CompletableFuture<ListAlgorithmsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsPublisher publisher = client.listAlgorithmsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsPublisher publisher = client.listAlgorithmsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation.</b>
     * </p>
     *
     * @param listAlgorithmsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAlgorithmsPublisher listAlgorithmsPaginator(ListAlgorithmsRequest listAlgorithmsRequest) {
        return new ListAlgorithmsPublisher(this, applyPaginatorUserAgent(listAlgorithmsRequest));
    }

    /**
     * <p>
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or
     * modified time, and whether the AppImageConfig name contains a specified string.
     * </p>
     *
     * @param listAppImageConfigsRequest
     * @return A Java Future containing the result of the ListAppImageConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppImageConfigsResponse> listAppImageConfigs(
            ListAppImageConfigsRequest listAppImageConfigsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppImageConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppImageConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppImageConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppImageConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppImageConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppImageConfigsRequest, ListAppImageConfigsResponse>()
                            .withOperationName("ListAppImageConfigs")
                            .withMarshaller(new ListAppImageConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAppImageConfigsRequest));
            CompletableFuture<ListAppImageConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or
     * modified time, and whether the AppImageConfig name contains a specified string.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsPublisher publisher = client.listAppImageConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsPublisher publisher = client.listAppImageConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppImageConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    public ListAppImageConfigsPublisher listAppImageConfigsPaginator(ListAppImageConfigsRequest listAppImageConfigsRequest) {
        return new ListAppImageConfigsPublisher(this, applyPaginatorUserAgent(listAppImageConfigsRequest));
    }

    /**
     * <p>
     * Lists apps.
     * </p>
     *
     * @param listAppsRequest
     * @return A Java Future containing the result of the ListApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppsResponse> listApps(ListAppsRequest listAppsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAppsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppsRequest, ListAppsResponse>().withOperationName("ListApps")
                            .withMarshaller(new ListAppsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppsRequest));
            CompletableFuture<ListAppsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists apps.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsPublisher publisher = client.listAppsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsPublisher publisher = client.listAppsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListAppsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListAppsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAppsPublisher listAppsPaginator(ListAppsRequest listAppsRequest) {
        return new ListAppsPublisher(this, applyPaginatorUserAgent(listAppsRequest));
    }

    /**
     * <p>
     * Lists the artifacts in your account and their properties.
     * </p>
     *
     * @param listArtifactsRequest
     * @return A Java Future containing the result of the ListArtifacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListArtifactsResponse> listArtifacts(ListArtifactsRequest listArtifactsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listArtifactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListArtifacts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListArtifactsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListArtifactsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListArtifactsRequest, ListArtifactsResponse>()
                            .withOperationName("ListArtifacts")
                            .withMarshaller(new ListArtifactsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listArtifactsRequest));
            CompletableFuture<ListArtifactsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the artifacts in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)} operation.</b>
     * </p>
     *
     * @param listArtifactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    public ListArtifactsPublisher listArtifactsPaginator(ListArtifactsRequest listArtifactsRequest) {
        return new ListArtifactsPublisher(this, applyPaginatorUserAgent(listArtifactsRequest));
    }

    /**
     * <p>
     * Lists the associations in your account and their properties.
     * </p>
     *
     * @param listAssociationsRequest
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssociationsResponse> listAssociations(ListAssociationsRequest listAssociationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssociationsRequest, ListAssociationsResponse>()
                            .withOperationName("ListAssociations")
                            .withMarshaller(new ListAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAssociationsRequest));
            CompletableFuture<ListAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the associations in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @param listAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    public ListAssociationsPublisher listAssociationsPaginator(ListAssociationsRequest listAssociationsRequest) {
        return new ListAssociationsPublisher(this, applyPaginatorUserAgent(listAssociationsRequest));
    }

    /**
     * <p>
     * Request a list of jobs.
     * </p>
     *
     * @param listAutoMlJobsRequest
     * @return A Java Future containing the result of the ListAutoMLJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAutoMlJobsResponse> listAutoMLJobs(ListAutoMlJobsRequest listAutoMlJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAutoMlJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAutoMLJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAutoMlJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAutoMlJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAutoMlJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAutoMlJobsRequest, ListAutoMlJobsResponse>()
                            .withOperationName("ListAutoMLJobs")
                            .withMarshaller(new ListAutoMlJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAutoMlJobsRequest));
            CompletableFuture<ListAutoMlJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Request a list of jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsPublisher publisher = client.listAutoMLJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsPublisher publisher = client.listAutoMLJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation.</b>
     * </p>
     *
     * @param listAutoMlJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAutoMLJobsPublisher listAutoMLJobsPaginator(ListAutoMlJobsRequest listAutoMlJobsRequest) {
        return new ListAutoMLJobsPublisher(this, applyPaginatorUserAgent(listAutoMlJobsRequest));
    }

    /**
     * <p>
     * List the candidates created for the job.
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     * @return A Java Future containing the result of the ListCandidatesForAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCandidatesForAutoMlJobResponse> listCandidatesForAutoMLJob(
            ListCandidatesForAutoMlJobRequest listCandidatesForAutoMlJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCandidatesForAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCandidatesForAutoMLJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCandidatesForAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCandidatesForAutoMlJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCandidatesForAutoMlJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCandidatesForAutoMlJobRequest, ListCandidatesForAutoMlJobResponse>()
                            .withOperationName("ListCandidatesForAutoMLJob")
                            .withMarshaller(new ListCandidatesForAutoMlJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCandidatesForAutoMlJobRequest));
            CompletableFuture<ListCandidatesForAutoMlJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the candidates created for the job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobPublisher publisher = client.listCandidatesForAutoMLJobPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobPublisher publisher = client.listCandidatesForAutoMLJobPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    public ListCandidatesForAutoMLJobPublisher listCandidatesForAutoMLJobPaginator(
            ListCandidatesForAutoMlJobRequest listCandidatesForAutoMlJobRequest) {
        return new ListCandidatesForAutoMLJobPublisher(this, applyPaginatorUserAgent(listCandidatesForAutoMlJobRequest));
    }

    /**
     * <p>
     * Gets a list of the Git repositories in your account.
     * </p>
     *
     * @param listCodeRepositoriesRequest
     * @return A Java Future containing the result of the ListCodeRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListCodeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCodeRepositoriesResponse> listCodeRepositories(
            ListCodeRepositoriesRequest listCodeRepositoriesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCodeRepositoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCodeRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCodeRepositoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCodeRepositoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCodeRepositoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCodeRepositoriesRequest, ListCodeRepositoriesResponse>()
                            .withOperationName("ListCodeRepositories")
                            .withMarshaller(new ListCodeRepositoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCodeRepositoriesRequest));
            CompletableFuture<ListCodeRepositoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the Git repositories in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCodeRepositories(software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesPublisher publisher = client.listCodeRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesPublisher publisher = client.listCodeRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeRepositories(software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodeRepositoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListCodeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    public ListCodeRepositoriesPublisher listCodeRepositoriesPaginator(ListCodeRepositoriesRequest listCodeRepositoriesRequest) {
        return new ListCodeRepositoriesPublisher(this, applyPaginatorUserAgent(listCodeRepositoriesRequest));
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     *
     * @param listCompilationJobsRequest
     * @return A Java Future containing the result of the ListCompilationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListCompilationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCompilationJobsResponse> listCompilationJobs(
            ListCompilationJobsRequest listCompilationJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCompilationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCompilationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCompilationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCompilationJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCompilationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCompilationJobsRequest, ListCompilationJobsResponse>()
                            .withOperationName("ListCompilationJobs")
                            .withMarshaller(new ListCompilationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCompilationJobsRequest));
            CompletableFuture<ListCompilationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsPublisher publisher = client.listCompilationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsPublisher publisher = client.listCompilationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCompilationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListCompilationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    public ListCompilationJobsPublisher listCompilationJobsPaginator(ListCompilationJobsRequest listCompilationJobsRequest) {
        return new ListCompilationJobsPublisher(this, applyPaginatorUserAgent(listCompilationJobsRequest));
    }

    /**
     * <p>
     * Lists the contexts in your account and their properties.
     * </p>
     *
     * @param listContextsRequest
     * @return A Java Future containing the result of the ListContexts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListContexts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListContexts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListContextsResponse> listContexts(ListContextsRequest listContextsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContextsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContexts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContextsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListContextsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListContextsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContextsRequest, ListContextsResponse>()
                            .withOperationName("ListContexts").withMarshaller(new ListContextsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listContextsRequest));
            CompletableFuture<ListContextsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the contexts in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listContexts(software.amazon.awssdk.services.sagemaker.model.ListContextsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListContextsPublisher publisher = client.listContextsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListContextsPublisher publisher = client.listContextsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListContextsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListContextsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContexts(software.amazon.awssdk.services.sagemaker.model.ListContextsRequest)} operation.</b>
     * </p>
     *
     * @param listContextsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListContexts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListContexts" target="_top">AWS API
     *      Documentation</a>
     */
    public ListContextsPublisher listContextsPaginator(ListContextsRequest listContextsRequest) {
        return new ListContextsPublisher(this, applyPaginatorUserAgent(listContextsRequest));
    }

    /**
     * <p>
     * Lists the data quality job definitions in your account.
     * </p>
     *
     * @param listDataQualityJobDefinitionsRequest
     * @return A Java Future containing the result of the ListDataQualityJobDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDataQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDataQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataQualityJobDefinitionsResponse> listDataQualityJobDefinitions(
            ListDataQualityJobDefinitionsRequest listDataQualityJobDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDataQualityJobDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataQualityJobDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataQualityJobDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDataQualityJobDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataQualityJobDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataQualityJobDefinitionsRequest, ListDataQualityJobDefinitionsResponse>()
                            .withOperationName("ListDataQualityJobDefinitions")
                            .withMarshaller(new ListDataQualityJobDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDataQualityJobDefinitionsRequest));
            CompletableFuture<ListDataQualityJobDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the data quality job definitions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsPublisher publisher = client.listDataQualityJobDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsPublisher publisher = client.listDataQualityJobDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataQualityJobDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDataQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDataQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDataQualityJobDefinitionsPublisher listDataQualityJobDefinitionsPaginator(
            ListDataQualityJobDefinitionsRequest listDataQualityJobDefinitionsRequest) {
        return new ListDataQualityJobDefinitionsPublisher(this, applyPaginatorUserAgent(listDataQualityJobDefinitionsRequest));
    }

    /**
     * <p>
     * Returns a list of devices in the fleet.
     * </p>
     *
     * @param listDeviceFleetsRequest
     * @return A Java Future containing the result of the ListDeviceFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDeviceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDeviceFleets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceFleetsResponse> listDeviceFleets(ListDeviceFleetsRequest listDeviceFleetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceFleetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeviceFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeviceFleetsRequest, ListDeviceFleetsResponse>()
                            .withOperationName("ListDeviceFleets")
                            .withMarshaller(new ListDeviceFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDeviceFleetsRequest));
            CompletableFuture<ListDeviceFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of devices in the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceFleets(software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsPublisher publisher = client.listDeviceFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsPublisher publisher = client.listDeviceFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceFleets(software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listDeviceFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDeviceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDeviceFleets" target="_top">AWS
     *      API Documentation</a>
     */
    public ListDeviceFleetsPublisher listDeviceFleetsPaginator(ListDeviceFleetsRequest listDeviceFleetsRequest) {
        return new ListDeviceFleetsPublisher(this, applyPaginatorUserAgent(listDeviceFleetsRequest));
    }

    /**
     * <p>
     * A list of devices.
     * </p>
     *
     * @param listDevicesRequest
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDevicesRequest, ListDevicesResponse>()
                            .withOperationName("ListDevices").withMarshaller(new ListDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDevicesRequest));
            CompletableFuture<ListDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDevicesPublisher listDevicesPaginator(ListDevicesRequest listDevicesRequest) {
        return new ListDevicesPublisher(this, applyPaginatorUserAgent(listDevicesRequest));
    }

    /**
     * <p>
     * Lists the domains.
     * </p>
     *
     * @param listDomainsRequest
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDomainsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDomainsRequest, ListDomainsResponse>()
                            .withOperationName("ListDomains").withMarshaller(new ListDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDomainsRequest));
            CompletableFuture<ListDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the domains.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDomainsPublisher listDomainsPaginator(ListDomainsRequest listDomainsRequest) {
        return new ListDomainsPublisher(this, applyPaginatorUserAgent(listDomainsRequest));
    }

    /**
     * <p>
     * Lists all edge deployment plans.
     * </p>
     *
     * @param listEdgeDeploymentPlansRequest
     * @return A Java Future containing the result of the ListEdgeDeploymentPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEdgeDeploymentPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgeDeploymentPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEdgeDeploymentPlansResponse> listEdgeDeploymentPlans(
            ListEdgeDeploymentPlansRequest listEdgeDeploymentPlansRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEdgeDeploymentPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEdgeDeploymentPlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEdgeDeploymentPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEdgeDeploymentPlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEdgeDeploymentPlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEdgeDeploymentPlansRequest, ListEdgeDeploymentPlansResponse>()
                            .withOperationName("ListEdgeDeploymentPlans")
                            .withMarshaller(new ListEdgeDeploymentPlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEdgeDeploymentPlansRequest));
            CompletableFuture<ListEdgeDeploymentPlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all edge deployment plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEdgeDeploymentPlans(software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansPublisher publisher = client.listEdgeDeploymentPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansPublisher publisher = client.listEdgeDeploymentPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEdgeDeploymentPlans(software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEdgeDeploymentPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEdgeDeploymentPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgeDeploymentPlans"
     *      target="_top">AWS API Documentation</a>
     */
    public ListEdgeDeploymentPlansPublisher listEdgeDeploymentPlansPaginator(
            ListEdgeDeploymentPlansRequest listEdgeDeploymentPlansRequest) {
        return new ListEdgeDeploymentPlansPublisher(this, applyPaginatorUserAgent(listEdgeDeploymentPlansRequest));
    }

    /**
     * <p>
     * Returns a list of edge packaging jobs.
     * </p>
     *
     * @param listEdgePackagingJobsRequest
     * @return A Java Future containing the result of the ListEdgePackagingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEdgePackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgePackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEdgePackagingJobsResponse> listEdgePackagingJobs(
            ListEdgePackagingJobsRequest listEdgePackagingJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEdgePackagingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEdgePackagingJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEdgePackagingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEdgePackagingJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEdgePackagingJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEdgePackagingJobsRequest, ListEdgePackagingJobsResponse>()
                            .withOperationName("ListEdgePackagingJobs")
                            .withMarshaller(new ListEdgePackagingJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEdgePackagingJobsRequest));
            CompletableFuture<ListEdgePackagingJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of edge packaging jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEdgePackagingJobs(software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsPublisher publisher = client.listEdgePackagingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsPublisher publisher = client.listEdgePackagingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEdgePackagingJobs(software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEdgePackagingJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEdgePackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgePackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListEdgePackagingJobsPublisher listEdgePackagingJobsPaginator(ListEdgePackagingJobsRequest listEdgePackagingJobsRequest) {
        return new ListEdgePackagingJobsPublisher(this, applyPaginatorUserAgent(listEdgePackagingJobsRequest));
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     *
     * @param listEndpointConfigsRequest
     * @return A Java Future containing the result of the ListEndpointConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEndpointConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEndpointConfigsResponse> listEndpointConfigs(
            ListEndpointConfigsRequest listEndpointConfigsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpointConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEndpointConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEndpointConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEndpointConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEndpointConfigsRequest, ListEndpointConfigsResponse>()
                            .withOperationName("ListEndpointConfigs")
                            .withMarshaller(new ListEndpointConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEndpointConfigsRequest));
            CompletableFuture<ListEndpointConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsPublisher publisher = client.listEndpointConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsPublisher publisher = client.listEndpointConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEndpointConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    public ListEndpointConfigsPublisher listEndpointConfigsPaginator(ListEndpointConfigsRequest listEndpointConfigsRequest) {
        return new ListEndpointConfigsPublisher(this, applyPaginatorUserAgent(listEndpointConfigsRequest));
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     *
     * @param listEndpointsRequest
     * @return A Java Future containing the result of the ListEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEndpointsResponse> listEndpoints(ListEndpointsRequest listEndpointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEndpointsRequest, ListEndpointsResponse>()
                            .withOperationName("ListEndpoints")
                            .withMarshaller(new ListEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEndpointsRequest));
            CompletableFuture<ListEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsPublisher publisher = client.listEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsPublisher publisher = client.listEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param listEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    public ListEndpointsPublisher listEndpointsPaginator(ListEndpointsRequest listEndpointsRequest) {
        return new ListEndpointsPublisher(this, applyPaginatorUserAgent(listEndpointsRequest));
    }

    /**
     * <p>
     * Lists all the experiments in your account. The list can be filtered to show only experiments that were created in
     * a specific time range. The list can be sorted by experiment name or creation time.
     * </p>
     *
     * @param listExperimentsRequest
     * @return A Java Future containing the result of the ListExperiments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListExperimentsResponse> listExperiments(ListExperimentsRequest listExperimentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExperimentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExperiments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListExperimentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListExperimentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListExperimentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListExperimentsRequest, ListExperimentsResponse>()
                            .withOperationName("ListExperiments")
                            .withMarshaller(new ListExperimentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listExperimentsRequest));
            CompletableFuture<ListExperimentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the experiments in your account. The list can be filtered to show only experiments that were created in
     * a specific time range. The list can be sorted by experiment name or creation time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiments(software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsPublisher publisher = client.listExperimentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsPublisher publisher = client.listExperimentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest)} operation.</b>
     * </p>
     *
     * @param listExperimentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    public ListExperimentsPublisher listExperimentsPaginator(ListExperimentsRequest listExperimentsRequest) {
        return new ListExperimentsPublisher(this, applyPaginatorUserAgent(listExperimentsRequest));
    }

    /**
     * <p>
     * List <code>FeatureGroup</code>s based on given filter and order.
     * </p>
     *
     * @param listFeatureGroupsRequest
     * @return A Java Future containing the result of the ListFeatureGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListFeatureGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFeatureGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFeatureGroupsResponse> listFeatureGroups(ListFeatureGroupsRequest listFeatureGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFeatureGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFeatureGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFeatureGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFeatureGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFeatureGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFeatureGroupsRequest, ListFeatureGroupsResponse>()
                            .withOperationName("ListFeatureGroups")
                            .withMarshaller(new ListFeatureGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFeatureGroupsRequest));
            CompletableFuture<ListFeatureGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List <code>FeatureGroup</code>s based on given filter and order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFeatureGroups(software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsPublisher publisher = client.listFeatureGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsPublisher publisher = client.listFeatureGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFeatureGroups(software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFeatureGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListFeatureGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFeatureGroups" target="_top">AWS
     *      API Documentation</a>
     */
    public ListFeatureGroupsPublisher listFeatureGroupsPaginator(ListFeatureGroupsRequest listFeatureGroupsRequest) {
        return new ListFeatureGroupsPublisher(this, applyPaginatorUserAgent(listFeatureGroupsRequest));
    }

    /**
     * <p>
     * Returns information about the flow definitions in your account.
     * </p>
     *
     * @param listFlowDefinitionsRequest
     * @return A Java Future containing the result of the ListFlowDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListFlowDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFlowDefinitionsResponse> listFlowDefinitions(
            ListFlowDefinitionsRequest listFlowDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlowDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFlowDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFlowDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFlowDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFlowDefinitionsRequest, ListFlowDefinitionsResponse>()
                            .withOperationName("ListFlowDefinitions")
                            .withMarshaller(new ListFlowDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFlowDefinitionsRequest));
            CompletableFuture<ListFlowDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the flow definitions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlowDefinitions(software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsPublisher publisher = client.listFlowDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsPublisher publisher = client.listFlowDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowDefinitions(software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListFlowDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    public ListFlowDefinitionsPublisher listFlowDefinitionsPaginator(ListFlowDefinitionsRequest listFlowDefinitionsRequest) {
        return new ListFlowDefinitionsPublisher(this, applyPaginatorUserAgent(listFlowDefinitionsRequest));
    }

    /**
     * <p>
     * Returns information about the human task user interfaces in your account.
     * </p>
     *
     * @param listHumanTaskUisRequest
     * @return A Java Future containing the result of the ListHumanTaskUis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListHumanTaskUis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListHumanTaskUisResponse> listHumanTaskUis(ListHumanTaskUisRequest listHumanTaskUisRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHumanTaskUisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHumanTaskUis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListHumanTaskUisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListHumanTaskUisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListHumanTaskUisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListHumanTaskUisRequest, ListHumanTaskUisResponse>()
                            .withOperationName("ListHumanTaskUis")
                            .withMarshaller(new ListHumanTaskUisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listHumanTaskUisRequest));
            CompletableFuture<ListHumanTaskUisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the human task user interfaces in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHumanTaskUis(software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisPublisher publisher = client.listHumanTaskUisPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisPublisher publisher = client.listHumanTaskUisPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanTaskUis(software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest)} operation.</b>
     * </p>
     *
     * @param listHumanTaskUisRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListHumanTaskUis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis" target="_top">AWS
     *      API Documentation</a>
     */
    public ListHumanTaskUisPublisher listHumanTaskUisPaginator(ListHumanTaskUisRequest listHumanTaskUisRequest) {
        return new ListHumanTaskUisPublisher(this, applyPaginatorUserAgent(listHumanTaskUisRequest));
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     * @return A Java Future containing the result of the ListHyperParameterTuningJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListHyperParameterTuningJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListHyperParameterTuningJobsResponse> listHyperParameterTuningJobs(
            ListHyperParameterTuningJobsRequest listHyperParameterTuningJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHyperParameterTuningJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHyperParameterTuningJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListHyperParameterTuningJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListHyperParameterTuningJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListHyperParameterTuningJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListHyperParameterTuningJobsRequest, ListHyperParameterTuningJobsResponse>()
                            .withOperationName("ListHyperParameterTuningJobs")
                            .withMarshaller(new ListHyperParameterTuningJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listHyperParameterTuningJobsRequest));
            CompletableFuture<ListHyperParameterTuningJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsPublisher publisher = client.listHyperParameterTuningJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsPublisher publisher = client.listHyperParameterTuningJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListHyperParameterTuningJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListHyperParameterTuningJobsPublisher listHyperParameterTuningJobsPaginator(
            ListHyperParameterTuningJobsRequest listHyperParameterTuningJobsRequest) {
        return new ListHyperParameterTuningJobsPublisher(this, applyPaginatorUserAgent(listHyperParameterTuningJobsRequest));
    }

    /**
     * <p>
     * Lists the versions of a specified image and their properties. The list can be filtered by creation time or
     * modified time.
     * </p>
     *
     * @param listImageVersionsRequest
     * @return A Java Future containing the result of the ListImageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListImageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImageVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImageVersionsResponse> listImageVersions(ListImageVersionsRequest listImageVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImageVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImageVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImageVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImageVersionsRequest, ListImageVersionsResponse>()
                            .withOperationName("ListImageVersions")
                            .withMarshaller(new ListImageVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImageVersionsRequest));
            CompletableFuture<ListImageVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the versions of a specified image and their properties. The list can be filtered by creation time or
     * modified time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImageVersions(software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsPublisher publisher = client.listImageVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsPublisher publisher = client.listImageVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImageVersions(software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImageVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListImageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImageVersions" target="_top">AWS
     *      API Documentation</a>
     */
    public ListImageVersionsPublisher listImageVersionsPaginator(ListImageVersionsRequest listImageVersionsRequest) {
        return new ListImageVersionsPublisher(this, applyPaginatorUserAgent(listImageVersionsRequest));
    }

    /**
     * <p>
     * Lists the images in your account and their properties. The list can be filtered by creation time or modified
     * time, and whether the image name contains a specified string.
     * </p>
     *
     * @param listImagesRequest
     * @return A Java Future containing the result of the ListImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImagesResponse> listImages(ListImagesRequest listImagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImagesRequest, ListImagesResponse>().withOperationName("ListImages")
                            .withMarshaller(new ListImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImagesRequest));
            CompletableFuture<ListImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the images in your account and their properties. The list can be filtered by creation time or modified
     * time, and whether the image name contains a specified string.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.sagemaker.model.ListImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.sagemaker.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    public ListImagesPublisher listImagesPaginator(ListImagesRequest listImagesRequest) {
        return new ListImagesPublisher(this, applyPaginatorUserAgent(listImagesRequest));
    }

    /**
     * <p>
     * Lists recommendation jobs that satisfy various filters.
     * </p>
     *
     * @param listInferenceRecommendationsJobsRequest
     * @return A Java Future containing the result of the ListInferenceRecommendationsJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListInferenceRecommendationsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListInferenceRecommendationsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInferenceRecommendationsJobsResponse> listInferenceRecommendationsJobs(
            ListInferenceRecommendationsJobsRequest listInferenceRecommendationsJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listInferenceRecommendationsJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInferenceRecommendationsJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInferenceRecommendationsJobsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListInferenceRecommendationsJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInferenceRecommendationsJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInferenceRecommendationsJobsRequest, ListInferenceRecommendationsJobsResponse>()
                            .withOperationName("ListInferenceRecommendationsJobs")
                            .withMarshaller(new ListInferenceRecommendationsJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listInferenceRecommendationsJobsRequest));
            CompletableFuture<ListInferenceRecommendationsJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists recommendation jobs that satisfy various filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceRecommendationsJobs(software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsPublisher publisher = client.listInferenceRecommendationsJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsPublisher publisher = client.listInferenceRecommendationsJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceRecommendationsJobs(software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceRecommendationsJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListInferenceRecommendationsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListInferenceRecommendationsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListInferenceRecommendationsJobsPublisher listInferenceRecommendationsJobsPaginator(
            ListInferenceRecommendationsJobsRequest listInferenceRecommendationsJobsRequest) {
        return new ListInferenceRecommendationsJobsPublisher(this,
                applyPaginatorUserAgent(listInferenceRecommendationsJobsRequest));
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     *
     * @param listLabelingJobsRequest
     * @return A Java Future containing the result of the ListLabelingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListLabelingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLabelingJobsResponse> listLabelingJobs(ListLabelingJobsRequest listLabelingJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLabelingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLabelingJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLabelingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLabelingJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLabelingJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLabelingJobsRequest, ListLabelingJobsResponse>()
                            .withOperationName("ListLabelingJobs")
                            .withMarshaller(new ListLabelingJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLabelingJobsRequest));
            CompletableFuture<ListLabelingJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     * @return A Java Future containing the result of the ListLabelingJobsForWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListLabelingJobsForWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLabelingJobsForWorkteamResponse> listLabelingJobsForWorkteam(
            ListLabelingJobsForWorkteamRequest listLabelingJobsForWorkteamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLabelingJobsForWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLabelingJobsForWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLabelingJobsForWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLabelingJobsForWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLabelingJobsForWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLabelingJobsForWorkteamRequest, ListLabelingJobsForWorkteamResponse>()
                            .withOperationName("ListLabelingJobsForWorkteam")
                            .withMarshaller(new ListLabelingJobsForWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLabelingJobsForWorkteamRequest));
            CompletableFuture<ListLabelingJobsForWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamPublisher publisher = client.listLabelingJobsForWorkteamPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamPublisher publisher = client.listLabelingJobsForWorkteamPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListLabelingJobsForWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    public ListLabelingJobsForWorkteamPublisher listLabelingJobsForWorkteamPaginator(
            ListLabelingJobsForWorkteamRequest listLabelingJobsForWorkteamRequest) {
        return new ListLabelingJobsForWorkteamPublisher(this, applyPaginatorUserAgent(listLabelingJobsForWorkteamRequest));
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsPublisher publisher = client.listLabelingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsPublisher publisher = client.listLabelingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation.</b>
     * </p>
     *
     * @param listLabelingJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListLabelingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS
     *      API Documentation</a>
     */
    public ListLabelingJobsPublisher listLabelingJobsPaginator(ListLabelingJobsRequest listLabelingJobsRequest) {
        return new ListLabelingJobsPublisher(this, applyPaginatorUserAgent(listLabelingJobsRequest));
    }

    /**
     * <p>
     * A list of lineage groups shared with your Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param listLineageGroupsRequest
     * @return A Java Future containing the result of the ListLineageGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListLineageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLineageGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLineageGroupsResponse> listLineageGroups(ListLineageGroupsRequest listLineageGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLineageGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLineageGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLineageGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLineageGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLineageGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLineageGroupsRequest, ListLineageGroupsResponse>()
                            .withOperationName("ListLineageGroups")
                            .withMarshaller(new ListLineageGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLineageGroupsRequest));
            CompletableFuture<ListLineageGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of lineage groups shared with your Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLineageGroups(software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsPublisher publisher = client.listLineageGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsPublisher publisher = client.listLineageGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageGroups(software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLineageGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListLineageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLineageGroups" target="_top">AWS
     *      API Documentation</a>
     */
    public ListLineageGroupsPublisher listLineageGroupsPaginator(ListLineageGroupsRequest listLineageGroupsRequest) {
        return new ListLineageGroupsPublisher(this, applyPaginatorUserAgent(listLineageGroupsRequest));
    }

    /**
     * <p>
     * Lists model bias jobs definitions that satisfy various filters.
     * </p>
     *
     * @param listModelBiasJobDefinitionsRequest
     * @return A Java Future containing the result of the ListModelBiasJobDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelBiasJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelBiasJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelBiasJobDefinitionsResponse> listModelBiasJobDefinitions(
            ListModelBiasJobDefinitionsRequest listModelBiasJobDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelBiasJobDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelBiasJobDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelBiasJobDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListModelBiasJobDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelBiasJobDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelBiasJobDefinitionsRequest, ListModelBiasJobDefinitionsResponse>()
                            .withOperationName("ListModelBiasJobDefinitions")
                            .withMarshaller(new ListModelBiasJobDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelBiasJobDefinitionsRequest));
            CompletableFuture<ListModelBiasJobDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists model bias jobs definitions that satisfy various filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelBiasJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsPublisher publisher = client.listModelBiasJobDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsPublisher publisher = client.listModelBiasJobDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelBiasJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelBiasJobDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelBiasJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelBiasJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListModelBiasJobDefinitionsPublisher listModelBiasJobDefinitionsPaginator(
            ListModelBiasJobDefinitionsRequest listModelBiasJobDefinitionsRequest) {
        return new ListModelBiasJobDefinitionsPublisher(this, applyPaginatorUserAgent(listModelBiasJobDefinitionsRequest));
    }

    /**
     * <p>
     * Lists model explainability job definitions that satisfy various filters.
     * </p>
     *
     * @param listModelExplainabilityJobDefinitionsRequest
     * @return A Java Future containing the result of the ListModelExplainabilityJobDefinitions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelExplainabilityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelExplainabilityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelExplainabilityJobDefinitionsResponse> listModelExplainabilityJobDefinitions(
            ListModelExplainabilityJobDefinitionsRequest listModelExplainabilityJobDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listModelExplainabilityJobDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelExplainabilityJobDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelExplainabilityJobDefinitionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListModelExplainabilityJobDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelExplainabilityJobDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelExplainabilityJobDefinitionsRequest, ListModelExplainabilityJobDefinitionsResponse>()
                            .withOperationName("ListModelExplainabilityJobDefinitions")
                            .withMarshaller(new ListModelExplainabilityJobDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelExplainabilityJobDefinitionsRequest));
            CompletableFuture<ListModelExplainabilityJobDefinitionsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists model explainability job definitions that satisfy various filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelExplainabilityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsPublisher publisher = client.listModelExplainabilityJobDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsPublisher publisher = client.listModelExplainabilityJobDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelExplainabilityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelExplainabilityJobDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelExplainabilityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelExplainabilityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListModelExplainabilityJobDefinitionsPublisher listModelExplainabilityJobDefinitionsPaginator(
            ListModelExplainabilityJobDefinitionsRequest listModelExplainabilityJobDefinitionsRequest) {
        return new ListModelExplainabilityJobDefinitionsPublisher(this,
                applyPaginatorUserAgent(listModelExplainabilityJobDefinitionsRequest));
    }

    /**
     * <p>
     * Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
     * </p>
     *
     * @param listModelMetadataRequest
     * @return A Java Future containing the result of the ListModelMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelMetadataResponse> listModelMetadata(ListModelMetadataRequest listModelMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListModelMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelMetadataRequest, ListModelMetadataResponse>()
                            .withOperationName("ListModelMetadata")
                            .withMarshaller(new ListModelMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelMetadataRequest));
            CompletableFuture<ListModelMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelMetadata(software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataPublisher publisher = client.listModelMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataPublisher publisher = client.listModelMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelMetadata(software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelMetadataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    public ListModelMetadataPublisher listModelMetadataPaginator(ListModelMetadataRequest listModelMetadataRequest) {
        return new ListModelMetadataPublisher(this, applyPaginatorUserAgent(listModelMetadataRequest));
    }

    /**
     * <p>
     * Gets a list of the model groups in your Amazon Web Services account.
     * </p>
     *
     * @param listModelPackageGroupsRequest
     * @return A Java Future containing the result of the ListModelPackageGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelPackageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackageGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelPackageGroupsResponse> listModelPackageGroups(
            ListModelPackageGroupsRequest listModelPackageGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelPackageGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelPackageGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelPackageGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListModelPackageGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelPackageGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelPackageGroupsRequest, ListModelPackageGroupsResponse>()
                            .withOperationName("ListModelPackageGroups")
                            .withMarshaller(new ListModelPackageGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelPackageGroupsRequest));
            CompletableFuture<ListModelPackageGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the model groups in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelPackageGroups(software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsPublisher publisher = client.listModelPackageGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsPublisher publisher = client.listModelPackageGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelPackageGroups(software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelPackageGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelPackageGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackageGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public ListModelPackageGroupsPublisher listModelPackageGroupsPaginator(
            ListModelPackageGroupsRequest listModelPackageGroupsRequest) {
        return new ListModelPackageGroupsPublisher(this, applyPaginatorUserAgent(listModelPackageGroupsRequest));
    }

    /**
     * <p>
     * Lists the model packages that have been created.
     * </p>
     *
     * @param listModelPackagesRequest
     * @return A Java Future containing the result of the ListModelPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelPackagesResponse> listModelPackages(ListModelPackagesRequest listModelPackagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelPackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelPackages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelPackagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListModelPackagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelPackagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelPackagesRequest, ListModelPackagesResponse>()
                            .withOperationName("ListModelPackages")
                            .withMarshaller(new ListModelPackagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelPackagesRequest));
            CompletableFuture<ListModelPackagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the model packages that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelPackages(software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesPublisher publisher = client.listModelPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesPublisher publisher = client.listModelPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelPackages(software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelPackagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages" target="_top">AWS
     *      API Documentation</a>
     */
    public ListModelPackagesPublisher listModelPackagesPaginator(ListModelPackagesRequest listModelPackagesRequest) {
        return new ListModelPackagesPublisher(this, applyPaginatorUserAgent(listModelPackagesRequest));
    }

    /**
     * <p>
     * Gets a list of model quality monitoring job definitions in your account.
     * </p>
     *
     * @param listModelQualityJobDefinitionsRequest
     * @return A Java Future containing the result of the ListModelQualityJobDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelQualityJobDefinitionsResponse> listModelQualityJobDefinitions(
            ListModelQualityJobDefinitionsRequest listModelQualityJobDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listModelQualityJobDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelQualityJobDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelQualityJobDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListModelQualityJobDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelQualityJobDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelQualityJobDefinitionsRequest, ListModelQualityJobDefinitionsResponse>()
                            .withOperationName("ListModelQualityJobDefinitions")
                            .withMarshaller(new ListModelQualityJobDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelQualityJobDefinitionsRequest));
            CompletableFuture<ListModelQualityJobDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of model quality monitoring job definitions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsPublisher publisher = client.listModelQualityJobDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsPublisher publisher = client.listModelQualityJobDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelQualityJobDefinitions(software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelQualityJobDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModelQualityJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelQualityJobDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListModelQualityJobDefinitionsPublisher listModelQualityJobDefinitionsPaginator(
            ListModelQualityJobDefinitionsRequest listModelQualityJobDefinitionsRequest) {
        return new ListModelQualityJobDefinitionsPublisher(this, applyPaginatorUserAgent(listModelQualityJobDefinitionsRequest));
    }

    /**
     * <p>
     * Lists models created with the <code>CreateModel</code> API.
     * </p>
     *
     * @param listModelsRequest
     * @return A Java Future containing the result of the ListModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelsResponse> listModels(ListModelsRequest listModelsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelsRequest, ListModelsResponse>().withOperationName("ListModels")
                            .withMarshaller(new ListModelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelsRequest));
            CompletableFuture<ListModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists models created with the <code>CreateModel</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsPublisher publisher = client.listModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsPublisher publisher = client.listModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)} operation.</b>
     * </p>
     *
     * @param listModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    public ListModelsPublisher listModelsPaginator(ListModelsRequest listModelsRequest) {
        return new ListModelsPublisher(this, applyPaginatorUserAgent(listModelsRequest));
    }

    /**
     * <p>
     * Returns list of all monitoring job executions.
     * </p>
     *
     * @param listMonitoringExecutionsRequest
     * @return A Java Future containing the result of the ListMonitoringExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListMonitoringExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMonitoringExecutionsResponse> listMonitoringExecutions(
            ListMonitoringExecutionsRequest listMonitoringExecutionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMonitoringExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMonitoringExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMonitoringExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMonitoringExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMonitoringExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMonitoringExecutionsRequest, ListMonitoringExecutionsResponse>()
                            .withOperationName("ListMonitoringExecutions")
                            .withMarshaller(new ListMonitoringExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMonitoringExecutionsRequest));
            CompletableFuture<ListMonitoringExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns list of all monitoring job executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitoringExecutions(software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsPublisher publisher = client.listMonitoringExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsPublisher publisher = client.listMonitoringExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoringExecutions(software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitoringExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListMonitoringExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListMonitoringExecutionsPublisher listMonitoringExecutionsPaginator(
            ListMonitoringExecutionsRequest listMonitoringExecutionsRequest) {
        return new ListMonitoringExecutionsPublisher(this, applyPaginatorUserAgent(listMonitoringExecutionsRequest));
    }

    /**
     * <p>
     * Returns list of all monitoring schedules.
     * </p>
     *
     * @param listMonitoringSchedulesRequest
     * @return A Java Future containing the result of the ListMonitoringSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListMonitoringSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMonitoringSchedulesResponse> listMonitoringSchedules(
            ListMonitoringSchedulesRequest listMonitoringSchedulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMonitoringSchedulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMonitoringSchedules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMonitoringSchedulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMonitoringSchedulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMonitoringSchedulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMonitoringSchedulesRequest, ListMonitoringSchedulesResponse>()
                            .withOperationName("ListMonitoringSchedules")
                            .withMarshaller(new ListMonitoringSchedulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMonitoringSchedulesRequest));
            CompletableFuture<ListMonitoringSchedulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns list of all monitoring schedules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitoringSchedules(software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesPublisher publisher = client.listMonitoringSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesPublisher publisher = client.listMonitoringSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoringSchedules(software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitoringSchedulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListMonitoringSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    public ListMonitoringSchedulesPublisher listMonitoringSchedulesPaginator(
            ListMonitoringSchedulesRequest listMonitoringSchedulesRequest) {
        return new ListMonitoringSchedulesPublisher(this, applyPaginatorUserAgent(listMonitoringSchedulesRequest));
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     * @return A Java Future containing the result of the ListNotebookInstanceLifecycleConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNotebookInstanceLifecycleConfigsResponse> listNotebookInstanceLifecycleConfigs(
            ListNotebookInstanceLifecycleConfigsRequest listNotebookInstanceLifecycleConfigsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listNotebookInstanceLifecycleConfigsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookInstanceLifecycleConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNotebookInstanceLifecycleConfigsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListNotebookInstanceLifecycleConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNotebookInstanceLifecycleConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNotebookInstanceLifecycleConfigsRequest, ListNotebookInstanceLifecycleConfigsResponse>()
                            .withOperationName("ListNotebookInstanceLifecycleConfigs")
                            .withMarshaller(new ListNotebookInstanceLifecycleConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listNotebookInstanceLifecycleConfigsRequest));
            CompletableFuture<ListNotebookInstanceLifecycleConfigsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsPublisher publisher = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsPublisher publisher = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListNotebookInstanceLifecycleConfigsPublisher listNotebookInstanceLifecycleConfigsPaginator(
            ListNotebookInstanceLifecycleConfigsRequest listNotebookInstanceLifecycleConfigsRequest) {
        return new ListNotebookInstanceLifecycleConfigsPublisher(this,
                applyPaginatorUserAgent(listNotebookInstanceLifecycleConfigsRequest));
    }

    /**
     * <p>
     * Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
     * </p>
     *
     * @param listNotebookInstancesRequest
     * @return A Java Future containing the result of the ListNotebookInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.ListNotebookInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNotebookInstancesResponse> listNotebookInstances(
            ListNotebookInstancesRequest listNotebookInstancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNotebookInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNotebookInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNotebookInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNotebookInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNotebookInstancesRequest, ListNotebookInstancesResponse>()
                            .withOperationName("ListNotebookInstances")
                            .withMarshaller(new ListNotebookInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listNotebookInstancesRequest));
            CompletableFuture<ListNotebookInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * 