/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the serverless configuration for an endpoint variant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductionVariantServerlessConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductionVariantServerlessConfig.Builder, ProductionVariantServerlessConfig> {
    private static final SdkField<Integer> MEMORY_SIZE_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemorySizeInMB").getter(getter(ProductionVariantServerlessConfig::memorySizeInMB))
            .setter(setter(Builder::memorySizeInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySizeInMB").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrency").getter(getter(ProductionVariantServerlessConfig::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_SIZE_IN_MB_FIELD,
            MAX_CONCURRENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer memorySizeInMB;

    private final Integer maxConcurrency;

    private ProductionVariantServerlessConfig(BuilderImpl builder) {
        this.memorySizeInMB = builder.memorySizeInMB;
        this.maxConcurrency = builder.maxConcurrency;
    }

    /**
     * <p>
     * The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096
     * MB, 5120 MB, or 6144 MB.
     * </p>
     * 
     * @return The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072
     *         MB, 4096 MB, 5120 MB, or 6144 MB.
     */
    public final Integer memorySizeInMB() {
        return memorySizeInMB;
    }

    /**
     * <p>
     * The maximum number of concurrent invocations your serverless endpoint can process.
     * </p>
     * 
     * @return The maximum number of concurrent invocations your serverless endpoint can process.
     */
    public final Integer maxConcurrency() {
        return maxConcurrency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantServerlessConfig)) {
            return false;
        }
        ProductionVariantServerlessConfig other = (ProductionVariantServerlessConfig) obj;
        return Objects.equals(memorySizeInMB(), other.memorySizeInMB())
                && Objects.equals(maxConcurrency(), other.maxConcurrency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductionVariantServerlessConfig").add("MemorySizeInMB", memorySizeInMB())
                .add("MaxConcurrency", maxConcurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemorySizeInMB":
            return Optional.ofNullable(clazz.cast(memorySizeInMB()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantServerlessConfig, T> g) {
        return obj -> g.apply((ProductionVariantServerlessConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductionVariantServerlessConfig> {
        /**
         * <p>
         * The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB,
         * 4096 MB, 5120 MB, or 6144 MB.
         * </p>
         * 
         * @param memorySizeInMB
         *        The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB,
         *        3072 MB, 4096 MB, 5120 MB, or 6144 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInMB(Integer memorySizeInMB);

        /**
         * <p>
         * The maximum number of concurrent invocations your serverless endpoint can process.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of concurrent invocations your serverless endpoint can process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(Integer maxConcurrency);
    }

    static final class BuilderImpl implements Builder {
        private Integer memorySizeInMB;

        private Integer maxConcurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantServerlessConfig model) {
            memorySizeInMB(model.memorySizeInMB);
            maxConcurrency(model.maxConcurrency);
        }

        public final Integer getMemorySizeInMB() {
            return memorySizeInMB;
        }

        public final void setMemorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
        }

        @Override
        public final Builder memorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        public ProductionVariantServerlessConfig build() {
            return new ProductionVariantServerlessConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
