/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the Debugger output tensor collections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CollectionConfiguration.Builder, CollectionConfiguration> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(CollectionConfiguration::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()).build();

    private static final SdkField<Map<String, String>> COLLECTION_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CollectionParameters")
            .getter(getter(CollectionConfiguration::collectionParameters))
            .setter(setter(Builder::collectionParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            COLLECTION_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String collectionName;

    private final Map<String, String> collectionParameters;

    private CollectionConfiguration(BuilderImpl builder) {
        this.collectionName = builder.collectionName;
        this.collectionParameters = builder.collectionParameters;
    }

    /**
     * <p>
     * The name of the tensor collection. The name must be unique relative to other rule configuration names.
     * </p>
     * 
     * @return The name of the tensor collection. The name must be unique relative to other rule configuration names.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollectionParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCollectionParameters() {
        return collectionParameters != null && !(collectionParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>,
     * <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>,
     * <code>"tensor_names"</code>, and <code>"save_histogram"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollectionParameters} method.
     * </p>
     * 
     * @return Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>,
     *         <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>,
     *         <code>"tensor_names"</code>, and <code>"save_histogram"</code>.
     */
    public final Map<String, String> collectionParameters() {
        return collectionParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCollectionParameters() ? collectionParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionConfiguration)) {
            return false;
        }
        CollectionConfiguration other = (CollectionConfiguration) obj;
        return Objects.equals(collectionName(), other.collectionName())
                && hasCollectionParameters() == other.hasCollectionParameters()
                && Objects.equals(collectionParameters(), other.collectionParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollectionConfiguration").add("CollectionName", collectionName())
                .add("CollectionParameters", hasCollectionParameters() ? collectionParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "CollectionParameters":
            return Optional.ofNullable(clazz.cast(collectionParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CollectionConfiguration, T> g) {
        return obj -> g.apply((CollectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollectionConfiguration> {
        /**
         * <p>
         * The name of the tensor collection. The name must be unique relative to other rule configuration names.
         * </p>
         * 
         * @param collectionName
         *        The name of the tensor collection. The name must be unique relative to other rule configuration names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>,
         * <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>,
         * <code>"tensor_names"</code>, and <code>"save_histogram"</code>.
         * </p>
         * 
         * @param collectionParameters
         *        Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>,
         *        <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>,
         *        <code>"tensor_names"</code>, and <code>"save_histogram"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionParameters(Map<String, String> collectionParameters);
    }

    static final class BuilderImpl implements Builder {
        private String collectionName;

        private Map<String, String> collectionParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CollectionConfiguration model) {
            collectionName(model.collectionName);
            collectionParameters(model.collectionParameters);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final Map<String, String> getCollectionParameters() {
            if (collectionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return collectionParameters;
        }

        public final void setCollectionParameters(Map<String, String> collectionParameters) {
            this.collectionParameters = CollectionParametersCopier.copy(collectionParameters);
        }

        @Override
        public final Builder collectionParameters(Map<String, String> collectionParameters) {
            this.collectionParameters = CollectionParametersCopier.copy(collectionParameters);
            return this;
        }

        @Override
        public CollectionConfiguration build() {
            return new CollectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
