/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Currently, the <code>TrafficRoutingConfig</code> API is not supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficRoutingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficRoutingConfig.Builder, TrafficRoutingConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TrafficRoutingConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitIntervalInSeconds").getter(getter(TrafficRoutingConfig::waitIntervalInSeconds))
            .setter(setter(Builder::waitIntervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build())
            .build();

    private static final SdkField<CapacitySize> CANARY_SIZE_FIELD = SdkField.<CapacitySize> builder(MarshallingType.SDK_POJO)
            .memberName("CanarySize").getter(getter(TrafficRoutingConfig::canarySize)).setter(setter(Builder::canarySize))
            .constructor(CapacitySize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanarySize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            WAIT_INTERVAL_IN_SECONDS_FIELD, CANARY_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer waitIntervalInSeconds;

    private final CapacitySize canarySize;

    private TrafficRoutingConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.canarySize = builder.canarySize;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TrafficRoutingConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return
     * @see TrafficRoutingConfigType
     */
    public final TrafficRoutingConfigType type() {
        return TrafficRoutingConfigType.fromValue(type);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TrafficRoutingConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return
     * @see TrafficRoutingConfigType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer waitIntervalInSeconds() {
        return waitIntervalInSeconds;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final CapacitySize canarySize() {
        return canarySize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(canarySize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficRoutingConfig)) {
            return false;
        }
        TrafficRoutingConfig other = (TrafficRoutingConfig) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(waitIntervalInSeconds(), other.waitIntervalInSeconds())
                && Objects.equals(canarySize(), other.canarySize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficRoutingConfig").add("Type", typeAsString())
                .add("WaitIntervalInSeconds", waitIntervalInSeconds()).add("CanarySize", canarySize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "WaitIntervalInSeconds":
            return Optional.ofNullable(clazz.cast(waitIntervalInSeconds()));
        case "CanarySize":
            return Optional.ofNullable(clazz.cast(canarySize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficRoutingConfig, T> g) {
        return obj -> g.apply((TrafficRoutingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficRoutingConfig> {
        /**
         * <p/>
         * 
         * @param type
         * @see TrafficRoutingConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficRoutingConfigType
         */
        Builder type(String type);

        /**
         * <p/>
         * 
         * @param type
         * @see TrafficRoutingConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficRoutingConfigType
         */
        Builder type(TrafficRoutingConfigType type);

        /**
         * <p/>
         * 
         * @param waitIntervalInSeconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitIntervalInSeconds(Integer waitIntervalInSeconds);

        /**
         * <p/>
         * 
         * @param canarySize
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canarySize(CapacitySize canarySize);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link CapacitySize.Builder} avoiding the need to
         * create one manually via {@link CapacitySize#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacitySize.Builder#build()} is called immediately and its
         * result is passed to {@link #canarySize(CapacitySize)}.
         * 
         * @param canarySize
         *        a consumer that will call methods on {@link CapacitySize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canarySize(CapacitySize)
         */
        default Builder canarySize(Consumer<CapacitySize.Builder> canarySize) {
            return canarySize(CapacitySize.builder().applyMutation(canarySize).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer waitIntervalInSeconds;

        private CapacitySize canarySize;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficRoutingConfig model) {
            type(model.type);
            waitIntervalInSeconds(model.waitIntervalInSeconds);
            canarySize(model.canarySize);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(TrafficRoutingConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        @Transient
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final CapacitySize.Builder getCanarySize() {
            return canarySize != null ? canarySize.toBuilder() : null;
        }

        public final void setCanarySize(CapacitySize.BuilderImpl canarySize) {
            this.canarySize = canarySize != null ? canarySize.build() : null;
        }

        @Override
        @Transient
        public final Builder canarySize(CapacitySize canarySize) {
            this.canarySize = canarySize;
            return this;
        }

        @Override
        public TrafficRoutingConfig build() {
            return new TrafficRoutingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
