/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for notifications of inference results for asynchronous inference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncInferenceNotificationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncInferenceNotificationConfig.Builder, AsyncInferenceNotificationConfig> {
    private static final SdkField<String> SUCCESS_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SuccessTopic").getter(getter(AsyncInferenceNotificationConfig::successTopic))
            .setter(setter(Builder::successTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessTopic").build()).build();

    private static final SdkField<String> ERROR_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorTopic").getter(getter(AsyncInferenceNotificationConfig::errorTopic))
            .setter(setter(Builder::errorTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorTopic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_TOPIC_FIELD,
            ERROR_TOPIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String successTopic;

    private final String errorTopic;

    private AsyncInferenceNotificationConfig(BuilderImpl builder) {
        this.successTopic = builder.successTopic;
        this.errorTopic = builder.errorTopic;
    }

    /**
     * <p>
     * Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no
     * notification is sent on success.
     * </p>
     * 
     * @return Amazon SNS topic to post a notification to when inference completes successfully. If no topic is
     *         provided, no notification is sent on success.
     */
    public final String successTopic() {
        return successTopic;
    }

    /**
     * <p>
     * Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is sent
     * on failure.
     * </p>
     * 
     * @return Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification
     *         is sent on failure.
     */
    public final String errorTopic() {
        return errorTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successTopic());
        hashCode = 31 * hashCode + Objects.hashCode(errorTopic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceNotificationConfig)) {
            return false;
        }
        AsyncInferenceNotificationConfig other = (AsyncInferenceNotificationConfig) obj;
        return Objects.equals(successTopic(), other.successTopic()) && Objects.equals(errorTopic(), other.errorTopic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncInferenceNotificationConfig").add("SuccessTopic", successTopic())
                .add("ErrorTopic", errorTopic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessTopic":
            return Optional.ofNullable(clazz.cast(successTopic()));
        case "ErrorTopic":
            return Optional.ofNullable(clazz.cast(errorTopic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceNotificationConfig, T> g) {
        return obj -> g.apply((AsyncInferenceNotificationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncInferenceNotificationConfig> {
        /**
         * <p>
         * Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no
         * notification is sent on success.
         * </p>
         * 
         * @param successTopic
         *        Amazon SNS topic to post a notification to when inference completes successfully. If no topic is
         *        provided, no notification is sent on success.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successTopic(String successTopic);

        /**
         * <p>
         * Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is
         * sent on failure.
         * </p>
         * 
         * @param errorTopic
         *        Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no
         *        notification is sent on failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorTopic(String errorTopic);
    }

    static final class BuilderImpl implements Builder {
        private String successTopic;

        private String errorTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceNotificationConfig model) {
            successTopic(model.successTopic);
            errorTopic(model.errorTopic);
        }

        public final String getSuccessTopic() {
            return successTopic;
        }

        public final void setSuccessTopic(String successTopic) {
            this.successTopic = successTopic;
        }

        @Override
        @Transient
        public final Builder successTopic(String successTopic) {
            this.successTopic = successTopic;
            return this;
        }

        public final String getErrorTopic() {
            return errorTopic;
        }

        public final void setErrorTopic(String errorTopic) {
            this.errorTopic = errorTopic;
        }

        @Override
        @Transient
        public final Builder errorTopic(String errorTopic) {
            this.errorTopic = errorTopic;
            return this;
        }

        @Override
        public AsyncInferenceNotificationConfig build() {
            return new AsyncInferenceNotificationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
