/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a hyperparameter tuning job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTuningJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTuningJobSummary.Builder, HyperParameterTuningJobSummary> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobName")
            .getter(getter(HyperParameterTuningJobSummary::hyperParameterTuningJobName))
            .setter(setter(Builder::hyperParameterTuningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName")
                    .build()).build();

    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobArn")
            .getter(getter(HyperParameterTuningJobSummary::hyperParameterTuningJobArn))
            .setter(setter(Builder::hyperParameterTuningJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobArn").build())
            .build();

    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobStatus")
            .getter(getter(HyperParameterTuningJobSummary::hyperParameterTuningJobStatusAsString))
            .setter(setter(Builder::hyperParameterTuningJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobStatus")
                    .build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strategy").getter(getter(HyperParameterTuningJobSummary::strategyAsString))
            .setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(HyperParameterTuningJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> HYPER_PARAMETER_TUNING_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("HyperParameterTuningEndTime")
            .getter(getter(HyperParameterTuningJobSummary::hyperParameterTuningEndTime))
            .setter(setter(Builder::hyperParameterTuningEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningEndTime")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(HyperParameterTuningJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<TrainingJobStatusCounters> TRAINING_JOB_STATUS_COUNTERS_FIELD = SdkField
            .<TrainingJobStatusCounters> builder(MarshallingType.SDK_POJO).memberName("TrainingJobStatusCounters")
            .getter(getter(HyperParameterTuningJobSummary::trainingJobStatusCounters))
            .setter(setter(Builder::trainingJobStatusCounters)).constructor(TrainingJobStatusCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatusCounters").build())
            .build();

    private static final SdkField<ObjectiveStatusCounters> OBJECTIVE_STATUS_COUNTERS_FIELD = SdkField
            .<ObjectiveStatusCounters> builder(MarshallingType.SDK_POJO).memberName("ObjectiveStatusCounters")
            .getter(getter(HyperParameterTuningJobSummary::objectiveStatusCounters))
            .setter(setter(Builder::objectiveStatusCounters)).constructor(ObjectiveStatusCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatusCounters").build())
            .build();

    private static final SdkField<ResourceLimits> RESOURCE_LIMITS_FIELD = SdkField
            .<ResourceLimits> builder(MarshallingType.SDK_POJO).memberName("ResourceLimits")
            .getter(getter(HyperParameterTuningJobSummary::resourceLimits)).setter(setter(Builder::resourceLimits))
            .constructor(ResourceLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLimits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, HYPER_PARAMETER_TUNING_JOB_ARN_FIELD, HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD,
            STRATEGY_FIELD, CREATION_TIME_FIELD, HYPER_PARAMETER_TUNING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            TRAINING_JOB_STATUS_COUNTERS_FIELD, OBJECTIVE_STATUS_COUNTERS_FIELD, RESOURCE_LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hyperParameterTuningJobName;

    private final String hyperParameterTuningJobArn;

    private final String hyperParameterTuningJobStatus;

    private final String strategy;

    private final Instant creationTime;

    private final Instant hyperParameterTuningEndTime;

    private final Instant lastModifiedTime;

    private final TrainingJobStatusCounters trainingJobStatusCounters;

    private final ObjectiveStatusCounters objectiveStatusCounters;

    private final ResourceLimits resourceLimits;

    private HyperParameterTuningJobSummary(BuilderImpl builder) {
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobArn = builder.hyperParameterTuningJobArn;
        this.hyperParameterTuningJobStatus = builder.hyperParameterTuningJobStatus;
        this.strategy = builder.strategy;
        this.creationTime = builder.creationTime;
        this.hyperParameterTuningEndTime = builder.hyperParameterTuningEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatusCounters = builder.trainingJobStatusCounters;
        this.objectiveStatusCounters = builder.objectiveStatusCounters;
        this.resourceLimits = builder.resourceLimits;
    }

    /**
     * <p>
     * The name of the tuning job.
     * </p>
     * 
     * @return The name of the tuning job.
     */
    public final String hyperParameterTuningJobName() {
        return hyperParameterTuningJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tuning job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tuning job.
     */
    public final String hyperParameterTuningJobArn() {
        return hyperParameterTuningJobArn;
    }

    /**
     * <p>
     * The status of the tuning job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hyperParameterTuningJobStatus} will return {@link HyperParameterTuningJobStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hyperParameterTuningJobStatusAsString}.
     * </p>
     * 
     * @return The status of the tuning job.
     * @see HyperParameterTuningJobStatus
     */
    public final HyperParameterTuningJobStatus hyperParameterTuningJobStatus() {
        return HyperParameterTuningJobStatus.fromValue(hyperParameterTuningJobStatus);
    }

    /**
     * <p>
     * The status of the tuning job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hyperParameterTuningJobStatus} will return {@link HyperParameterTuningJobStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hyperParameterTuningJobStatusAsString}.
     * </p>
     * 
     * @return The status of the tuning job.
     * @see HyperParameterTuningJobStatus
     */
    public final String hyperParameterTuningJobStatusAsString() {
        return hyperParameterTuningJobStatus;
    }

    /**
     * <p>
     * Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each
     * iteration. Currently, the only valid value is Bayesian.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link HyperParameterTuningJobStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #strategyAsString}.
     * </p>
     * 
     * @return Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each
     *         iteration. Currently, the only valid value is Bayesian.
     * @see HyperParameterTuningJobStrategyType
     */
    public final HyperParameterTuningJobStrategyType strategy() {
        return HyperParameterTuningJobStrategyType.fromValue(strategy);
    }

    /**
     * <p>
     * Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each
     * iteration. Currently, the only valid value is Bayesian.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link HyperParameterTuningJobStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #strategyAsString}.
     * </p>
     * 
     * @return Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each
     *         iteration. Currently, the only valid value is Bayesian.
     * @see HyperParameterTuningJobStrategyType
     */
    public final String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * The date and time that the tuning job was created.
     * </p>
     * 
     * @return The date and time that the tuning job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the tuning job ended.
     * </p>
     * 
     * @return The date and time that the tuning job ended.
     */
    public final Instant hyperParameterTuningEndTime() {
        return hyperParameterTuningEndTime;
    }

    /**
     * <p>
     * The date and time that the tuning job was modified.
     * </p>
     * 
     * @return The date and time that the tuning job was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized by status,
     * that this tuning job launched.
     * </p>
     * 
     * @return The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized by
     *         status, that this tuning job launched.
     */
    public final TrainingJobStatusCounters trainingJobStatusCounters() {
        return trainingJobStatusCounters;
    }

    /**
     * <p>
     * The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by objective
     * metric status, that this tuning job launched.
     * </p>
     * 
     * @return The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by
     *         objective metric status, that this tuning job launched.
     */
    public final ObjectiveStatusCounters objectiveStatusCounters() {
        return objectiveStatusCounters;
    }

    /**
     * <p>
     * The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training jobs
     * allowed for this tuning job.
     * </p>
     * 
     * @return The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training
     *         jobs allowed for this tuning job.
     */
    public final ResourceLimits resourceLimits() {
        return resourceLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLimits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobSummary)) {
            return false;
        }
        HyperParameterTuningJobSummary other = (HyperParameterTuningJobSummary) obj;
        return Objects.equals(hyperParameterTuningJobName(), other.hyperParameterTuningJobName())
                && Objects.equals(hyperParameterTuningJobArn(), other.hyperParameterTuningJobArn())
                && Objects.equals(hyperParameterTuningJobStatusAsString(), other.hyperParameterTuningJobStatusAsString())
                && Objects.equals(strategyAsString(), other.strategyAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(hyperParameterTuningEndTime(), other.hyperParameterTuningEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(trainingJobStatusCounters(), other.trainingJobStatusCounters())
                && Objects.equals(objectiveStatusCounters(), other.objectiveStatusCounters())
                && Objects.equals(resourceLimits(), other.resourceLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTuningJobSummary")
                .add("HyperParameterTuningJobName", hyperParameterTuningJobName())
                .add("HyperParameterTuningJobArn", hyperParameterTuningJobArn())
                .add("HyperParameterTuningJobStatus", hyperParameterTuningJobStatusAsString())
                .add("Strategy", strategyAsString()).add("CreationTime", creationTime())
                .add("HyperParameterTuningEndTime", hyperParameterTuningEndTime()).add("LastModifiedTime", lastModifiedTime())
                .add("TrainingJobStatusCounters", trainingJobStatusCounters())
                .add("ObjectiveStatusCounters", objectiveStatusCounters()).add("ResourceLimits", resourceLimits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperParameterTuningJobName":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobName()));
        case "HyperParameterTuningJobArn":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobArn()));
        case "HyperParameterTuningJobStatus":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobStatusAsString()));
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "HyperParameterTuningEndTime":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "TrainingJobStatusCounters":
            return Optional.ofNullable(clazz.cast(trainingJobStatusCounters()));
        case "ObjectiveStatusCounters":
            return Optional.ofNullable(clazz.cast(objectiveStatusCounters()));
        case "ResourceLimits":
            return Optional.ofNullable(clazz.cast(resourceLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobSummary, T> g) {
        return obj -> g.apply((HyperParameterTuningJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTuningJobSummary> {
        /**
         * <p>
         * The name of the tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobName
         *        The name of the tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobName(String hyperParameterTuningJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobArn
         *        The Amazon Resource Name (ARN) of the tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn);

        /**
         * <p>
         * The status of the tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobStatus
         *        The status of the tuning job.
         * @see HyperParameterTuningJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStatus
         */
        Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus);

        /**
         * <p>
         * The status of the tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobStatus
         *        The status of the tuning job.
         * @see HyperParameterTuningJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStatus
         */
        Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus);

        /**
         * <p>
         * Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each
         * iteration. Currently, the only valid value is Bayesian.
         * </p>
         * 
         * @param strategy
         *        Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for
         *        each iteration. Currently, the only valid value is Bayesian.
         * @see HyperParameterTuningJobStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStrategyType
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each
         * iteration. Currently, the only valid value is Bayesian.
         * </p>
         * 
         * @param strategy
         *        Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for
         *        each iteration. Currently, the only valid value is Bayesian.
         * @see HyperParameterTuningJobStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStrategyType
         */
        Builder strategy(HyperParameterTuningJobStrategyType strategy);

        /**
         * <p>
         * The date and time that the tuning job was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the tuning job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the tuning job ended.
         * </p>
         * 
         * @param hyperParameterTuningEndTime
         *        The date and time that the tuning job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime);

        /**
         * <p>
         * The date and time that the tuning job was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the tuning job was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized by
         * status, that this tuning job launched.
         * </p>
         * 
         * @param trainingJobStatusCounters
         *        The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized
         *        by status, that this tuning job launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters);

        /**
         * <p>
         * The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized by
         * status, that this tuning job launched.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingJobStatusCounters.Builder} avoiding the
         * need to create one manually via {@link TrainingJobStatusCounters#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingJobStatusCounters.Builder#build()} is called immediately
         * and its result is passed to {@link #trainingJobStatusCounters(TrainingJobStatusCounters)}.
         * 
         * @param trainingJobStatusCounters
         *        a consumer that will call methods on {@link TrainingJobStatusCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobStatusCounters(TrainingJobStatusCounters)
         */
        default Builder trainingJobStatusCounters(Consumer<TrainingJobStatusCounters.Builder> trainingJobStatusCounters) {
            return trainingJobStatusCounters(TrainingJobStatusCounters.builder().applyMutation(trainingJobStatusCounters).build());
        }

        /**
         * <p>
         * The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by
         * objective metric status, that this tuning job launched.
         * </p>
         * 
         * @param objectiveStatusCounters
         *        The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by
         *        objective metric status, that this tuning job launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters);

        /**
         * <p>
         * The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by
         * objective metric status, that this tuning job launched.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectiveStatusCounters.Builder} avoiding the
         * need to create one manually via {@link ObjectiveStatusCounters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectiveStatusCounters.Builder#build()} is called immediately
         * and its result is passed to {@link #objectiveStatusCounters(ObjectiveStatusCounters)}.
         * 
         * @param objectiveStatusCounters
         *        a consumer that will call methods on {@link ObjectiveStatusCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectiveStatusCounters(ObjectiveStatusCounters)
         */
        default Builder objectiveStatusCounters(Consumer<ObjectiveStatusCounters.Builder> objectiveStatusCounters) {
            return objectiveStatusCounters(ObjectiveStatusCounters.builder().applyMutation(objectiveStatusCounters).build());
        }

        /**
         * <p>
         * The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training
         * jobs allowed for this tuning job.
         * </p>
         * 
         * @param resourceLimits
         *        The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel
         *        training jobs allowed for this tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLimits(ResourceLimits resourceLimits);

        /**
         * <p>
         * The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training
         * jobs allowed for this tuning job.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLimits.Builder} avoiding the need to
         * create one manually via {@link ResourceLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceLimits(ResourceLimits)}.
         * 
         * @param resourceLimits
         *        a consumer that will call methods on {@link ResourceLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceLimits(ResourceLimits)
         */
        default Builder resourceLimits(Consumer<ResourceLimits.Builder> resourceLimits) {
            return resourceLimits(ResourceLimits.builder().applyMutation(resourceLimits).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String hyperParameterTuningJobName;

        private String hyperParameterTuningJobArn;

        private String hyperParameterTuningJobStatus;

        private String strategy;

        private Instant creationTime;

        private Instant hyperParameterTuningEndTime;

        private Instant lastModifiedTime;

        private TrainingJobStatusCounters trainingJobStatusCounters;

        private ObjectiveStatusCounters objectiveStatusCounters;

        private ResourceLimits resourceLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobSummary model) {
            hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            hyperParameterTuningJobArn(model.hyperParameterTuningJobArn);
            hyperParameterTuningJobStatus(model.hyperParameterTuningJobStatus);
            strategy(model.strategy);
            creationTime(model.creationTime);
            hyperParameterTuningEndTime(model.hyperParameterTuningEndTime);
            lastModifiedTime(model.lastModifiedTime);
            trainingJobStatusCounters(model.trainingJobStatusCounters);
            objectiveStatusCounters(model.objectiveStatusCounters);
            resourceLimits(model.resourceLimits);
        }

        public final String getHyperParameterTuningJobName() {
            return hyperParameterTuningJobName;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        @Override
        @Transient
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final String getHyperParameterTuningJobArn() {
            return hyperParameterTuningJobArn;
        }

        public final void setHyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
        }

        @Override
        @Transient
        public final Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
            return this;
        }

        public final String getHyperParameterTuningJobStatus() {
            return hyperParameterTuningJobStatus;
        }

        public final void setHyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
        }

        @Override
        @Transient
        public final Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus(hyperParameterTuningJobStatus == null ? null : hyperParameterTuningJobStatus
                    .toString());
            return this;
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        @Transient
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        @Transient
        public final Builder strategy(HyperParameterTuningJobStrategyType strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getHyperParameterTuningEndTime() {
            return hyperParameterTuningEndTime;
        }

        public final void setHyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
        }

        @Override
        @Transient
        public final Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final TrainingJobStatusCounters.Builder getTrainingJobStatusCounters() {
            return trainingJobStatusCounters != null ? trainingJobStatusCounters.toBuilder() : null;
        }

        public final void setTrainingJobStatusCounters(TrainingJobStatusCounters.BuilderImpl trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters != null ? trainingJobStatusCounters.build() : null;
        }

        @Override
        @Transient
        public final Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters;
            return this;
        }

        public final ObjectiveStatusCounters.Builder getObjectiveStatusCounters() {
            return objectiveStatusCounters != null ? objectiveStatusCounters.toBuilder() : null;
        }

        public final void setObjectiveStatusCounters(ObjectiveStatusCounters.BuilderImpl objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters != null ? objectiveStatusCounters.build() : null;
        }

        @Override
        @Transient
        public final Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters;
            return this;
        }

        public final ResourceLimits.Builder getResourceLimits() {
            return resourceLimits != null ? resourceLimits.toBuilder() : null;
        }

        public final void setResourceLimits(ResourceLimits.BuilderImpl resourceLimits) {
            this.resourceLimits = resourceLimits != null ? resourceLimits.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceLimits(ResourceLimits resourceLimits) {
            this.resourceLimits = resourceLimits;
            return this;
        }

        @Override
        public HyperParameterTuningJobSummary build() {
            return new HyperParameterTuningJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
