/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelQualityJobDefinitionResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeModelQualityJobDefinitionResponse.Builder, DescribeModelQualityJobDefinitionResponse> {
    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionArn").getter(getter(DescribeModelQualityJobDefinitionResponse::jobDefinitionArn))
            .setter(setter(Builder::jobDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionArn").build()).build();

    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionName").getter(getter(DescribeModelQualityJobDefinitionResponse::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeModelQualityJobDefinitionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<ModelQualityBaselineConfig> MODEL_QUALITY_BASELINE_CONFIG_FIELD = SdkField
            .<ModelQualityBaselineConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ModelQualityBaselineConfig")
            .getter(getter(DescribeModelQualityJobDefinitionResponse::modelQualityBaselineConfig))
            .setter(setter(Builder::modelQualityBaselineConfig))
            .constructor(ModelQualityBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityBaselineConfig").build())
            .build();

    private static final SdkField<ModelQualityAppSpecification> MODEL_QUALITY_APP_SPECIFICATION_FIELD = SdkField
            .<ModelQualityAppSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("ModelQualityAppSpecification")
            .getter(getter(DescribeModelQualityJobDefinitionResponse::modelQualityAppSpecification))
            .setter(setter(Builder::modelQualityAppSpecification))
            .constructor(ModelQualityAppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityAppSpecification")
                    .build()).build();

    private static final SdkField<ModelQualityJobInput> MODEL_QUALITY_JOB_INPUT_FIELD = SdkField
            .<ModelQualityJobInput> builder(MarshallingType.SDK_POJO).memberName("ModelQualityJobInput")
            .getter(getter(DescribeModelQualityJobDefinitionResponse::modelQualityJobInput))
            .setter(setter(Builder::modelQualityJobInput)).constructor(ModelQualityJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobInput").build())
            .build();

    private static final SdkField<MonitoringOutputConfig> MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD = SdkField
            .<MonitoringOutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ModelQualityJobOutputConfig")
            .getter(getter(DescribeModelQualityJobDefinitionResponse::modelQualityJobOutputConfig))
            .setter(setter(Builder::modelQualityJobOutputConfig))
            .constructor(MonitoringOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobOutputConfig")
                    .build()).build();

    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField
            .<MonitoringResources> builder(MarshallingType.SDK_POJO).memberName("JobResources")
            .getter(getter(DescribeModelQualityJobDefinitionResponse::jobResources)).setter(setter(Builder::jobResources))
            .constructor(MonitoringResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()).build();

    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<MonitoringNetworkConfig> builder(MarshallingType.SDK_POJO).memberName("NetworkConfig")
            .getter(getter(DescribeModelQualityJobDefinitionResponse::networkConfig)).setter(setter(Builder::networkConfig))
            .constructor(MonitoringNetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeModelQualityJobDefinitionResponse::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<MonitoringStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(DescribeModelQualityJobDefinitionResponse::stoppingCondition))
            .setter(setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_ARN_FIELD,
            JOB_DEFINITION_NAME_FIELD, CREATION_TIME_FIELD, MODEL_QUALITY_BASELINE_CONFIG_FIELD,
            MODEL_QUALITY_APP_SPECIFICATION_FIELD, MODEL_QUALITY_JOB_INPUT_FIELD, MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD,
            JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD));

    private final String jobDefinitionArn;

    private final String jobDefinitionName;

    private final Instant creationTime;

    private final ModelQualityBaselineConfig modelQualityBaselineConfig;

    private final ModelQualityAppSpecification modelQualityAppSpecification;

    private final ModelQualityJobInput modelQualityJobInput;

    private final MonitoringOutputConfig modelQualityJobOutputConfig;

    private final MonitoringResources jobResources;

    private final MonitoringNetworkConfig networkConfig;

    private final String roleArn;

    private final MonitoringStoppingCondition stoppingCondition;

    private DescribeModelQualityJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.creationTime = builder.creationTime;
        this.modelQualityBaselineConfig = builder.modelQualityBaselineConfig;
        this.modelQualityAppSpecification = builder.modelQualityAppSpecification;
        this.modelQualityJobInput = builder.modelQualityJobInput;
        this.modelQualityJobOutputConfig = builder.modelQualityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model quality job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model quality job.
     */
    public final String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    /**
     * <p>
     * The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the
     * Amazon Web Services account.
     * </p>
     * 
     * @return The name of the quality job definition. The name must be unique within an Amazon Web Services Region in
     *         the Amazon Web Services account.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The time at which the model quality job was created.
     * </p>
     * 
     * @return The time at which the model quality job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The baseline configuration for a model quality job.
     * </p>
     * 
     * @return The baseline configuration for a model quality job.
     */
    public final ModelQualityBaselineConfig modelQualityBaselineConfig() {
        return modelQualityBaselineConfig;
    }

    /**
     * <p>
     * Configures the model quality job to run a specified Docker container image.
     * </p>
     * 
     * @return Configures the model quality job to run a specified Docker container image.
     */
    public final ModelQualityAppSpecification modelQualityAppSpecification() {
        return modelQualityAppSpecification;
    }

    /**
     * <p>
     * Inputs for the model quality job.
     * </p>
     * 
     * @return Inputs for the model quality job.
     */
    public final ModelQualityJobInput modelQualityJobInput() {
        return modelQualityJobInput;
    }

    /**
     * Returns the value of the ModelQualityJobOutputConfig property for this object.
     * 
     * @return The value of the ModelQualityJobOutputConfig property for this object.
     */
    public final MonitoringOutputConfig modelQualityJobOutputConfig() {
        return modelQualityJobOutputConfig;
    }

    /**
     * Returns the value of the JobResources property for this object.
     * 
     * @return The value of the JobResources property for this object.
     */
    public final MonitoringResources jobResources() {
        return jobResources;
    }

    /**
     * <p>
     * Networking options for a model quality job.
     * </p>
     * 
     * @return Networking options for a model quality job.
     */
    public final MonitoringNetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final MonitoringStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelQualityJobDefinitionResponse)) {
            return false;
        }
        DescribeModelQualityJobDefinitionResponse other = (DescribeModelQualityJobDefinitionResponse) obj;
        return Objects.equals(jobDefinitionArn(), other.jobDefinitionArn())
                && Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modelQualityBaselineConfig(), other.modelQualityBaselineConfig())
                && Objects.equals(modelQualityAppSpecification(), other.modelQualityAppSpecification())
                && Objects.equals(modelQualityJobInput(), other.modelQualityJobInput())
                && Objects.equals(modelQualityJobOutputConfig(), other.modelQualityJobOutputConfig())
                && Objects.equals(jobResources(), other.jobResources()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stoppingCondition(), other.stoppingCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelQualityJobDefinitionResponse").add("JobDefinitionArn", jobDefinitionArn())
                .add("JobDefinitionName", jobDefinitionName()).add("CreationTime", creationTime())
                .add("ModelQualityBaselineConfig", modelQualityBaselineConfig())
                .add("ModelQualityAppSpecification", modelQualityAppSpecification())
                .add("ModelQualityJobInput", modelQualityJobInput())
                .add("ModelQualityJobOutputConfig", modelQualityJobOutputConfig()).add("JobResources", jobResources())
                .add("NetworkConfig", networkConfig()).add("RoleArn", roleArn()).add("StoppingCondition", stoppingCondition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionArn":
            return Optional.ofNullable(clazz.cast(jobDefinitionArn()));
        case "JobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModelQualityBaselineConfig":
            return Optional.ofNullable(clazz.cast(modelQualityBaselineConfig()));
        case "ModelQualityAppSpecification":
            return Optional.ofNullable(clazz.cast(modelQualityAppSpecification()));
        case "ModelQualityJobInput":
            return Optional.ofNullable(clazz.cast(modelQualityJobInput()));
        case "ModelQualityJobOutputConfig":
            return Optional.ofNullable(clazz.cast(modelQualityJobOutputConfig()));
        case "JobResources":
            return Optional.ofNullable(clazz.cast(jobResources()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelQualityJobDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeModelQualityJobDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelQualityJobDefinitionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model quality job.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) of the model quality job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);

        /**
         * <p>
         * The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the
         * Amazon Web Services account.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the quality job definition. The name must be unique within an Amazon Web Services Region
         *        in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The time at which the model quality job was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the model quality job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The baseline configuration for a model quality job.
         * </p>
         * 
         * @param modelQualityBaselineConfig
         *        The baseline configuration for a model quality job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityBaselineConfig(ModelQualityBaselineConfig modelQualityBaselineConfig);

        /**
         * <p>
         * The baseline configuration for a model quality job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelQualityBaselineConfig.Builder} avoiding the
         * need to create one manually via {@link ModelQualityBaselineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelQualityBaselineConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #modelQualityBaselineConfig(ModelQualityBaselineConfig)}.
         * 
         * @param modelQualityBaselineConfig
         *        a consumer that will call methods on {@link ModelQualityBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityBaselineConfig(ModelQualityBaselineConfig)
         */
        default Builder modelQualityBaselineConfig(Consumer<ModelQualityBaselineConfig.Builder> modelQualityBaselineConfig) {
            return modelQualityBaselineConfig(ModelQualityBaselineConfig.builder().applyMutation(modelQualityBaselineConfig)
                    .build());
        }

        /**
         * <p>
         * Configures the model quality job to run a specified Docker container image.
         * </p>
         * 
         * @param modelQualityAppSpecification
         *        Configures the model quality job to run a specified Docker container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityAppSpecification(ModelQualityAppSpecification modelQualityAppSpecification);

        /**
         * <p>
         * Configures the model quality job to run a specified Docker container image.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelQualityAppSpecification.Builder} avoiding
         * the need to create one manually via {@link ModelQualityAppSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelQualityAppSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #modelQualityAppSpecification(ModelQualityAppSpecification)}.
         * 
         * @param modelQualityAppSpecification
         *        a consumer that will call methods on {@link ModelQualityAppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityAppSpecification(ModelQualityAppSpecification)
         */
        default Builder modelQualityAppSpecification(Consumer<ModelQualityAppSpecification.Builder> modelQualityAppSpecification) {
            return modelQualityAppSpecification(ModelQualityAppSpecification.builder()
                    .applyMutation(modelQualityAppSpecification).build());
        }

        /**
         * <p>
         * Inputs for the model quality job.
         * </p>
         * 
         * @param modelQualityJobInput
         *        Inputs for the model quality job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityJobInput(ModelQualityJobInput modelQualityJobInput);

        /**
         * <p>
         * Inputs for the model quality job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelQualityJobInput.Builder} avoiding the need
         * to create one manually via {@link ModelQualityJobInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelQualityJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #modelQualityJobInput(ModelQualityJobInput)}.
         * 
         * @param modelQualityJobInput
         *        a consumer that will call methods on {@link ModelQualityJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityJobInput(ModelQualityJobInput)
         */
        default Builder modelQualityJobInput(Consumer<ModelQualityJobInput.Builder> modelQualityJobInput) {
            return modelQualityJobInput(ModelQualityJobInput.builder().applyMutation(modelQualityJobInput).build());
        }

        /**
         * Sets the value of the ModelQualityJobOutputConfig property for this object.
         *
         * @param modelQualityJobOutputConfig
         *        The new value for the ModelQualityJobOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityJobOutputConfig(MonitoringOutputConfig modelQualityJobOutputConfig);

        /**
         * Sets the value of the ModelQualityJobOutputConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringOutputConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #modelQualityJobOutputConfig(MonitoringOutputConfig)}.
         * 
         * @param modelQualityJobOutputConfig
         *        a consumer that will call methods on {@link MonitoringOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityJobOutputConfig(MonitoringOutputConfig)
         */
        default Builder modelQualityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelQualityJobOutputConfig) {
            return modelQualityJobOutputConfig(MonitoringOutputConfig.builder().applyMutation(modelQualityJobOutputConfig)
                    .build());
        }

        /**
         * Sets the value of the JobResources property for this object.
         *
         * @param jobResources
         *        The new value for the JobResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobResources(MonitoringResources jobResources);

        /**
         * Sets the value of the JobResources property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringResources.Builder} avoiding the need
         * to create one manually via {@link MonitoringResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringResources.Builder#build()} is called immediately and
         * its result is passed to {@link #jobResources(MonitoringResources)}.
         * 
         * @param jobResources
         *        a consumer that will call methods on {@link MonitoringResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobResources(MonitoringResources)
         */
        default Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return jobResources(MonitoringResources.builder().applyMutation(jobResources).build());
        }

        /**
         * <p>
         * Networking options for a model quality job.
         * </p>
         * 
         * @param networkConfig
         *        Networking options for a model quality job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(MonitoringNetworkConfig networkConfig);

        /**
         * <p>
         * Networking options for a model quality job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringNetworkConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringNetworkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringNetworkConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConfig(MonitoringNetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link MonitoringNetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(MonitoringNetworkConfig)
         */
        default Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return networkConfig(MonitoringNetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link MonitoringStoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(MonitoringStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link MonitoringStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(MonitoringStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(MonitoringStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String jobDefinitionArn;

        private String jobDefinitionName;

        private Instant creationTime;

        private ModelQualityBaselineConfig modelQualityBaselineConfig;

        private ModelQualityAppSpecification modelQualityAppSpecification;

        private ModelQualityJobInput modelQualityJobInput;

        private MonitoringOutputConfig modelQualityJobOutputConfig;

        private MonitoringResources jobResources;

        private MonitoringNetworkConfig networkConfig;

        private String roleArn;

        private MonitoringStoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelQualityJobDefinitionResponse model) {
            super(model);
            jobDefinitionArn(model.jobDefinitionArn);
            jobDefinitionName(model.jobDefinitionName);
            creationTime(model.creationTime);
            modelQualityBaselineConfig(model.modelQualityBaselineConfig);
            modelQualityAppSpecification(model.modelQualityAppSpecification);
            modelQualityJobInput(model.modelQualityJobInput);
            modelQualityJobOutputConfig(model.modelQualityJobOutputConfig);
            jobResources(model.jobResources);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final ModelQualityBaselineConfig.Builder getModelQualityBaselineConfig() {
            return modelQualityBaselineConfig != null ? modelQualityBaselineConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityBaselineConfig(ModelQualityBaselineConfig modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig;
            return this;
        }

        public final void setModelQualityBaselineConfig(ModelQualityBaselineConfig.BuilderImpl modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig != null ? modelQualityBaselineConfig.build() : null;
        }

        public final ModelQualityAppSpecification.Builder getModelQualityAppSpecification() {
            return modelQualityAppSpecification != null ? modelQualityAppSpecification.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityAppSpecification(ModelQualityAppSpecification modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification;
            return this;
        }

        public final void setModelQualityAppSpecification(ModelQualityAppSpecification.BuilderImpl modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification != null ? modelQualityAppSpecification.build()
                    : null;
        }

        public final ModelQualityJobInput.Builder getModelQualityJobInput() {
            return modelQualityJobInput != null ? modelQualityJobInput.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityJobInput(ModelQualityJobInput modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput;
            return this;
        }

        public final void setModelQualityJobInput(ModelQualityJobInput.BuilderImpl modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput != null ? modelQualityJobInput.build() : null;
        }

        public final MonitoringOutputConfig.Builder getModelQualityJobOutputConfig() {
            return modelQualityJobOutputConfig != null ? modelQualityJobOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityJobOutputConfig(MonitoringOutputConfig modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig;
            return this;
        }

        public final void setModelQualityJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig != null ? modelQualityJobOutputConfig.build() : null;
        }

        public final MonitoringResources.Builder getJobResources() {
            return jobResources != null ? jobResources.toBuilder() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public DescribeModelQualityJobDefinitionResponse build() {
            return new DescribeModelQualityJobDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
