/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceFleetsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListDeviceFleetsResponse.Builder, ListDeviceFleetsResponse> {
    private static final SdkField<List<DeviceFleetSummary>> DEVICE_FLEET_SUMMARIES_FIELD = SdkField
            .<List<DeviceFleetSummary>> builder(MarshallingType.LIST)
            .memberName("DeviceFleetSummaries")
            .getter(getter(ListDeviceFleetsResponse::deviceFleetSummaries))
            .setter(setter(Builder::deviceFleetSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceFleetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceFleetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDeviceFleetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DeviceFleetSummary> deviceFleetSummaries;

    private final String nextToken;

    private ListDeviceFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceFleetSummaries = builder.deviceFleetSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceFleetSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceFleetSummaries() {
        return deviceFleetSummaries != null && !(deviceFleetSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary of the device fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceFleetSummaries} method.
     * </p>
     * 
     * @return Summary of the device fleet.
     */
    public final List<DeviceFleetSummary> deviceFleetSummaries() {
        return deviceFleetSummaries;
    }

    /**
     * <p>
     * The response from the last list when returning a list large enough to need tokening.
     * </p>
     * 
     * @return The response from the last list when returning a list large enough to need tokening.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceFleetSummaries() ? deviceFleetSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceFleetsResponse)) {
            return false;
        }
        ListDeviceFleetsResponse other = (ListDeviceFleetsResponse) obj;
        return hasDeviceFleetSummaries() == other.hasDeviceFleetSummaries()
                && Objects.equals(deviceFleetSummaries(), other.deviceFleetSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeviceFleetsResponse")
                .add("DeviceFleetSummaries", hasDeviceFleetSummaries() ? deviceFleetSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceFleetSummaries":
            return Optional.ofNullable(clazz.cast(deviceFleetSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceFleetsResponse, T> g) {
        return obj -> g.apply((ListDeviceFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDeviceFleetsResponse> {
        /**
         * <p>
         * Summary of the device fleet.
         * </p>
         * 
         * @param deviceFleetSummaries
         *        Summary of the device fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetSummaries(Collection<DeviceFleetSummary> deviceFleetSummaries);

        /**
         * <p>
         * Summary of the device fleet.
         * </p>
         * 
         * @param deviceFleetSummaries
         *        Summary of the device fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetSummaries(DeviceFleetSummary... deviceFleetSummaries);

        /**
         * <p>
         * Summary of the device fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceFleetSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DeviceFleetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceFleetSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceFleetSummaries(List<DeviceFleetSummary>)}.
         * 
         * @param deviceFleetSummaries
         *        a consumer that will call methods on {@link List<DeviceFleetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceFleetSummaries(List<DeviceFleetSummary>)
         */
        Builder deviceFleetSummaries(Consumer<DeviceFleetSummary.Builder>... deviceFleetSummaries);

        /**
         * <p>
         * The response from the last list when returning a list large enough to need tokening.
         * </p>
         * 
         * @param nextToken
         *        The response from the last list when returning a list large enough to need tokening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<DeviceFleetSummary> deviceFleetSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceFleetsResponse model) {
            super(model);
            deviceFleetSummaries(model.deviceFleetSummaries);
            nextToken(model.nextToken);
        }

        public final List<DeviceFleetSummary.Builder> getDeviceFleetSummaries() {
            List<DeviceFleetSummary.Builder> result = DeviceFleetSummariesCopier.copyToBuilder(this.deviceFleetSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceFleetSummaries(Collection<DeviceFleetSummary.BuilderImpl> deviceFleetSummaries) {
            this.deviceFleetSummaries = DeviceFleetSummariesCopier.copyFromBuilder(deviceFleetSummaries);
        }

        @Override
        @Transient
        public final Builder deviceFleetSummaries(Collection<DeviceFleetSummary> deviceFleetSummaries) {
            this.deviceFleetSummaries = DeviceFleetSummariesCopier.copy(deviceFleetSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceFleetSummaries(DeviceFleetSummary... deviceFleetSummaries) {
            deviceFleetSummaries(Arrays.asList(deviceFleetSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceFleetSummaries(Consumer<DeviceFleetSummary.Builder>... deviceFleetSummaries) {
            deviceFleetSummaries(Stream.of(deviceFleetSummaries).map(c -> DeviceFleetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeviceFleetsResponse build() {
            return new ListDeviceFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
