/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDeployConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDeployConfig.Builder, ModelDeployConfig> {
    private static final SdkField<Boolean> AUTO_GENERATE_ENDPOINT_NAME_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AutoGenerateEndpointName")
            .getter(getter(ModelDeployConfig::autoGenerateEndpointName)).setter(setter(Builder::autoGenerateEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGenerateEndpointName").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(ModelDeployConfig::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_GENERATE_ENDPOINT_NAME_FIELD, ENDPOINT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean autoGenerateEndpointName;

    private final String endpointName;

    private ModelDeployConfig(BuilderImpl builder) {
        this.autoGenerateEndpointName = builder.autoGenerateEndpointName;
        this.endpointName = builder.endpointName;
    }

    /**
     * <p>
     * Set to <code>True</code> to automatically generate an endpoint name for a one-click Autopilot model deployment;
     * set to <code>False</code> otherwise. The default value is <code>False</code>.
     * </p>
     * <note>
     * <p>
     * If you set <code>AutoGenerateEndpointName</code> to <code>True</code>, do not specify the
     * <code>EndpointName</code>; otherwise a 400 error is thrown.
     * </p>
     * </note>
     * 
     * @return Set to <code>True</code> to automatically generate an endpoint name for a one-click Autopilot model
     *         deployment; set to <code>False</code> otherwise. The default value is <code>False</code>.</p> <note>
     *         <p>
     *         If you set <code>AutoGenerateEndpointName</code> to <code>True</code>, do not specify the
     *         <code>EndpointName</code>; otherwise a 400 error is thrown.
     *         </p>
     */
    public final Boolean autoGenerateEndpointName() {
        return autoGenerateEndpointName;
    }

    /**
     * <p>
     * Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not
     * generated automatically.
     * </p>
     * <note>
     * <p>
     * Specify the <code>EndpointName</code> if and only if you set <code>AutoGenerateEndpointName</code> to
     * <code>False</code>; otherwise a 400 error is thrown.
     * </p>
     * </note>
     * 
     * @return Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not
     *         generated automatically.</p> <note>
     *         <p>
     *         Specify the <code>EndpointName</code> if and only if you set <code>AutoGenerateEndpointName</code> to
     *         <code>False</code>; otherwise a 400 error is thrown.
     *         </p>
     */
    public final String endpointName() {
        return endpointName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoGenerateEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDeployConfig)) {
            return false;
        }
        ModelDeployConfig other = (ModelDeployConfig) obj;
        return Objects.equals(autoGenerateEndpointName(), other.autoGenerateEndpointName())
                && Objects.equals(endpointName(), other.endpointName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDeployConfig").add("AutoGenerateEndpointName", autoGenerateEndpointName())
                .add("EndpointName", endpointName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoGenerateEndpointName":
            return Optional.ofNullable(clazz.cast(autoGenerateEndpointName()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDeployConfig, T> g) {
        return obj -> g.apply((ModelDeployConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDeployConfig> {
        /**
         * <p>
         * Set to <code>True</code> to automatically generate an endpoint name for a one-click Autopilot model
         * deployment; set to <code>False</code> otherwise. The default value is <code>False</code>.
         * </p>
         * <note>
         * <p>
         * If you set <code>AutoGenerateEndpointName</code> to <code>True</code>, do not specify the
         * <code>EndpointName</code>; otherwise a 400 error is thrown.
         * </p>
         * </note>
         * 
         * @param autoGenerateEndpointName
         *        Set to <code>True</code> to automatically generate an endpoint name for a one-click Autopilot model
         *        deployment; set to <code>False</code> otherwise. The default value is <code>False</code>.</p> <note>
         *        <p>
         *        If you set <code>AutoGenerateEndpointName</code> to <code>True</code>, do not specify the
         *        <code>EndpointName</code>; otherwise a 400 error is thrown.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGenerateEndpointName(Boolean autoGenerateEndpointName);

        /**
         * <p>
         * Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not
         * generated automatically.
         * </p>
         * <note>
         * <p>
         * Specify the <code>EndpointName</code> if and only if you set <code>AutoGenerateEndpointName</code> to
         * <code>False</code>; otherwise a 400 error is thrown.
         * </p>
         * </note>
         * 
         * @param endpointName
         *        Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is
         *        not generated automatically.</p> <note>
         *        <p>
         *        Specify the <code>EndpointName</code> if and only if you set <code>AutoGenerateEndpointName</code> to
         *        <code>False</code>; otherwise a 400 error is thrown.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoGenerateEndpointName;

        private String endpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDeployConfig model) {
            autoGenerateEndpointName(model.autoGenerateEndpointName);
            endpointName(model.endpointName);
        }

        public final Boolean getAutoGenerateEndpointName() {
            return autoGenerateEndpointName;
        }

        public final void setAutoGenerateEndpointName(Boolean autoGenerateEndpointName) {
            this.autoGenerateEndpointName = autoGenerateEndpointName;
        }

        @Override
        @Transient
        public final Builder autoGenerateEndpointName(Boolean autoGenerateEndpointName) {
            this.autoGenerateEndpointName = autoGenerateEndpointName;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        @Override
        public ModelDeployConfig build() {
            return new ModelDeployConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
