/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitoringSchedulesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListMonitoringSchedulesResponse.Builder, ListMonitoringSchedulesResponse> {
    private static final SdkField<List<MonitoringScheduleSummary>> MONITORING_SCHEDULE_SUMMARIES_FIELD = SdkField
            .<List<MonitoringScheduleSummary>> builder(MarshallingType.LIST)
            .memberName("MonitoringScheduleSummaries")
            .getter(getter(ListMonitoringSchedulesResponse::monitoringScheduleSummaries))
            .setter(setter(Builder::monitoringScheduleSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitoringScheduleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitoringScheduleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMonitoringSchedulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<MonitoringScheduleSummary> monitoringScheduleSummaries;

    private final String nextToken;

    private ListMonitoringSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleSummaries = builder.monitoringScheduleSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitoringScheduleSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMonitoringScheduleSummaries() {
        return monitoringScheduleSummaries != null && !(monitoringScheduleSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON array in which each element is a summary for a monitoring schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitoringScheduleSummaries} method.
     * </p>
     * 
     * @return A JSON array in which each element is a summary for a monitoring schedule.
     */
    public final List<MonitoringScheduleSummary> monitoringScheduleSummaries() {
        return monitoringScheduleSummaries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in
     * the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use
     *         it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitoringScheduleSummaries() ? monitoringScheduleSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringSchedulesResponse)) {
            return false;
        }
        ListMonitoringSchedulesResponse other = (ListMonitoringSchedulesResponse) obj;
        return hasMonitoringScheduleSummaries() == other.hasMonitoringScheduleSummaries()
                && Objects.equals(monitoringScheduleSummaries(), other.monitoringScheduleSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMonitoringSchedulesResponse")
                .add("MonitoringScheduleSummaries", hasMonitoringScheduleSummaries() ? monitoringScheduleSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleSummaries":
            return Optional.ofNullable(clazz.cast(monitoringScheduleSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringSchedulesResponse, T> g) {
        return obj -> g.apply((ListMonitoringSchedulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMonitoringSchedulesResponse> {
        /**
         * <p>
         * A JSON array in which each element is a summary for a monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleSummaries
         *        A JSON array in which each element is a summary for a monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleSummaries(Collection<MonitoringScheduleSummary> monitoringScheduleSummaries);

        /**
         * <p>
         * A JSON array in which each element is a summary for a monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleSummaries
         *        A JSON array in which each element is a summary for a monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleSummaries(MonitoringScheduleSummary... monitoringScheduleSummaries);

        /**
         * <p>
         * A JSON array in which each element is a summary for a monitoring schedule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MonitoringScheduleSummary>.Builder}
         * avoiding the need to create one manually via {@link List<MonitoringScheduleSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MonitoringScheduleSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoringScheduleSummaries(List<MonitoringScheduleSummary>)}
         * .
         * 
         * @param monitoringScheduleSummaries
         *        a consumer that will call methods on {@link List<MonitoringScheduleSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringScheduleSummaries(List<MonitoringScheduleSummary>)
         */
        Builder monitoringScheduleSummaries(Consumer<MonitoringScheduleSummary.Builder>... monitoringScheduleSummaries);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it
         * in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs,
         *        use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<MonitoringScheduleSummary> monitoringScheduleSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringSchedulesResponse model) {
            super(model);
            monitoringScheduleSummaries(model.monitoringScheduleSummaries);
            nextToken(model.nextToken);
        }

        public final List<MonitoringScheduleSummary.Builder> getMonitoringScheduleSummaries() {
            List<MonitoringScheduleSummary.Builder> result = MonitoringScheduleSummaryListCopier
                    .copyToBuilder(this.monitoringScheduleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringScheduleSummaries(
                Collection<MonitoringScheduleSummary.BuilderImpl> monitoringScheduleSummaries) {
            this.monitoringScheduleSummaries = MonitoringScheduleSummaryListCopier.copyFromBuilder(monitoringScheduleSummaries);
        }

        @Override
        @Transient
        public final Builder monitoringScheduleSummaries(Collection<MonitoringScheduleSummary> monitoringScheduleSummaries) {
            this.monitoringScheduleSummaries = MonitoringScheduleSummaryListCopier.copy(monitoringScheduleSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringScheduleSummaries(MonitoringScheduleSummary... monitoringScheduleSummaries) {
            monitoringScheduleSummaries(Arrays.asList(monitoringScheduleSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringScheduleSummaries(
                Consumer<MonitoringScheduleSummary.Builder>... monitoringScheduleSummaries) {
            monitoringScheduleSummaries(Stream.of(monitoringScheduleSummaries)
                    .map(c -> MonitoringScheduleSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitoringSchedulesResponse build() {
            return new ListMonitoringSchedulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
