/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStudioLifecycleConfigsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListStudioLifecycleConfigsResponse.Builder, ListStudioLifecycleConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStudioLifecycleConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<StudioLifecycleConfigDetails>> STUDIO_LIFECYCLE_CONFIGS_FIELD = SdkField
            .<List<StudioLifecycleConfigDetails>> builder(MarshallingType.LIST)
            .memberName("StudioLifecycleConfigs")
            .getter(getter(ListStudioLifecycleConfigsResponse::studioLifecycleConfigs))
            .setter(setter(Builder::studioLifecycleConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StudioLifecycleConfigDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(StudioLifecycleConfigDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STUDIO_LIFECYCLE_CONFIGS_FIELD));

    private final String nextToken;

    private final List<StudioLifecycleConfigDetails> studioLifecycleConfigs;

    private ListStudioLifecycleConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.studioLifecycleConfigs = builder.studioLifecycleConfigs;
    }

    /**
     * <p>
     * A token for getting the next set of actions, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of actions, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StudioLifecycleConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStudioLifecycleConfigs() {
        return studioLifecycleConfigs != null && !(studioLifecycleConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Lifecycle Configurations and their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStudioLifecycleConfigs} method.
     * </p>
     * 
     * @return A list of Lifecycle Configurations and their properties.
     */
    public final List<StudioLifecycleConfigDetails> studioLifecycleConfigs() {
        return studioLifecycleConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStudioLifecycleConfigs() ? studioLifecycleConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioLifecycleConfigsResponse)) {
            return false;
        }
        ListStudioLifecycleConfigsResponse other = (ListStudioLifecycleConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStudioLifecycleConfigs() == other.hasStudioLifecycleConfigs()
                && Objects.equals(studioLifecycleConfigs(), other.studioLifecycleConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStudioLifecycleConfigsResponse").add("NextToken", nextToken())
                .add("StudioLifecycleConfigs", hasStudioLifecycleConfigs() ? studioLifecycleConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StudioLifecycleConfigs":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudioLifecycleConfigsResponse, T> g) {
        return obj -> g.apply((ListStudioLifecycleConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStudioLifecycleConfigsResponse> {
        /**
         * <p>
         * A token for getting the next set of actions, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of actions, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of Lifecycle Configurations and their properties.
         * </p>
         * 
         * @param studioLifecycleConfigs
         *        A list of Lifecycle Configurations and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigs(Collection<StudioLifecycleConfigDetails> studioLifecycleConfigs);

        /**
         * <p>
         * A list of Lifecycle Configurations and their properties.
         * </p>
         * 
         * @param studioLifecycleConfigs
         *        A list of Lifecycle Configurations and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigs(StudioLifecycleConfigDetails... studioLifecycleConfigs);

        /**
         * <p>
         * A list of Lifecycle Configurations and their properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StudioLifecycleConfigDetails>.Builder}
         * avoiding the need to create one manually via {@link List<StudioLifecycleConfigDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StudioLifecycleConfigDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #studioLifecycleConfigs(List<StudioLifecycleConfigDetails>)}.
         * 
         * @param studioLifecycleConfigs
         *        a consumer that will call methods on {@link List<StudioLifecycleConfigDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #studioLifecycleConfigs(List<StudioLifecycleConfigDetails>)
         */
        Builder studioLifecycleConfigs(Consumer<StudioLifecycleConfigDetails.Builder>... studioLifecycleConfigs);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<StudioLifecycleConfigDetails> studioLifecycleConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioLifecycleConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            studioLifecycleConfigs(model.studioLifecycleConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StudioLifecycleConfigDetails.Builder> getStudioLifecycleConfigs() {
            List<StudioLifecycleConfigDetails.Builder> result = StudioLifecycleConfigsListCopier
                    .copyToBuilder(this.studioLifecycleConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStudioLifecycleConfigs(Collection<StudioLifecycleConfigDetails.BuilderImpl> studioLifecycleConfigs) {
            this.studioLifecycleConfigs = StudioLifecycleConfigsListCopier.copyFromBuilder(studioLifecycleConfigs);
        }

        @Override
        @Transient
        public final Builder studioLifecycleConfigs(Collection<StudioLifecycleConfigDetails> studioLifecycleConfigs) {
            this.studioLifecycleConfigs = StudioLifecycleConfigsListCopier.copy(studioLifecycleConfigs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioLifecycleConfigs(StudioLifecycleConfigDetails... studioLifecycleConfigs) {
            studioLifecycleConfigs(Arrays.asList(studioLifecycleConfigs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioLifecycleConfigs(Consumer<StudioLifecycleConfigDetails.Builder>... studioLifecycleConfigs) {
            studioLifecycleConfigs(Stream.of(studioLifecycleConfigs)
                    .map(c -> StudioLifecycleConfigDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStudioLifecycleConfigsResponse build() {
            return new ListStudioLifecycleConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
