/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubscribedWorkteamResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeSubscribedWorkteamResponse.Builder, DescribeSubscribedWorkteamResponse> {
    private static final SdkField<SubscribedWorkteam> SUBSCRIBED_WORKTEAM_FIELD = SdkField
            .<SubscribedWorkteam> builder(MarshallingType.SDK_POJO).memberName("SubscribedWorkteam")
            .getter(getter(DescribeSubscribedWorkteamResponse::subscribedWorkteam)).setter(setter(Builder::subscribedWorkteam))
            .constructor(SubscribedWorkteam::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedWorkteam").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIBED_WORKTEAM_FIELD));

    private final SubscribedWorkteam subscribedWorkteam;

    private DescribeSubscribedWorkteamResponse(BuilderImpl builder) {
        super(builder);
        this.subscribedWorkteam = builder.subscribedWorkteam;
    }

    /**
     * <p>
     * A <code>Workteam</code> instance that contains information about the work team.
     * </p>
     * 
     * @return A <code>Workteam</code> instance that contains information about the work team.
     */
    public final SubscribedWorkteam subscribedWorkteam() {
        return subscribedWorkteam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscribedWorkteam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscribedWorkteamResponse)) {
            return false;
        }
        DescribeSubscribedWorkteamResponse other = (DescribeSubscribedWorkteamResponse) obj;
        return Objects.equals(subscribedWorkteam(), other.subscribedWorkteam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSubscribedWorkteamResponse").add("SubscribedWorkteam", subscribedWorkteam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscribedWorkteam":
            return Optional.ofNullable(clazz.cast(subscribedWorkteam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubscribedWorkteamResponse, T> g) {
        return obj -> g.apply((DescribeSubscribedWorkteamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSubscribedWorkteamResponse> {
        /**
         * <p>
         * A <code>Workteam</code> instance that contains information about the work team.
         * </p>
         * 
         * @param subscribedWorkteam
         *        A <code>Workteam</code> instance that contains information about the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedWorkteam(SubscribedWorkteam subscribedWorkteam);

        /**
         * <p>
         * A <code>Workteam</code> instance that contains information about the work team.
         * </p>
         * This is a convenience that creates an instance of the {@link SubscribedWorkteam.Builder} avoiding the need to
         * create one manually via {@link SubscribedWorkteam#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubscribedWorkteam.Builder#build()} is called immediately and its
         * result is passed to {@link #subscribedWorkteam(SubscribedWorkteam)}.
         * 
         * @param subscribedWorkteam
         *        a consumer that will call methods on {@link SubscribedWorkteam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedWorkteam(SubscribedWorkteam)
         */
        default Builder subscribedWorkteam(Consumer<SubscribedWorkteam.Builder> subscribedWorkteam) {
            return subscribedWorkteam(SubscribedWorkteam.builder().applyMutation(subscribedWorkteam).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private SubscribedWorkteam subscribedWorkteam;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscribedWorkteamResponse model) {
            super(model);
            subscribedWorkteam(model.subscribedWorkteam);
        }

        public final SubscribedWorkteam.Builder getSubscribedWorkteam() {
            return subscribedWorkteam != null ? subscribedWorkteam.toBuilder() : null;
        }

        public final void setSubscribedWorkteam(SubscribedWorkteam.BuilderImpl subscribedWorkteam) {
            this.subscribedWorkteam = subscribedWorkteam != null ? subscribedWorkteam.build() : null;
        }

        @Override
        @Transient
        public final Builder subscribedWorkteam(SubscribedWorkteam subscribedWorkteam) {
            this.subscribedWorkteam = subscribedWorkteam;
            return this;
        }

        @Override
        public DescribeSubscribedWorkteamResponse build() {
            return new DescribeSubscribedWorkteamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
