/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContextResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeContextResponse.Builder, DescribeContextResponse> {
    private static final SdkField<String> CONTEXT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextName").getter(getter(DescribeContextResponse::contextName)).setter(setter(Builder::contextName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextName").build()).build();

    private static final SdkField<String> CONTEXT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextArn").getter(getter(DescribeContextResponse::contextArn)).setter(setter(Builder::contextArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextArn").build()).build();

    private static final SdkField<ContextSource> SOURCE_FIELD = SdkField.<ContextSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(DescribeContextResponse::source)).setter(setter(Builder::source))
            .constructor(ContextSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> CONTEXT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextType").getter(getter(DescribeContextResponse::contextType)).setter(setter(Builder::contextType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeContextResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(DescribeContextResponse::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeContextResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeContextResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeContextResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeContextResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_NAME_FIELD,
            CONTEXT_ARN_FIELD, SOURCE_FIELD, CONTEXT_TYPE_FIELD, DESCRIPTION_FIELD, PROPERTIES_FIELD, CREATION_TIME_FIELD,
            CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));

    private final String contextName;

    private final String contextArn;

    private final ContextSource source;

    private final String contextType;

    private final String description;

    private final Map<String, String> properties;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private DescribeContextResponse(BuilderImpl builder) {
        super(builder);
        this.contextName = builder.contextName;
        this.contextArn = builder.contextArn;
        this.source = builder.source;
        this.contextType = builder.contextType;
        this.description = builder.description;
        this.properties = builder.properties;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    /**
     * <p>
     * The name of the context.
     * </p>
     * 
     * @return The name of the context.
     */
    public final String contextName() {
        return contextName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the context.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the context.
     */
    public final String contextArn() {
        return contextArn;
    }

    /**
     * <p>
     * The source of the context.
     * </p>
     * 
     * @return The source of the context.
     */
    public final ContextSource source() {
        return source;
    }

    /**
     * <p>
     * The type of the context.
     * </p>
     * 
     * @return The type of the context.
     */
    public final String contextType() {
        return contextType;
    }

    /**
     * <p>
     * The description of the context.
     * </p>
     * 
     * @return The description of the context.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the context's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return A list of the context's properties.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * <p>
     * When the context was created.
     * </p>
     * 
     * @return When the context was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * When the context was last modified.
     * </p>
     * 
     * @return When the context was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contextName());
        hashCode = 31 * hashCode + Objects.hashCode(contextArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(contextType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContextResponse)) {
            return false;
        }
        DescribeContextResponse other = (DescribeContextResponse) obj;
        return Objects.equals(contextName(), other.contextName()) && Objects.equals(contextArn(), other.contextArn())
                && Objects.equals(source(), other.source()) && Objects.equals(contextType(), other.contextType())
                && Objects.equals(description(), other.description()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeContextResponse").add("ContextName", contextName()).add("ContextArn", contextArn())
                .add("Source", source()).add("ContextType", contextType()).add("Description", description())
                .add("Properties", hasProperties() ? properties() : null).add("CreationTime", creationTime())
                .add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextName":
            return Optional.ofNullable(clazz.cast(contextName()));
        case "ContextArn":
            return Optional.ofNullable(clazz.cast(contextArn()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ContextType":
            return Optional.ofNullable(clazz.cast(contextType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContextResponse, T> g) {
        return obj -> g.apply((DescribeContextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeContextResponse> {
        /**
         * <p>
         * The name of the context.
         * </p>
         * 
         * @param contextName
         *        The name of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextName(String contextName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the context.
         * </p>
         * 
         * @param contextArn
         *        The Amazon Resource Name (ARN) of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextArn(String contextArn);

        /**
         * <p>
         * The source of the context.
         * </p>
         * 
         * @param source
         *        The source of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ContextSource source);

        /**
         * <p>
         * The source of the context.
         * </p>
         * This is a convenience that creates an instance of the {@link ContextSource.Builder} avoiding the need to
         * create one manually via {@link ContextSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContextSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ContextSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ContextSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ContextSource)
         */
        default Builder source(Consumer<ContextSource.Builder> source) {
            return source(ContextSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The type of the context.
         * </p>
         * 
         * @param contextType
         *        The type of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextType(String contextType);

        /**
         * <p>
         * The description of the context.
         * </p>
         * 
         * @param description
         *        The description of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of the context's properties.
         * </p>
         * 
         * @param properties
         *        A list of the context's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * When the context was created.
         * </p>
         * 
         * @param creationTime
         *        When the context was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * When the context was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the context was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String contextName;

        private String contextArn;

        private ContextSource source;

        private String contextType;

        private String description;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContextResponse model) {
            super(model);
            contextName(model.contextName);
            contextArn(model.contextArn);
            source(model.source);
            contextType(model.contextType);
            description(model.description);
            properties(model.properties);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
        }

        public final String getContextName() {
            return contextName;
        }

        public final void setContextName(String contextName) {
            this.contextName = contextName;
        }

        @Override
        @Transient
        public final Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public final String getContextArn() {
            return contextArn;
        }

        public final void setContextArn(String contextArn) {
            this.contextArn = contextArn;
        }

        @Override
        @Transient
        public final Builder contextArn(String contextArn) {
            this.contextArn = contextArn;
            return this;
        }

        public final ContextSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ContextSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ContextSource source) {
            this.source = source;
            return this;
        }

        public final String getContextType() {
            return contextType;
        }

        public final void setContextType(String contextType) {
            this.contextType = contextType;
        }

        @Override
        @Transient
        public final Builder contextType(String contextType) {
            this.contextType = contextType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        @Override
        @Transient
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        @Transient
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        @Override
        public DescribeContextResponse build() {
            return new DescribeContextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
